/*
 * Copyright (C) 1990-1997 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)send2tpd.c	1.10 05/07/97 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

/*	send2tpd - send request to tape daemon and get reply */
#include <errno.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#if ultrix || hpux || apollo || _AIX || (__alpha && __osf__) || SOLARIS || IRIX5 || linux
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/un.h>
#if defined(SOLARIS)
#include <sys/filio.h>
#endif
#endif
#include "tape.h"
send2tpd(treqp, trepp, repsize)
struct tpdreq *treqp;
char *trepp;
int *repsize;
{
	int c;
	char func[16];
	struct tpdrphdr tpdrphdr;
#if ultrix || hpux || apollo || _AIX || (__alpha && __osf__) || SOLARIS || IRIX5 || linux
	int s;
	struct sockaddr_un sname;
#else
	int rpfd, rqfd;
	char *tempnam();
#endif

	ENTRY (send2tpd);

#if ultrix || hpux || apollo || _AIX || (__alpha && __osf__) || SOLARIS || IRIX5 || linux
	/* create socket to communicate with tape daemon */

	if ((s = socket (AF_UNIX, SOCK_STREAM, 0)) < 0) {
		tplogit (func, TP002, REQPIPE, "socket", errno);
		RETURN (ETSYS);
	}
	sname.sun_family = AF_UNIX;
	strcpy (sname.sun_path, REQPIPE);
	if (connect (s, (struct sockaddr *) &sname, sizeof(sname)) < 0) {
		if (errno == ECONNREFUSED) {
			tplogit (func, TP000);
			close (s);
			RETURN (ETDNP);
		} else {
			tplogit (func, TP002, REQPIPE, "connect", errno);
			close (s);
			RETURN (ETSYS);
		}
	}

	/* send request to tape daemon */

	if (WRITE (s, (char *) treqp, treqp->rh.size) < 0) {
		tplogit (func, TP002, REQPIPE, "send", errno);
		close (s);
		RETURN (ETSYS);
	}
	if (trepp == NULL) {	/* does not want a reply */
		close (s);
		RETURN (0);
	}

	/* get reply */

	c = READ (s, (char *) &tpdrphdr, sizeof(struct tpdrphdr));

	if (c != sizeof(struct tpdrphdr)) {
		tplogit (func, TP002, REQPIPE, "recv", errno);
		close (s);
		RETURN (ETSYS);
	}
	if ((*repsize = tpdrphdr.size - sizeof(struct tpdrphdr)) != 0)
		if (READ (s, trepp, *repsize) != *repsize) {
			tplogit (func, TP002, REQPIPE, "recv", errno);
			close (s);
			RETURN (ETSYS);
		}
	close (s);
#else
	/* make reply pipe */

	strcpy (treqp->rh.rpn, tempnam(NULL, "tp"));
	if (mknod (treqp->rh.rpn, 0010700, 0) < 0) {
		tplogit (func, TP002, treqp->rh.rpn, "mknod", errno);
		RETURN (ETSYS);
	}
	if ((rpfd = open (treqp->rh.rpn, O_RDWR)) < 0) {
		tplogit (func, TP002, treqp->rh.rpn, "open", errno);
		RETURN (ETSYS);
	}

	/* open request pipe to tape daemon */

	while ((rqfd = open (REQPIPE, O_WRONLY | O_NDELAY)) < 0) {
		switch (errno) {
			case ENFILE:
				sleep (1);
				continue;
			case ENOENT:
			case ENXIO:
				tplogit (func, TP000);
				close (rpfd);
				unlink (treqp->rh.rpn);
				RETURN (ETDNP);
			default:
				tplogit (func, TP002, REQPIPE, "open", errno);
				close (rpfd);
				unlink (treqp->rh.rpn);
				RETURN (ETSYS);
		}
	}

	/* send request to tape daemon */

	if (write (rqfd, (char *) treqp, treqp->rh.size) != treqp->rh.size) {
		tplogit (func, TP002, REQPIPE, "write", errno);
		close (rqfd);
		close (rpfd);
		unlink (treqp->rh.rpn);
		RETURN (ETSYS);
	}
	close (rqfd);
	if (! trepp) {	/* does not want a reply */
		close (rpfd);
		unlink (treqp->rh.rpn);
		RETURN (0);
	}

	/* get reply */

	c = read (rpfd, (char *) &tpdrphdr, sizeof(struct tpdrphdr));

	if (c != sizeof(struct tpdrphdr)) {
		tplogit (func, TP002, treqp->rh.rpn, "read", errno);
		close (rpfd);
		unlink (treqp->rh.rpn);
		RETURN (ETSYS);
	}
	if ((*repsize = tpdrphdr.size - sizeof(struct tpdrphdr)) != 0)
		if (read (rpfd, trepp, *repsize) != *repsize) {
			tplogit (func, TP002, treqp->rh.rpn, "read", errno);
			close (rpfd);
			unlink (treqp->rh.rpn);
			RETURN (ETSYS);
		}
	close (rpfd);
	unlink (treqp->rh.rpn);
#endif
	RETURN (tpdrphdr.rc);
}
