/*
 * Copyright (C) 1990,1991 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)savelabel.c	1.2 07/24/92 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

/*	savelabel - save label information in .tplabel */

#include <errno.h>
#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include "tape.h"
savelabel (tplblfn, uid, gid, path, info)
char *tplblfn;
uid_t uid;
gid_t gid;
char *path;
char *info;
{
	int fd;
	int i;
	struct labelinfo labelinfo;
	off_t offset;
	char *p;
	char *strchr();

	if ((fd = open (tplblfn, O_RDWR, 0664)) <0) {
		if (errno != ENOENT ||
			(fd = open (tplblfn, O_RDWR | O_CREAT, 0664)) <0) {
				fprintf (stderr, "TP002 - %s : open error : %d\n",
					tplblfn, errno);
				return (-errno);
		}
		chown (tplblfn, uid, gid);
	}
	offset = sizeof(struct labelinfo);
	while (read (fd, (char *)&labelinfo, sizeof(struct labelinfo)) ==
	       sizeof(struct labelinfo)) {
		p = strchr (labelinfo.path, ' ');
		*p = '\0';
		if (strcmp (labelinfo.path, path) == 0) {
			lseek (fd, - offset, 1);
			break;
		}
	}
	memcpy ((char *)&labelinfo, info, sizeof(struct labelinfo));
	for (i = 0; i < MAXPATH; i++)
		labelinfo.path[i] = ' ';
	memcpy (labelinfo.path, path, strlen (path));
	write (fd, (char *)&labelinfo, sizeof(struct labelinfo));
	close (fd);
	return (0);
}
