/*
 * Copyright (C) 1990-1996 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)rls.c	1.13 06/24/96 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

/*	rls - unload tape and relaese reservations */
#include <errno.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "tape.h"
extern	int	optind;
extern	char	*optarg;
int jid;
char *getcwd();
char *getenv();
char repbuf[133];
char savepath[MAXPATH];
struct	tprls	req;

main(argc, argv)
int	argc;
char	**argv;
{
	int aflg = 0;
	int c, n;
	int errflg = 0;

	jid = findpgrp();
	req.rh.size = sizeof(struct tprls);
	req.rh.code = TPRLS;
	req.jid = jid;
	while ((c = getopt (argc, argv, "ad:kp:")) != EOF) {
		switch (c) {
		case 'a':
			if (aflg == 0) {
				aflg++;
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case 'd':
			if (req.dvn[0] == '\0') {
				if (strlen(optarg) < sizeof(req.dvn))
					strcpy (req.dvn, optarg);
				else {
					fprintf (stderr, TP006, argv[optind-2]);
					errflg++;
				}
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case 'k':
			if (req.keeprsv == 0) {
				req.keeprsv = 1;
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case 'p':
			if (req.path[0] == '\0') {
				if (*optarg != '/') {
					if (getcwd (req.path, sizeof(req.path) - 3) == NULL) {
						fprintf (stderr,
						    "TP002 -  : getcwd error : %d\n", errno);
						errflg++;
					}
					strcat (req.path, "/");
				}
				if (strlen(req.path) + strlen(optarg) < sizeof(req.path)) {
					strcat (req.path, optarg);
					strcpy (savepath, optarg);
				} else {
					fprintf (stderr, TP006, argv[optind-2]);
					errflg++;
				}
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case '?':
			errflg++;
			break;
		}
	}
	if (aflg && req.dvn[0] != 0) {
		fprintf (stderr, TP016, 'a', 'd');
		errflg++;
	}
	if (aflg && req.keeprsv != 0) {
		fprintf (stderr, TP016, 'a', 'k');
		errflg++;
	}
	if (aflg && req.path[0] != 0) {
		fprintf (stderr, TP016, 'a', 'p');
		errflg++;
	}
	if (req.keeprsv != 0 && req.dvn[0] == 0 && req.path[0] == 0) {
		fprintf (stderr, TP036);
		errflg++;
	}
	if (errflg) {
		usage (argv[0]);
		exit (ETPRM);
	}

	c = send2tpd (&req, repbuf, &n);
	switch (c) {
	case ETDNP:
		fprintf (stderr, "%s\n", TP000);
		break;
	case ETSYS:
		fprintf (stderr, "%s\n", TP026);
		break;
	case ETTMO:
		fprintf (stderr, "%s\n", TP001);
		break;
	case ETRLSP:
		fprintf (stderr, "%s\n", TP040);
		break;
	}

	/* update or remove tape label information file */

	rmlabelinfo (aflg, savepath);
	exit (c);
}

usage(cmd)
char *cmd;
{
	fprintf (stderr, "usage: %s ", cmd);
	fprintf (stderr, "[-a] [-d device_name] [-p path_name]\n");
}

rmlabelinfo(aflg, path)
int aflg;
char *path;
{
	int i;
	char *malloc();
	int nblabel;
	char *p;
	struct labelinfo *p1, *p2, *q;
	struct stat st;
	char *strchr();
	int tplblfd;
	char tplblfn[MAXPATH];

	if ((p = getenv ("TAPENV")) == NULL)
		p = ".tplabel";
	if (*p == '/') {
		tplblfn[0] = '\0';
	} else {
		if (getcwd (tplblfn, sizeof(tplblfn) - 3) == NULL) {
			fprintf (stderr, "TP002 -  : getcwd error : %d\n", errno);
			exit(ETPRM);
		}
		strcat (tplblfn, "/");
	}
	if (strlen(tplblfn) + strlen(p) < sizeof(tplblfn)) {
		strcat (tplblfn, p);
	} else {
		fprintf (stderr, TP038, p);
		exit (ETPRM);
	}
	nblabel = -1;
	if (path[0] != '\0') {
		if (access (tplblfn, W_OK) == 0 &&
			(tplblfd = open (tplblfn, O_RDWR)) >= 0) {
			fstat (tplblfd, &st);
			nblabel = 0;
			if (st.st_size != 0) {
				nblabel = st.st_size / sizeof(struct labelinfo);
				if ((q = (struct labelinfo *)malloc (st.st_size)) != NULL) {
					read (tplblfd, (char *)q, st.st_size);
					p1 = q;
					for (i = 0; i < nblabel; i++) {
						p = strchr (p1->path, ' ');
						*p = '\0';
						if (strcmp (p1->path, path) == 0) break;
						*p = ' ';
						p1++;
					}
					if (i < nblabel) {	/* path found */
						nblabel--;
						if (nblabel != 0) {
							if (i != nblabel) {	/* not last entry */
								p2 = p1 + 1;
								memcpy ((char *)p1, (char *)p2,
									(nblabel-i)*sizeof(struct labelinfo));
							}
							lseek (tplblfd, (off_t)0, 0);
							write (tplblfd, (char *)q, nblabel * sizeof(struct labelinfo));
							ftruncate (tplblfd, nblabel * sizeof(struct labelinfo));
						}
					}
				}
			}
			close (tplblfd);
		}
	}
	if (aflg || nblabel == 0) {
		if (chkdirw (tplblfn) == 0) {
			unlink (tplblfn);
		} else {
			fprintf (stderr, "TP002 - %s : access error : %d\n",
				tplblfn, errno);
			return (ETPRM);
		}
	}
	return (0);
}
