/*
 * Copyright (C) 1990-1996 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)nextvol.c	1.5 06/24/96 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

/*	nextvol - switch to next volume in multivolume set */
#include <errno.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include "tape.h"
extern	int	optind;
extern	char	*optarg;
int jid;
char repbuf[MAXPATH+246];
struct	nextvol	req;

main(argc, argv)
int	argc;
char	**argv;
{
	int c, n;
	int errflg = 0;
	char *getcwd();
	char *getenv();
	char *p;
	char savepath[MAXPATH];
	char tplblfn[MAXPATH];

	jid = findpgrp();
	req.rh.size = sizeof(struct nextvol);
	req.rh.code = NEXTVOL;
	req.jid = jid;
	while ((c = getopt (argc, argv, "P:")) != EOF) {
		switch (c) {
		case 'P':
			if (req.path[0] == '\0') {
				if (*optarg != '/') {
					if (getcwd (req.path, sizeof(req.path) - 3) == NULL) {
						fprintf (stderr,
						    "TP002 -  : getcwd error : %d\n", errno);
						errflg++;
					}
					strcat (req.path, "/");
				}
				if (strlen(req.path) + strlen(optarg) < sizeof(req.path)) {
					strcat (req.path, optarg);
					strcpy (savepath, optarg);
				} else {
					fprintf (stderr, TP006, argv[optind-2]);
					errflg++;
				}
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case '?':
			errflg++;
			break;
		}
	}
	if (req.path[0] == 0) {
		fprintf (stderr, TP029);
		errflg++;
	}
	if (errflg) {
		usage (argv[0]);
		exit (ETPRM);
	}

	/* check if allowed to save tape label info */

	if ((p = getenv ("TAPENV")) == NULL)
		p = ".tplabel";
	if (*p == '/') {
		tplblfn[0] = '\0';
	} else {
		if (getcwd (tplblfn, sizeof(tplblfn) - 3) == NULL) {
			fprintf (stderr, "TP002 -  : getcwd error : %d\n", errno);
			exit (ETPRM);
		}
		strcat (tplblfn, "/");
	}
	if (strlen(tplblfn) + strlen(p) < sizeof(tplblfn)) {
		strcat (tplblfn, p);
	} else {
		fprintf (stderr, TP038, p);
		exit (ETPRM);
	}
	if (access (tplblfn, W_OK)) {
		if (errno != ENOENT || chkdirw (tplblfn)) {
			fprintf (stderr, "TP002 - %s : access error : %d\n",
				tplblfn, errno);
			exit (errno);
		}
	}

	c = send2tpd (&req, repbuf, &n);
	switch (c) {
	case 0:
		savelabel (tplblfn, getuid(), getgid(), savepath, repbuf);
		break;
	case ETDNP:
		fprintf (stderr, "%s\n", TP000);
		break;
	case ETSYS:
		fprintf (stderr, "%s\n", TP026);
		break;
	case ETTMO:
		fprintf (stderr, "%s\n", TP001);
		break;
	case ETNRS:
		fprintf (stderr, TP014);
		break;
	case ETEOL:
		break;
	default:
		if (n) fprintf (stderr, "%s\n", repbuf);
		break;
	}
	exit (c);
}

usage(cmd)
char *cmd;
{
	fprintf (stderr, "usage: %s ", cmd);
	fprintf (stderr, "-P path_name\n");
}
