/*
 * Copyright (C) 1990-1999 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)mounttape.c	1.95 06/25/99 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

#include <errno.h>
#include <stdio.h>
#include <pwd.h>
#include <signal.h>
#include <fcntl.h>
#if linux
#include <sys/mtio.h>
#endif
#include <string.h>
#if sgi || sun || ultrix
#include <sys/termio.h>
#endif
#include <sys/time.h>
#include <sys/types.h>
#include <sys/param.h>
#if defined(_AIX) && defined(_IBMR2)
#include <sys/select.h>
#endif
#include "tape.h"
#if SACCT
#include "../h/sacct.h"
#endif
extern int serrno;
#if !defined(linux)
extern char *sys_errlist[];
#endif
char *dvrname;
char func[16];
char hostname[MAXHOSTNAMELEN];
int jid;
char *loader;
int maxfds;
char msg[OPRMSGSZ];
int msg_num;
struct ovlend oereq;
char orepbuf[OPRMSGSZ];
fd_set readmask;
struct tpdrep rep;
char repbuf[133];
struct rslt rsltreq;
struct tprls rlsreq;
int fhs_mount_failed;
char *rpn;
int tapefd;
struct updfil ufreq;
struct updvsn uvreq;
#if TMS || FHS
struct vsn_req vrqp;
#endif
main(argc, argv)
int	argc;
char	**argv;
{
	char *acctname, *devtype, *dgn, *dvn, *nqsid, *path, *prevvid, *unm;
	char *vid, *vsn;
	gid_t gid;
	int lbl, ring, ux;
	uid_t uid;

	int blksize, cfseq, den, fsec, fseq, lrecl, prelabel, retentd;
	int Qfirst, Qlast;
	char fid[18], filstat, ignoreeoi, Nflag, recfm[4], Tflag;
	char tpfid[18];

	int c, i, n;
	void cleanup();
	unsigned int demountforce;
	int get_reply;
	char hdr1[LBLBUFSZ], hdr2[LBLBUFSZ];
	struct labelinfo labelinfo;
	static char labels[5][4] = {"", "al", "nl", "sl", "blp"};
	int lbl4pos;
	void mountkilled();
#if DUXV4
	char *msgaddr;
#endif
        char msg1[9];
#if linux
	struct mtop mtop;
#endif
	char name[15];
	int needrbtmnt;
	char *p;
	struct passwd *pwd;
	fd_set readfds;
	char rings[9];
	struct rsltr rsltr;
	int scsi;
	int sonyraw;
	int status;
	struct timeval timeval;
	int tplbl;
	int tpring;
	char tpvsn[7];
	char vol1[LBLBUFSZ];
	int vsnretry = 0;
	char *why;

	ENTRY (mounttape);

	unm = argv[1];
	vid = argv[2];
	dvn = argv[3];
	rpn = argv[4];
	uid = atoi (argv[5]);
	gid = atoi (argv[6]);
	acctname = argv[7];
	jid = atoi (argv[8]);
	nqsid = strcmp (argv[9], ".") ? argv[9] : "";
	ux = atoi(argv[10]);
	dgn = argv[11];
	devtype = argv[12];
	dvrname = argv[13];
	loader = argv[14];
	ring = atoi (argv[15]);
	lbl = atoi (argv[16]);
	vsn = argv[17];

	cfseq = atoi (argv[18]);
	strcpy (fid, argv[19]);
	filstat = argv[20][0];
	fsec = atoi (argv[21]);
	fseq = atoi (argv[22]);
	path = argv[23];
	Qfirst = atoi (argv[24]);
	Qlast = atoi (argv[25]);
	retentd = atoi (argv[26]);

	strcpy (recfm, argv[27]);
	blksize = atoi (argv[28]);
	lrecl = atoi (argv[29]);
	den = atoi (argv[30]);

	ignoreeoi = argv[31][0];
	Nflag = argv[32][0];
	Tflag = argv[33][0];
	prelabel = atoi (argv[34]);
	prevvid = argv[35];
#if _AIX
#if defined(_IBMESA)
	scsi = 0;
#else
	scsi = strncmp (dvrname, "mtdd", 4);
#endif
#else
	scsi = 1;
#endif
#if SONYRAW
	if (strcmp (devtype, "DIR1") == 0 && den == SRAW)
		sonyraw = 1;
	else
		sonyraw = 0;
#endif

#if ultrix || sun || sgi
        c = open ("/dev/tty", O_RDWR);
        if (c >= 0) {
                ioctl (c, TIOCNOTTY, 0);
                (void) close (c);
        }
#endif
	c = 0;
	rep.data[0] = '\0';
	gethostname (hostname, MAXHOSTNAMELEN);

	/* initialize structures */

	rlsreq.rh.size = sizeof(struct tprls);
	rlsreq.rh.code = TPRLS;
	rlsreq.jid = jid;
	rlsreq.keeprsv = 1;
	strcpy (rlsreq.path, path);

	ufreq.rh.size = sizeof(struct updfil);
	ufreq.rh.code = UPDFIL;
	ufreq.ux = ux;

	uvreq.rh.size = sizeof(struct updvsn);
	uvreq.rh.code = UPDVSN;
	uvreq.ux = ux;
	strcpy (uvreq.vid, vid);
	strcpy (uvreq.vsn, vsn);
	uvreq.lbl = lbl;
	uvreq.ring = ring;

#if TMS || FHS
	vrqp.num = 1;
	vrqp.uid = uid;
	vrqp.gid = gid;
	vrqp.mode = ring == IN ? VSN_WRITE : VSN_READ;
	strcpy (vrqp.vsn[0], vsn);
	strcpy (vrqp.vid[0], vid);
	strcpy (vrqp.acctname, acctname);
	vrqp.jid = jid;
	strcpy (vrqp.nqsid, nqsid);
	strcpy (vrqp.dvn, unm);
	strcpy (vrqp.path, path);
#endif
	/* initialize for select */

#if defined(ultrix) || (defined(sun) && !defined(SOLARIS)) || defined(linux)
	maxfds = getdtablesize();
#else
	maxfds = _NFILE;
#endif
	FD_ZERO (&readmask);
	FD_ZERO (&readfds);

	signal (SIGINT, mountkilled);

	if (fsec > 1) {	/* nth file section in multivolume set */
		tapefd = open (path, O_RDONLY);
		if (strcmp (devtype, "3480") == 0 ||
		    strcmp (devtype, "9840") == 0 ||
		    strcmp (devtype, "SD3") == 0)
			lddisplay (tapefd, path, 0x20, "", "", 0);
		else if (strcmp (devtype, "3590") == 0)
			lddisplay (tapefd, path, 0x20, "", "", 1);
		else if (strstr (devtype, "/VB"))
			lddisplay (tapefd, path, 0x80, "", "", 2);
		if (*loader != 'n')
			if (c = unldtape (tapefd, path))
				goto reply;
#if SACCT
		tapeacct (TPUNLOAD, uid, gid, jid, nqsid, dgn, unm, prevvid, 0, "nextvol");
#endif
		close (tapefd);
		if (*loader != 'm' && *loader != 'f') {
			demountforce = 0;
			do {
				c = rbtdemount (prevvid, unm, dvn, loader, demountforce);
				if ((n = rbtdmntchk (&c, unm, &demountforce)) < 0)
					goto reply;
			} while (n == 1);
			if (n == 2)	/* tape not unloaded */
				goto reply;
		}
#ifdef FHS
		if (*loader == 'f')
			c = fhsexit (&vrqp, 4);
#endif
#ifdef TMS
		c = tmsexit (&vrqp, 4);
#endif
	} else if (cfseq) {	/* tape is already mounted */
#if SONYRAW
	    if (! sonyraw) {
#endif
#ifndef SOLARIS25
		if (!scsi)
#endif
			tapefd = open (path, O_RDONLY);
#ifndef SOLARIS25
		else
			tapefd = open (path, O_RDONLY|O_NDELAY);
#endif
		if (tapefd >= 0) {
			if (chkunitready (tapefd) > 0) goto positp;
			else close (tapefd);
		}
#if SONYRAW
	    } else {
		tapefd = open (path, O_RDWR|O_NDELAY);
		if (tapefd >= 0) {
			if (chkunitready_sony (tapefd) > 0) goto positp;
			else close (tapefd);
		}
	    }
#endif
		cfseq = 0;
	}
	Nflag = 0;
#ifdef TMS
	c = tmsexit (&vrqp, 1);
	if (c != 0) {
		strcpy (rep.data, repbuf);
		if (c == ETVBSY)
			n = tmsexit (&vrqp, 8);
		goto reply;
	}
#endif

	/* build mount message */

	pwd = getpwuid (uid);
	strcpy (name, pwd->pw_name);
	if (ring == OUT)
		strcpy (rings, "ring-out");
	else
		strcpy (rings, "ring-in");
	why = "";
	msg_num = 0;
reselect_loop:
	/* send vid, vsn and flag "to be mounted" to the tape daemon */

	uvreq.tobemounted = 1;
	uvreq.cfseq = cfseq;
	if ((c = send2tpd (&uvreq, NULL, (int *)0)) != 0) goto reply;

#if SACCT
	tapeacct (TP2MOUNT, uid, gid, jid, nqsid, dgn, unm, vid, fseq, why);
#endif

	if (*loader != 'm' && *loader != 'f')
		needrbtmnt = 1;

	/* build LED display message for 3480 compatible units */

	strcpy (msg1, vid);
	if (ring == OUT)
		strcat (msg1, " .");
	if (strcmp (devtype, "3480") == 0 ||
	    strcmp (devtype, "9840") == 0 ||
	    strcmp (devtype, "SD3") == 0)
		lddisplay (-1, path, 0x40, msg1, "", 0);
	else if (strcmp (devtype, "3590") == 0)
		lddisplay (-1, path, 0x40, msg1, "", 1);
	else if (strstr (devtype, "/VB"))
		lddisplay (-1, path, 0x18, msg1, "", 2);

	while (1) {

		/* send mount message to operator and get message number */

		sprintf (msg, TP020, vid, labels[lbl], rings, unm, hostname,
			name, jid, nqsid, why);
		if ((n = omsgr (func, msg, 1)) < 0) {
			c = n;
			goto reply;
		} else
			msg_num = n;
		get_reply = 0;
remount_loop:
		if (*loader != 'm' && *loader != 'f' && needrbtmnt) {
			do {
				c = rbtmount (vid, unm, dvn, ring, loader);
				if ((n = rbtmountchk (&c, unm, vid, dvn, loader)) < 0)
					goto reply;
			} while (n == 1);
			if (n == 2) {
				get_reply = 1;
				goto procorep;
			}
		}
#ifdef FHS
		if (*loader == 'f') {
			c = fhsexit (&vrqp, 1);
			if (c != 0) {
				strcpy (rep.data, repbuf);
				goto reply;
			}
		}
#endif

		while (1) {	/* wait for unit ready or operator cancel */
#if defined(sun) || (defined(_AIX) && defined(_IBMR2))
#if _AIX
			if (scsi) {
				if ((tapefd = open (path, O_RDWR)) >= 0) {
					tpring = 1;	/* ring in */
					break;
				}
				if (errno == EWRPROTECT) {
					if ((tapefd = open (path, O_RDONLY)) >= 0) {
						tpring = 0;	/* ring out */
						break;
					}
				}
				if (errno != EIO && errno != ENOTREADY) c = errno;
			} else {
#else
#ifndef SOLARIS25
				if ((tapefd = open (path, O_RDWR|O_NDELAY)) >= 0) {
#else
				if ((tapefd = open (path, O_RDWR)) >= 0) {
#endif
					tpring = 1;	/* ring in */
					break;
				}
				if (errno == EACCES) {
#ifndef SOLARIS25
					if ((tapefd = open (path, O_RDONLY|O_NDELAY)) >= 0) {
#else
					if ((tapefd = open (path, O_RDONLY)) >= 0) {
#endif
						tpring = 0;	/* ring out */
						break;
					}
				}
				if (errno != EIO) c = errno;
#endif
#endif
#ifndef sun
#if !defined(_IBMR2) || defined(RS6000PCTA)
#if SONYRAW
			    if (! sonyraw) {
#endif
				if ((tapefd = open (path, O_RDONLY|O_NDELAY)) >= 0) {
					if (chkunitready (tapefd) > 0) {
						tpring = chkringstatus (tapefd);
						break;
					} else close (tapefd);
				} else c = errno;
#if SONYRAW
			    } else {
				if ((tapefd = open (path, O_RDWR|O_NDELAY)) >= 0) {
					if (chkunitready_sony (tapefd) > 0) {
						tpring = chkringstatus_sony (tapefd);
						break;
					} else close (tapefd);
				} else c = errno;
			    }
#endif
#endif
#if defined(_AIX) && defined(_IBMR2)
			}
#endif
#endif
			if (c) {
				if (errno == ENXIO) {	/* unit not operational */
					usrmsg (func, TP033, unm, hostname);
					configdown (unm);
				} else
					usrmsg (func, TP042, path, "open",
						sys_errlist[errno]);
				goto reply;
			}
			if (testorep (&readfds)) {
				get_reply = 1;
				needrbtmnt = 0;
				break;
			}
#if defined(_AIX) && defined(_IBMR2) && (defined(RS6000PCTA) || defined(ADSTAR))
			if (*loader == 'l')
				c = qmid3495 (&status);
#endif
#if defined(CDK)
			if (*loader == 'a')
				c = acsmountresp();
#endif
#if defined(RS6000PCTA) || defined(ADSTAR) || defined(CDK)
			if (*loader == 'l' || *loader == 'a') {
				if ((n = rbtmountchk (&c, unm, vid, dvn, loader)) < 0)
					goto reply;
				if (n == 1) goto remount_loop;
				if (n == 2) {
					get_reply = 1;
					break;
				}
			}
#endif
#if FHS
			if (fhs_mount_failed) {
				c = EINTR;
				strcpy (rep.data, repbuf);
				goto reply;
			}
#endif
			memcpy (&readfds, &readmask, sizeof(readmask));
			timeval.tv_sec = UCHECKI;	/* must set each time for linux */
			timeval.tv_usec = 0;
			if (select (maxfds, &readfds, (fd_set *)0, (fd_set *)0,
				&timeval) < 0) {
				FD_ZERO (&readfds);
			}
		}

procorep:
		if (get_reply) {
			checkorep (func, orepbuf);
			if (strlen (orepbuf) == 0) continue;
			if (strncmp (orepbuf, "cancel", 6) == 0) {
				usrmsg (func, TP023, orepbuf);
				c = EACCES;
				goto reply;
			} else if (strcmp (orepbuf, "reselect server") == 0) {
				usrmsg (func, TP047);
				c = ETRSLT;
				goto reply;
			} else if ((int) strlen (orepbuf) < 9) {	/* reselect ? */
				if (strcmp (devtype, "3480") == 0 ||
				    strcmp (devtype, "9840") == 0 ||
				    strcmp (devtype, "SD3") == 0)
					lddisplay (-1, path, 0x20, "", "", 0);
				else if (strcmp (devtype, "3590") == 0)
					lddisplay (-1, path, 0x20, "", "", 1);
				else if (strstr (devtype, "/VB"))
					lddisplay (-1, path, 0x80, "", "", 2);
unload_loop1:
#ifndef SOLARIS25
				if ((tapefd = open (path, O_RDONLY|O_NDELAY)) >= 0) {
#else
				if ((tapefd = open (path, O_RDONLY)) >= 0) {
#endif
					if (chkunitready (tapefd) > 0) {
						if (*loader != 'n')
							if (n = unldtape (tapefd, path)) {
								c = n;
								goto reply;
							}
#if SACCT
						tapeacct (TPUNLOAD, uid, gid, jid, nqsid,
						    dgn, unm, vid, fseq, "reselect");
#endif
					}
					close (tapefd);
				}
				if (*loader != 'm' && *loader != 'f') {
					demountforce = 0;
					do {
						c = rbtdemount (vid, unm, dvn,
							loader, demountforce);
						if ((n = rbtdmntchk (&c, unm, &demountforce)) < 0)
							goto reply;
					} while (n == 1);
					if (n == 2)	/* tape has become ready */
						goto unload_loop1;
				}
#ifdef FHS
				if (*loader == 'f')
					n = fhsexit (&vrqp, 4);
#endif
				if (strcmp (unm, orepbuf) == 0) { /* same unit */
					why = "reselect same";
					goto reselect_loop;
				}
				rsltreq.rh.size = sizeof(struct rslt);
				rsltreq.rh.code = RSLT;
				rsltreq.jid = jid;
				strcpy (rsltreq.olddvn, unm);
				strcpy (rsltreq.newdvn, orepbuf);
				if (send2tpd (&rsltreq, &rsltr, &n)) {
					why = "reselect failed";
				} else {
					strcpy (unm, rsltreq.newdvn);
#if TMS || FHS
					strcpy (vrqp.dvn, unm);
#ifdef TMS
					c = tmsexit (&vrqp, 1);
					if (c != 0) {
						strcpy (rep.data, repbuf);
						goto reply;
					}
#endif
#endif
					ufreq.ux = rsltr.ux;
					uvreq.ux = rsltr.ux;
					loader = rsltr.loader;
					dvn = rsltr.dvn;
					why = "reselect";
				}
				goto reselect_loop;
			} else continue;	/* bad reply */
		}

		/* tape is ready */

		if (strcmp (devtype, "3480") == 0 ||
		    strcmp (devtype, "9840") == 0 ||
		    strcmp (devtype, "SD3") == 0)
			lddisplay (tapefd, path, 0x20, msg1, "", 0);
		else if (strcmp (devtype, "3590") == 0)
			lddisplay (tapefd, path, 0x20, msg1, "", 1);
		else if (strstr (devtype, "/VB"))
			lddisplay (tapefd, path, 0x80, msg1, "", 2);

		omsgdel (func, msg_num);

		/* check ring status */

		if (tpring != ring && tpring == OUT && *loader != 'm') {
			sprintf (msg, TP041, "mount", vid, unm, "write protected");
			usrmsg (func, "%s", msg);
			omsgr (func, msg, 0);
			c = EACCES;
			goto reply;
		}
		if (tpring != ring && *loader == 'm') {
			if (c = unldtape (tapefd, path))
				goto reply;
			if (strcmp (devtype, "3480") == 0 ||
			    strcmp (devtype, "9840") == 0 ||
			    strcmp (devtype, "SD3") == 0)
				lddisplay (tapefd, path, 0x50, msg1, "wrng rng", 0);
			else if (strcmp (devtype, "3590") == 0)
				lddisplay (tapefd, path, 0x50, msg1, "wrng rng", 1);
			else if (strstr (devtype, "/VB"))
				lddisplay (tapefd, path, 0x1A, msg1, "wrong ring", 2);
			close (tapefd);
			why = "wrong ring status";
#if SACCT
			tapeacct (TPUNLOAD, uid, gid, jid, nqsid, dgn, unm, vid, fseq, why);
#endif
			continue;
		}
#if defined(_AIX) && (defined(_IBMESA) || defined(RS6000PCTA))
		if (!scsi) {
			close (tapefd);         /* to avoid errno 22 on read */
			if ((tapefd = open (path, O_RDONLY)) < 0) {
				usrmsg (func, TP042, path, "reopen", sys_errlist[errno]);
				c = errno;
				goto reply;
			}
		}
#endif
#if SONYRAW
		if (sonyraw) break;
#endif
#if linux
		mtop.mt_op = MTSETBLK;
		mtop.mt_count = 0;
		ioctl (tapefd, MTIOCTOP, &mtop);	/* set variable block size */
#endif
#if DUXV4
		(void) gettperror (tapefd, &msgaddr);	/* clear eei status */
#endif

		/* position tape at BOT */

		if ((c = rwndtape (tapefd, path))) goto reply;

		/* check VOL1 label if not blp and not prelabel */

		if (lbl == BLP || prelabel) break;

		if ((c = readlbl (tapefd, path, vol1)) < 0) goto reply;
		if (c) {	/* record read is not 80 bytes long */
			c = 0;
			tplbl = NL;
		} else if (strncmp (vol1, "VOL1", 4) == 0) tplbl = AL;
		else {
			ebc2asc (vol1, 80);
			if (strncmp (vol1, "VOL1", 4) == 0) tplbl = SL;
			else tplbl = NL;
		}
		if (tplbl == NL && lbl == NL) break;
		if (tplbl != NL)
			tplogit (func, "vol1 = %s", vol1);
		if (lbl != tplbl && vsnretry) {	/* wrong label type */
			usrmsg (func, TP021, labels[lbl], labels[tplbl]);
			c = EACCES;
			goto reply;
		}
		if (tplbl != NL) {
			strncpy (tpvsn, vol1 + 4, 6);
			tpvsn[6] = '\0';
			if ((p = strchr (tpvsn, ' ')) != NULL) *p = '\0';
			if (lbl == tplbl && strcmp (tpvsn, vsn) == 0) break;
		}
		if (*loader != 'm' && vsnretry++) {
			usrmsg (func, TP039, vsn, tpvsn);
			c = EACCES;
			goto reply;
		}
		if (*loader != 'n')
			if (n = unldtape (tapefd, path)) {
				c = n;
				goto reply;
			}
		if (strcmp (devtype, "3480") == 0 ||
		    strcmp (devtype, "9840") == 0 ||
		    strcmp (devtype, "SD3") == 0)
			lddisplay (tapefd, path, 0x50, msg1, "wrng vsn", 0);
		else if (strcmp (devtype, "3590") == 0)
			lddisplay (tapefd, path, 0x50, msg1, "wrng vsn", 1);
		else if (strstr (devtype, "/VB"))
			lddisplay (tapefd, path, 0x1A, msg1, "wrong vsn", 2);
		close (tapefd);
		why = "wrong vsn";
#if SACCT
		tapeacct (TPUNLOAD, uid, gid, jid, nqsid,
		    dgn, unm, vid, fseq, why);
#endif
		if (*loader == 'm')
			continue;
		if (*loader != 'f') {
			demountforce = 1;
			do {
				c = rbtdemount (vid, unm, dvn, loader, demountforce);
				if ((n = rbtdmntchk (&c, unm, &demountforce)) < 0)
					goto reply;
			} while (n == 1);
			if (n == 2)	/* tape not unloaded */
				goto reply;
		}
#ifdef FHS
		if (*loader == 'f')
			c = fhsexit (&vrqp, 4);
#endif
		needrbtmnt = 1;
		continue;
	}

	/* tape is mounted */

#if SACCT
	tapeacct (TPMOUNTED, uid, gid, jid, nqsid, dgn, unm, vid, fseq, "");
#endif
	uvreq.tobemounted = 0;
	uvreq.cfseq = cfseq;
	if ((c = send2tpd (&uvreq, NULL, (int *)0)) != 0) goto reply;

#ifdef TMS
	c = tmsexit (&vrqp, 2);
	if (c != 0) {
		strcpy (rep.data, repbuf);
		goto reply;
	}
#endif

positp:
#if SONYRAW
    if (! sonyraw) {
#endif
	lbl4pos = prelabel != 0 ? BLP : lbl;
	if ((c = posittape (tapefd, path, devtype, lbl4pos, ring, &cfseq, fid,
	    filstat, fsec, fseq, den, ignoreeoi, Nflag, Qfirst, Qlast,
	    vol1, hdr1, hdr2)))
		goto reply;
#if SONYRAW
    } else {
	if (! prelabel) {
		if (fseq < 600) fseq = 7000;
		if (c = locate_sony (tapefd, path, fseq)) goto reply;
		cfseq = fseq;
	}
    }
#endif

	/* tape is positionned */

#if SACCT
	tapeacct (TPPOSIT, uid, gid, jid, nqsid, dgn, unm, vid, cfseq, "");
#endif
	if (lbl == AL || lbl == SL) {
		if (filstat != 'n') {
			if (fid[0] == '\0') {
				strncpy (tpfid, hdr1 + 4, 17);
				tpfid [17] = '\0';
				if ((p = strchr (tpfid, ' ')) != NULL) *p = '\0';
				strcpy (fid, tpfid);
			}
			if (hdr2[0]) {
				if (recfm[0] == '\0') {
					memset (recfm, 0, 4);
					recfm[0] = hdr2[4];
					if (lbl == SL && hdr2[38] != ' ') {
						if (hdr2[38] == 'R')
							memcpy (recfm + 1, "BS", 2);
						else
							recfm[1] = hdr2[38];
					}
				}
				if (blksize == 0) sscanf (hdr2 + 5, "%5d", &blksize);
				if (lrecl == 0) sscanf (hdr2 + 10, "%5d", &lrecl);
			}
		} else {
			if (fid[0] == '\0') {
				p = strrchr (path, '/') + 1;
				if ((i = strlen (p) - 17) > 0) p += i;
				UPPER (p);
				strcpy (fid, p);
			}
			if (recfm[0] == '\0')
				strcpy (recfm, "U");
			if (blksize == 0)
				if (strcmp (devtype, "SD3")) {
					if (lrecl == 0)
						blksize = 32760;
					else
						blksize = lrecl;
				} else {
					if (lrecl == 0)
						blksize = 262144;
					else if (strcmp (recfm, "F") == 0) {
						blksize = (262144 / lrecl) * lrecl;
						strcpy (recfm, "FB");
					} else
						blksize = lrecl;
				}
			if (lrecl == 0 && strcmp (recfm, "U")) lrecl = blksize;
		}
	}

	ufreq.blksize = blksize;
	ufreq.cfseq = cfseq;
	strcpy (ufreq.fid, fid);
	ufreq.lrecl = lrecl;
	strcpy (ufreq.recfm, recfm);
	if ((c = send2tpd (&ufreq, NULL, (int *)0)) != 0) goto reply;

	/* do the prelabel if flag is set */

	if (prelabel) {
#if SONYRAW
	    if (! sonyraw) {
#endif
		close (tapefd);
		if ((tapefd = open (path, O_WRONLY)) < 0) {
			usrmsg (func, TP042, path, "reopen", sys_errlist[errno]);
			c = errno;
			goto reply;
		}
		if (lbl != NL) {
			buildvollbl (vol1, vsn, lbl, name);
			if (lbl == SL) asc2ebc (vol1, 80);
			if ((c = writelbl (tapefd, path, vol1)) < 0) goto reply;
			if (prelabel > 0) {
				buildhdrlbl(hdr1, hdr2,
					fid, 1, 1, retentd,
					recfm, blksize, lrecl, den, lbl);
				if (lbl == SL) asc2ebc (hdr1, 80);
				if ((c = writelbl (tapefd, path, hdr1)) < 0) goto reply;
				if (prelabel > 1) {
					if (lbl == SL) asc2ebc (hdr2, 80);
					if ((c = writelbl (tapefd, path, hdr2)) < 0) goto reply;
				}
			}
		}
		if  ((c = wrttpmrk (tapefd, path, 1)) < 0) goto reply;
		if (strncmp (devtype, "DLT", 3) && strcmp (devtype, "3590") &&
		    strcmp (devtype, "SD3") && strcmp (devtype, "9840"))
			if  ((c = wrttpmrk (tapefd, path, 1)) < 0) goto reply;
		if (strcmp (devtype, "SD3") == 0)	/* flush buffer */
			if  ((c = wrttpmrk (tapefd, path, 0)) < 0) goto reply;
#if SONYRAW
	    } else {
		if (c = erase_sony (tapefd, path)) goto reply;
	    }
#endif
		rep.rh.size = sizeof(struct tpdrphdr) + strlen (rep.data);
		goto reply;
	}

	if (c == 0) {
		for (i = 0; i < MAXPATH; i++)
			labelinfo.path[i] = ' ';
		memcpy (labelinfo.path, path, strlen (path));
		memcpy (labelinfo.labeltype, labels[lbl], 2);
		labelinfo.Tflag = Tflag;
		sprintf (labelinfo.fseq, "%.4d", cfseq);
		if (lbl == AL || lbl == SL) {
			buildvollbl (vol1, vsn, lbl, name);
			if (ring == OUT || filstat == 'a')
				memcpy (labelinfo.hdr1, hdr1, 80);
			buildhdrlbl(hdr1, hdr2,
				fid, fsec, cfseq, retentd,
				recfm, blksize, lrecl, den, lbl);
			memcpy (labelinfo.vol1, vol1, 80);
			if (ring == IN && filstat != 'a')
				memcpy (labelinfo.hdr1, hdr1, 80);
			memcpy (labelinfo.hdr2, hdr2, 80);
		} else {
			for (i = 0; i< 80; i++) {
				labelinfo.vol1[i] = ' ';
				labelinfo.hdr1[i] = ' ';
				labelinfo.hdr2[i] = ' ';
			}
		}
		labelinfo.lf = '\n';
		memcpy (rep.data, (char *)&labelinfo, sizeof(struct labelinfo));
		rep.rh.size = sizeof(struct tpdrphdr) + sizeof(struct labelinfo);
	}

reply:
	if (c < 0) c = -c;
	if (c) {
		rep.rh.rc = c;
		rep.rh.size = sizeof(struct tpdrphdr) + strlen (rep.data) + 1;
		cleanup();
	} else {
		close (tapefd);
#if defined(_AIX) && defined(_IBMR2) && defined(RS6000PCTA)
                if (*loader == 'l')
                        closelmcp ();
#endif
#if defined(CDK)
		if (*loader == 'a')
			wait4acsfinalresp();
#endif
#if defined(DMSCAPI)
		if (*loader == 'R')
			closefbs (loader);
#endif
	}
	sendrep (rpn, &rep);

	oereq.rh.size = sizeof(struct ovlend);
	oereq.rh.code = OVLEND;
	oereq.ux = ux;
	oereq.mntovly_pid = getpid();
	c = send2tpd (&oereq, NULL, (int *)0);
	exit (0);
}

void cleanup()
{
	int c, n;

	tplogit (func, "cleanup started");
	if (tapefd >= 0)
		close (tapefd);
#if defined(_AIX) && defined(_IBMR2) && defined(RS6000PCTA)
	if (*loader == 'l')
		closelmcp ();
#endif
#if defined(CDK)
	if (*loader == 'a')
		wait4acsfinalresp();
#endif
#if defined(DMSCAPI)
	if (*loader == 'R')
		closefbs();
#endif
	if (*loader == 's')
		closesmc ();

	if (msg_num)	/* cancel pending operator message */
		omsgdel (func, msg_num);

	/* must unload and deassign */

	c = send2tpd (&rlsreq, repbuf, &n);
}

configdown(unm)
char *unm;
{
	struct tpconf confreq;
	int n;

	sprintf (msg, TP033, unm, hostname); /* ops msg */
	omsgr ("configdown", msg, 0);
	memset ((char *)&confreq, 0, sizeof(confreq));
	confreq.rh.size = sizeof(struct tpconf);
	confreq.rh.code = TPCONF;
	confreq.status = 0;	/* down */
	strcpy (confreq.unm[0], unm);
	confreq.count = 1;
	send2tpd (&confreq, repbuf, &n);
}

void mountkilled()
{
	cleanup();
#if !defined(ultrix) && !defined(hpux) && !defined(apollo) && !defined(_AIX) && (!defined(__alpha) && !defined(__osf__)) && !defined(SOLARIS)
	unlink (rpn);
#endif
	exit (2);
}

rbtdmntchk(c, unm, demountforce)
int *c;
char *unm;
unsigned int *demountforce;
{
	fd_set readfds;
	struct timeval rbttimeval;

	switch (*c) {
	case 0:
		return (0);
	case RBT_NORETRY:
	case RBT_SLOW_RETRY:
		*c = EIO;
		return (-1);
	case RBT_FAST_RETRY:
		omsgr (func, msg, 0);
		rbttimeval.tv_sec = RBTFASTRI;
		rbttimeval.tv_usec = 0;
		memcpy (&readfds, &readmask, sizeof(readmask));
		if (select (maxfds, &readfds, (fd_set *)0,
		    (fd_set *)0, &rbttimeval) > 0 && testorep (&readfds)) {
			checkorep (func, orepbuf);
			if (strncmp (orepbuf, "cancel", 6) == 0) {
				*c = EIO;
				return (-1);
			}
		}
		return (1);	/* retry */
	case RBT_DMNT_FORCE:
		if (*demountforce) {
			*c = EIO;
			return (-1);
		} else {
			*demountforce = 1;
			return (1);
		}
	case RBT_CONF_DRV_DN:
		configdown (unm);
		*c = EIO;
		return (-1);
	case RBT_OMSG_NORTRY:
		omsgr (func, msg, 0);
		*c = EACCES;
		return (-1);
	case RBT_OMSG_SLOW_R:
	case RBT_OMSGR:
		omsgr (func, msg, 0);
		checkorep (func, orepbuf);
		if (strncmp (orepbuf, "cancel", 6) == 0) {
			*c = EIO;
			return (-1);
		}
		return (1);	/* retry */
	case RBT_UNLD_DMNT:
		*c = EIO;
		return (2);	/* may be unload and retry */
	default:
		return (-1);	/* unrecoverable error */
	}
}

rbtmountchk(c, unm, vid, dvn, loader)
int *c;
char *unm;
char *vid;
char *dvn;
char *loader;
{
	unsigned int demountforce;
	int n;
	fd_set readfds;
	struct timeval rbttimeval;
	int tapefd;

	switch (*c) {
	case 0:
		return (0);
	case RBT_NORETRY:
		*c = EIO;
		return (-1);
	case RBT_SLOW_RETRY:
		*c = ETVBSY;	/* volume in use (ifndef TMS) */
		return (-1);
	case RBT_FAST_RETRY:
		rbttimeval.tv_sec = RBTFASTRI;
		rbttimeval.tv_usec = 0;
		memcpy (&readfds, &readmask, sizeof(readmask));
		if (select (maxfds, &readfds, (fd_set *)0,
		    (fd_set *)0, &rbttimeval) > 0 && testorep (&readfds))
			return (2);	/* get & process operator reply */
		else
			return (1);	/* retry */
	case RBT_DMNT_FORCE:
		if ((tapefd = open (dvn, O_RDONLY|O_NDELAY)) < 0) {
			*c = errno;
			return (-1);
		}
		if (chkunitready (tapefd) > 0) {
			if ((*c = unldtape (tapefd, dvn)) < 0) {
				close (tapefd);
				return (-1);
			}
		}
		close (tapefd);
		demountforce = 1;
		do {
			*c = rbtdemount (vid, unm, dvn, loader, demountforce);
			if ((n = rbtdmntchk (c, unm, &demountforce)) < 0)
				return (-1);
		} while (n == 1);
		if (n == 2)	/* tape not unloaded */
			return (-1);
		return (1);	/* retry */
	case RBT_CONF_DRV_DN:
		configdown (unm);
		*c = EIO;
		return (-1);
	case RBT_OMSG_NORTRY:
		omsgr (func, msg, 0);
		*c = EACCES;	/* volume not in library */
		return (-1);
	case RBT_OMSG_SLOW_R:
		omsgr (func, msg, 0);
		*c = ETVBSY;	/* volume in use or inaccessible */
		return (-1);
	case RBT_OMSGR:
		omsgr (func, msg, 0);
		return (2);	/* get & process operator reply */
	default:
		return (-1);	/* unrecoverable error */
	}
}
