/*
 * Copyright (C) 1990-1994 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)getunitstat.c	1.14 05/12/97 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

#include <errno.h>
#if defined(ultrix) || (defined(__osf__) && defined(__alpha))
#include <sys/types.h>
#include <sys/devio.h>
#include <sys/ioctl.h>
#include "tape.h"
chkunitready(tapefd)
int tapefd;
{
	char func[16];
	struct devget mt_info;

	strcpy (func, "chkunitready");
	if (ioctl (tapefd, DEVIOCGET, &mt_info) < 0) {
		tplogit (func, TP002, "", "ioctl", errno);
		return (-errno);	/* error */
	}
	if (mt_info.stat & DEV_OFFLINE)
		return (0);	/* unit not ready */
	else
		return (1);	/* unit ready */
}

chkringstatus(tapefd)
int tapefd;
{
	char func[16];
	struct devget mt_info;

	strcpy (func, "chkringstatus");
	if (ioctl (tapefd, DEVIOCGET, &mt_info) < 0) {
		tplogit (func, TP002, "", "ioctl", errno);
		return (-errno);	/* error */
	}
	if (mt_info.stat & DEV_WRTLCK)
		return (0);	/* ring out */
	else
		return (1);	/* ring in */
}
#else
#if sgi
#include <sys/types.h>
#include <sys/mtio.h>
#include "tape.h"
chkunitready(tapefd)
int tapefd;
{
	char func[16];
	struct mtget mt_info;

	strcpy (func, "chkunitready");
	if (ioctl (tapefd, MTIOCGET, &mt_info) < 0) {
		tplogit (func, TP002, "", "ioctl", errno);
		return (-errno);	/* error */
	}
	if (mt_info.mt_dposn & MT_ONL)
		return (1);	/* unit ready */
	else
		return (0);	/* unit not ready */
}

chkringstatus(tapefd)
int tapefd;
{
	char func[16];
	struct mtget mt_info;

	strcpy (func, "chkringstatus");
	if (ioctl (tapefd, MTIOCGET, &mt_info) < 0) {
		tplogit (func, TP002, "", "ioctl", errno);
		return (-errno);	/* error */
	}
	if (mt_info.mt_dposn & MT_WPROT)
		return (0);	/* ring out */
	else
		return (1);	/* ring in */
}
#else
#if sun
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/mtio.h>
#include "tape.h"
chkunitready(tapefd)
int tapefd;
{
	char func[16];
	struct mtget mt_info;

	strcpy (func, "chkunitready");
	if (ioctl (tapefd, MTIOCGET, &mt_info) < 0) {
		tplogit (func, TP002, "", "ioctl", errno);
		return (-errno);	/* error */
	}
	return (1);	/* if open is successful, unit is ready */
}

chkringstatus(tapefd)
int tapefd;
{
	char func[16];
	struct mtget mt_info;

	strcpy (func, "chkringstatus");
	if (ioctl (tapefd, MTIOCGET, &mt_info) < 0) {
		tplogit (func, TP002, "", "ioctl", errno);
		return (-errno);	/* error */
	}
	if (mt_info.mt_erreg == 7)
		return (0);	/* ring out */
	else
		return (1);	/* ring in */
}
#else
#if hpux || linux
#include <sys/types.h>
#include <sys/mtio.h>
#include "tape.h"
chkunitready(tapefd)
int tapefd;
{
	char func[16];
	struct mtget mt_info;

	strcpy (func, "chkunitready");
	if (ioctl (tapefd, MTIOCGET, &mt_info) < 0) {
		tplogit (func, TP002, "", "ioctl", errno);
		return (-errno);	/* error */
	}
	if (GMT_ONLINE(mt_info.mt_gstat))
		return (1);	/* unit ready */
	else
		return (0);	/* unit not ready */
}

chkringstatus(tapefd)
int tapefd;
{
	char func[16];
	struct mtget mt_info;

	strcpy (func, "chkringstatus");
	if (ioctl (tapefd, MTIOCGET, &mt_info) < 0) {
		tplogit (func, TP002, "", "ioctl", errno);
		return (-errno);	/* error */
	}
	if (GMT_WR_PROT(mt_info.mt_gstat))
		return (0);	/* ring out */
	else
		return (1);	/* ring in */
}
#else
#if _AIX
#include <errno.h>
#include <sys/types.h>
#if defined(_IBMESA) || defined(RS6000PCTA)
#include <sys/ioctl.h>
#include <sys/mtio.h>
#if defined(_IBMESA)
#include <sys/mttms.h>
#endif
#endif
#if defined(ADSTAR)
#include <sys/Atape.h>
#endif
#include "tape.h"
chkunitready(tapefd)
int tapefd;
{
	char func[16];
#if defined(_IBMESA) || defined(RS6000PCTA)
        struct mtop mtop;
#endif
#if defined(ADSTAR)
        struct stop stop;
#endif

#if defined(_IBMR2)
	extern char *dvrname;
	if (strcmp (dvrname, "tape") == 0)
		return (1);	/* if open is successful, unit is ready */
#endif
	strcpy (func, "chkunitready");
#if defined(_IBMESA) || defined(RS6000PCTA)
#if defined(RS6000PCTA)
	if (strncmp (dvrname, "mtdd", 4) == 0) {
#endif
		mtop.mt_op = MTNOP;	/* no-op */
		mtop.mt_count = 1;
		if (ioctl (tapefd, MTIOCTOP, &mtop) < 0) {
			if (errno == EIO || errno == ENOTREADY) {
				return (0);	/* unit not ready */
			} else {
				tplogit (func, TP002, "", "ioctl", errno);
				return (-errno);	/* error */
			}
		}
		return (1);	/* unit ready */
#if defined(RS6000PCTA)
	}
#endif
#endif
#if defined(ADSTAR)
	if (strcmp (dvrname, "Atape") == 0) {
		stop.st_op = STTUR;
		if (ioctl (tapefd, STIOCTOP, &stop) < 0) {
			if (errno == ENOTREADY) {
				return (0);	/* unit not ready */
			} else {
				tplogit (func, TP002, "", "ioctl", errno);
				return (-errno);	/* error */
			}
		}
		return (1);	/* unit ready */
	}
#endif
}

#if defined(_IBMESA) || defined(RS6000PCTA)
chkringstatus(tapefd)
int tapefd;
{
	char func[16];
	struct mtsrbl mtsrbl;
        struct mtop mtop;

	strcpy (func, "chkringstatus");
	mtop.mt_op = MTNOP;	/* no-op */
	mtop.mt_count = 1;
	if (ioctl (tapefd, MTIOCTOP, &mtop) < 0) {
		tplogit (func, TP002, "", "ioctl", errno);
		return (-errno);	/* error */
        }
	mtsrbl.resvd = 0;
	mtsrbl.versn = 0;
	mtsrbl.mtsrblop = MTSNSOP;
	if (ioctl (tapefd, MTSRBLOP, &mtsrbl) < 0) {
		tplogit (func, TP002, "", "ioctl", errno);
                return (-errno);	/* error */
        }
	if (mtsrbl.mtsrblinfo[1] & 0x2)
		return (0);	/* ring out */
	else
		return (1);	/* ring in */
}
#endif
#endif
#endif
#endif
#endif
#endif
