/*
 * Copyright (C) 1994-1995 by CERN/CN/PDP/DH
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)getlabelinfo.c	1.4 08/16/95 CERN CN-PDP/DH Jean-Philippe Baud";
#endif /* not lint */

#include <errno.h>
#include <fcntl.h>
#include <string.h>
#include <sys/types.h>
#include "tape.h"

/*	gethdrinfo - get information from HDR labels */
/*	return	-errno	in case of error
 *		0	for labelled tapes
 *		1	for nl or blp
 */
gethdrinfo (path, fid, fseq, recfm, blksize, lrecl)
char	*path;
char	*fid;
int	*fseq;
char	*recfm;
int	*blksize;
int	*lrecl;
{
	int c;
	char hdr1[81], hdr2[81];
	char labeltype;
	char *p;
	char Tflag;
	char tpfid[18];
	char vol1[81];

	if ((c = getlabelinfo (path, vol1, hdr1, hdr2, fseq, &labeltype, &Tflag)) < 0)
		return (c);
	if (labeltype == 'n' || labeltype == 'b')	/* tape is unlabelled */
		return (1);
	strncpy (tpfid, hdr1 + 4, 17);
	tpfid [17] = '\0';
	if ((p = strchr (tpfid, ' ')) != NULL) *p = '\0';
	strcpy (fid, tpfid);
	memset (recfm, 0, 4);
	*recfm = hdr2[4];
	if (labeltype == 's' && hdr2[38] != ' ') {
		if (hdr2[38] == 'R')
			memcpy (recfm + 1, "BS", 2);
		else
			*(recfm + 1) = hdr2[38];
	}
	sscanf (hdr2 + 5, "%5d", blksize);
	sscanf (hdr2 + 10, "%5d", lrecl);
	return (0);
}

getlabelinfo (path, vol1, hdr1, hdr2, fseq, labeltype, Tflag)
char *path;
int *fseq;
char *hdr1, *hdr2, *vol1;
char *labeltype;
char *Tflag;
{
	int c;
	char func[16];
	char *getenv();
	struct labelinfo labelinfo;
	char *p;
	int tplblfd;
	char *tplblfn;

	strcpy (func, "getlabelinfo");

	/* get label info */

	if ((tplblfn = getenv ("TAPENV")) == NULL)
		tplblfn = ".tplabel";
	if ((tplblfd = open (tplblfn, O_RDONLY)) <0) {
		usrmsg (func, TP002, tplblfn, "open", errno);
		return (-errno);
	} else {
		c = -ENOENT;
		while (read (tplblfd, (char *)&labelinfo, sizeof(struct labelinfo)) ==
		       sizeof(struct labelinfo)) {
			p = strchr (labelinfo.path, ' ');
			*p = '\0';
			if (strcmp (labelinfo.path, path) == 0) {
				*labeltype = labelinfo.labeltype[0];
				*Tflag = labelinfo.Tflag;
				sscanf (labelinfo.fseq, "%4d", fseq);
				memcpy (vol1, labelinfo.vol1, 80);
				vol1[80] = '\0';
				memcpy (hdr1, labelinfo.hdr1, 80);
				hdr1[80] = '\0';
				memcpy (hdr2, labelinfo.hdr2, 80);
				hdr2[80] = '\0';
				c = 0;
				break;
			}
		}
		close (tplblfd);
	}
	return (c);
}
