/*
 * Copyright (C) 1993 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)getdvrnam.c	1.1 02/16/94 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

#include <sys/stat.h>
#include <odmi.h>
#include "CuDv.h"
#include "CuDvDr.h"
getdvrnam(path, dvrname)
char *path;
char *dvrname;
{
	char buf[64];
	struct CuDv CuDv;
	struct CuDvDr CuDvDr;
	struct stat st;

	stat (path, &st);
	if (odm_initialize () < 0) return (-odmerrno);
	sprintf (buf, "resource=ddins and value2=%d", st.st_rdev >> 16);
	if (odm_get_first (CuDvDr_CLASS, buf, &CuDvDr) > 0) {	/* PCTA */
		strcpy (dvrname, CuDvDr.value1);
	} else {	/* SCSI */
		sprintf (buf, "resource=devno and value1=%d and value2=%d",
			st.st_rdev >> 16, st.st_rdev & 0xFFFF);
		if (odm_get_first (CuDvDr_CLASS, buf, &CuDvDr) <= 0) {
			odm_terminate();
			return (-odmerrno);
		}
		sprintf (buf, "name=%s", CuDvDr.value3);
		if (odm_get_first (CuDv_CLASS, buf, &CuDv) <= 0) {
			odm_terminate();
			return (-odmerrno);
		}
		strcpy (dvrname, CuDv.ddins);
	}
	odm_terminate();
	return (0);
}
