/*
 * Copyright (C) 1990-1997 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)findpgrp.c	1.17 08/22/97 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

/*	findpgrp - get process group (replaces getpgrp broken by C-shell) */
#include <errno.h>
#include <sys/time.h>
#include <sys/types.h>
#ifndef linux
#if HPUX10
#include <sys/param.h>
#include <sys/pstat.h>
#else
#if defined(SOLARIS) || defined(IRIX5) || (defined(__osf__) && defined(__alpha))
#if defined(__osf__) && defined(__alpha)
#include <sys/ioctl.h>
#endif
#include <sys/procfs.h>
#else
#if sun
#include <kvm.h>
#include <stdio.h>
#endif
#if sgi
#include <sys/syssgi.h>
#include <sys/user.h>
#else
#include <nlist.h>
#endif
#include <sys/proc.h>
#if _AIX && _IBMR2
#include <sys/sysconfig.h>
#include <sys/var.h>
#endif
#endif
#endif
#endif
#include "tape.h"
static char func[16];
findpgrp()
{
	int pgrp, pid;
	uid_t uid;
#ifndef linux
#if HPUX10
	struct pst_status stproc;
#else
#if defined(sun) && !defined(SOLARIS)
	kvm_t *Flkvm;
#else
	int fdkmem;
#endif
#if defined(SOLARIS) || defined(IRIX5) || (defined(__osf__) && defined(__alpha))
	struct prpsinfo prpsinfo;
	char name[12];
#else
#if sgi
	long procaddr;
	struct user *user;
#else
	struct proc *findproc();
	static struct nlist nl[3];
	int nproc;
	struct proc *p;
	long proctabaddr;
#endif
	struct proc *proctab;
#endif
#if _AIX && _IBMR2
	long lastprocaddr;
	int proctabsiz;
	struct var var;
#endif
#endif
#endif
	ENTRY (findpgrp);
	pid = getpid();
	pgrp = pid;
	uid = getuid();

#if HPUX10
	while (pid != 1) {
		if (pstat_getproc (&stproc, sizeof(struct pst_status), 0, pid) < 0) {
			tplogit (func, TP002, "", "pstat_getproc", errno);
			RETURN (-1);
		}
		if (stproc.pst_uid != uid) break;
		pgrp = stproc.pst_pid;
		pid = stproc.pst_ppid;
	}
#else
#if defined(linux)
	if ((pgrp = getsid (0)) < 0) {
		tplogit (func, TP002, "", "getsid", errno);
		RETURN (-1);
	}
#else
#if defined(SOLARIS) || defined(IRIX5) || (defined(__osf__) && defined(__alpha))
	sprintf (name, "/proc/%.5d", pid);
	fdkmem = open (name, 0);
	if (fdkmem < 0) {
		tplogit (func, TP002, name, "open", errno);
		RETURN (-1);
	}
	if (ioctl (fdkmem, PIOCPSINFO, &prpsinfo) < 0) {
		tplogit (func, TP002, name, "ioctl", errno);
		close (fdkmem);
		RETURN (-1);
	}
	pgrp = prpsinfo.pr_sid;
	close (fdkmem);
#else
#if sgi
	user = (struct user *) calloc (1, sizeof(struct user));
	if (user == 0) {
		tplogit (func, TP005);
		RETURN (-1);
	}
	syssgi (SGI_RDUBLK, pid, user, sizeof(struct user));
	procaddr = (long) user->u_procp & 0x7fffffff;
	free (user);
	fdkmem = open ("/dev/kmem", 0);
	if (fdkmem < 0) {
		tplogit (func, TP002, "/dev/kmem", "open", errno);
		RETURN (-1);
	}
	proctab = (struct proc *) malloc (sizeof(struct proc));
	if (proctab == 0) {
		tplogit (func, TP005);
		close (fdkmem);
		RETURN (-1);
	}
	if (lseek (fdkmem, procaddr, 0) < 0) {
		tplogit (func, TP002, "/dev/kmem", "lseek", errno);
		close (fdkmem);
		free (proctab);
		RETURN (-1);
	}
	if (read (fdkmem, (char *) proctab, sizeof(struct proc)) < 0) {
		tplogit (func, TP002, "/dev/kmem", "read", errno);
		close (fdkmem);
		free (proctab);
		RETURN (-1);
	}
	while (proctab->p_uid == uid) {
		if (proctab->p_ppid == 1) break;
		pgrp = proctab->p_pid;
		procaddr = (long) proctab->p_parent & 0x7fffffff;
		if (lseek (fdkmem, procaddr, 0) < 0) {
			tplogit (func, TP002, "/dev/kmem", "lseek", errno);
			close (fdkmem);
			free (proctab);
			RETURN (-1);
		}
		if (read (fdkmem, (char *) proctab, sizeof(struct proc)) < 0) {
			tplogit (func, TP002, "/dev/kmem", "read", errno);
			close (fdkmem);
			free (proctab);
			RETURN (-1);
		}
	}
	close (fdkmem);
#else
#if sun
	nl[0].n_name = "_proc";
	nl[1].n_name = "_nproc";
	Flkvm = kvm_open ("/vmunix", NULL, NULL, 0, "findpgrp");
	if (Flkvm == 0) RETURN (-1);
	kvm_nlist (Flkvm, nl);
	if (kvm_read (Flkvm, nl[0].n_value, &proctabaddr, 4) < 0) {
		tplogit (func, TP002, "/dev/kmem", "kvm_read", errno);
		kvm_close (Flkvm);
		RETURN (-1);
	}
	if (kvm_read (Flkvm, nl[1].n_value, &nproc, 4) < 0) {
		tplogit (func, TP002, "/dev/kmem", "kvm_read", errno);
		kvm_close (Flkvm);
		RETURN (-1);
	}
	proctab = (struct proc *) malloc (nproc * sizeof(struct proc));
	if (proctab == 0) {
		tplogit (func, TP005);
		kvm_close (Flkvm);
		RETURN (-1);
	}
	if (kvm_read (Flkvm, proctabaddr, (char *) proctab, nproc * sizeof(struct proc)) < 0) {
		tplogit (func, TP002, "/dev/kmem", "kvm_read", errno);
		kvm_close (Flkvm);
		free (proctab);
		RETURN (-1);
	}
	kvm_close (Flkvm);

	while ((p = findproc (proctab, pid))->p_uid == uid) {
		if (p->p_ppid == 1) break;
		pgrp = p->p_pid;
		pid = p->p_ppid;
	}
#else
#if ultrix
	nl[0].n_name = "_proc";
	nl[1].n_name = "_nproc";
	nlist ("/vmunix", nl);
	fdkmem = open ("/dev/kmem", 0);
	if (fdkmem < 0) {
		tplogit (func, TP002, "/dev/kmem", "open", errno);
		RETURN (-1);
	}
	if (lseek (fdkmem, nl[0].n_value, 0) < 0) {
		tplogit (func, TP002, "/dev/kmem", "lseek", errno);
		close (fdkmem);
		RETURN (-1);
	}
	if (read (fdkmem, &proctabaddr, 4) < 0) {
		tplogit (func, TP002, "/dev/kmem", "read", errno);
		close (fdkmem);
		RETURN (-1);
	}
	if (lseek (fdkmem, nl[1].n_value, 0) < 0) {
		tplogit (func, TP002, "/dev/kmem", "lseek", errno);
		close (fdkmem);
		RETURN (-1);
	}
	if (read (fdkmem, &nproc, 4) < 0) {
		tplogit (func, TP002, "/dev/kmem", "read", errno);
		close (fdkmem);
		RETURN (-1);
	}
	proctab = (struct proc *) malloc (nproc * sizeof(struct proc));
	if (proctab == 0) {
		tplogit (func, TP005);
		close (fdkmem);
		RETURN (-1);
	}
	if (lseek (fdkmem, proctabaddr, 0) < 0) {
		tplogit (func, TP002, "/dev/kmem", "lseek", errno);
		close (fdkmem);
		free (proctab);
		RETURN (-1);
	}
	if (read (fdkmem, (char *) proctab, nproc * sizeof(struct proc)) < 0) {
		tplogit (func, TP002, "/dev/kmem", "read", errno);
		close (fdkmem);
		free (proctab);
		RETURN (-1);
	}
	close (fdkmem);

	while ((p = findproc (proctab, pid))->p_uid == uid) {
		if (p->p_ppid == 1) break;
		pgrp = p->p_pid;
		pid = p->p_ppid;
	}
#else
#if hpux
	nl[0].n_name = "proc";
	nl[1].n_name = "nproc";
	nlist ("/hp-ux", nl);
	fdkmem = open ("/dev/kmem", 0);
	if (fdkmem < 0) {
		tplogit (func, TP002, "/dev/kmem", "open", errno);
		RETURN (-1);
	}
	if (lseek (fdkmem, nl[0].n_value, 0) < 0) {
		tplogit (func, TP002, "/dev/kmem", "lseek", errno);
		close (fdkmem);
		RETURN (-1);
	}
	if (read (fdkmem, &proctabaddr, 4) < 0) {
		tplogit (func, TP002, "/dev/kmem", "read", errno);
		close (fdkmem);
		RETURN (-1);
	}
	if (lseek (fdkmem, nl[1].n_value, 0) < 0) {
		tplogit (func, TP002, "/dev/kmem", "lseek", errno);
		close (fdkmem);
		RETURN (-1);
	}
	if (read (fdkmem, &nproc, 4) < 0) {
		tplogit (func, TP002, "/dev/kmem", "read", errno);
		close (fdkmem);
		RETURN (-1);
	}
	proctab = (struct proc *) malloc (nproc * sizeof(struct proc));
	if (proctab == 0) {
		tplogit (func, TP005);
		close (fdkmem);
		RETURN (-1);
	}
	if (lseek (fdkmem, proctabaddr, 0) < 0) {
		tplogit (func, TP002, "/dev/kmem", "lseek", errno);
		close (fdkmem);
		free (proctab);
		RETURN (-1);
	}
	if (read (fdkmem, (char *) proctab, nproc * sizeof(struct proc)) < 0) {
		tplogit (func, TP002, "/dev/kmem", "read", errno);
		close (fdkmem);
		free (proctab);
		RETURN (-1);
	}
	close (fdkmem);

	while ((p = findproc (proctab, pid))->p_uid == uid) {
		if (p->p_ppid == 1) break;
		pgrp = p->p_pid;
		pid = p->p_ppid;
	}
#else
#if _AIX
#if _IBMR2
	nl[0].n_name = "proc";
	knlist (nl, 1, sizeof(struct nlist));
	proctabaddr = nl[0].n_value;
	if (sysconfig (SYS_GETPARMS, &var, sizeof(var)) < 0) {
		tplogit (func, TP002, "", "sysconfig", errno);
		RETURN (-1);
	}
	lastprocaddr = (long) var.ve_proc;
	fdkmem = open ("/dev/kmem", 0);
	if (fdkmem < 0) {
		tplogit (func, TP002, "/dev/kmem", "open", errno);
		RETURN (-1);
	}
	proctabsiz = lastprocaddr - proctabaddr;
	proctab = (struct proc *) malloc (proctabsiz);
	if (proctab == 0) {
		tplogit (func, TP005);
		close (fdkmem);
		RETURN (-1);
	}
	if (seek_and_read (fdkmem, proctabaddr, proctab, proctabsiz) < 0) {
		close (fdkmem);
		free (proctab);
		RETURN (-1);
	}
	close (fdkmem);

	while ((p = findproc (proctab, pid))->p_uid == uid) {
		if (p->p_ppid == 1) break;
		pgrp = p->p_pid;
		pid = p->p_ppid;
	}
#endif
#if _IBMESA
	nl[0].n_name = "proc";
	nl[1].n_name = "nproc";
	nlist ("/vmunix", nl);
	fdkmem = open ("/dev/kmem", 0);
	if (fdkmem < 0) {
		tplogit (func, TP002, "/dev/kmem", "open", errno);
		RETURN (-1);
	}
	if (lseek (fdkmem, nl[0].n_value, 0) < 0) {
		tplogit (func, TP002, "/dev/kmem", "lseek", errno);
		close (fdkmem);
		RETURN (-1);
	}
	if (read (fdkmem, &proctabaddr, 4) < 0) {
		tplogit (func, TP002, "/dev/kmem", "read", errno);
		close (fdkmem);
		RETURN (-1);
	}
	if (lseek (fdkmem, nl[1].n_value, 0) < 0) {
		tplogit (func, TP002, "/dev/kmem", "lseek", errno);
		close (fdkmem);
		RETURN (-1);
	}
	if (read (fdkmem, &nproc, 4) < 0) {
		tplogit (func, TP002, "/dev/kmem", "read", errno);
		close (fdkmem);
		RETURN (-1);
	}
	proctab = (struct proc *) malloc (nproc * (sizeof(struct proc) + 48));
	if (proctab == 0) {
		tplogit (func, TP005);
		close (fdkmem);
		RETURN (-1);
	}
	if (lseek (fdkmem, proctabaddr, 0) < 0) {
		tplogit (func, TP002, "/dev/kmem", "lseek", errno);
		close (fdkmem);
		free (proctab);
		RETURN (-1);
	}
	if (read (fdkmem, (char *) proctab, nproc * (sizeof(struct proc) + 48)) < 0) {
		tplogit (func, TP002, "/dev/kmem", "read", errno);
		close (fdkmem);
		free (proctab);
		RETURN (-1);
	}
	close (fdkmem);

	while ((p = findproc (proctab, pid))->p_ruid == uid) {
		if (p->p_ppid == 1) break;
		pgrp = p->p_pid;
		pid = p->p_ppid;
	}
#endif
#endif
#endif
#endif
#endif
#endif
	free (proctab);
#endif
#endif
#endif
	RETURN (pgrp);
}
#if (defined(hpux) && !defined(HPUX10)) || (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined(_AIX)
struct proc *
findproc(proctab, pid)
struct proc *proctab;
int pid;
{
	struct proc *p;
	p = proctab;
#if _AIX && _IBMESA
	while (p->p_pid != pid) p = (struct proc *) ((int)p + sizeof(struct proc) + 48);
#else
	while (p->p_pid != pid) p++;
#endif
	return (p);
}
#endif
#if _AIX && _IBMR2
#define TWO_GIG (0x80000000)
static int
seek_and_read(fd, offset, data, data_len)
int fd;
long offset;
void *data;
int data_len;
{
	int rc;

	if (offset >= TWO_GIG) {
		if (lseek (fd, offset - TWO_GIG, 0) < 0) {
			tplogit (func, TP002, "/dev/kmem", "lseek", errno);
			return (-1);
		}
		if (readx (fd, data, data_len ,1) < 0) {
			tplogit (func, TP002, "/dev/kmem", "readx", errno);
			return (-1);
		}
	} else {
		if (lseek (fd, offset, 0) < 0) {
			tplogit (func, TP002, "/dev/kmem", "lseek", errno);
			return (-1);
		}
		if (readx (fd, data, data_len ,0) < 0) {
			tplogit (func, TP002, "/dev/kmem", "readx", errno);
			return (-1);
		}
	}
	return (0);
}
#endif
