#!DMPSHELL
#
#  Copyright (C) 1990-1998 by CERN/CN/SW/CU
#  All rights reserved
#
#       @(#)dumptape.sh	1.24 12/09/98 CERN CN-SW/CU Jean-Philippe Baud
 
# dumptape   Dumps a tape and analyzes its content.
#
# calling seqence:
#
# dumptape -V VID [-d {6250|1600}] [-g {CART|CT1|8MM}]
#	  [-B maxbyt] [-C {ebcdic|ascii}] [-F maxfil] [-N blknos]
#
#   -B  number of bytes per block to be dumped
#   -C  character code for data interpretation
#   -F  Number of files to be dumped
#   -N  starting and ending block numbers to be dumped
#   -V  tape VID
#
ODMDIR=/etc/objrepos
export ODMDIR
# set defaults
code=ebcdic
blknos=1
maxbyt=320
#
tpath=".tspath"
#
set -- `getopt B:C:E:F:N:S:V:b:d:g:v: $*`
if test $? != 0
then
    exit 1
fi
#
while test $# -gt 0
do  case $1 in
    -B)     maxbyt=$2; shift;;
    -C)     code=$2; shift;;
    -E)     Eflag="-E "$2; shift;;
    -F)     maxfil="-F "$2; shift;;
    -N)     blknos=$2; shift;;
    -S)     shift;;
    -V)     vid=$2; shift;;
    -b)     blksiz=$2; shift;;
    -d)     den=$2; shift;;
    -g)     devgroup=$2; shift;;
    -v)     vsn=$2; shift;;
    --)     break;;
    *)      echo "Bad parameter: " $1; exit 1;;
    esac
    shift
done
#
if [ -z "$vsn" -a -z "$vid" ]
then
    echo "The vsn or the vid must be specified"
    exit 1
fi
if [ -z "$vid" ]
then
    vid=$vsn
fi
#
tpvsn=""
tmvid=$vid
tmvsn=$vsn
#
# Only if TMS is used and information on tape is missing.
#
if [ ! -f NOTMSDAEMON -a USINGTMS = "TMS" -a \
    \( \( -z "$den" -a "$devgroup" != "CART" \) \
    -o -z "$devgroup" -o -z "$tmvsn" \) ]
then
    OIFS=$IFS
    IFS="
"
    while true
    do
        tmrep=`BIN/tmsreq qvol $tmvid \( message`
	tmsreqrc=$?
	case $tmsreqrc in
	    0)	break;;
	    8)	echo $tmrep ; exit 1 ;;		# Vid syntax error
	    12)	echo $tmrep ; exit 1 ;;		# Permission denied
	    56)	echo $tmrep ; exit 1 ;;		# Volume unavailable
	    59)	echo $tmrep ; exit 1 ;;		# Volume unmountable
	    100) echo $tmrep ; exit 1 ;;	# Volume not known
	    85)	sleep 300;;			# tms not active
	    *)	echo $tmrep
		BIN/msgr "$tmrep" ;;
	esac
    done
    if [ -z "$tmvsn" ]
    then
	tmvsn=`echo $tmrep | cut -c1-6 | cut -d' ' -f1`
    fi
    if [ -z "$devgroup" ]
    then
	devgroup=`echo $tmrep | cut -c26-31 | cut -d' ' -f1`
    fi
    if [ -z "$den" ]
    then
	den=`echo $tmrep | cut -c33-40`
    fi
    IFS=$OIFS
else
    if [ -z "$tmvsn" ]
    then
	tmvsn=$tmvid
    fi
    if [ -z "$devgroup" ]
    then
	devgroup=CART
    fi
    if [ $devgroup = "TAPE" -a -z "$den" ]
    then
	den=6250
    fi
fi
tmvsn=`echo $tmvsn | tr '[a-z]' '[A-Z]'`
tmvid=`echo $tmvid | tr '[a-z]' '[A-Z]'`
if [ "$tmvid" = "$tmvsn" ]
then
    tpvsn=$tmvsn
else
    tpvsn=$tmvsn"="$tmvid
fi
if [ $devgroup = "CT1" ]
then
    devgroup=CART
fi
if [ $devgroup != "CART" -a -n "$den" ]
then
    tpden="-d "$den
fi
code=`echo $code | tr '[a-z]' '[A-Z]'`
#
# creating the tape path and the label information file path
#
if [ -z "$PIDNUMBER" ]
then
    PIDNUMBER=$$
fi
tpath="PATH"${PIDNUMBER}
j=0
if [ -f $tpath ]
then
    while [ -f $tpath"."$j ]
    do
	j=`expr $j + 1`
    done
    tpath=$tpath"."$j
fi
TAPENV=".TP"${PIDNUMBER}
j=0
if [ -f $TAPENV ]
then
    while [ -f $TAPENV"."$j ]
    do
	j=`expr $j + 1`
    done
    TAPENV=$TAPENV"."$j
fi
export TAPENV
#
while test -f NOMORETAPES
#
# operators don't want tape requests
#
do
    sleep 300
done
#
# reserve the device unit if none reserved by the user
#
errmsg=`BIN/reserv $devgroup 1 2>&1`
reservrc=$?
#
# ## Fix to allow 3480 read mounts on 3490 devices.
#
if [ $reservrc -eq 207 -a \( "$devgroup" = "CART" -o "$devgroup" = "CT1" \) ]; then
    devgroup="CT2"
    BIN/reserv $devgroup 1
    reservrc=$?
elif [ $reservrc -ne 0 ]; then
    echo $errmsg >&2
fi
case $reservrc in
    0)          rflag="";;      #reserved by dumptape
    204)        rflag="-k";;    #reserved by user
    205)        exit 205;;      #too many tape users
    *)		exit 2;;
esac
#
# mount the tape
#
echo " `date '+%T'` + tpmnt -F U $tpden -g $devgroup -l blp \
-P $tpath -q 1 -r out -v $tpvsn -n"
BIN/tpmnt -F U $tpden -g $devgroup -l blp \
      -P $tpath -q 1 -r out -v $tpvsn -n
tpmntrc=$?
# test if parameter error
#      or device not reserved
#      or no device allocated (used >= reserved)
if test $tpmntrc -ne 0
then
    if test $tpmntrc -ne 208
    then
        echo "`date '+%T'` + rls $rflag -p $tpath"
        BIN/rls $rflag -p $tpath
    fi
    if test $tpmntrc -eq 203 -o $tpmntrc -eq 208 -o $tpmntrc -eq 206 -o $tpmntrc -eq 13
    then
	exit 1
    elif test $tpmntrc -eq 222
    then
	exit 222	#reselect server
    else
	exit 2
    fi
fi
#
# get the device type
#
tpinforep=`BIN/tpinfo -P $tpath`
if test $? -ne 0
then
    exit 2
fi
set -- `getopt b:D:d:F:f:L:q:T: $tpinforep`
if test $? -ne 0
then
    exit 2
fi
while test $# -gt 0
do  case $1 in
    -b)     shift;;
    -D)     echo " DUMP - TAPE MOUNTED ON UNIT $2"; shift;;
    -d)     den=$2; shift;;
    -F)     shift;;
    -f)     shift;;
    -L)     shift;;
    -q)     shift;;
    -T)     devtype=$2; shift;;
    --)     break;;
    *)      echo "Bad parameter in tpinfo reply: " $1; exit 2;;
    esac
    shift
done
if [ -z "$blksiz" ]
then
    if [ "$devtype" = "SD3" ]
    then
	blksiz=262144
    else
	blksiz=65536
    fi
fi
#
# analyze the tape
#
BIN/dmpfil -i $tpath -B $maxbyt -C $code $maxfil -N $blknos -V $tmvid -b $blksiz -d $den $Eflag -T $devtype
rc=$?
#
# release device unit if own reservation
#
echo " `date '+%T'` + rls $rflag -p $tpath"
BIN/rls $rflag -p $tpath
exit $rc
