#!DMPSHELL
#
#  Copyright (C) 1994-1998 by CERN/CN/PDP/DH
#  All rights reserved
#
#       @(#)dumplabel.sh	1.3 12/09/98 CERN CN-PDP/DH Jean-Philippe Baud

# dumplabel   Dumps a tape label and analyzes its content.
#
# calling seqence:
#
# dumplabel -V VID
#
ODMDIR=/etc/objrepos
export ODMDIR
tpath=".tspath"
#
set -- `getopt V: $*`
if test $? != 0
then
    exit 1
fi
#
while test $# -gt 0
do  case $1 in
    -V)     vid=$2; shift;;
    --)     break;;
    *)      echo "Bad parameter: " $1; exit 1;;
    esac
    shift
done
#
if [ -z "$vid" ]
then
    echo "The vid must be specified"
    exit 1
fi
#
tpvsn=""
tmvid=$vid
tmvsn=$vsn
#
# Only if TMS is used and information on tape is missing.
#
if [ ! -f NOTMSDAEMON -a USINGTMS = "TMS" -a \
    \( \( -z "$den" -a "$devgroup" != "CART" \) \
    -o -z "$devgroup" -o -z "$tmvsn" \) ]
then
    OIFS=$IFS
    IFS="
"
    while true
    do
        tmrep=`BIN/tmsreq qvol $tmvid \( message`
	tmsreqrc=$?
	case $tmsreqrc in
	    0)	break;;
	    8)	echo $tmrep ; exit 1 ;;		# Vid syntax error
	    12)	echo $tmrep ; exit 1 ;;		# Permission denied
	    56)	echo $tmrep ; exit 1 ;;		# Volume unavailable
	    59)	echo $tmrep ; exit 1 ;;		# Volume unmountable
	    100) echo $tmrep ; exit 1 ;;	# Volume not known
	    85)	sleep 300;;			# tms not active
	    *)	echo $tmrep
		BIN/msgr "$tmrep" ;;
	esac
    done
    if [ -z "$tmvsn" ]
    then
	tmvsn=`echo $tmrep | cut -c1-6 | cut -d' ' -f1`
    fi
    if [ -z "$devgroup" ]
    then
	devgroup=`echo $tmrep | cut -c26-31 | cut -d' ' -f1`
    fi
    if [ -z "$den" ]
    then
	den=`echo $tmrep | cut -c33-40`
    fi
    IFS=$OIFS
else
    if [ -z "$tmvsn" ]
    then
	tmvsn=$tmvid
    fi
    if [ -z "$devgroup" ]
    then
	devgroup=CART
    fi
    if [ $devgroup = "TAPE" -a -z "$den" ]
    then
	den=6250
    fi
fi
tmvsn=`echo $tmvsn | tr '[a-z]' '[A-Z]'`
tmvid=`echo $tmvid | tr '[a-z]' '[A-Z]'`
if [ "$tmvid" = "$tmvsn" ]
then
    tpvsn=$tmvsn
else
    tpvsn=$tmvsn"="$tmvid
fi
if [ $devgroup = "CT1" ]
then
    devgroup=CART
fi
if [ $devgroup != "CART" -a -n "$den" ]
then
    tpden="-d "$den
fi
#
while test -f NOMORETAPES
#
# operators don't want tape requests
#
do
    sleep 300
done
#
# reserve the device unit if none reserved by the user
#
BIN/reserv $devgroup 1
case $? in
    0)          rflag="";;      #reserved by dumplabel
    55)         rflag="-k";;    #reserved by user
    *)          exit 2;;
esac
#
# mount the tape
#
echo " `date '+%T'` + tpmnt -g $devgroup -l blp -P $tpath -q 1 -r out -v $tpvsn -n"
BIN/tpmnt -g $devgroup -l blp -P $tpath -q 1 -r out -v $tpvsn -n
tpmntrc=$?
# test if parameter error
#      or device not reserved
#      or no device allocated (used >= reserved)
if test $tpmntrc -ne 0
then
    if test $tpmntrc -ne 208
    then
        echo "`date '+%T'` + rls $rflag -p $tpath"
        BIN/rls $rflag -p $tpath
    fi
    if test $tpmntrc -eq 203 -o $tpmntrc -eq 208 -o $tpmntrc -eq 206 -o $tpmntrc -eq 13
    then
	exit 1
    else
	exit 2
    fi
fi
#
# analyze the tape
#
BIN/dmplbl -i $tpath -V $tmvid
rc=$?
#
# release device unit if own reservation
#
echo " `date '+%T'` + rls $rflag -p $tpath"
BIN/rls $rflag -p $tpath
exit $rc
