/*
 * Copyright (C) 1994-1998 by CERN/CN/PDP/DH
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)dmplbl.c	1.5 05/05/98 CERN CN-PDP/DH Jean-Philippe Baud";
#endif /* not lint */

/*	dmplbl - analyse the content of a tape label */
#include <errno.h>
#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#if sun
#include <sys/mtio.h>
#endif
#include "tape.h"
extern	int	optind;
extern	char	*optarg;
#if !defined(linux)
extern	char	*sys_errlist[];
#endif
int code;
char *dvrname;
char infil[MAXPATH];
int irec;
int maxbyte;
char vid[7];

main(argc, argv)
int	argc;
char	**argv;
{
	char buffer[128];
	int c;
	static char codes[4][7] = {"", "ASCII", "", "EBCDIC"};
	char driver_name[7];
	int errcat = 0;
	int errflg = 0;
	int infd;
	char label[81];
	int lcode;
	char *malloc();
	char *msgaddr;
	int nbytes;
	int nfile;
	char *p;
	int qbov, qlab;
	char *strchr();

	while ((c = getopt (argc, argv, "i:V:")) != EOF) {
		switch (c) {
		case 'i':
			if (infil[0] == '\0') {
				if (strlen(optarg) < sizeof(infil)) {
					strcpy (infil, optarg);
				} else {
					fprintf (stderr, TP006, argv[optind-2]);
					errflg++;
				}
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case 'V':
			if (vid[0] == '\0') {
				if (strlen(optarg) < 7) {
					strcpy (vid, optarg);
				} else {
					fprintf (stderr, TP006, argv[optind-2]);
					errflg++;
				}
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case '?':
			errflg++;
			break;
		}
	}
	if (vid[0] == '\0') {
		fprintf (stderr, TP031);
		errflg++;
	}
	if (errflg) {
		usage (argv[0]);
		exit (1);
	}

        /* Set default values */

        maxbyte = 80;

#if defined(_AIX) && defined(_IBMR2)
	if (getdvrnam (infil, driver_name) < 0)
		strcpy (driver_name, "tape");
	dvrname = driver_name;
#endif

	/* initialise flags and counters */

	lcode = 0;
	nfile = 0;
	qbov = 1;
	qlab = 0;

	/* open path */

	if ((infd = open (infil, O_RDONLY)) < 0) {
		fprintf (stderr, " DUMP - OPEN ERROR %d ON INPUT FILE\n", errno);
		exit (2);
	}

	for (irec = 1; irec < 6; irec++) {
		nbytes = read (infd, buffer, sizeof(buffer));
		if (nbytes > 0) {		/* record found */
			dumpblock (buffer, nbytes);
			if (qbov) {	/* beginning of tape */
				qbov = 0;
				if (nbytes == 80) {
					ebc_asc (buffer, label, 80);
					if (strncmp (label, "VOL1", 4) == 0)
						lcode = SL;
					else {
						asc_asc (buffer, label, 80);
						if (strncmp (label, "VOL1", 4) == 0)
							lcode = AL;
					}
				}
				if (lcode) {
					printf ("               %s HAS AN %s LABEL\n", vid, codes[lcode]);
					printf ("\n VOLUME LABEL :\n");
					printf (" VOLUME SERIAL NUMBER:       %.6s\n", label+4);
					printf (" OWNER IDENTIFIER:           %.14s\n", label+37);
				} else {
					printf ("               %s IS UNLABELLED\n", vid);
				}
			} else if (nbytes == 80) {
				if (lcode == SL)
					ebc_asc (buffer, label, 80);
				else
					asc_asc (buffer, label, 80);
				if (strncmp (label, "HDR1", 4) == 0) {
					printf ("\n HEADER LABEL 1:\n");
					printlabel1 (label);
					qlab = 1;
				} else if (strncmp (label, "HDR2", 4) == 0) {
					printf ("\n HEADER LABEL 2:\n");
					printlabel2 (label);
					qlab = 1;
				} else if (strncmp (label, "HDR3", 4) == 0) {
					printf ("\n HEADER LABEL 3:             %.76s\n", label+4);
					qlab = 1;
				} else if (strncmp (label, "HDR4", 4) == 0) {
					printf ("\n HEADER LABEL 4:             %.76s\n", label+4);
					qlab = 1;
				}
			}
		} else if (nbytes == 0) {	/* tape mark found */
#if sun
			if (gettperror (infd, &msgaddr) == ETBLANK) {
				fflush (stdout);
				fprintf (stderr, " DUMP ! READ ERROR: %s (BLOCK # %d)\n",
					"Blank check", irec);
				break;
			}
#endif
			if (qlab) {
				printf (" ***** TAPE MARK READ *****      END OF LABEL GROUP\n");
				qlab = 0;
			} else {
				nfile++;
				printf (" ***** TAPE MARK READ *****      FILE %d CONTAINED %d BLOCKS.\n",
					nfile, irec-1);
			}
			printf (" *********************************************************************************************************************\n");
			break;
		} else {
			if (errno == EIO)
				errcat = gettperror (infd, &msgaddr);
			else
#if sgi || ultrix || (__alpha && __osf__)
				if (errno == ENOSPC) {
					msgaddr = "Blank check";
					errcat = ETBLANK;
				} else
#endif
					msgaddr = sys_errlist[errno];
			fprintf (stderr, " DUMP ! READ ERROR: %s (BLOCK # %d)\n",
				msgaddr, irec);
			if (errcat == ETBLANK) break;
		}
	}

	printf (" DUMP - DUMPING PROGRAM COMPLETE.\n");
	exit (0);
}

dumpblock (buffer, nbytes)
char *buffer;
int nbytes;
{
	char bufftr[33];
	int i, k, l;
	int iad;
	char *p;

	printf (" BLOCK NUMBER %d\n", irec);
	for (iad = 0, p = buffer; iad < nbytes; iad += 32) {
		if (maxbyte != 0 && iad >= maxbyte) break;
		l = iad + 31;
		if (l >= nbytes) l = nbytes - 1;
		k = l - iad + 1;
		if (code == SL)
			ebc_asc (p, bufftr, k);
		else
			asc_asc (p, bufftr, k);
		bufftr[k] = '\0';
		printf (" %.8x   ", iad);
		for (i = 0; i < k; i++) {
			if (i % 8 == 0) putchar (' ');
			printf ("%.2x", *(p++) & 0xff);
		}
		for (i = k; i < 32; i++)
			putchar (' ');
		printf ("    *%s*\n", bufftr);
	}
}

ebc_asc(p, q, n)
char *p;
char *q;
int n;
{
	int i;
	static char e2atab[256] = {

	'.','.','.','.','.','.','.','.','.','.','.','.','.','.','.','.',

	'.','.','.','.','.','.','.','.','.','.','.','.','.','.','.','.',

	'.','.','.','.','.','.','.','.','.','.','.','.','.','.','.','.',

	'.','.','.','.','.','.','.','.','.','.','.','.','.','.','.','.',

	' ','.','.','.','.','.','.','.','.','.','.','.','<','(','+','|',

	'&','.','.','.','.','.','.','.','.','.','!','$','*',')',';','^',

	'-','/','.','.','.','.','.','.','.','.','.',',','%','_','>','?',

	'.','.','.','.','.','.','.','.','.','`',':','#','@','\'','=','"',

	'.','a','b','c','d','e','f','g','h','i','.','.','.','.','.','.',

	'.','j','k','l','m','n','o','p','q','r','.','.','.','.','.','.',

	'.','~','s','t','u','v','w','x','y','z','.','.','.','[','.','.',

	'.','.','.','.','.','.','.','.','.','.','.','.','.',']','.','.',

	'{','A','B','C','D','E','F','G','H','I','.','.','.','.','.','.',

	'}','J','K','L','M','N','O','P','Q','R','.','.','.','.','.','.',

	'\\','.','S','T','U','V','W','X','Y','Z','.','.','.','.','.','.',

	'0','1','2','3','4','5','6','7','8','9','.','.','.','.','.','.',
	};

	for (i = 0; i < n; i++)
		*q++ = e2atab[*p++ & 0xff];
}

asc_asc(p, q, n)
char *p;
char *q;
int n;
{
	int i;
	static char a2atab[256] = {

	'.','.','.','.','.','.','.','.','.','.','.','.','.','.','.','.',

	'.','.','.','.','.','.','.','.','.','.','.','.','.','.','.','.',

	' ','!','"','#','$','%','&','\'','(',')','*','+',',','-','.','/',

	'0','1','2','3','4','5','6','7','8','9',':',';','<','=','>','?',

	'@','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O',

	'P','Q','R','S','T','U','V','W','X','Y','Z','[','\\',']','^','_',

	'`','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o',

	'p','q','r','s','t','u','v','w','x','y','z','{','|','}','~','.',

	'.','.','.','.','.','.','.','.','.','.','.','.','.','.','.','.',

	'.','.','.','.','.','.','.','.','.','.','.','.','.','.','.','.',

	'.','.','.','.','.','.','.','.','.','.','.','.','.','.','.','.',

	'.','.','.','.','.','.','.','.','.','.','.','.','.','.','.','.',

	'.','.','.','.','.','.','.','.','.','.','.','.','.','.','.','.',

	'.','.','.','.','.','.','.','.','.','.','.','.','.','.','.','.',

	'.','.','.','.','.','.','.','.','.','.','.','.','.','.','.','.',

	'.','.','.','.','.','.','.','.','.','.','.','.','.','.','.','.',
	};

	for (i = 0; i < n; i++)
		*q++ = a2atab[*p++ & 0xff];
}

printlabel1 (label)
char *label;
{
	printf (" FILE ID:                    %.17s\n", label + 4);
	printf (" VOLUME SEQNO:               %.4s\n", label + 27);
	printf (" FILE SEQNO:                 %.4s\n", label + 31);
	printf (" CREATION DATE:              %.6s\n", label + 41);
	printf (" EXPIRATION DATE:            %.6s\n", label + 47);
	printf (" BLOCK COUNT:                %.6s\n", label + 54);
}

printlabel2 (label)
char *label;
{
	printf (" RECORD FORMAT:              %.1s\n", label + 4);
	printf (" BLOCK LENGTH:               %.5s\n", label + 5);
	printf (" RECORD LENGTH:              %.5s\n", label + 10);
	printf (" DENSITY:                    %.1s\n", label + 15);
	printf (" DATA RECORDING:             %.1s\n", label + 34);
}

usage(cmd)
char *cmd;
{
	fprintf (stderr, "usage: %s ", cmd);
	fprintf (stderr, "%s",
		"[-i path_name] [-V vid]\n");
}
