/*
 * Copyright (C) 1990-1997 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)checkjobdied.c	1.15 08/22/97 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

/*	checkjobdied - returns the list of jobs that have died */

#include <errno.h>
#include <sys/time.h>
#include <sys/types.h>
#ifndef HPUX10
#if cray
#include <sys/table.h>
#include <sys/jtab.h>
#else
#if defined(SOLARIS) || defined(IRIX5) || (defined(__osf__) && defined(__alpha)) || defined(linux)
#include <errno.h>
#include <sys/stat.h>
#else
#if sun
#include <kvm.h>
#include <stdio.h>
#endif
#if sgi
#include <errno.h>
#include <sys/syssgi.h>
#include <sys/user.h>
#else
#include <nlist.h>
#endif
#include <sys/proc.h>
#if _AIX && _IBMR2
#include <sys/sysconfig.h>
#include <sys/var.h>
#endif
#endif
#endif
#endif
#include "tape.h"
static char func[16];
checkjobdied(jobs)
int jobs[];
{
	int i, j, k;
#ifndef HPUX10
#if cray
	struct jtab *jtable, *jt;
	struct tbs tabs;
#else
#if defined(sun) && !defined(SOLARIS)
	kvm_t *Flkvm;
#else
	int fdkmem;
#endif
#if defined(SOLARIS) || defined(IRIX5) || (defined(__osf__) && defined(__alpha)) || defined(linux)
	char name[12];
	struct stat st;
#else
#if sgi
	struct user *user;
#else
	static struct nlist nl[3];
	static int nlistdone = 0;
	int nproc;
	struct proc *p;
	long proctabaddr;
#endif
	struct proc *proctab;
#endif
#endif
#if _AIX && _IBMR2
	long lastprocaddr;
	int proctabsiz;
	struct var var;
#endif
#endif
	ENTRY (checkjobdied);
#if HPUX10
	for (i = 0, k = 0; jobs[i]; i++) {
		if (kill(jobs[i], 0) != 0)
			jobs[k++] = jobs[i];		/* job has died */
	}
#else
#if cray
	/* Read job & proc tables from memory */
	if (tabinfo(JTAB,&tabs) < 0) RETURN (-1);
	jtable = (struct jtab *) malloc(tabs.ent*tabs.len);
	if (jtable == 0) {
		tplogit (func, TP005);
		RETURN (-1);
	}
	if (tabread(JTAB,(char *)jtable,tabs.ent*tabs.len,tabs.head) < 0) RETURN (-1);
	for (i = 0, k = 0; jobs[i]; i++) {
		for (j = 0, jt = jtable; j < tabs.ent; j++, jt++)
			if (jt->j_jid == jobs[i]) break;	/* job still alive */
		if (j == tabs.ent) jobs[k++] = jobs[i];		/* job has died */
	}
	free (jtable);
#else
#if defined(linux)
	for (i = 0, k = 0; jobs[i]; i++) {
		sprintf (name, "/proc/%d", jobs[i]);
		j = stat (name, &st);
		if (j < 0 && errno == ENOENT) jobs[k++] = jobs[i];	/* job has died */
	}
#else
#if defined(SOLARIS) || defined(IRIX5) || (defined(__osf__) && defined(__alpha))
	for (i = 0, k = 0; jobs[i]; i++) {
		sprintf (name, "/proc/%.5d", jobs[i]);
		j = stat (name, &st);
		if (j < 0 && errno == ENOENT) jobs[k++] = jobs[i];	/* job has died */
	}
#else
#if sgi
	user = (struct user *) calloc (1, sizeof(struct user));
	if (user == 0) {
		tplogit (func, TP005);
		RETURN (-1);
	}
	for (i = 0, k = 0; jobs[i]; i++) {
		j = syssgi (SGI_RDUBLK, jobs[i], user, sizeof(struct user));
		if (j < 0 && errno == ESRCH) jobs[k++] = jobs[i];	/* job has died */
	}
	free (user);
#else
#if sun
	nl[0].n_name = "_proc";
	nl[1].n_name = "_nproc";
	Flkvm = kvm_open ("/vmunix", NULL, NULL, 0, "checkjobdied");
	if (Flkvm == 0) RETURN (-1);
	kvm_nlist (Flkvm, nl);
	if (kvm_read (Flkvm, nl[0].n_value, &proctabaddr, 4) < 0) {
		tplogit (func, TP002, "/dev/kmem", "kvm_read", errno);
		kvm_close (Flkvm);
		RETURN (-1);
	}
	if (kvm_read (Flkvm, nl[1].n_value, &nproc, 4) < 0) {
		tplogit (func, TP002, "/dev/kmem", "kvm_read", errno);
		kvm_close (Flkvm);
		RETURN (-1);
	}
	proctab = (struct proc *) malloc (nproc * sizeof(struct proc));
	if (proctab == 0) {
		tplogit (func, TP005);
		kvm_close (Flkvm);
		RETURN (-1);
	}
	if (kvm_read (Flkvm, proctabaddr, (char *) proctab, nproc * sizeof(struct proc)) < 0) {
		tplogit (func, TP002, "/dev/kmem", "kvm_read", errno);
		kvm_close (Flkvm);
		free (proctab);
		RETURN (-1);
	}
	kvm_close (Flkvm);

	for (i = 0, k = 0; jobs[i]; i++) {
		for (j = 0, p = proctab; j < nproc; j++, p++)
			if (p->p_pid == jobs[i]) break;		/* job still alive */
		if (j == nproc) jobs[k++] = jobs[i];		/* job has died */
	}
	free (proctab);
#else
#if ultrix
	if (nlistdone == 0) {
		nl[0].n_name = "_proc";
		nl[1].n_name = "_nproc";
		nlist ("/vmunix", nl);
		nlistdone = 1;
	}
	fdkmem = open ("/dev/kmem", 0);
	if (fdkmem < 0) {
		tplogit (func, TP002, "/dev/kmem", "open", errno);
		RETURN (-1);
	}
	if (lseek (fdkmem, nl[0].n_value, 0) < 0) {
		tplogit (func, TP002, "/dev/kmem", "lseek", errno);
		close (fdkmem);
		RETURN (-1);
	}
	if (read (fdkmem, &proctabaddr, 4) < 0) {
		tplogit (func, TP002, "/dev/kmem", "read", errno);
		close (fdkmem);
		RETURN (-1);
	}
	if (lseek (fdkmem, nl[1].n_value, 0) < 0) {
		tplogit (func, TP002, "/dev/kmem", "lseek", errno);
		close (fdkmem);
		RETURN (-1);
	}
	if (read (fdkmem, &nproc, 4) < 0) {
		tplogit (func, TP002, "/dev/kmem", "read", errno);
		close (fdkmem);
		RETURN (-1);
	}
	proctab = (struct proc *) malloc (nproc * sizeof(struct proc));
	if (proctab == 0) {
		tplogit (func, TP005);
		close (fdkmem);
		RETURN (-1);
	}
	if (lseek (fdkmem, proctabaddr, 0) < 0) {
		tplogit (func, TP002, "/dev/kmem", "lseek", errno);
		close (fdkmem);
		free (proctab);
		RETURN (-1);
	}
	if (read (fdkmem, (char *) proctab, nproc * sizeof(struct proc)) < 0) {
		tplogit (func, TP002, "/dev/kmem", "read", errno);
		close (fdkmem);
		free (proctab);
		RETURN (-1);
	}
	close (fdkmem);

	for (i = 0, k = 0; jobs[i]; i++) {
		for (j = 0, p = proctab; j < nproc; j++, p++)
			if (p->p_pid == jobs[i]) break;		/* job still alive */
		if (j == nproc) jobs[k++] = jobs[i];		/* job has died */
	}
	free (proctab);
#else
#if hpux
	nl[0].n_name = "proc";
	nl[1].n_name = "nproc";
	nlist ("/hp-ux", nl);
	fdkmem = open ("/dev/kmem", 0);
	if (fdkmem < 0) {
		tplogit (func, TP002, "/dev/kmem", "open", errno);
		RETURN (-1);
	}
	if (lseek (fdkmem, nl[0].n_value, 0) < 0) {
		tplogit (func, TP002, "/dev/kmem", "lseek", errno);
		close (fdkmem);
		RETURN (-1);
	}
	if (read (fdkmem, &proctabaddr, 4) < 0) {
		tplogit (func, TP002, "/dev/kmem", "read", errno);
		close (fdkmem);
		RETURN (-1);
	}
	if (lseek (fdkmem, nl[1].n_value, 0) < 0) {
		tplogit (func, TP002, "/dev/kmem", "lseek", errno);
		close (fdkmem);
		RETURN (-1);
	}
	if (read (fdkmem, &nproc, 4) < 0) {
		tplogit (func, TP002, "/dev/kmem", "read", errno);
		close (fdkmem);
		RETURN (-1);
	}
	proctab = (struct proc *) malloc (nproc * sizeof(struct proc));
	if (proctab == 0) {
		tplogit (func, TP005);
		close (fdkmem);
		RETURN (-1);
	}
	if (lseek (fdkmem, proctabaddr, 0) < 0) {
		tplogit (func, TP002, "/dev/kmem", "lseek", errno);
		close (fdkmem);
		free (proctab);
		RETURN (-1);
	}
	if (read (fdkmem, (char *) proctab, nproc * sizeof(struct proc)) < 0) {
		tplogit (func, TP002, "/dev/kmem", "read", errno);
		close (fdkmem);
		free (proctab);
		RETURN (-1);
	}
	close (fdkmem);

	for (i = 0, k = 0; jobs[i]; i++) {
		for (j = 0, p = proctab; j < nproc; j++, p++)
			if (p->p_pid == jobs[i] &&
			    p->p_stat != 0) break;		/* job still alive */
		if (j == nproc) jobs[k++] = jobs[i];		/* job has died */
	}
	free (proctab);
#else
#if _AIX
#if _IBMR2
	nl[0].n_name = "proc";
	knlist (nl, 1, sizeof(struct nlist));
	fdkmem = open ("/dev/kmem", 0);
	if (fdkmem < 0) {
		tplogit (func, TP002, "/dev/kmem", "open", errno);
		RETURN (-1);
	}
	proctabaddr = nl[0].n_value;
	sysconfig (SYS_GETPARMS, &var, sizeof(var));
	lastprocaddr = (long) var.ve_proc;
	proctabsiz = lastprocaddr - proctabaddr;
	proctab = (struct proc *) malloc (proctabsiz);
	if (proctab == 0) {
		tplogit (func, TP005);
		close (fdkmem);
		RETURN (-1);
	}
	if (seek_and_read (fdkmem, proctabaddr, proctab, proctabsiz) < 0) {
		close (fdkmem);
		free (proctab);
		RETURN (-1);
	}
	close (fdkmem);
	nproc = proctabsiz / sizeof(struct proc);
#endif
#if _IBMESA
	nl[0].n_name = "proc";
	nl[1].n_name = "nproc";
	nlist ("/vmunix", nl);
	fdkmem = open ("/dev/kmem", 0);
	if (fdkmem < 0) {
		tplogit (func, TP002, "/dev/kmem", "open", errno);
		RETURN (-1);
	}
	if (lseek (fdkmem, nl[0].n_value, 0) < 0) {
		tplogit (func, TP002, "/dev/kmem", "lseek", errno);
		close (fdkmem);
		RETURN (-1);
	}
	if (read (fdkmem, &proctabaddr, 4) < 0) {
		tplogit (func, TP002, "/dev/kmem", "read", errno);
		close (fdkmem);
		RETURN (-1);
	}
	if (lseek (fdkmem, nl[1].n_value, 0) < 0) {
		tplogit (func, TP002, "/dev/kmem", "lseek", errno);
		close (fdkmem);
		RETURN (-1);
	}
	if (read (fdkmem, &nproc, 4) < 0) {
		tplogit (func, TP002, "/dev/kmem", "read", errno);
		close (fdkmem);
		RETURN (-1);
	}
	proctab = (struct proc *) malloc (nproc * (sizeof(struct proc) + 48));
	if (proctab == 0) {
		tplogit (func, TP005);
		close (fdkmem);
		RETURN (-1);
	}
	if (lseek (fdkmem, proctabaddr, 0) < 0) {
		tplogit (func, TP002, "/dev/kmem", "lseek", errno);
		close (fdkmem);
		free (proctab);
		RETURN (-1);
	}
	if (read (fdkmem, (char *) proctab, nproc * (sizeof(struct proc) + 48)) < 0) {
		tplogit (func, TP002, "/dev/kmem", "read", errno);
		close (fdkmem);
		free (proctab);
		RETURN (-1);
	}
	close (fdkmem);
#endif

	for (i = 0, k = 0; jobs[i]; i++) {
#if _AIX && _IBMESA
		for (j = 0, p = proctab; j < nproc; j++) {
			if (p->p_pid == jobs[i]) break;		/* job still alive */
			p = (struct proc *) ((int)p + sizeof(struct proc) + 48);
		}
#else
		for (j = 0, p = proctab; j < nproc; j++, p++)
			if (p->p_pid == jobs[i] &&
			    p->p_stat != 0) break;		/* job still alive */
#endif
		if (j == nproc) jobs[k++] = jobs[i];		/* job has died */
	}
	free (proctab);
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
	RETURN (k);
}

#if _AIX && _IBMR2
#define TWO_GIG (0x80000000)
static int
seek_and_read(fd, offset, data, data_len)
int fd;
long offset;
void *data;
int data_len;
{
	int rc;

	if (offset >= TWO_GIG) {
		if (lseek (fd, offset - TWO_GIG, 0) < 0) {
			tplogit (func, TP002, "/dev/kmem", "lseek", errno);
			return (-1);
		}
		if (readx (fd, data, data_len ,1) < 0) {
			tplogit (func, TP002, "/dev/kmem", "readx", errno);
			return (-1);
		}
	} else {
		if (lseek (fd, offset, 0) < 0) {
			tplogit (func, TP002, "/dev/kmem", "lseek", errno);
			return (-1);
		}
		if (readx (fd, data, data_len ,0) < 0) {
			tplogit (func, TP002, "/dev/kmem", "readx", errno);
			return (-1);
		}
	}
	return (0);
}
#endif
