/*
 * Copyright (C) 1990-1997 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] =
"@(#)sysreq.c	1.19 09/03/97 CERN CN-SW/DC Frederic Hemmer";
#endif /* not lint */

/* sysreq.c       sysreq command using network communication            */
 
#if defined(_WIN32)
#define _POSIX_
#endif 
#include <stdio.h>              /* Standard Input/Output                */
#include <string.h>             /* String manipulation routines         */
#include "sysreq.h"             /* SYSREQ specific definitions          */
#ifndef vms
#include <stdlib.h>             /* Standard library definitions         */
#include <serrno.h>             /* Special error numbers                */
#else
#include "serrno.h"             /* Special Error numbers                */
#endif /* vms */
#if defined(unix) || (defined(_AIX) && defined(_IBMR2))
#include <pwd.h>                /* Password file definitions            */
#endif /* unix || (_AIX && _IBMR2) */
#if defined(_WIN32)
#include <winsock2.h>
#endif

#if defined(vms) && defined(__alpha) && defined(COMPILE_NOPREFIX)
#define exit    DECC$EXIT
#define strcat  DECC$STRCAT
#endif /* vms && vax && COMPILE_NOPREFIX */
 
#define RECSEP  '\n'            /* SYSREQ's record separator            */
#define RECLEN  256             /* SYSREQ's max record length           */

extern int sysreq();

static char *
nextcmd(s)                      /* Get next command to issue            */
char    *s;
{
        register int    i;

        for (i= strlen(s);i>=(int)strlen(s)-RECLEN;i--)    {
                if (s[i] == RECSEP) return(s+i+1);
        }
        return (NULL);
}
 
#define USERNAME_L      12

main(argc, argv)
int     argc;
char    **argv;
{
	char    service[20];
        char    cmd[512];
        char    reptxt[2048];
        int     status, len, cmdl, i;
	int     do_retry = 1;           /* Do retry if sysreqd/tms down */
        char    *s;
	register int    c;
	register int    cont=1;
	register int    error=0;
	register int    uflag=0;
	register int    aflag=0;
	char    user    [USERNAME_L+1];         /* username buffer      */
	extern  char    *optarg;
	extern  int     optind;
	extern char *getacct();                 /* get account string   */
	char    *acct;  /* account string pointer                       */
	char    buf[BUFSIZ];
#if defined(unix) || (defined(_AIX) && defined(_IBMR2))
	struct  passwd  *pw;    /* password entry buffer pointer        */
#endif /* unix || (_AIX && _IBMR2) */
#if defined(vms) || defined(_WIN32)
	char    name[L_cuserid];        /* username buffer              */
#endif /* vms || _WIN32 */
#if defined(_WIN32)
	WSADATA wsadata;
#endif

	while ((c = getopt (argc, argv, "a:u:cn")) != EOF) {
		switch(c)       {
		case 'u':       strcpy(user,optarg);
				uflag++;
				break;
		case 'a':       strcpy(buf,optarg);
				acct=buf;
				aflag++;
				break;
		case 'c':       cont++;
				break;
		case 'n':       cont=0;
				break;
		case '?':       error++;
				break;
		default:
				break;
		}
	}
	if (argc <= optind+1)     {
		error++;
	}

	if (error)      {
		fprintf(stderr,"usage: %s [-c|-n] [-u <username>] [-a <account>] <SERVICE NAME> <COMMAND>\n",
				argv[0]);
		exit(1);
	}

	if (!aflag ||(geteuid()!=0))     {
		if (( acct = getacct()) == NULL) acct = "        ";
	}

	strcpy(service, argv[optind]);
	strcpy(cmd,"");
	for (i=optind+1;i<argc;i++)  {
		strcat(cmd, " ");strcat(cmd,argv[i]);
        }

reissue:
        cmdl = strlen(cmd);
        len = sizeof(reptxt);
#if defined(unix) || (defined(_AIX) && defined(_IBMR2))
	if (!uflag)     {
		pw = getpwuid(geteuid());
		strcpy(user,pw->pw_name);
	}
#endif /* unix || (_AIX && _IBMR2) */
#if defined(vms) || defined(_WIN32)
	if (!uflag)     {
		cuserid(name);
		strcpy(user,name);
	}
#endif /* vms || _WIN32 */
#if defined(_WIN32)
	if (WSAStartup (MAKEWORD (2, 0), &wsadata)) {
		fprintf (stderr, "WSAStartup unsuccessful\n");
		exit(1);
	}
#endif
	status = _sysreq(user, acct, service, cmd, cmdl, reptxt, &len,do_retry);

        switch (status) {
                case    0:      fprintf(stdout,"%s\n",reptxt);
#if defined(_WIN32)
				WSACleanup();
#endif
                                exit(0);
                case -SEUBUF2SMALL:   fprintf(stdout,"%s\n",reptxt);
                                fprintf(stdout,"Data truncated\n");
                                break;
                case    2:
                                if ((s = nextcmd(reptxt)) == NULL)      {
                                        fprintf(stderr,
                        "Internal error: Unable to get next command\n");
                                }
                                else    {
                                        /* Discard last reptxt record   */
                                        *(s-1) = '\0';
                                        fprintf(stdout,"%s\n",reptxt);
                                        strcpy(cmd,s);
					if (!cont)      {
						fprintf(stdout,"%s\n",cmd);
#if defined(_WIN32)
						WSACleanup();
#endif
						exit(2);
					}
                                        goto reissue;
                                }
                                break;
                default:
                                if (status < 0) {
#ifdef _WIN32
				        if (-status>WSABASEERR) fprintf(stderr,"sysreq: Windows socket error\n");
                                        else sperror("sysreq");
#else
                                        sperror("sysreq");
#endif
                                        status = -status;
					len = 0;
                                }
                                if (len >0) fprintf(stdout,"%s\n",reptxt);
        }
        fprintf(stderr,"RC(%d)\n",status);
#if defined(_WIN32)
        WSACleanup();
#endif
        exit(1);
}
