/*
 * Copyright (C) 1990-1997 by CERN CN-PDP/CS
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)netreq.c	1.31 09/21/98 CERN CN-PDP/CS F. Hemmer";
#endif /* not lint */

/* netreq.c     Network interface to the SYSREQ communication system    */
 
#include "config.h"     /* configuration parameters                     */
#include "sysreq.h"     /* SYSREQ specific definitions                  */

#include <string.h>
#if !defined(vms)
#include <sys/types.h>  /* Standard data types                          */
#if defined(_WIN32)
#include <winsock2.h>
#else
#include <sys/socket.h> /* Socket interface                             */
#include <netinet/in.h> /* Internet data types                          */
#include <arpa/inet.h>  /* Arpa internet routines                       */
#endif
#include <stdio.h>      /* Standard Input/Output                        */
#include <pwd.h>        /* Password file structure                      */
#if !defined(_WIN32)
#include <netdb.h>      /* Network "data base"                          */
#endif
#include <errno.h>      /* Error numbers                                */
#include <serrno.h>     /* Special Error numbers                        */
#include <trace.h>      /* tracing definitions                          */
#endif /* vms */
#if defined(vms)
#include <types.h>      /* Standard data types                          */
#include <socket.h>     /* Socket interface                             */
#include <in.h>         /* Internet data types                          */
#include <inet.h>       /* Arpa internet routines                       */
#include <stdio.h>      /* Standard Input/Output                        */
#include <netdb.h>      /* Network "data base"                          */
#include <errno.h>      /* Error numbers                                */
#include "serrno.h"     /* Special Error numbers                        */
#include "trace.h"      /* tracing definitions                          */

#if defined(TGV) && (TGV == 1) && !defined(MULTINET)
#define MULTINET        1
#endif /* TGV && !MULTINET */

#if (!defined(TWG) && !defined(MULTINET) && !defined(TCPWARE) && !defined(UCX))
/* We generate a compiler error (#error not defined everywhere!) */
!!! YOU MUST SPECIFY either MULTINET or TWG or TCPWARE or UCX !!!

#endif /* !MULTINET && !TWG && !TCPWARE && !UCX */
#ifdef TWG
#define close(x)  netclose(x)   /* TWG network close                    */
extern int      uerrno;
extern int      vmserrno;
#define perror(x) fprintf(stderr,"%s: TWG error %d\n",x,uerrno);
#define errno   (uerrno ? uerrno : vmserrno)
#endif /* TWG */
#if defined(MULTINET) && (MULTINET == 1)
#define close(x)  socket_close(x)   /* MULTINET network close           */
#define perror(x) socket_perror(x)  /* MULTINET network error           */
extern volatile int noshare      socket_errno;
extern volatile int noshare      vmserrno;
#define errno   (socket_errno ? socket_errno : vmserrno)
#endif /* MULTINET */
#include <ssdef.h>      /* system services retcodes definitions         */
#include <jpidef.h>     /* job and process information                  */
#include <prvdef.h>     /* privileges definitions                       */

#endif /* vms */

#if defined(vms) && defined(__alpha) && defined(COMPILE_NOPREFIX)
#define atoi    DECC$ATOI
#define free    DECC$FREE
#define getenv  DECC$GETENV
#define strcpy  DECC$STRCPY
#define strcmp  DECC$STRCMP
#define strlen  DECC$STRLEN
#define strncpy DECC$STRNCPY
#define sleep   DECC$SLEEP
#endif /* vms && __alpha && COMPILE_NOPREFIX */
 
extern  char    *getconfent();
extern  char    *getenv();

#ifdef vms
#define USERNAME_L      12
typedef struct  {
	short           bufl;
	short           code;
	char            *buf;
	unsigned int    *retl;
} Item;

char    username[USERNAME_L+1];         /* username buffer              */
unsigned int    usernamel;              /* length of dito               */
unsigned int    curpriv[2];             /* current process privileges   */
unsigned int    curprivl;               /* length of dito               */

static struct   {
	Item    item[2];
	int     eol;
} itemlist = {
	{
	{ sizeof(curpriv),      JPI$_CURPRIV,   curpriv,        &curprivl },
	{ sizeof(username),     JPI$_USERNAME,  username,       &usernamel},
	},
	0
};

#endif /* vms */

int
_sysreq(loginid, acct, sernam, comtxt, comtxtl, reptxt, arysz, do_retry)
char    *loginid;       /* requestor's login id                         */
char    *acct;          /* requestor's account                          */
char    *sernam;        /* Service name                                 */
char    *comtxt;        /* Command text                                 */
int     comtxtl;        /* Command text length                          */
char    *reptxt;        /* Reply text                                   */
int     *arysz;         /* Reply array size, actual size on return      */
int     do_retry;       /* Retry switch. No retry = 0, do retry <> 0    */
{
        char    sysreq_hosts[100];
	char    *sysreq_host[10];
	int     i;
	short   sysreq_port;    /* SYSREQ service port number           */
        struct servent  *sp;    /* services pointer                     */
        struct hostent  *hp;    /* host pointer                         */
        struct sockaddr_in sin; /* internet socket                      */
        int     s;              /* socket descriptor                    */
	LONG magic;             /* to hold magic number trust           */
        WORD    reqtype;        /* to hold the request type             */
        char    *p;             /* a character array pointer            */
	int     replylen;       /* SYSREQ reply length                  */
        int     sysreqrc;       /* SYSREQ return code                   */
#if defined(unix) || defined(_WIN32)
	struct  passwd  *pw;    /* Password entry structure             */
#endif /* unix || _WIN32 */
#ifdef vms
	int     rc;             /* system services return code          */
#endif /* vms */

        sysreq_port = SYSREQ_PORT;

/*
 * Get some run-time options
 */

	INIT_TRACE("SYSREQ_TRACE");
reissue:
        if ((p = getenv("SYSREQ_HOST")) != NULL)       {
	  strcpy(sysreq_hosts, p);
        }
        else    {
	  if ((p = getconfent("SYSREQ", "HOST",1)) == NULL ||
	      strcmp(p,"") == 0) {
	    strcpy (sysreq_hosts,SYSREQ_HOST);
	    if (serrno == SENOCONFIG) serrno = 0;
	  }
	  else    {
	    strcpy(sysreq_hosts, p);
	  }
        }
        if ((p = getenv("SYSREQ_PORT")) != NULL)       {
	  sysreq_port = atoi(p);
        }

	TRACE(1, "sysreq", "_sysreq(%s,%s,%s,%d,%x,%d,%d) entered",
	      loginid, sernam, comtxt, comtxtl, reptxt, *arysz,do_retry);
 
        sin.sin_family = AF_INET;
 
	sysreq_host[0] = strtok(sysreq_hosts," \t\n");
	i=0;
	while ( ++i<10 && (sysreq_host[i] = strtok(NULL," \t\n")) != NULL );
	i=0;
	for (;;) { /* sysreq_host loop to break out of */
	  TRACE(2, "sysreq", "Looking for host %s",sysreq_host[i]);
	  hp = gethostbyname(sysreq_host[i]);
	  if (hp == NULL) {
	    serrno = SENOSHOST;
	    END_TRACE();
	    return(-SENOSHOST);
	  }
	  sin.sin_addr.s_addr = ((struct in_addr *)(hp->h_addr))->s_addr;
	  
#if SERVICESDB
	  if ((p = getenv("SYSREQ_PORT")) == NULL)       {
	    TRACE(2, "sysreq", "Looking for service %s on %s",
		  SYSREQ_NAME, SYSREQ_PROTO);
	    if ((sp = getservbyname(SYSREQ_NAME, SYSREQ_PROTO)) == NULL) {
	      serrno = SENOSSERV;
	      END_TRACE();
	      return(-SENOSSERV);
	    }
	    sin.sin_port = sp->s_port;
	    sysreq_port = ntohs(sp->s_port);
	  }
#endif /* services */
	  TRACE(2, "sysreq", "Assigning port %d to %s using %s",
		sysreq_port, SYSREQ_NAME, SYSREQ_PROTO);
	  sin.sin_port = htons(sysreq_port);
	  
	  TRACE(2, "sysreq", "creating socket");
	  if ((s = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
#ifdef _WIN32
	    int save_errno = h_errno;
#else
	    int save_errno = errno;
#endif
	    TRACE(2, "sysreq", "socket(): (errno=%d)", save_errno);
	    END_TRACE();
	    return(-save_errno);
	  }
	  
	  TRACE(2, "sysreq", "connecting %s port %d", sysreq_host[i], 
		sysreq_port);
	  if (connect(s, (struct sockaddr *)&sin, sizeof(struct sockaddr_in)) == -1) {
#ifdef _WIN32
	    int save_errno = h_errno;
#else
	    int save_errno = errno;
#endif
	    TRACE(2, "sysreq", "connect(): (errno=%d)", save_errno);
	    (void) close(s);
	    if ( ++i<10 && (sysreq_host[i] != NULL ) ) continue;
	    
	    if ( retry(do_retry,save_errno) ) goto reissue;
	    END_TRACE();
	    return(-save_errno);
	  }
	  else break;
	}
	
        magic = C_MAGIC;
	TRACE(2, "sysreq", "send magic number: %x",C_MAGIC);
        if (SendLong(s, &magic) < 0)    {
#ifdef _WIN32
	  int save_errno = h_errno;
#else
	  int save_errno = errno;
#endif
	  TRACE(2, "sysreq", "SendLong(magic): (errno=%d)", save_errno);
	  (void) close(s);
	  END_TRACE();
	  return(serrno ? -serrno : -save_errno);
        }
	TRACE(2, "sysreq", "receive magic number");
	if (RecvLong(s, &magic) <= 0)    {
#ifdef _WIN32
	  int save_errno = h_errno;
#else
	  int save_errno = errno;
#endif
	  TRACE(2, "sysreq", "RecvLong(magic): (serrno=%d) (errno=%d)", serrno, save_errno);
	  (void) close(s);
	  END_TRACE();
	  return(serrno ? -serrno : -save_errno);
        }
	TRACE(2, "sysreq", "server magic: %x", magic);
        if (magic != S_MAGIC)    {
	  TRACE(2, "sysreq", "server: bad magic number: %x", magic);
	  (void) close(s);
	  serrno = SEBADVERSION;
	  END_TRACE();
	  return(-SEBADVERSION);
        }
        if (loginid == (char *)0) loginid = "";
/*
 * send out effective id (i.e. the one really issuing the request
 */
#if defined(unix) || defined(_WIN32)
        if ( (pw = getpwuid(geteuid())) != NULL ) {
	  if (strcmp(pw->pw_name,loginid)) {
	    if (strcmp(pw->pw_name,"root"))    {    /* Not authorized */
	      TRACE(2, "sysreq", "user %s not authorized",
		    pw->pw_name);
	      loginid = pw->pw_name;
	    }
	  }
	} else {
	  int save_errno = errno;
	  TRACE(2,"sysreq","not authorized because real user not found");
	  (void)close(s);
	  END_TRACE();
	  return(-save_errno);
	}
	TRACE(2, "sysreq","send loginid: %s",loginid);
	if ((int) SendStr(s, loginid, strlen(loginid)) < 0)     {
#ifdef _WIN32
	  int save_errno = h_errno;
#else
	  int save_errno = errno;
#endif
	  TRACE(2, "sysreq", "SendStr(loginid): (errno=%d)", save_errno);
	  (void) close(s);
	  END_TRACE();
	  return(serrno ? -serrno : -save_errno);
	}
	TRACE(2, "sysreq","send real user: %s", pw->pw_name);
	if ((int) SendStr(s, pw->pw_name, strlen(pw->pw_name)) < 0)     {
#ifdef _WIN32
	  int save_errno = h_errno;
#else
	  int save_errno = errno;
#endif
	  TRACE(2, "sysreq", "SendStr(realuser): (errno=%d)", save_errno);
	  (void) close(s);
	  END_TRACE();
	  return(serrno ? -serrno : -save_errno);
        }
#endif /* unix || _WIN32 */
#ifdef vms
	TRACE(2, "sysreq","send loginid: %s",loginid);
	/* if PRV$_SYSPRV is granted, we issue the command as SYSTEM */
	if ((rc = sys$getjpi(0, 0, 0, &itemlist, 0, 0, 0)) != SS$_NORMAL) {
	  if (!(rc & 0x01))       {
	    vaxc$errno = rc;
#if defined(MULTINET) && (MULTINET == 1)
	    vmserrno = EVMSERR;
#endif /* MULTINET */
#if defined(TWG) && (TWG == 1)
	    vmserrno = EVMSERR;
#endif /* TWG */
#if defined(UCX) && (UCX == 1)
	    errno = EVMSERR;
#endif /* UCX */
	    return(-errno);
	  }
	}
	username[usernamel]='\0';
	if (curpriv[0] & PRV$M_SYSPRV)  { /* pretend being SYSTEM */
		loginid = "SYSTEM";
	}

        if ((int) SendStr(s, loginid, strlen(loginid)) < 0)     {
	  int save_errno = errno;
	  TRACE(2, "sysreq", "SendStr(loginid): (errno=%d)", save_errno);
	  (void) close(s);
	  END_TRACE();
	  return(serrno ? -serrno : -save_errno);
        }
	TRACE(2, "sysreq","send real user: %s", username);
        if ((int) SendStr(s, username, strlen(username)) < 0)     {
	  int save_errno = errno;
	  TRACE(2, "sysreq", "SendStr(realuser): (errno=%d)", save_errno);
	  (void) close(s);
	  END_TRACE();
	  return(serrno ? -serrno : -save_errno);
        }
#endif /* vms */
	TRACE(2, "sysreq", "send account: %s",acct);
        if ((int) SendStr(s, acct, strlen(acct)) < 0)     {
#ifdef _WIN32
	  int save_errno = h_errno;
#else
	  int save_errno = errno;
#endif
	  TRACE(2, "sysreq", "SendStr(account): (errno=%d)", save_errno);
	  (void) close(s);
	  END_TRACE();
	  return(serrno ? -serrno : -save_errno);
        }

/*
 * Process here
 */
        reqtype = SYSREQTYPE;
	TRACE(2, "sysreq", "send request type: 0X%X", reqtype);
        if ((int) SendWord(s, &reqtype) < 0)     {
#ifdef _WIN32
	  int save_errno = h_errno;
#else
	  int save_errno = errno;
#endif
	  TRACE(2, "sysreq", "SendWord(ReqType): (errno=%d)", save_errno);
	  (void) close(s);
	  END_TRACE();
	  return(serrno ? -serrno : -save_errno);
        }

	TRACE(2, "sysreq", "send service name: %s",sernam);
        if ((int) SendStr(s, sernam, strlen(sernam)) < 0)     {
#ifdef _WIN32
	  int save_errno = h_errno;
#else
	  int save_errno = errno;
#endif
	  TRACE(2, "sysreq", "SendStr(ServiceName): (errno=%d)", save_errno);
	  (void) close(s);
	  END_TRACE();
	  return(serrno ? -serrno : -save_errno);
        }
	TRACE(2, "sysreq", "send comm. text: <%s>",comtxt);
        if ((int) SendStr(s, comtxt, comtxtl) < 0)     {
#ifdef _WIN32
	  int save_errno = h_errno;
#else
	  int save_errno = errno;
#endif
	  TRACE(2, "sysreq", "SendStr(CommTxt): (errno=%d)", save_errno);
	  (void) close(s);
	  END_TRACE();
	  return(serrno ? -serrno : -save_errno);
        }
	TRACE(2, "sysreq", "recv reply length");
	if ((int)(p = RecvStr(s, &replylen)) <= 0)     {
#ifdef _WIN32
	  int save_errno = h_errno;
#else
	  int save_errno = errno;
#endif
	  TRACE(2, "sysreq", "RecvStr(RepLen): (serrno=%d) (errno=%d)",serrno, save_errno);
	  (void) close(s);
	  END_TRACE();
	  return(serrno ? -serrno : -save_errno);
        }
	TRACE(2, "sysreq", "reply length is %d byte(s) long", replylen);
	TRACE(2, "sysreq", "recv return code");
	if (RecvLong(s, &sysreqrc) <= 0)     {
#ifdef _WIN32
	  int save_errno = h_errno;
#else
	  int save_errno = errno;
#endif
	  TRACE(2, "sysreq", "RecvLong(RetCode): (serrno=%d) (errno=%d)",serrno, save_errno);
	  (void) free(p);
	  (void) close(s);
	  END_TRACE();
	  return(serrno ? -serrno : -save_errno);
        }
	TRACE(2, "sysreq", "return code is %d (dec)", sysreqrc);

	TRACE(2, "sysreq", "user buffer at %x is %d byte(s) long",
			reptxt, *arysz);
        if (*arysz-1 < replylen)  {
	  TRACE(2, "sysreq", "strncpy(%x,%x,%d)", reptxt,p,*arysz-1);
	  strncpy(reptxt, p, *arysz-1);
	  reptxt[*arysz] = '\0';
	  free(p);
	  TRACE(2, "sysreq", "reply buffer too short");
	  TRACE(2, "sysreq", "shutdown socket");
	  (void) shutdown(s, 2);
	  (void) close(s);
	  serrno = SEUBUF2SMALL;
	  END_TRACE();
	  return(-SEUBUF2SMALL);
        }
	TRACE(2, "sysreq", "strncpy(%x,%x,%d)", reptxt,p,replylen);
        strncpy(reptxt, p, replylen);
        free(p);
	TRACE(2, "sysreq", "shutdown socket");
        (void) shutdown(s, 2);
        (void) close(s);
	if ( retry(do_retry,sysreqrc) ) goto reissue;
        *arysz = replylen;
	END_TRACE();
	retry(do_retry,0); /* Reset retry-counters */
        return(sysreqrc);
}
/*
 * Name:        retry 
 * Author:      Olof Barring CN-PDP/DM
 * Description: control sysreq retries in case of sysreqd/tms failures.
 *              Implements a progressive increase of retry time for the
 *              first 10 (= SYSREQ_RETRY_SEED) retries to prevent long 
 *              waits in case of temporary unavailability of sysreqd or 
 *              tms (e.g. when all tms servers are busy).
 *              With defaults settings the retry delays are:
 *              Retry nb.    1  2  3  4  5  6  7  8  9  10 ... 130
 *              delay (sec.) 1  1  1  1  2  2  3  5  10 30 ... 30
 *              Total retry time before giving up: 120x30+26=3626 (sec.)
 *              If do_retry=1 (default for sysreq shell command) retry is 
 *              enabled but may be disabled by setting the environment
 *              variable SYSREQ_NORETRY.
 *              If do_retry=0 (default for the sysreq callable interface)
 *              retry is disabled but may be re-enabled by setting
 *              the environment variable SYSREQ_RETRY.
 * Return values: 0 = don't retry, 1 = do retry.
 */
int retry(do_retry,status)
int do_retry,status;
{
  static int retry_flag = -1;
  static int retry_nb = 0;
  static int total_retry_time = 0;
  int retry_time;
  if ( !status ) {
    total_retry_time = 0;
    retry_flag=-1;
    retry_nb = 0;
    return(0);
  }
#if defined(_WIN32)
  if ( status != WSAECONNREFUSED
#else
  if ( status != ECONNREFUSED 
#endif
	  && status != -SETMSNOTACT ) return(0);
  if ( !do_retry && retry_flag < 0) retry_flag=
				      (getenv("SYSREQ_RETRY") != NULL);
  if ( retry_flag < 0 ) retry_flag=(getenv("SYSREQ_NORETRY") == NULL);
  if ( !retry_flag ) return(0);
  retry_nb++;
  if ( retry_nb > SYSREQ_RETRY_MAX ) {
#if defined(_WIN32)
	if ( status == WSAECONNREFUSED)
#else
	if ( status == ECONNREFUSED)
#endif
      fprintf(stderr,"sysreqd not responding (%d seconds), giving up\n",
	       total_retry_time);
    if ( status == -SETMSNOTACT)
      fprintf(stderr,"tms not responding (%d seconds), giving up\n",
	       total_retry_time);
    total_retry_time = 0;
    retry_flag=-1;
    retry_nb = 0;
    return(0);
  }
  retry_time=SYSREQ_RETRY_DELAY;
  if ( SYSREQ_RETRY_SEED > retry_nb ) {
    retry_time = SYSREQ_RETRY_SEED/(SYSREQ_RETRY_SEED - retry_nb);
    if ( retry_time > SYSREQ_RETRY_DELAY ) retry_time = SYSREQ_RETRY_DELAY;
  }
  else {
#if defined(_WIN32)
	if ( status == WSAECONNREFUSED)
#else
    if ( status == ECONNREFUSED)
#endif
      fprintf(stderr,"sysreqd not responding (%d seconds), keep trying ...\n",
	       total_retry_time);
    if ( status == -SETMSNOTACT)
      fprintf(stderr,"tms not responding (%d seconds), keep trying ...\n",
	       total_retry_time);
  }
  total_retry_time+=retry_time;
  sleep(retry_time);
  return(1);
}

