.\" @(#)stagestat.man	1.2 10/27/99 CERN CN-PDP/DM Claire Redmond
.\" Copyright (C) 1995-1999 by CERN/CN/PDP/DM
.\" All rights reserved
.\"
.TH STAGESTAT l "10/27/99"
.SH NAME
stagestat \- gives global statistics on stager usage and detailed statistics on
each file staged in 
.SH SYNOPSIS
.B stagestat
[
.BI -e " end_time"
] [
.BI -f " accounting_file"
] [
.BI -p " pool_name"
] [
.BI -S " sorting_criteria"
] [
.BI -s " start_time"
]
.SH DESCRIPTION
.B stagestat
obtains information on the usage of a stager by reading the 
.B sacct
accounting file.  The information is given in tabular form in two 
sections.

The first section gives global statistics for the stager, which consists
of details on each stage command such as the number of requests, number 
of successful requests, warnings and errors. Also the number of mounts,
remounts, multifile requests and mounts avoided by the stager.

The second section gives file details by pool name, including
average lifetime per file and per group if garbage collected, and 
average number of accesses per file and per group.
.SH OPTIONS
.TP
.BI \-e " end_time"
The date and time up to which information should be collated.  If not
specified the default is the time of the last record in the accounting 
file.  The format for date input is
.BR mmddhhmm [ yy ].
.B yy
is the year in the century and is optional:
if yy between 00 and 37, 21th century is assumed,
if yy between 70 and 99, 20th century is assumed
else the command fails.
.TP
.BI \-f " accounting_file"
The file from which information is to be read.  If not specified the 
default is the current 
.B sacct
file
.TP
.BI \-p " pool_name"
The name of the particular pool on which information is required.  If not 
specified information is given on all pools in the accounting file, but no 
file details are displayed
.TP
.BI \-S " sort_criteria"
To obtain file details this option must be used 
.br
.B a 
\- will give the file details sorted by number of accesses
.br
.B t
\- will give the file details sorted by average lifetime.  If
.B t
is specified only files staged in and cleared within the time period
will be displayed
.TP
.BI \-s " start_time"
The date and time from which to begin collating information.  If not
specified the default is the time of the first record in the accounting
file.  Format for date input is
.BR mmddhhmm [ yy ].
.B yy
is the year in the century and is optional:
if yy between 00 and 37, 21th century is assumed,
if yy between 70 and 99, 20th century is assumed
else the command fails.
.SH EXAMPLES
To get information on pool atlas_stage sorted by lifetime type the following command :
.br

.B     stagestat -p atlas_stage -S t
.br

Your results will be displayed in the following format :

.br
.nf
.cs R 18 
        shd20 Stager statistics (26/02/1996 16:30:47  -  03/03/1996 23:43:14)

Command	   No Reqs Success Warning Userr Syserr Unerr Conferr ENOSPC Cleared Kill Other

stagein       787     767       3     3      0     0       0      1       0   14     0
stageout       18      18       0     0      0     0       0      0       0    0     0
stagewrt        5       5       0     0      0     0       0      0       0    0     0
stageput        9       8       0     1      0     0       0      0       0    0     0
stagealloc    118     103       0     0      1     0       0     13       0    1     0
stageqry     1170
.cs R
.fi
.sp
.nf
.cs R 18 
stageclr     1497
stageupdc     247
stageinit       1
stagecat        0
restart(s       1

Stagein Statistics :
        Number of mounts                        223
        Number of remounts                      30
        Number of mounts avoided by stager      544
        Number of multifile requests             0


File Request Details for Pool : atlas_stage

Number of requests started before time period began                     40
Out of these:   Number accessed before being cleared                    23
                Number accessed but not cleared during time period      17

Number of requests started after beginning of time period               177
Out of these:   Number accessed but not cleared                         108
                Number accessed and then cleared                        69

Average number of file accesses         :            3.47
Average lifetime of a staged file       :          101.76

 
Lifetime and accesses per file sorted by Average Lifetime

Tape VID     Fseq    Avg Life   Number    Login Name    Group 
                        (hrs)  Accesses
  I06486        1      141.16         5       fredbg       zp
  I06484        1      140.68         5       fredbg       zp
  I06482        1      140.35         5       fredbg       zp
  LW1032        2      120.24         1        tdhar       zp
  LE9398        1      116.25         2      sprman2       zp
  LE9398        3      115.02         2      sprman2       zp
  LH2072        1      114.54         8      donaldu       zp
  I09289       10      105.47         1        tdhar       zp
  LH2075        1       97.19         8      donaldu       zp
  I06471        1       94.67         2       fredbg       zp
  I09295       12       85.57         2     selwynnf       zp

.cs R
.fi
.SH RETURN CODES
\
.br
0	Ok.
.br
1	User error.
.br
2	System error.
