/*
 * Copyright (C) 1990-1999 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = " @(#)tptodkU.c	2.38 11/10/99  CERN CN-PDP/CS Felix Hassine";
#endif /* not lint */

/* tptodk.c             SHIFT transferring data from local tape to remote disk.          */

#include <stdio.h>
#include <fcntl.h>
#include <malloc.h>
#include <sys/errno.h>

#if defined(apollo)
#include <strings.h>
#else
#include <string.h>
#endif	/* apollo */
#include <sys/types.h>
#include <signal.h>
#include <sys/stat.h>
#include "rtcopy.h"
#include <rfio.h>

/*
 * Static definitions
 */
static int dskon = 0 ;		/* Is disk file open ? */
int tpon = 0 ;			/* Is tape device open ? */
static int dskfd = 20 ; 	/* Fortran file number */
static int tpfd ;		/* Tape file descriptor */
char tpdevtyp[9] = "";		/* Device type          */
static int irc = 0 ;		/* return status	*/
extern int errno ; 		/* Error number		*/
extern int rfio_errno ;		/* Rfio error number 	*/
extern int serrno ;		/* Special error number */
extern char * getifnam() ;
extern char * getconfent() ;
#ifndef linux
extern char *sys_errlist[];
#endif /* linux */
#if defined(SONYRAW)
extern int sonyraw ; /* If this flag is raised, choose sony_read,sony_write ...*/
#endif /* SONYRAW */

#ifndef min
#define min(a,b)      (((a)<(b)) ? (a):(b))
#endif

#define PAGE	4096
static struct stat statbuf ;

/*
 * Handler for signal SIGPIPE
 */
void hand() { (void) fprintf(stderr, RT136, "CPTPDSK") ; 
	      fflush(stderr) ;
	      if ( getconfent("RTCOPYD","NETRETRY",0) != NULL && 
		     stat(NOMORETAPES, &statbuf) < 0)  {
				if ( dskon ) rfio_close(rfio_xysock(dskfd)) ;
				if ( tpon ) tclose(tpfd) ;
				exit(SYRETRY) ;
			}
			else {
				if ( dskon ) rfio_close(rfio_xysock(dskfd)) ;
				if ( tpon ) tclose(tpfd) ;
				exit(SYERR) ;
			}
	    }

/*
 * Transfer program
 */
main(argc,argv)
	int     argc ; 
	char ** argv ;
{
	/*
	 * To parse options.
	 */
	extern char * optarg ; 
	extern int    optind ;
	extern long strtol() ;
	extern char * getenv() ;
	char 		* cp ; 
	int 		   c ; 	
	int 	undersctl =0 ; 		/* option -s specified ?     */
	int 	  maxsiz = 0 ;		/* Num of Mbytes to rqst     */
	int 	    free = 0 ; 		/* Num of Mbytes left        */
	int    sizestart = 0 ;		/* decremented from free at restart */
	int        error = 0 ;
	int    underNctl = 0 ;
	int 	   ebc2a = 0 ;
	static char tpden[8] = "";      /* Tape density         */

	/*
	 *  To log
	 */ 
	char 	     ptr[10] ;		/* Message to log	     */
	char 	       *ifce ;


	/*
	 * To store options.
	 */
	int      append= 0 ; 		/* Append mode		*/
	int  blksiz= 32760 ;		/* Block size		*/
	int      nread= -1 ; 		/* Max nb of records	*/

	/*
	 * Buffer
	 */
	char 	    * buffer ;		/* Pointer to buffer	*/
	int	      buflen ; 		/* Buffer length	*/

	/*
	 * Files 
	 */
	char  * dskfil ;		/* Disk file name	*/
	char  *  tpfil ; 		/* Tape file name	*/

	/*
	 * Counters
	 */
	int	total= 0 ; 		/* Total number of bytes transfered	*/
	int	 irec= 0 ; 		/* Index of the current record		*/
	int   nskips = 0 ; 		/* Number of skips on tape errors 	*/
	time_t stime,etime ;

	/*
	 * Return codes for system call.
	 */
	int 	rc ; 

        /*
         * For storing the uid & gid & key of an external user
         */
        char    *special_uid = NULL;
        char    *special_gid = NULL;
        char    *special_key = NULL;
	char 	*reqhost = NULL ;
#if defined(linux)
        float   compress ;
        COMPRESSION_STATS compstats ;
#endif


        /*
         * Getting info from the daemon
         */
        special_uid=getenv("ORI_UID");
        special_gid=getenv("ORI_GID");
        special_key=getenv("KEY");
        reqhost=getenv("REQHOST");

	(void)signal(SIGPIPE,(void (*)())hand);
	/* 
	 * Input parameter analysis
	 */
	(void) fprintf(stderr, RT209, "CPTPDSK", 'U') ; 
	while( (c= getopt(argc,argv, "d:E:xab:t:N:X:s:i:C:T:")) != EOF ) {
		switch(c) {
			case 'x':
				break ;
                        case 'd':
                                strcpy(tpden,optarg) ;
                                break;
			case 'a':
				append= 1 ; 
				(void) fprintf(stderr, RT203, "CPTPDSK") ; 
				break ; 
			case 'b':
				blksiz= (int) strtol(optarg,&cp,10) ;
				if ( *cp != '\0' ) {
					(void) fprintf(stderr, RT129, "CPTPDSK") ;
					exit(USERR) ;
				}
				(void) fprintf(stderr, RT204, "CPTPDSK", blksiz) ; 
				break ; 
			case 't':
				tpfil= optarg ;
				break ; 
			case 'N':
				nread= (int) strtol(optarg,&cp,10) ;
				if ( *cp != '\0' ) {
					(void) fprintf(stderr, RT133, "CPTPDSK") ;
					exit(USERR) ;
				}
				if ( nread > 0 ) {
					(void) fprintf(stderr, RT207, "CPTPDSK", nread) ;
					underNctl ++ ;
				}
				break ; 
			case 's':
                                maxsiz= (int) strtol(optarg,&cp,10) ;
                                if ( *cp != '\0' ) {
                                        (void) fprintf(stderr, RT132, "CPTPDSK") ;
                                        exit(USERR) ;
                                }
                                if ( maxsiz > 0 )
                                        (void) fprintf(stderr, RT208, "CPTPDSK", maxsiz) ;
                                if ( maxsiz >= 2048 ) {
                                        (void) fprintf(stderr, RT220, "CPTPDSK") ;
                                        free = MAXFILESZ ;
                                }
                                else
                                        free = maxsiz*1024*1024 ;

				undersctl++ ;
				break ;
			case 'E':
				if ( !strcmp (optarg,"skip") )
					setpopt(SKIP_ON_ERR) ;
				setpopt(SET_EFLAG);
				break ;
                        case 'i':
                                sizestart=(int) strtol(optarg,&cp,10) ;
                                if ( *cp != '\0' ) {
                                        (void) fprintf(stderr, RT146, "CPTPDSK") ;
                                        exit(SYERR) ;
                                }
                                if ( sizestart < 0 ) {
                                        (void) fprintf(stderr, RT146, "CPTPDSK") ;
                                        exit(SYERR) ;
                                }
                                break ;

                        case 'C':
                                if ( !strcmp (optarg,"ebcdic") || !strcmp (optarg,"EBCDIC") ) {
                                        ebc2a ++ ;

#if defined(TRACE1)
                                fprintf(stderr," ebcdic conversion requested \n");
#endif  /* TRACE1 */
                                }
				(void) fprintf(stderr, RT214, "CPTPDSK") ;
                                break ;
		        case 'T':
			        strcpy(tpdevtyp,optarg);
				break;

			case '?':
				(void) fprintf(stderr, RT102, "CPTPDSK"); 
				exit(USERR) ;
		}
	}

	setdevtype(tpdevtyp,tpden);
#if defined(SONYRAW)
	if ( !strcmp(tpden,"RAW") || !strcmp(tpden,"raw") ) {
		sonyraw++ ;
	}
#endif /* SONYRAW */
        /*
         * Calculate the new value for  free after decrement
         * the value  sizestart
         */
         if ( undersctl && sizestart ) {
                if ( free - (sizestart*1024) < 0 ) {
                        (void) fprintf(stderr, RT147, "CPTPDSK", sizestart, free/(1024*1024));
                        rtcplogit(argv[0],"calculation of free: free (%d) minus sizestart (%d *1024) negative\n",free,sizestart);
                        /* Go on with larger free value anyway */
                }
                else
                        free -= sizestart*1024 ;

        }


	/*
	 * Buffer allocation
	 */
#ifdef CRAY
	buflen= ((blksiz+PAGE-1)/PAGE)*PAGE ; 
#else
        buflen= blksiz ;
#endif
	if ( ( buffer= ( char *) malloc((unsigned) buflen)) == NULL ) {
		(void) fprintf(stderr, RT105, "CPTPDSK", sys_errlist[errno]) ;
		exit(SYERR) ;
	}	

	/*
	 * Getting disk file name.
	 */
	if ( optind < argc ) { 
		dskfil= argv[optind] ;
	}
	else	{
		(void) fprintf(stderr, RT120, "CPTPDSK") ; 
		exit(USERR) ; 
	}

        if ( strstr(dskfil,":/afs") != NULL ) {
                (void) fprintf(stderr, RT145, "CPTPDSK") ;
                exit(USERR) ;
        }

	/*
	 * Opening tape file as input.
	 * Set it to perform tapelist I/O.
	 */
	tpfd= topen(tpfil,O_RDONLY) ;
	tpon ++ ;
	/* 
	 * Opening disk file as output
	 * If fixed format and record length not 
	 * specified we wait for the first record 
	 * to be read.
	 */

	if (special_uid != NULL && special_gid != NULL && special_key !=NULL && reqhost!= NULL)
		rc= rfio_xyopen_ext(dskfil," ",dskfd,0,(append)?"USEA":"USE",&irc,
				(uid_t)atol(special_uid),
                                (gid_t)atol(special_gid),
                                atoi(special_key),
				reqhost) ;
	else
		rc= rfio_xyopen(dskfil," ",dskfd,0,(append)?"USEA":"USE",&irc) ;
	if ( rc || irc  ) {
		error = rc ? rc : irc ;
		(void) fprintf(stderr, RT110, "CPTPDSK", rfio_serror()) ;
		tclose(tpfd) ;
		rtcplogit(argv[0],"rfio_xyopen() : errno = %d, serrno = %d, rfio_errno = %d", errno, serrno, rfio_errno ) ;
		switch ( error ) {
			case ENOENT:
			case EISDIR:
			case EPERM:
			case EACCES:
				exit(USERR);
			default:
				exit(UNERR) ;
		}
	}
	dskon ++ ;

	/*
 	 * writing interface name
 	 */
	if ( (ifce=getifnam(rfio_xysock(dskfd)))==NULL ) 
		strcpy(ptr,"unknown");
	else 
		strcpy(ptr,ifce);

	(void) time(&stime) ;
	/*
	 * Starting the transfer
	 */
	for(;;) {
		int nbyte ;

		if ( undersctl )
			if ( free < buflen && free > 0 )  {
				(void)time(&etime) ;
				(void) fprintf(stderr, RT201, "CPTPDSK", total) ;
				(void) fprintf(stderr, RT202, "CPTPDSK", irec) ;
				(void) fprintf(stderr, RT212, "CPTPDSK");
				(void) printf("%d:%d:%s\n",irec,total,ptr) ; 
				total/=1024 ;
			       	if ( etime-stime > 0 )
					(void) fprintf(stderr, RT221,"CPTPDSK",total,ptr,total/(etime-stime));
				rfio_xyclose(dskfd," ",&irc) ;
				(void) tclose(tpfd) ; 
#if !defined(SONYRAW)
				if ( nskips > 0 )
					exit (TPE_LSZ);
				else
					exit(LIMBYSZ) ;
#else
				exit(0) ;
#endif
			}
		/* 
		 * Reading data
		 */
		rc= tread(tpfd,buffer,buflen) ;
		
		if ( rc == NEXTREC  && nskips < MAXNBSKIPS ) {
			nskips ++ ;
			continue ;
		}
		if ( rc == NEXTREC && nskips >= MAXNBSKIPS ) {
                                exit( MNYPARY ) ;
                }

		/*
		 * End of tape file has been reached.
		 */
		if ( rc == 0 ) {
			(void) fprintf(stderr, RT205, "CPTPDSK") ; 
			rc= rfio_xyclose(dskfd," ",&irc) ;
			if ( rc || irc ) {
				(void) fprintf(stderr, RT108, "CPTPDSK", rfio_serror()) ; 
				rtcplogit(argv[0],"rfio_xyclose() : errno = %d, serrno = %d, rfio_errno = %d", errno, serrno, rfio_errno ) ;
				tclose(tpfd) ;
				exit(SYERR) ;
			}
			(void) time(&etime) ;
			(void) tclose(tpfd) ; 
			(void) printf("%d:%d:%s\n",nread,total,ptr) ; 
			(void) fprintf(stderr, RT201, "CPTPDSK", total) ; 
			(void) fprintf(stderr, RT202, "CPTPDSK", irec) ; 
			total/=1024 ;
		       	if ( etime-stime > 0 )
				(void) fprintf(stderr, RT221,"CPTPDSK",total,ptr,total/(etime-stime));
			if ( nskips ) 
				exit(BLKSKPD);
			else
				exit(0) ;
		} 

#if defined(TRACE1)
                fprintf(stderr,"rfio_write() writing %d bytes to disk\n",rc);
#endif /* TRACE1 */

		/*
		 * Writing data	to disk.
		 */
		nbyte= rc ; 
		total += nbyte ; 
		free -= nbyte ;

		if ( nbyte > 0 && ebc2a ) {
			ebc2asc(buffer,nbyte) ;
		}

		rc= rfio_xywrite(dskfd,buffer,0,nbyte," ",&irc) ; 	
		if ( rc || irc ) {
			(void) fprintf(stderr, RT115, "CPTPDSK", rfio_serror()) ; 
			rtcplogit(argv[0],"rfio_xywrite() : errno = %d, serrno = %d, rfio_errno = %d", errno, serrno, rfio_errno ) ;
			tclose(tpfd) ;
			rfio_xyclose(dskfd," ",&irc) ;
			if (rc == ENOSPC || irc == ENOSPC) {
				(void) printf("%d:%d:%s\n",nread,total,ptr);
				exit(ENOSPC) ;
			}
			else 
				exit(SYERR) ;
		}	
		/*
	 	 * Other records to copy ?
		 */
		irec ++ ;
		if ( nread != -1 ) {
			nread -- ;
			if ( nread == 0 ) {
				( void ) time( &etime ) ;
				(void) fprintf(stderr, RT205, "CPTPDSK") ; 
				(void) fprintf(stderr, RT212, "CPTPDSK");
				rc= rfio_xyclose(dskfd," ",&irc) ;
				if ( rc || irc ) {
					(void) fprintf(stderr, RT108, "CPTPDSK", rfio_serror()) ; 
					tclose(tpfd) ;
					exit(SYERR) ;
				}
				(void) tclose(tpfd) ; 
				(void) printf("%d:%d:%s\n",nread,total,ptr) ; 
				(void) fprintf(stderr, RT201, "CPTPDSK", total) ; 
				(void) fprintf(stderr, RT202, "CPTPDSK", irec) ; 
				total/=1024 ;
			       	if ( etime-stime > 0 )
					(void) fprintf(stderr, RT221,"CPTPDSK",total,ptr,total/(etime-stime));
				if ( underNctl ) {
				    if ( nskips ) 
					exit(TPE_LSZ);
				    else
					exit(LIMBYSZ) ;
				}
				else
					exit(0) ;
			}
		}
	}
}
