/*
 * Copyright (C) 1990-1999 by CERN/IT/PDP/IP
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)tptodkF.c	2.53 11/10/99  F. Hassine";
#endif /* not lint */


/* tptodkF.c             SHIFT transferring data from local tape to remote disk in fixed format.  */

#include <stdio.h>
#include <fcntl.h>
#include <malloc.h>
#include <sys/errno.h>

#if defined(apollo)
#include <strings.h>
#else
#include <string.h>
#endif	/* apollo */
#include <sys/types.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <log.h>
#include "rtcopy.h"

#define SWAPIT(a) { int __a; \
        swab((char *)&a, (char *)&__a, sizeof(a)); \
        a = ((unsigned int)__a << 16) | ((unsigned int)__a >> 16); }

extern char * getifnam() ;
extern char * getconfent() ;
extern void rtyexit() ;
extern int rfio_open_ext() ;
extern int rfio_write() ;
extern int rfio_close() ;

extern int serrno ;
extern int rfio_errno ;
extern int errno ;
#ifndef linux
extern char *sys_errlist[];
#endif /* linux */
#if defined (SONYRAW)
extern int sonyraw ;
#endif /* SONYRAW */

#include <rfio.h>

/*
 * Static definitions
 */
static int dskon = 0 ;
int tpon = 0 ;
static int dskfd ;
static int tpfd ;
static int rc ;
static char func[16] ;
char tpdevtyp[9] = "";        /* Device type          */

/*
 * Stager control code
 */
#define LIMBYSZ 197

#ifndef min
#define min(a,b)      (((a)<(b)) ? (a):(b))
#endif

#define PAGE	4096
#define DEFNBPAGES 256 	/* 1 MB */

static struct stat statbuf ;

/*
 * Handler for signal SIGPIPE
 */
void hand() { 	(void) fprintf(stderr, RT136, "CPTPDSK") ; 
		fflush(stderr) ;
	      	if ( getconfent("RTCOPYD","NETRETRY",0) != NULL && 
		     (rc=stat(NOMORETAPES, &statbuf)) < 0) {
				rtcplogit(func,"SIGPIPE hand(): retry required");
				if (dskon) { 
					rfio_close(dskfd) ;
					rtcplogit(func,"rfio_close(): done");
				}
				if (tpon) tclose(tpfd) ;
				exit(SYRETRY) ;
		}
		else {
			rtcplogit(func,"SIGPIPE hand(): retry not required %s", 
					(rc < 0 ? "":"file nomoretapes exists") );
			if (dskon) rfio_close(dskfd) ;
			if (tpon) tclose(tpfd) ;
			exit(SYERR) ;
		}
}

/*
 * End of transfer
 */

main(argc,argv)
	int     argc ; 
	char ** argv ;
{
	/*
	 * To parse options.
	 */
	extern char * optarg ; 
	extern int    optind ;
	extern long strtol() ;
	extern char *getenv();
	char 		* cp ; 
	int 		   c ; 	
	/*
	 *  To log
	 */ 
	char 	     ptr[10] ;		/* Message to log	     */
	char 	       *ifce ;		/* to collect interface name */

	/*
	 * To store options.
	 */
	int      append= 0 ; 		/* Append mode.		*/
	int  blksiz= 32760 ;		/* Block size		*/
	int       lrecl= 0 ;		/* Record length	*/
	int 	 nread= -1 ; 		/* Max nb of records	*/
	int 	maxsiz =-1 ;		/* num. of Megs wanted  */
	int 	 free = -1 ; 		/* counter of maxsiz    */
	int  sizestart = 0 ;		/* decremented from free at restart */
	int  undersctl = 0 ; 		/* data under limit control ? */
	int      nrecs = 0 ; 		/* records counted */
	int 	 nfree = 0 ; 		/* number of recs. read */
	int 	expbytes = 0 ;		/* Constant : initial value for free */
	int  underNctl = 0 ;		/* number of recs limited by -N */
	int	 ebc2a = 0 ;		/* Ebcdic to ascii	*/
	static char tpden[8] = "";        /* Tape density         */
	int    unblock = 0 ;		/* Fixed to variable	*/
	int    f77unblock = 0 ;		/* F77 record format to fixed */

	/*
	 * Buffer
	 */
	char 	    * buffer ;		/* Pointer to buffer	*/
	int    	      buflen ; 		/* Buffer length	*/
	char * convbuf = NULL ;		/* Buffer to convert fixed to variable */
	char	      * obuf ;		/* Output buffer pointer */
	int 	     readlen ; 		/* Read buffer length	*/
	int 	      nbread ; 		/* Nb read per transfer	*/
	char      vmstr[256] ;
	int          nbpages ;		/* Number of 4K pages for buffer */

	/*
	 * Files 
	 */
	char 	    * dskfil ;		/* Disk file name	*/
	char 	    *  tpfil ; 		/* Tape file name	*/

	/*
	 * Counters
	 */
	int   irec= 0 ; 	/* Index of the current record		*/
	int  total= 0 ; 	/* Total number of bytes transferred	*/
	int nskips = 0;		/* Number of skips on tape errors */
	int todisk = 0 ;	/* What will be written to disk at next loop ? */
	int diskbytes = 0 ;	/* What has been written in total to disk */
	time_t etime,stime ;	/* End time, start time */
	int 	total1 ;	/* Total number of Kbytes */

	/*
	 * Return code for call.
	 */
	int rc ; 
	int v;

	/*
	 * To store RETRY reason
 	 */ 
	char rtyreason[24] ;

        /*
         * For storing the uid & gid & key of an external user
         */
        char    *special_uid = NULL;
        char    *special_gid = NULL;
        char    *special_key = NULL;
	char 	*reqhost = NULL ;
	char  	rh[1] ;
#if defined(linux)
        float   compress ;
        COMPRESSION_STATS compstats ;
#endif

	
	rh[0]='\0';
	vmstr[0] = '\0' ;

	strcpy(func,argv[0]) ;

        /*
         * Getting info from the daemon
         */
        special_uid=getenv("ORI_UID");
        special_gid=getenv("ORI_GID");
        special_key=getenv("KEY");
	reqhost= getenv("REQHOST");

	(void)signal(SIGPIPE,(void (*)())hand);

	/* 
	 * Input parameter analysis
	 */
	(void) fprintf(stderr, RT209, "CPTPDSK", 'F') ; 
	while( (c= getopt(argc,argv, "d:E:xab:t:L:N:X:s:i:C:T:")) != EOF ) {
		switch(c) {
                        case 'd':
                                strcpy(tpden,optarg) ;
                                break;
			case 'a':
				append= 1 ; 
				(void) fprintf(stderr, RT203, "CPTPDSK") ; 
				break ; 
			case 'x':
				(void) initlog("rtcopyd", LOG_DEBUG, "");
				break ;
			case 'X':
				strcpy(vmstr,optarg) ;
				break;
			case 'b':
				blksiz= (int) strtol(optarg,&cp,10) ;
				if ( *cp != '\0' ) {
					(void) fprintf(stderr, RT129, "CPTPDSK") ;
					exit(USERR) ;
				}
				(void) fprintf(stderr, RT204, "CPTPDSK", blksiz) ; 
				break ; 
                        case 's':
                                maxsiz= (int) strtol(optarg,&cp,10) ;
                                if ( *cp != '\0' ) {
                                        (void) fprintf(stderr, RT132, "CPTPDSK") ;
                                        exit(USERR) ;
                                }
                                if ( maxsiz > 0 )
                                        (void) fprintf(stderr, RT208, "CPTPDSK", maxsiz) ;
				if ( maxsiz >= 2048 ) {
					(void) fprintf(stderr, RT220, "CPTPDSK") ;
					free = MAXFILESZ ;
				}	
                                else 
					free = maxsiz*1024*1024 ;
				undersctl++ ;
                                break ;

				/* 
				 * This option goes along with the -s option 
				 */
			case 'i':
				sizestart=(int) strtol(optarg,&cp,10) ;
				if ( *cp != '\0' ) {
                                        (void) fprintf(stderr, RT146, "CPTPDSK") ;
                                        exit(SYERR) ;
                                }
				if ( sizestart < 0 ) { 
                                        (void) fprintf(stderr, RT146, "CPTPDSK") ;
                                        exit(SYERR) ;
				}
				break ;
					
			case 't':
				tpfil= optarg ;
				break ; 
			case 'L':
				lrecl= (int) strtol(optarg,&cp,10) ;
				if ( *cp != '\0' ) {
					(void) fprintf(stderr, RT135, "CPTPDSK") ;
					exit(USERR) ;
				}
				(void) fprintf(stderr, RT210, "CPTPDSK", lrecl) ; 
				break ; 
			case 'N':
				nread= (int) strtol(optarg,&cp,10) ;
				if ( *cp != '\0' ) {
					(void) fprintf(stderr, RT133, "CPTPDSK") ;
					exit(USERR) ;
				}
				if ( nread > 0 ) {
					(void) fprintf(stderr, RT207, "CPTPDSK", nread) ;
					underNctl++ ;
				}
				break ; 
			case 'E':
				if ( ! strcmp ( optarg,"skip" ) )
					setpopt(SKIP_ON_ERR);
				setpopt(SET_EFLAG);
				break ;
			case 'C':
				cp = strtok (optarg,",") ;
				while (cp) {
					if ( !strcmp (cp,"ebcdic") ) {
						ebc2a ++ ;
						log(LOG_DEBUG," ebcdic -> ascii conversion requested \n");
					} else if ( !strcmp (cp,"block") )
						unblock ++ ;
					else if ( !strcmp(cp,"f77") ) 
					        f77unblock ++ ;
					if (cp = strtok (NULL,",")) *(cp-1) = ',' ;
				}
				break ;
		        case 'T':
			        strcpy(tpdevtyp,optarg);
				break;
 			case '?':
				(void) fprintf(stderr, RT102, "CPTPDSK"); 
				exit(USERR) ;
		}
	}

	log(LOG_DEBUG, " Free: %d, sizestart: %d\n",free,sizestart);
	setdevtype(tpdevtyp,tpden);
#if defined (SONYRAW)
        if ( !strcmp(tpden,"RAW") || !strcmp(tpden,"raw") ) {
		log(LOG_DEBUG," Switching to tape reading for SONY drive \n");
                sonyraw++ ;
        }
#endif /* SONYRAW */

	/*
 	 * Calculate the new value for  free after decrement
  	 * the value  sizestart
	 */
	 if ( undersctl && sizestart ) {
		log(LOG_DEBUG," >> Free: %d, sizestart(KB): %d, new value for free:%d\n",free,sizestart,free-sizestart*1024);
		if ( free - (sizestart*1024) < 0 ) {
			(void) fprintf(stderr, RT147, "CPTPDSK", sizestart, free/(1024*1024));
			rtcplogit(argv[0],"calculation of free: free (%d) minus sizestart (%d *1024) negative\n",free,sizestart);
			/* Go on with larger free value anyway */
		}
		else
			free -= sizestart*1024 ;
	}

	if ( ( nread > 0 && lrecl > 0 )  && underNctl && !undersctl ) {
		free = lrecl * nread ;
		expbytes = free ;
	}
	else if ( !underNctl && undersctl ) {
		expbytes = free ;
	}
	else if ( underNctl && undersctl && (lrecl > 0 && free > 0)  ) {
		expbytes = ( free < lrecl * nread ? free : lrecl * nread )  ;
	}
 
        log(LOG_DEBUG," 0 - Expected Bytes : expbytes = %d \n",expbytes);
	log(LOG_DEBUG," 0 - Free is %d ( free ) , lrecl = %d , nread = %d\n",free,lrecl,nread ) ;
	log(LOG_DEBUG," 0 - underNctl = %d , undersctl = %d \n",underNctl,undersctl) ;

	/*
	 * Getting disk file name.
	 */
	if ( optind < argc ) { 
		dskfil= argv[optind] ;
	}
	else	{
		(void) fprintf(stderr, RT120, "CPTPDSK") ; 
		exit(USERR) ; 
	}

	if ( strstr(dskfil,":/afs") != NULL ) {
		(void) fprintf(stderr, RT145, "CPTPDSK") ;
		exit(USERR) ;
	}

	/* Activate new transfer mode */
	v = RFIO_STREAM;
	rfiosetopt(RFIO_READOPT,&v,4); 
	(void) fprintf(stderr," CPTPDSK - TRYING NEW RFIO V3 PROTOCOL\n") ;
	
	/* 
	 * Opening disk file as output.
	 */
	rfio_errno = 0 ;
	if ( ebc2a ) 
		(void) fprintf(stderr, RT214, "CPTPDSK") ;
	if ( append ) {
		if ( (dskfd= rfio_open_ext(dskfil,O_APPEND|O_WRONLY|O_APPEND, 0666 ,
				(special_uid==NULL ? 0:(uid_t)atol(special_uid)),
				(special_gid==NULL ? 0:(gid_t)atol(special_gid)),
				(special_key==NULL ? 0:atoi(special_key)),
				(reqhost==NULL ? rh : reqhost) , 
				vmstr )) == -1 ) { 
			rtcplogit(argv[0],"rfio_open() : errno = %d, serrno = %d, rfio_errno = %d", errno, serrno, rfio_errno ) ;
			(void) fprintf(stderr, RT110, "CPTPDSK", rfio_serror()) ;
			switch(rfio_errno) {
                                case ENOENT:
                                case EACCES:
                                case EISDIR:
				case EPERM :
                                        exit(USERR) ;
                                        break ;
                                default:

					if (errno == EBADF ) {
						strcpy(rtyreason,"TRANSFRTY");
						rtyexit(rtyreason,UNERR) ;
					}
					else
						exit(UNERR) ;
			}
		}
		dskon ++ ;
	}
	else	{
		if ( (dskfd= rfio_open_ext(dskfil,O_CREAT|O_WRONLY|O_TRUNC,0666,
				(special_uid==NULL ? 0:(uid_t)atol(special_uid)),
                                (special_gid==NULL ? 0:(gid_t)atol(special_gid)),
                                (special_key==NULL ? 0:atoi(special_key)),
				(reqhost==NULL ? rh : reqhost), vmstr )) == -1 ) { 
			rtcplogit(argv[0],"rfio_open() : errno = %d, serrno = %d, rfio_errno = %d", errno, serrno, rfio_errno ) ;
			(void) fprintf(stderr, RT110, "CPTPDSK", rfio_serror()) ;
			switch(rfio_errno) {
			 	case ENOENT:
				case EACCES:
				case EISDIR:
					exit(USERR) ;
					break ;
				default:
					if (errno == EBADF && rfio_errno == 0 && serrno == 0 ) {
						strcpy(rtyreason,"TRANSFRTY");
						rtyexit(rtyreason,UNERR) ;
					}
					else
						exit(UNERR) ;
			}
		}
		dskon ++ ;
	}

	if ((rfioreadopt(RFIO_READOPT) & RFIO_READBUF) == RFIO_READBUF) 
	  (void) fprintf(stderr," CPTPDSK - SERVER DOESN'T HAVE RFIO V3 PROTOCOL\n") ;
	rfio_errno = 0 ;
	(void) time(&stime) ;

	/*
 	 * writing interface name
 	 */
	if ( (ifce=getifnam(dskfd))==NULL ) 
		strcpy(ptr,"unknown");
	else 
		strcpy(ptr,ifce);

        if ( (cp=getconfent("RTCOPYBUFFER","NBPAGES",0)) != NULL && atoi(cp) > 0 ) {
                nbpages=atoi(cp) ;
        }
        else
                nbpages=DEFNBPAGES ;

	/*
	 * Buffer allocation.
	 */
	nbread= (nbpages*PAGE) / blksiz ;
	if ( nbread == 0 ) nbread= 1;	/* specified blksiz > NBPAGES */
#ifdef CRAY
		readlen= ((blksiz+PAGE-1)/PAGE)*PAGE ;
#else
		readlen= blksiz;
#endif
	buflen = ((readlen*nbread+PAGE-1)/PAGE)*PAGE ;
	if ( lrecl )
		nbread= nbread * (blksiz/lrecl) ;

        log(LOG_DEBUG," Buffer will allocate %d pages\n",nbpages) ;
 	if ( buflen <= 0 ) {
		(void) fprintf(stderr, RT148, "CPTPDSK",buflen) ;
		exit (USERR) ;
	}

	if ( ( buffer= ( char *) malloc((unsigned)buflen)) == NULL ) {
		(void) fprintf(stderr, RT105, "CPTPDSK", sys_errlist[errno]) ;
		exit(RSLCT) ;
	}	
	log(LOG_DEBUG,"Malloc'ed a buffer of %d bytes \n",buflen);

	if (lrecl) {
		nfree=free/lrecl ;
		if ( unblock )
			if ((convbuf= (char *)
			    malloc(buflen+(buflen+lrecl-1)/lrecl)) == NULL ) {
				(void) fprintf(stderr, RT105, "CPTPDSK", sys_errlist[errno]) ;
				exit(RSLCT) ;
			}	
	}

	/*
	 * Opening tape file as input.
	 */
	tpfd= topen(tpfil,O_RDONLY) ;
	tpon ++ ;
	for(;;) {
		int   ngot ;
		int  nwant ; 	/* Nb records to read	*/
		int offset ;	/* Offset in buffer	*/
		int 	 i ; 	/* Loop index		*/

		/* 
		 * Setting nwant in function of option request.
		 */
		nwant= ( nread > 0 && nread < nbread ) ? nread : nbread ;
		if ( undersctl && lrecl > 0 )
		       if ( free >= 0 ) {
			       	nwant= min( free/lrecl , nwant ) ;
				/*
				 * If (0<= free < lrecl) take one more record.
				 */
				if ( nwant == 0 ) 
					nwant = 1 ;
			       	nrecs += nwant ;
		       }

				
		log(LOG_DEBUG,"nread=%d,nbread=%d,nfree=%d,free=%d,lrecl=%d, nwant=%d\n",nread,nbread,nfree,free,lrecl,nwant);
		/* 
		 * Reading data; Termination condition of loop includes the test
		 * offset + readlen < buflen to prevent buffer from beeing overlaid
		 */
		for(i= 0, offset= 0; i< nwant && offset + readlen <= buflen; ) {
			rfio_errno = 0 ;
			log(LOG_DEBUG,"COPYING %d BYTES OF DATA FROM TAPE TO %x + %d\n",readlen,buffer,offset);
			rc = tread(tpfd,buffer+offset,readlen) ;
			if ( rc == NEXTREC && nskips < MAXNBSKIPS ) {
				log(LOG_DEBUG," BLOCK SKIPPED !\n");
				nskips ++; 
				continue ;
			}
			if ( rc == NEXTREC && nskips >= MAXNBSKIPS ) {
				exit( MNYPARY ) ;
			}
			if ( rc == 0 ) {
				log(LOG_DEBUG,"Returned code from tread() is 0\n");
				total+= offset ; 
				todisk= offset ;

				if ( todisk > 0 && ebc2a ) {
					ebc2asc(buffer,todisk) ;
				}
				if ( todisk > 0 && unblock ) {
					todisk = fix2var(buffer,convbuf,todisk,lrecl);
					obuf = convbuf;
				} else if ( f77unblock ) {
				        todisk = f77rec2fix(buffer,todisk,lrecl);
					if ( todisk == -1 ) {
					  tclose(tpfd) ;
					  rfio_close(dskfd) ;
					  exit(USERR);
					}
				        obuf = buffer;
				} else
					obuf = buffer;

				/* 
				 * When the tape file comes to its natural end ,
				 * The rfio_write used is the following 
				 */

				if ( todisk && (rc= rfio_write(dskfd,obuf,todisk)) == -1 ) {
					int last_err ;
					int last_errno ;
					log(LOG_DEBUG,"rfio_write() writing %d bytes to disk\n",offset);
					last_err = rfio_errno ;
					last_errno = errno ;
					rtcplogit(argv[0],"rfio_write() : errno = %d, serrno = %d, rfio_errno = %d", errno, serrno,  last_err ) ;
					(void) fprintf(stderr, RT115, "CPTPDSK", rfio_serror()) ;
					tclose(tpfd) ;
					if ( last_err == ENOSPC || (last_err==0 && last_errno== ENOSPC) ) {
						(void) printf("%d:%d:%s\n",nread,total,ptr);
						rfio_close(dskfd) ;
						exit(ENOSPC) ;
					}
					else if ( last_errno == ENODEV ) {
						strcpy(rtyreason,"TRANSFRTY");
						rtyexit(rtyreason,SYERR) ;
					}
					else {
						rfio_close(dskfd) ;
						exit(SYERR) ;
					}
				}	
				diskbytes += rc ;
				(void) fprintf(stderr, RT205, "CPTPDSK") ; 
				(void) time(&etime) ;
				if ( rfio_close(dskfd) == -1 ) {
					if ( rfio_errno == ENOSPC ||
				   	   ( rfio_errno == 0 && errno == ENOSPC ) ) {
				 		rc = ENOSPC;
						(void) printf("%d:%d:%s\n",nread,total,ptr) ;
					} else
						rc = SYERR;
					rtcplogit(argv[0],"rfio_close() : errno = %d, serrno = %d, rfio_errno = %d", errno, serrno, rfio_errno ) ;
					(void) fprintf(stderr, RT108, "CPTPDSK", rfio_serror()) ;
					if (tpon) tclose(tpfd) ;
					exit(rc) ;
				}
				(void) tclose(tpfd) ; 
				(void) printf("%d:%d:%s\n",nread,total,ptr) ; 
				(void) fprintf(stderr, RT201, "CPTPDSK", diskbytes) ; 
				(void) fprintf(stderr, RT202, "CPTPDSK", irec) ; 
                                total1=diskbytes/1024 ;
                                if ( etime - stime > 0 )
                                        (void) fprintf(stderr, RT221,"CPTPDSK",total1,ptr,total1/(etime-stime));

				if ( nskips ) {
					log(LOG_DEBUG," Block skipped , exit with %d\n", BLKSKPD) ;
					exit(BLKSKPD) ;
				}
				else
					exit(0) ;
			} 

			/*
			 * The record length was not given 
			 * by the user.
			 */
			if ( lrecl == 0 ) {
				lrecl= rc ;
				(void) fprintf(stderr, RT210, "CPTPDSK", lrecl) ; 
				if ( undersctl && lrecl)
					nfree=free/lrecl ;
				if ( unblock )
					if ((convbuf= (char *)
					    malloc(buflen+(buflen+lrecl-1)/lrecl)) == NULL ) {
						(void) fprintf(stderr, RT105, "CPTPDSK", sys_errlist[errno]) ;
						exit(RSLCT) ;
					}	
			}  

			/* 
			 * If lrecl was not known before, expbytes = 0 
			 * Give a value now. This takes place once after the 
			 * first read .
			 */

        		if ( ( expbytes == 0 && nread > 0 && lrecl > 0 )  && underNctl && !undersctl ) {
                		free = lrecl * nread ;
                		expbytes = free ;
        		}
        		else if ( expbytes == 0 && !underNctl && undersctl ) {
                		expbytes = free ;
        		}
        		else if ( underNctl && undersctl && expbytes == 0  ) {
                		expbytes = ( free < lrecl * nread ? free : lrecl * nread )  ;
        		}

                	log(LOG_DEBUG," 0 - Expected Bytes : expbytes = %d \n",expbytes);
                	log(LOG_DEBUG," 0 - Free is %d ( free ) , lrecl = %d , nread = %d\n",free,lrecl,nread ) ;
                	log(LOG_DEBUG," 0 - underNctl = %d , undersctl = %d \n",underNctl,undersctl) ;
                	log(LOG_DEBUG," 0 - # of records got ( ngot ) = %d, irec = %d  \n",ngot,irec);

			if ( nread > 0 && rc > nread*lrecl )
				rc = nread*lrecl ;
			offset += rc ; 

			/* When number of bytes get oat end of tape file happens to 
			 * be positibe but lower than expected, increment the number 
			 * of records actially read 
			 */
			if ( lrecl > 0 && rc > 0 && rc < lrecl )
				ngot = 1 ;
			else
				ngot = rc/lrecl ;

			i += ngot ;
			irec += ngot ;
			nread -= ngot ;
#ifdef SUNOS_411
			if ( offset % 2 ) break ;
#else
#ifdef sgi
			if ( offset % 4 ) break ;
#else
#ifdef CRAY
			if ( offset % 8 ) break ;
#endif
#endif
#endif
		} /* for(;;) */

		if ( undersctl && free < 0 ) {
                               /* Stop because maxsize limit reached */
			       (void) time(&etime) ;
                               tclose(tpfd) ;
			       rc = 0;
                               if ( rfio_close(dskfd) == -1 ) {
					if ( rfio_errno == ENOSPC ||
					   ( rfio_errno == 0 && errno == ENOSPC ) )
						rc = ENOSPC;
					else
						rc = SYERR;
					rtcplogit(argv[0],"rfio_close() : errno = %d, serrno = %d, rfio_errno = %d", errno, serrno, rfio_errno ) ;
					(void) fprintf(stderr, RT108, "CPTPDSK", rfio_serror()) ;
			       }
                               (void) printf("%d:%d:%s\n",nfree,diskbytes,ptr) ;
                               (void) fprintf(stderr, RT201, "CPTPDSK", diskbytes) ;
                               (void) fprintf(stderr, RT202, "CPTPDSK", nfree ) ;
				(void) fprintf(stderr, RT212, "CPTPDSK");
                                total1=diskbytes/1024 ;
                                if ( etime - stime > 0 )
                                        (void) fprintf(stderr, RT221,"CPTPDSK",total1,ptr,total1/(etime-stime));

#if !defined(SONYRAW)
				if ( rc ) exit(rc);
				if ( nskips )
					exit(TPE_LSZ);
				else
					exit(LIMBYSZ) ;
#else
				exit(rc) ;
#endif
		}
	
		/*
		 * Writing data	
		 */
		rfio_errno = 0 ;
		total+= offset ;
                free-= offset ;
		if ( undersctl || underNctl ) {
			if ( expbytes - diskbytes > 0  && expbytes - diskbytes < offset )
				todisk = expbytes - diskbytes ;
			else
				todisk = offset ;
		}
                else
                        todisk = offset ;

		log(LOG_DEBUG," 1 - expected bytes ( %d ) - diskbytes ( %d ) = %d\n",expbytes,diskbytes,expbytes - diskbytes) ;
                log(LOG_DEBUG," 1 - total # of bytes ( total ) bufferred = %d\n",total ) ;
                log(LOG_DEBUG," 1 - # of bytes before stop ( -s, -N ) ( free ) = %d\n", free ) ;
		log(LOG_DEBUG," 1 - will write to disk %d bytes ( todisk ) \n",todisk ) ;


		if ( todisk > 0 && ebc2a ) {
			ebc2asc(buffer,todisk) ;
		}
		if ( todisk > 0 && unblock ) {
			todisk = fix2var(buffer,convbuf,todisk,lrecl);
			obuf = convbuf;
		} else if ( f77unblock ) {
		  todisk = f77rec2fix(buffer,todisk,lrecl);
		  if ( todisk == -1 ) {
		    tclose(tpfd) ;
		    rfio_close(dskfd) ;
		    exit(USERR);
		  }
		  obuf = buffer;
		} else
			obuf = buffer;

		if ( ( rc=rfio_write(dskfd,obuf,todisk) ) == -1 ) {
			int last_err ;
			int last_errno ;

			last_err = rfio_errno ;
			last_errno = errno ;
			rtcplogit(argv[0],"rfio_write() : errno = %d, serrno = %d, rfio_errno = %d", errno, serrno,  last_err ) ;
			(void) fprintf(stderr, RT115, "CPTPDSK", rfio_serror()) ;
			rfio_close(dskfd) ;
			tclose(tpfd) ;
			if ( last_err == ENOSPC || (last_err == 0 && last_errno == ENOSPC) ) {
				(void) printf("%d:%d:%s\n",nread,diskbytes,ptr) ;
				exit(ENOSPC) ;
			}
			else if ( last_errno == ENODEV ) {
				strcpy(rtyreason,"TRANSFRTY");
				rtyexit(rtyreason,SYERR) ;
			}
			else
				exit(SYERR) ;
		}	
		else
			diskbytes += rc ; 

                log(LOG_DEBUG," 1 - Total # of bytes on disk ( diskbytes ) %d \n", diskbytes );

		/*
	 	 * Other records to copy ?
		 */
		if ( nread == 0 ) {
			(void) fprintf(stderr, RT206, "CPTPDSK") ; 
			(void) fprintf(stderr, RT212, "CPTPDSK");
			(void) time(&etime) ;
			if ( rfio_close(dskfd) == -1 ) {
				if ( rfio_errno == ENOSPC ||
				   ( rfio_errno == 0 && errno == ENOSPC ) ) {
					rc = ENOSPC;
					(void) printf("%d:%d:%s\n",nread,total,ptr) ;
				} else
					rc = SYERR;
				(void) fprintf(stderr, RT108, "CPTPDSK", rfio_serror()) ;
				tclose(tpfd) ;
				exit(rc) ;
			}
			(void) tclose(tpfd) ; 
			(void) printf("%d:%d:%s\n",nread,diskbytes,ptr) ; 
			(void) fprintf(stderr, RT201, "CPTPDSK", diskbytes) ; 
			(void) fprintf(stderr, RT202, "CPTPDSK", irec) ; 

			log(LOG_DEBUG,"nskip= %d, exit with %d\n",nskips,BLKSKPD);

                        total1=diskbytes/1024 ;
                        if ( etime - stime > 0 )
                                (void) fprintf(stderr, RT221,"CPTPDSK",total1,ptr,total1/(etime-stime));

			/* 
			 * nread limited by the -N option 
			 * If skips on tape , return with TPE_LSZ, otherwise
			 * return with LIMBYSZ 
			 */
#if !defined (SONYRAW)
			if ( underNctl ) {
                        	if ( nskips )
                                	exit(TPE_LSZ) ;
                        	else 
					exit(LIMBYSZ) ;
			}
			else
				exit(0) ;
#else
			exit(0) ;
#endif 
		}
	} /* for */
}

/*	convert fixed length records to variable length */
/*	i.e. strip trailing blanks and add a newline */
fix2var(ibuf, obuf, len, lrecl)
char *ibuf;
char *obuf;
int len;
int lrecl;
{
	char *ip;
	int n;
	char *op;
	char *p;
	int remlen;

	ip = ibuf;
	op = obuf;
	remlen = len;
	while (remlen > 0) {
		p = ip + ((remlen > lrecl) ? lrecl : remlen) - 1;
		while (p >= ip && *p == ' ') p--;
		n = p - ip + 1;
		if (n)
			memcpy (op, ip, n);
		op += n;
		*(op++) = '\n';
		remlen -= lrecl;
		ip += lrecl;
	}
	return (op - obuf);
}

/*
 * Remove FORTRAN control words, i.e. remove the enclosing lrecl words 
 * on each logical record. Note that the enclosing lrecl words are NOT counted
 * to the record which means that the actual record length is lrecl+8 bytes.
 */
int f77rec2fix(ibuf,len,lrecl)
char *ibuf;
int len,lrecl;
{
  static int do_swap = -1;
  static int in_p = 0;
  int save_in_p = 0;
  int out_len, remlen;
  union {
    char c[4];
    int lrecl;
  } f77;

  save_in_p = in_p;
  out_len = remlen = len;
  remlen -= in_p;
  while ( remlen>0 ) {
    memcpy(f77.c,&ibuf[in_p],4);
    if ( do_swap == -1 ) {
      if ( f77.lrecl == lrecl ) do_swap = 0;
      else {
	SWAPIT(f77.lrecl);
	if ( f77.lrecl == lrecl ) do_swap = 1;
      }
    } else if ( do_swap ) SWAPIT(f77.lrecl);
    
    if ( f77.lrecl != lrecl ) {
      fprintf(stderr,RT149,"CPTPDSK",lrecl,f77.lrecl);
      return(-1);
    }
    if ( in_p == 0 ) {
      out_len -= 4;
      memmove(&ibuf[in_p],&ibuf[in_p+4],remlen);
    } else if ( in_p >= 4 ) {
      out_len -= 8;
      in_p -=4;
      memmove(&ibuf[in_p],&ibuf[in_p+8],remlen);
    }
    in_p+= f77.lrecl < remlen ? f77.lrecl+4 : remlen;
    remlen=out_len-in_p;
  }
  if ( remlen == 0 ) out_len -=4; /* Remove the enclosing controlword for the last record */
  /* This equation can probably be simplified in some clever manner but it works! */
  in_p = (f77.lrecl+8 - (len - save_in_p) % (f77.lrecl+8)) % (f77.lrecl+8);
  return(out_len);
}

