/*
 * Copyright (C) 1990,1991 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)scantp.c	2.2 07/25/91 CERN CN-SW/DC Antoine Trannoy";
#endif /* not lint */

/*
 * scantp.c	Count the number of files on the tape.
 */

/*
 * Calling sequence :  scantp -p filnam -v VSN1[:...VSNn]
 *
 * Nb of file read written on stdout. 
 *
 * Return code: 0 if no error.
 *
 */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <tapereq.h>
#include <sys/types.h>
#include <sys/bmxctl.h>

extern void exit() ;
extern void perror() ; 

/*
 * Possible return code.
 */
#define USERR	1
#define SYERR	2
#define UNERR	3
#define SEERR	4

/*
 * Conversion table.
 */
char tab[257]= 
"................................................................\
 ...........<(+|&.........!$*);~-/........^,%_>?..........:#@'=\042\
.abcdefghi.{.....jklmnopqr.}......stuvwxyz...[...............]..\
.ABCDEFGHI.......JKLMNOPQR........STUVWXYZ......0123456789......" ;

/*
 * Converting an EBCDIC string into an ASCII one.
 */
void ebctoasc(from,to,nb)
	char *from ; 
	char *to ; 
	int nb ; 
{
	int i ; 

	for(i= 0; i<nb; i ++) 
		to[i]= tab[from[i]] ; 
} 

/*
 * Positioning the tape to the next tape mark.
 */
void nexttpmk(fd)
	int fd ;
{
	struct dmn_comm pos ; 		/* To perform IOCTL	*/

	pos.POS_REQ= TR_PTMS ;
	pos.POS_COUNT= 1 ; 
	if ( ioctl(fd,BXC_SPOS,&pos) < 0 ) {
		perror("SCANTP - POSITIONING TO NEXT TAPE MARK") ; 
		(void) printf("0") ; 
		exit(SYERR) ; 
	}
	if ( ioctl(fd,BXC_GPOS,&pos) < 0 ) {
		perror("SCANTP - POSITIONING TO NEXT TAPE MARK") ; 
		(void) printf("0") ; 
		exit(SYERR) ;
	}
	if ( pos.POS_REP != 0 ) {
		(void) fprintf(stderr,"SCANTP - TAPE POSITIONING ERROR %d\n",pos.POS_REP) ; 
		(void) printf("0") ; 
		exit(SYERR) ; 
	} 
}

/*
 * Different type of labels.
 */
#define NL	0	/* No Label		*/
#define AL	1	/* ANSI Label		*/
#define SL	2	/* Standard Label	*/

/*
 * Finding out the last file sequence number.
 */
main(argc,argv)
	int    argc ; 
	char **argv ;
{
	extern int    errno ;
	extern int   optind ;
	extern char *optarg ;

	int 		 fd ; 		/* File Descriptor	*/
	char     vsns[1024] ;		/* vsn list 		*/
	char   filnam[1024] ;		/* File Name		*/
	char     buffer[80] ;		/* Buffer to read tape	*/
	char     ebcbuf[81] ;		/* Conversion buffer	*/
	char      seqstr[5] ;		/* File sequence string */ 
	int       seqnb = 0 ;		/* last file seq nb	*/
	int       label = 0 ;		/* label		*/
	int 	    vol = 1 ; 		/* volume offset 	*/
	char          * vsn ; 		/* pointing on next vsn */
	int              rc ; 		/* Return code		*/
	int 		  c ;		/* To parse options	*/

	(void) fprintf(stderr,"\nSCANTP\n\n") ; 

	/*
	 * Getting arguments.
	 */
	while((c= getopt(argc,argv,"p:v:")) != EOF ) {
		switch((char)c) {
			case 'p':
				(void) strcpy(filnam,optarg) ;
				break ;
			case 'v':
				(void) strcpy(vsns,optarg) ; 
				(void) fprintf(stderr,"SCANTP - VSN IS %s\n",vsns) ; 
				break ;
		} 
	}
		
	/*
	 * Opening tape file.
	 */
	if ( (fd= open(filnam,O_RDONLY)) == -1 ) { 
		perror("SCANTP - OPENING TAPE FILE") ;
		(void) printf("0") ; 
		exit(SYERR) ; 
	}

	/*
	 * Is the tape labeled?
         */ 
	if ( (rc= read(fd, buffer, 80)) == -1 ) { 
		perror("SCANTP - READING FIRST BLOCK OF THE TAPE") ; 
		(void) printf("0") ; 
		exit(SYERR) ; 
	}
	if ( rc == 80 ) {
		if ( !strncmp(buffer,"VOL1",4)) {
			label= AL ;
			(void) fprintf(stderr,"SCANTP - ANSI LABEL\n") ; 
		} 
		else 	{
			ebctoasc(buffer,ebcbuf,80) ;
			if ( !strncmp(ebcbuf,"VOL1",4)) {
				label = SL ;
				(void) fprintf(stderr,"SCANTP - STANDARD LABEL\n") ; 
			}
		}
	}
	if ( label == NL ) 
		(void) fprintf(stderr,"SCANTP - NO LABEL\n") ; 

	/*
	 * Checking VSN of the first volume. 
	 */
	vsn= strtok(vsns,":") ; 	

	if ( label == AL   &&  strncmp(vsn,buffer+4,6) ) {
		(void) fprintf(stderr,"SCANTP - WRONG VSN\n") ; 
		(void) printf("0") ; 
		exit(USERR) ; 
	}
	if ( label == SL  &&  strncmp(vsn,ebcbuf+4,6) ) {
		(void) fprintf(stderr,"SCANTP - WRONG VSN\n") ; 
		(void) printf("0") ; 
		exit(USERR) ; 
	}
 
	/*
 	 * Reading next block.
	 */
	if ( (rc= read(fd,buffer,80)) == -1 ) { 
		perror("SCANTP - READING HDR1 LABEL") ; 
		(void) printf("0") ; 
		exit(SYERR) ; 
	}

	/*
	 * Scanning the tape.
	 */
	for(;;) {
		int         eof  ; 	/* end of file ? 	*/
		int 	    eov  ; 	/* end of volume ?	*/

		if ( label != NL ) {

			 /*** HDR1 ***/

			if ( rc != 80 ) {
			   (void) fprintf(stderr,"SCANTP - WRONG HEADER LABEL\n"); 
			   (void) printf("0") ; 
			   exit(USERR) ; 
			}
			if ( label == SL ) ebctoasc(buffer,ebcbuf,80) ;

			 /*** Reading file sequence ***/

			if ( label == AL ) 
				(void) strncpy(seqstr,buffer+31,4) ; 
			 else 
				(void) strncpy(seqstr,ebcbuf+31,4) ; 
			
			seqstr[4] = 0 ; 
			seqnb= atoi(seqstr) ; 

			/*** Skipping HDR2 ***/

			nexttpmk(fd) ;

			/*** Skipping file section ***/
			
			nexttpmk(fd) ;
			
			 /*** Reading label ***/

			eof= 0 ; 
			eov= 0 ; 

			if ( (rc= read(fd,buffer,80)) == -1 ) { 
				perror("SCANTP - READING EOF1 or EOV1 LABEL") ; 
				(void) printf("0") ; 
				exit(SYERR) ;
			}
			if ( rc != 80 ) {
				(void) fprintf(stderr,
				"SCANTP - WRONG END OF FILE OR VOLUME LABEL\n") ;
				(void) printf("0") ; 
				exit(USERR) ; 
			}

			 /*** EOF or EOV ***/ 
			 
			if ( label == AL ) {
				eof= !strncmp(buffer,"EOF1",4) ; 	
				eov= !strncmp(buffer,"EOV1",4) ; 
			} else {
				ebctoasc(buffer,ebcbuf,80) ;
				eof= !strncmp(ebcbuf,"EOF1",4) ;
				eov= !strncmp(ebcbuf,"EOV1",4) ; 
			}

			if ( !(eof || eov) ) {
			   (void) fprintf(stderr, "SCANTP - MISSING LABEL\n") ;  
			   (void) printf("0") ; 
			   exit(USERR) ;   
			}
			
			/*** EOV ***/

			if ( eov ) {
				struct dmn_comm pos ;

				/*** Reaching end of tape ***/

				nexttpmk(fd) ; 

				/*** Changing volume ***/

				pos.POS_REQ= TR_PVOL ; 
				pos.POS_COUNT= ++ vol ;
				(void) strcpy((char *)&pos.POS_VSN,"VSN") ; 
				if ( ioctl(fd,BXC_SPOS,&pos) < 0 ) {
					perror("SCANTP - SWITCHING VOLUME") ;
					(void) printf("0") ;
					exit(SYERR) ; 
				}
				if ( ioctl(fd,BXC_GPOS,&pos) < 0 ) {
					perror("SCANTP - SWITCHING VOLUME") ; 
					(void) printf("0") ;
					exit(SYERR) ; 
				}
				if ( pos.POS_REP != 0 ) {
					(void) fprintf(stderr,
	       		  		"SCANTP - SWITCHING VOLUME ERROR %d\n",
					pos.POS_REP) ; 
					(void) printf("0") ;
					exit(SYERR) ;   
				} 

				/*** Reading VOL1 ***/	

				if ( (rc= read(fd, buffer, 80)) == -1 ) { 
					perror("SCANTP - READING LABEL") ; 
					(void) printf("0") ;
					exit(SYERR) ; 
				}
				if ( rc!= 80 ) {
				   (void) fprintf(stderr,"SCANTP - WRONG LABEL\n");
				   (void) printf("0") ;
				   exit(USERR) ; 
				}

				if ( label == SL )
					ebctoasc(buffer,ebcbuf,80) ;

				/*** Is it the right vsn ? ***/
			
				vsn= strtok(NULL,":") ; 
				if ( label == AL   &&  strncmp(vsn,buffer+4,6) ) {
					(void) fprintf(stderr,"SCANTP - WRONG VSN\n") ; 
					(void) printf("0") ;
					exit(USERR) ; 
				}
				if ( label == SL  &&  strncmp(vsn,ebcbuf+4,6) ) {
					(void) fprintf(stderr,"SCANTP - WRONG VSN\n") ; 
					(void) printf("0") ;
					exit(USERR) ; 
				}
			}

			 /*** EOF ***/

			if ( eof ) {

				/*** Skipping EOF2 ***/

				nexttpmk(fd) ; 
			}
		} 

		else 	{
			/*** NO LABEL ***/

			seqnb ++ ;
			nexttpmk(fd) ; 
		}

		/*** Reading next block ***/	

		if ( (rc= read(fd,buffer,80)) == -1 ) { 
			perror("SCANTP - READING BLOCK AFTER TAPE MARK") ; 
			(void) printf("0") ;
			exit(SYERR) ; 
		}

		/*** EOT ***/

		if ( rc == 0 )  
			break ; 
	}

	(void) fprintf(stderr,"\nSCANTP - %d FILES HAVE BEEN SCANNED\n",seqnb) ;
	(void) printf("%d",seqnb) ; 
	(void) close(fd) ;
}    
