/*
 * Copyright (C) 1994 by CERN/CN/PDP/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)rtyexit.c	1.5 01/16/95  F. Hassine";
#endif /* not lint */

/* rtyexit.c      Procedures to exit rtcopy software with retries */

#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <varargs.h>
#include "rtcopy.h"

#define PRTBUFSZ  180

/*
 * Exits with retry code.
 */
void rtyexit(rtyreason,def)
char * rtyreason ;
int def;

{
 extern char * getconfent() ;
 char *cp ;
 int rcode ;
 struct stat statbuf ;
 if (   (cp = getconfent("RTCOPYD",rtyreason,0)) != NULL &&
        (rcode=atoi(cp)) >0 &&
        stat(NOMORETAPES,&statbuf) < 0 ) {
        switch ( rcode ) {
                case SYRETRYD:
                case SYRETRYMORE:
                case SYRETRY:
		case SYRETRYUSERR:
		case SYRETRYPARITY:
                        exit(rcode) ;
                default:
                        exit(def) ;
        }
 }
 else
        exit(def) ;
}

rtcplogit(va_alist) va_dcl
{
        va_list args;
        char *func;
        char *msg;
        char prtbuf[PRTBUFSZ];
        struct tm *tm;
        time_t current_time;
        int fd_log;
	char rh[8] , *pr ;
	extern char * getenv() ;

	rh[0]='\0' ;
	if ( (pr=getenv("PIDNUMBER")) != NULL ) 
		strcpy(rh, pr) ;
		
        va_start (args);
        func = va_arg (args, char *);
        msg = va_arg (args, char *);
        time (&current_time);           /* Get current time */
        tm = localtime (&current_time);
        sprintf (prtbuf, "%02d/%02d %02d:%02d:%02d [%s] %s: ", tm->tm_mon+1,
                tm->tm_mday, tm->tm_hour, tm->tm_min, tm->tm_sec, rh , func);
        vsprintf (prtbuf+strlen(prtbuf), msg, args);
        va_end (args);
        strcat (prtbuf, "\n");
        fd_log = open (LOGFILE, O_WRONLY | O_CREAT | O_APPEND, 0664);
        write (fd_log, prtbuf, strlen(prtbuf));
        close (fd_log);
}

