/*
 * Copyright (C) 1995-1996 by CERN/CN/PDP/DS Maria Luisa Barja
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)rtcpacct.c	1.3 08/07/96 CERN CN-PDP/DH Maria Luisa Barja";
#endif /* not lint */

#include <stdio.h>
#include <sys/types.h>
#include "rtcopy.h"
#include "sacct.h"

rtcpacct(subtype, uid, gid, jid, stgreqid, reqtype, ifce, vid, size, retryn, exitcode, clienthost, dsksrvr)
	int     subtype;
	uid_t	uid;
	gid_t	gid;
	int     jid;
	int     stgreqid;
	char    reqtype;
	char    *ifce;
	char    *vid;
	int     size;
	int     retryn;
	int     exitcode;
	char    *clienthost;
	char    *dsksrvr;
{
	int acctreclen;
	struct acctrtcp acctrtcp;
	char *getconfent();
	char *p;

	if ((p = getconfent("ACCT", "RTCOPY", 0)) == NULL ||
	    (strcmp (p, "YES") && strcmp (p, "yes"))) return;
	memset ((char *) &acctrtcp, 0, sizeof(struct acctrtcp));
	acctrtcp.subtype = subtype;
	acctrtcp.uid = uid;
	acctrtcp.gid = gid;
	acctrtcp.jid = jid;
	acctrtcp.stgreqid = stgreqid;
	acctrtcp.reqtype = reqtype;
        strcpy (acctrtcp.ifce, ifce);
        strcpy (acctrtcp.vid, vid);
	acctrtcp.size = size;
	acctrtcp.retryn = retryn;
	acctrtcp.exitcode = exitcode;
	strcpy (acctrtcp.clienthost, clienthost);
	strcpy (acctrtcp.dsksrvr, dsksrvr);
	acctreclen = ((char *) acctrtcp.dsksrvr - (char *) &acctrtcp) +
		strlen (dsksrvr) + 1;

	wsacct (ACCTRTCOPY, &acctrtcp, acctreclen);
}
