/*
 * Copyright (C) 1990-1999 by CERN CN-PDP/CS
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)rtcopyd.c	2.79 06/28/99 CERN CN-PDP/CS A. Trannoy, F. Hassine";
#endif /* not lint */

/* rtcopyd.c      SHIFT remote tape copy super server                   */

#include <stdio.h>                    
#include <unistd.h>
#include <sys/types.h>                  /* Standard data types          */
#if defined(IRIX5)
#include <stdarg.h>
#endif

#if defined(CRAY) 
#include <udb.h>			/* To get account identifier	*/
#endif	/* CRAY */

#include <pwd.h>			/* To get info on passwd file	*/
#include <grp.h>			/* To get info on group file	*/
#include <fcntl.h>			/* File control			*/
#include <malloc.h>			/* to allocate memory		*/
#if defined(_AIX) && defined(_IBMR2)
#include <sys/select.h>
#endif /* AIX */

#if defined(apollo)
#include <strings.h>
#else
#include <string.h>			/* string manipulation		*/
#endif	/* apollo */

#if !defined(IRIX5)
#include <varargs.h>			/* Variable parameter list	*/
#endif /* IRIX5 */

#include <sys/stat.h>			/* To do a stat() call		*/
#include <sys/file.h>			/* File I/O definitions		*/
#include <sys/param.h>                  /* System parameters            */
#include <sys/time.h>			/* Time definition 		*/
#if defined(_AIX)
#include <time.h>
#endif

#include "rtcopy.h"
#include "sacct.h"

/*
 * Networking.
 */
#include <sys/socket.h>                 /* Socket interface             */
#include <netinet/in.h>                 /* Internet data types          */
#include <arpa/inet.h>			/* Internet address		*/
#include <netdb.h>                      /* Network "data base"          */
#include <marshall.h>			/* Marshalling macros		*/

extern int (*recvfunc)() ;
extern int (*sendfunc)() ;
extern int isremote() ;
extern int setnetio() ;
#define netread		(*recvfunc)
#define netwrite	(*sendfunc)

/*
 * WARNING !!! VALID ONLY ON ASCII MACHINES
 * unmarshall_STRING is redefined to avoid unnecessary copies.
 */
#undef  unmarshall_STRING
#define unmarshall_STRING(ptr,str)	{ str= ptr ; INC_PTR(ptr,strlen(str)+1) ; }

/*
 * Process handling.
 */
#include <signal.h>			/* Signal handling		*/
#if  ( defined(__osf__) && defined(__alpha)|| defined(sgi) ) || defined(linux)
#include <sys/wait.h>
#endif  /* ( __osf__ && __alpha ) || sgi */
#if defined(sun) || defined(ultrix) || defined (_AIX) || defined(hpux) 
#include <sys/wait.h>			/* wait, wait3, wait4 (BSD)	*/
#include <sgtty.h>			/* Terminal ioctl's		*/
#include <sys/resource.h>               /* Resources usage definitions  */
#endif	/* sun || ultrix */
#if defined(CRAY) 
#include <sys/category.h>		/* To perform killm		*/
#endif	/* CRAY */

/*
 * Error and message handling.
 */
#include <errno.h>                      /* System error codes           */
#include <serrno.h>                     /* SHIFT error codes            */
#include <syslog.h>			/* System logger		*/
#include <log.h>			/* Our logging handler 		*/
extern void 	perror() ; 		/* System call error reporting	*/
extern int 	errno ; 		/* Current system error index	*/
#ifndef linux
extern char     *sys_errlist[] ; 	/* System error list            */
#endif

/*
 * Option's flags.
 */
static int      standalone      = 0 ;   /* Standalone flag      */
static int      loglevel = LOG_INFO ;	/* Default log level    */
static int      debug		= 0 ;  	/* Debug flag           */
static int      port 		= 0 ;	/* Non-standard port    */
static int      logging  	= 0 ;	/* Default not to log   */
static int 	bet ;

static char * tpdump  = TPDUMP ;
static char * cptpdsk = CPTPDSK ;
static char * cpdsktp = CPDSKTP ;
static char * logfile = LOGFILE ;
static char * workdir = WORKDIR ;
static 	char userlogfile[1024] ;
static int logf ;

/*
 * Message buffer.
 */
static char buffer[SYCONFLIM] ;
#if !defined(IRIX5)
static void printerr();         /* Function to log error messages sent to clients */
#else
static void printerr(char * , ... ) ;
#endif /* IRIX5 */

int 		CPtest();		/* Function to select error messages */

static int    	new_uid;                /* New uid after mapping for an out of site user */
static int    	new_gid;                /* New gid after mapping for an out of site user */
static int      old_uid;                /* Old uid after mapping for an out of site user */
static int      old_gid;                /* Old gid after mapping for an out of site user */
static uid_t    uid ;			/* Client user identifier			*/
static gid_t    gid ;			/* Client group identifier			*/
static char 	acctstr[7];		/* uuu$gg					*/
static char 	clienthost[MAXHOSTNAMELEN]; /* Where the request is from 		*/
static int	rfiokey;
static int    	isoutofsite=0;         	/* Is user out of site ? */
#if defined(ACCTON)
static char charcom ='\0' ;
static int stagerid = 0;
#endif


/*
 * Job identifier
 */
static int jid ; 
static int  islocal = 0 ; 		/* Is the request issued from current host ? */
/*
 * For information transfer to environment
 */
static char envacct[64] ;
static char envpid[64] ;
static char envhom[64] ;
static char envtz[64] ;
static char envuid[64] ;
static char envgid[64] ;
static char envkey[64] ;
static char envhost[64];

/*
 * To kill user job.
 * On CRAY, the job is killed.
 * On sgi, sun and ultrix, the job means the process group.
 */
static void killjob(job, rcode)
	int job ;
	int rcode ;
{
	log(LOG_INFO,"command failed\n") ; 
#if defined(ACCTON)
	log(LOG_DEBUG,"rtcpacct(RTCPCMDC,%d,%d,%d,%d,%c, , , 0,0,%d,%s\n",uid,gid,jid,stagerid,charcom,rcode,clienthost) ;
	rtcpacct(RTCPCMDC,uid,gid,jid,stagerid,charcom,"","",0,0,rcode, clienthost,"") ;
#endif /* ACCTON */
#if defined(CRAY)
	if ( job ) {
		if ( killm(C_JOB,job,SIGKILL) == -1 ) {
		     log(LOG_ERR,"killm(C_JOB,%d,SIGKILL): %s\n",job,sys_errlist[errno]) ; 
		     exit(SYERR) ; 
		}
	}
#else
	if ( job > 1 ) {
		if ( kill(-job,SIGKILL) == -1 ) {
			log(LOG_ERR," kill(%d,SIGKILL): %s\n",job,sys_errlist[errno]) ; 
			exit(SYERR) ; 
		}
#if defined(sun) || defined(ultrix)
		/*
		 * The process which signals the process group does 
		 * not signal itself on BSD system.
		 */
		exit(SYERR) ;
#endif	/* sun || ultrix */
	}
#endif	/* CRAY */
	else	{
		log(LOG_ERR,"Wrong user job id\n") ; 
		exit(SYERR) ; 
	}
}

/*
 * Handling SIGPIPE
 */
static SIGPIPE_hand() { 
		log(LOG_ERR,"Broken pipe\n");
		killjob(jid, SYERR) ;
		exit(SYERR) ;
}

/*
 * Send back an acknowledgment.
 */
static int sendackn(sock,req) 
	int sock ; 
	int  req ; 
{
	char ackn[3*LONGSIZE] ;
	char            * ptr ;

	ptr= ackn ; 
	marshall_LONG(ptr,(bet ? RTCOPY_MAGIC : RTCOPY_MAGIC_OLD) ) ; 
	switch(req) {
		case RQST_TPDK:
			marshall_LONG(ptr,ACKN_TPDK) ;
			break ; 
		case RQST_DKTP:
			marshall_LONG(ptr,ACKN_DKTP) ;
			break ; 
		case RQST_DPTP:
                        marshall_LONG(ptr,ACKN_DPTP) ;
                        break ;
		case RQST_PING:
			marshall_LONG(ptr,ACKN_PING) ;
			break ; 
		case RQST_ABORT:
			marshall_LONG(ptr,ACKN_ABORT) ;
			break ;
		default:
			serrno= SEINTERNAL ;
			log(LOG_ERR,"sendackn(): %s\n",sstrerror(serrno)) ;
			return -1 ;
	}
	marshall_LONG(ptr,0) ;
	switch( netwrite(sock,ackn,3*LONGSIZE) ) {
		case -1:
			log(LOG_ERR,"netwrite(): %s\n",sys_errlist[errno]) ; 
			return -1 ;
		case  0:
			serrno= SECONNDROP ;
			log(LOG_ERR,"netwrite(): %s\n",sstrerror(serrno)) ; 
			return -1 ;
	}
	return 0 ; 
}

/*
 * Receive message in buffer.
 * Returns the type of the message, 
 * or -1 if an error occurred.
 */
static int rcvmsg(sock)
	int sock ; 
{
	int msglen ; 
	int reqtyp ;
	int  magic ; 
	char * ptr ;
        char     clas[26] ; /* clock value in ascii format */
        time_t cl         ;
	int err ;

        (void)time(&cl) ;
        strcpy(clas,ctime(&cl));
        clas[ strlen(clas) -1 ]='\0';

	/*
	 * Getting header message.
	 */
	switch( netread(sock,buffer,LONGSIZE*3) ) {
		case -1:
			err = errno ;
			log(LOG_ERR,"netread(): %s\n",sys_errlist[err]) ; 
			printerr("%s [%d]: netread(): %s\n",clas,getpid(),sys_errlist[err]) ;
			return -1 ;
		case  0:
			serrno= SECONNDROP ;
			log(LOG_ERR,"netread(): %s\n",sstrerror(serrno)) ;
			printerr("%s [%d]: netread(): %s\n",clas,getpid(), sstrerror(serrno)) ;
			return -1 ;
	}
	ptr= buffer ;
	unmarshall_LONG(ptr,magic) ; 
	unmarshall_LONG(ptr,reqtyp) ; 
	unmarshall_LONG(ptr,msglen) ; 
	if ( magic != RTCOPY_MAGIC && magic != RTCOPY_MAGIC_OLD ) {
		serrno= SEBADVERSION ;
		log(LOG_ERR,"rcvmsg(): %s\n",sstrerror(serrno)) ;
		return -1 ; 
	}
	bet = ( magic == RTCOPY_MAGIC ? 1 : 0 );
	log(LOG_DEBUG,"New protocol ? %s\n",(bet ? "yes" : "no"));
		/* Illegal attempt */
 	if ( isoutofsite && !bet ) 
                return SEBADVERSION ;

	/*
	 * Sending back request type if no body.
	 */
	if ( msglen == 0 ) 
		return reqtyp ; 

	/*
	 * Getting message body.
	 */
	if ( msglen > SYCONFLIM ) {
		log(LOG_ERR,"rcvmsg(): request length %d bytes too long (limit is %d bytes)\n", msglen,SYCONFLIM);
		printerr("%s [%d]: rcvmsg(): request length %d bytes too long\n",clas,getpid(),msglen);
		return -1 ;
	}
		
	switch( netread(sock,buffer,msglen) ) {
		case -1:
			err = errno ;
			log(LOG_ERR,"netread(): %s\n",sys_errlist[err]) ; 
			printerr("%s [%d]: netread(): %s\n",clas,getpid(),sys_errlist[err]) ;
			return -1 ;
		case  0:
			serrno= SECONNDROP ;
			log(LOG_ERR,"netread(): %s\n",sstrerror(serrno)) ;
			printerr("%s [%d]: netread(): %s\n",clas,getpid(), sstrerror(serrno)) ;
			return -1 ;
	}

	/*
	 * Sending back request type.
	 */
	return reqtyp ; 
}

/*
 * Check if newacct has been executed by the client
 */
static int chk_newacct(pwd,gid)
	struct passwd *pwd ;
	gid_t gid ;
{
	char buf[BUFSIZ] ;
	char * def_acct ;
	struct group * gr ;
	char * getacctent() ;

	/* get default account */
	if ( getacctent(pwd,NULL,buf,sizeof(buf)) == NULL )
		return -1 ;
	if ( strtok(buf,":") == NULL || (def_acct= strtok(NULL,":")) == NULL )
		return -1;
	if ( strlen(def_acct) == 6 && *(def_acct+3) == '$' &&	/* uuu$gg */
	    (gr= getgrgid(gid)) ) {
		strncpy(acctstr,def_acct,4) ;
		strcpy(acctstr+4,gr->gr_name) ;	/* new uuu$gg */
		if ( getacctent(pwd,acctstr,buf,sizeof(buf)) )
			return 0 ;	/* newacct was executed */
	}
	acctstr[0]= '\0' ;
	return -1 ;
}

/*
 * Sending error messages to the client.
 * VARARGS1
 */
#if !defined(IRIX5)
static void clientlog(va_alist)
        va_dcl
#else
static void clientlog(int sock, char *format, ...)
#endif /* IRIX5 */

{
	va_list	 args ;
#if !defined(IRIX5)
	int      sock ; 
	char * format ; 
#endif /* IRIX5 */
	char msg[256] ;
	char str[256] ;
	char *    ptr ;
        time_t  clock ;
        extern time_t time() ;

	/*
	 * Building the message.
	 */
	ptr= msg ; 
	marshall_LONG(ptr,(bet ? RTCOPY_MAGIC : RTCOPY_MAGIC_OLD)) ;
	marshall_LONG(ptr,GIVE_OUTP) ;

        (void) time(&clock) ;

	/*
 	 * 	Duplicating message to file MSGLOG
	 */
	(void) strcpy(str,ctime(&clock)+strlen("Ddd ")) ; 
	(void) sprintf(str+strlen(str)-1-strlen(" YYYY")," rtcopyd[%d]: ",getpid()) ;
#if !defined(IRIX5)
        va_start(args) ;
        sock= va_arg(args,int) ;
        format= va_arg(args,char *) ;
#else
        va_start(args, format ) ;
#endif /*IRIX5 */
	(void) vsprintf(str+strlen(str),format,args) ; 
	printerr(str);
	marshall_LONG(ptr,strlen(str)+1) ;
	marshall_STRING(ptr,str) ; 
	va_end(args) ; 

	/*
	 * Sending the message.
	 */
	switch( netwrite(sock,msg,3*LONGSIZE+strlen(str)+1) ) {
		case -1:
			log(LOG_ERR,"netwrite(): %s\n",sys_errlist[errno]) ; 
			break ; 
		case  0:
			serrno= SECONNDROP ;
			log(LOG_ERR,"netwrite(): %s\n",sstrerror(serrno)) ;
			break ; 
	}
}

/*
 * Reading data written on pipe to be logged.
 * Appending it to the log.
 */
static void getlogpipe(sock,pipe)
	int sock ; 
	int pipe ;
{
	static char line[256] ;
	static int  length= 0 ; 

	for(;;)	{
		char 	 c ; 
		int status ; 

		while ( (status= read(pipe,&c,1)) == -1 && errno == EINTR )
			;
		switch(status) {
			case 0 :
				return ; 
			case -1 : 
#if defined(CRAY) || defined(sun) || ( defined(__osf__) && defined(__alpha) )
				if ( errno == EWOULDBLOCK ) {
#endif	/* CRAY	|| sun */
#if defined(ultrix) || defined(sgi) || defined(_AIX) || defined(hpux) || defined(linux)
				if ( errno == EAGAIN ) {
#endif	/* ultrix || sgi || _AIX || hpux */
					return ;
				}
				else	{	
					log(LOG_ERR,"read(): %s\n",sys_errlist[errno]) ; 
					clientlog(sock,"read(): %s\n",sys_errlist[errno]) ; 
					killjob(jid, SYERR) ; 
				}
				/* NOTREACHED */	
			default:
				line[length++]= c ; 
				if ( c == '\n' ) {
					line[length]= '\0' ;
					log(LOG_INFO,"%s",line) ; 
					length= 0 ; 
				}
				/* NOTREACHED */	
		} 
	}
}

/*
 * Reading data written on pipe to be sent
 * back to the user.
 */
static void getclientpipe(sock,pipe,logtoerr) 
	int sock ; 
	int pipe ;
	int logtoerr ;
{
	char rdbuf[512] ; 		/* Buffer to read the pipe	*/
	char      * ptr ; 		/* Pointer to the sending buffer*/
	int	 status ;
	log(LOG_DEBUG,"Entering getclientpipe for pipe %d \n",pipe);

	for(;;) {
		while( (status = read(pipe,rdbuf,511)) == -1 && errno == EINTR )
			;
		switch(status) {
		   case 0 :
			return ; 
		   case -1 : 
#if defined(CRAY) || defined(sun) || ( defined(__osf__) && defined(__alpha) )
			if ( errno == EWOULDBLOCK ) {
#endif	/* CRAY	|| sun || alpha-osf */
#if defined(ultrix) || defined(sgi) || defined(_AIX) || defined(hpux) || defined(linux)
			if ( errno == EAGAIN ) {
#endif	/* ultrix || sgi || _AIX || hpux */
				return ;
			}
			else	{	
				log(LOG_ERR,"read(): %s\n",sys_errlist[errno]) ; 
				clientlog(sock,"read(): %s\n",sys_errlist[errno]) ; 
				killjob(jid, SYERR) ; 
			}
			/* NOTREACHED */
		   default:
			rdbuf[status]= '\0' ; 
			if (logtoerr) {
				filter(rdbuf);
			}
			ptr= buffer ;
			marshall_LONG(ptr,(bet ? RTCOPY_MAGIC : RTCOPY_MAGIC_OLD) ) ; 
			marshall_LONG(ptr,GIVE_OUTP) ;
			marshall_LONG(ptr,status+1) ; 
			marshall_STRING(ptr,rdbuf) ; 
			if ( netwrite(sock,buffer,3*LONGSIZE+status+1) == -1  ) {
				log(LOG_ERR,"netwrite(): %s\n", sys_errlist[errno]) ; 
				killjob(jid, SYERR) ; 
			}
			/* NOTREACHED */
		}
	}
}

/*
 * To catch the return code of child process.
 * Global variables declared below are set.
 */
static int        rc = 0 ; 
static int    isback = 0 ;
static int signalled = 0 ;
static int   stopped = 0 ;

void actionSIGCLD()
{
	int status ;
	char clas[26] 	      ;
	time_t cl	      ; /* To read time		*/

	(void) time (&cl);
        strcpy(clas,ctime(&cl) );
        clas[strlen(clas) -1 ]='\0';

	(void) wait(&status) ; 
	switch(status & 0xFF) {
		case 0:
			/*
			 * Terminated due to an exit() call.
			 */
			rc= ( status>>8 ) & 0xFF ;
			break ;
		case 0177:
			/*
			 * The process has been stopped.
			 */
			stopped= WSTOPSIG(status) ;
			log(LOG_ERR,"rtcopy stopped by signal %d\n",stopped) ;
			printerr("%s [%d]: rtcopy stopped by signal %d\n",clas,getpid(), stopped) ;
			rc= SYERR ;
			break ;
		default:
			/*
			 * Process terminated due to a signal
			 */
			signalled= WTERMSIG(status) ;
			log(LOG_ERR,"rtcopy killed by signal %d\n",signalled);
			printerr("%s [%d]: rtcopy killed by signal %d\n",clas,getpid(), signalled) ;
			rc= SYERR ;
			break ;
	}
	isback= 1 ;
}


/*
 * Executing request: Either cptpdsk or cpdsktp or tpdump
 */
static int execreq(sock,command,ptrptr,clienthost)
	int        sock ;		/* socket identifier		*/
	char *  command ;		/* cptpdsk or cpdsktp or tpdump	*/
	char **  ptrptr ;		/* address of the pointer to    */
					/* the buffer.			*/
	char * clienthost ;		/* host where request is issued */
{
	char     * ptr ;		/* Pointer to the buffer	*/
	char   ** argv ;		/* Pointing on arguments'       */ 
	char   ** envp ;		/* Pointing on env variables'	*/
	int  env_index ;
	int       argc ; 
	int 	    st ;		/* File descriptor 		*/
	struct stat errstat ;
	int logtoerr = 1;               /* flag for getclientpipe filter */

	int logpfd[2] ;			/* pipe to get log information	*/					
        int outpfd[2] ;                 /* pipe to get stdout */
        int errpfd[2] ;                 /* pipe to get stderr */

	int         i ; 		/* Loop index			*/
	char 	   *p ;			/* Ptr to entry in config. file */
	time_t cl	      ; /* To read time					*/
	char clas[26] 	      ;
#if defined(ACCTON)
	char stagerreqid[16]; 
#endif
#if defined(CRAY)
	int 	     acid ;		/* Account identifier		*/
	char         * cp ; 		/* Character pointer		*/
	char   acctnam[7] ;		/* Account name			*/
	struct udb *userdb;		/* Pointer to udb structure	*/
	
	extern char * gid2nam() ; 	/* External declarations	*/
	extern char * acid2nam() ;
	extern int nam2acid() ; 
	extern int acctid() ; 
#endif	/* CRAY */

	extern char * getenv() ;	/* External declaration.	*/
	extern char * getconfent() ;	/* External declaration.      	*/

	/*
	 * Getting the options.
	 * Setting them in the array pointed to by argv.
	 */
	ptr= *ptrptr ;

	unmarshall_LONG(ptr,argc) ; 
	if ( (argv= ( char **) malloc((unsigned)((argc+1)*sizeof( char *)))) == NULL ) {
		log(LOG_ERR,"malloc(): %s\n",sys_errlist[errno]) ; 
		clientlog(sock,"malloc(): %s\n",sys_errlist[errno]) ; 
		return SYERR ;
	}
	argv[0]= command ; 
	for(i=1; i<argc; i ++)  
		unmarshall_STRING(ptr,argv[i]) ;
	
	argv[argc]= NULL ;

#if defined(ACCTON)
	for ( i=1; i<argc; i++ )
		if ( !strcmp(argv[i],"-Z") )
			break ;
	if ( i < argc-2 && i > 1 ) {
		strcpy(stagerreqid,argv[i+1]) ;
		p=strchr(stagerreqid,'.') ;
		if ( p != NULL ) 
			p[0]='\0' ;
		if ( (stagerid=atoi(stagerreqid)) > 0 )
			log(LOG_INFO,"Stager request number id is %d\n",stagerid);
	}
	if ( strstr(command,"cptpdsk") != NULL ) 
		charcom='r' ;
	else if ( strstr(command,"cpdsktp") != NULL )
		charcom='w' ;
	else if ( strstr(command,"dumptape") != NULL )
		charcom='d' ;
	else
		charcom='u' ;
	log(LOG_DEBUG,"rtcpacct(RTCPCMDD,%d,%d,%d,%d,%c, , , 0,0,0,%s\n",uid,gid,jid,stagerid,charcom,clienthost ) ;
        rtcpacct(RTCPCMDD,uid,gid,jid,stagerid,charcom,"","",0,0,0, clienthost,"") ;
#endif

	/*
         * Setting the filter flag for getclientpipe
         */
        if ( strstr( command, tpdump ) )
                logtoerr = 0 ;

	/*
	 * Setting environment variables in the array pointed to by envp.
	 */
	if ( (envp= (char **) malloc((unsigned)(9*sizeof(char *)))) == NULL ) {
		log(LOG_ERR,"malloc(): %s\n",sys_errlist[errno]) ; 
		clientlog(sock,"malloc(): %s\n",sys_errlist[errno]) ; 
		return SYERR ;
	}
	env_index= 0;
	(void) sprintf(envpid,"PIDNUMBER=%d",getpid()) ; 
	if ( putenv(envpid) != 0 ) {
		log(LOG_ERR,"putenv(%s) failed\n",envpid) ; 
		clientlog(sock,"putenv(%s) failed\n",envpid) ; 
		return SYERR ; 
	}
	envp[env_index++]= envpid ;
	(void) sprintf(envhom,"HOME=%s",workdir) ; 
	if ( putenv(envhom) != 0 ) {
		log(LOG_ERR,"putenv(%s) failed\n",envhom) ; 
		clientlog(sock,"putenv(%s) failed\n",envhom) ; 
		return SYERR ; 
	}
	envp[env_index++]= envhom ;
	if ( acctstr[0] ) {
		(void) sprintf(envacct,"ACCOUNT=%s",acctstr) ; 
		if ( putenv(envacct) != 0 ) {
			log(LOG_ERR,"putenv(%s) failed\n",envacct) ; 
			clientlog(sock,"putenv(%s) failed\n",envacct) ; 
			return SYERR ; 
		}
		envp[env_index++]= envacct ;
	}
/*
 * Adding to environment the uid & gid of the user
 * who made the request if this user is external
 * (out of site).
 */
        if (isoutofsite) {
                (void) sprintf(envuid,"ORI_UID=%d",old_uid);
                if ( putenv(envuid) != 0 ) {
                        log(LOG_ERR,"putenv(%s) failed\n",envuid) ;
                        clientlog(sock,"putenv(%s) failed\n",envuid) ;
                        return SYERR ;
                }
		envp[env_index++]= envuid;
                (void) sprintf(envgid,"ORI_GID=%d",old_gid);
                if ( putenv(envgid) != 0 ) {
                        log(LOG_ERR,"putenv(%s) failed\n",envgid) ;
                        clientlog(sock,"putenv(%s) failed\n",envgid) ;
                        return SYERR ;
                }
		envp[env_index++]= envgid;
		(void) sprintf(envkey,"KEY=%d",rfiokey);
		if ( putenv(envkey) != 0 ) {
                        log(LOG_ERR,"putenv(%s) failed\n",envkey) ;
                        clientlog(sock,"putenv(%s) failed\n",envkey) ;
                        return SYERR ;
                }
		envp[env_index++]= envkey;
		(void) sprintf(envhost,"REQHOST=%s",clienthost);
                if ( putenv(envhost) != 0 ) {
                        log(LOG_ERR,"putenv(%s) failed\n",envhost) ;
                        clientlog(sock,"putenv(%s) failed\n",envhost) ;
                        return SYERR ;
                }
		envp[env_index++]= envhost;
        }

	if ( (ptr = getenv("TZ")) != NULL) {
		(void) sprintf(envtz,"TZ=%s",ptr) ;
		envp[env_index++]= envtz ;
	}
	envp[env_index++]= NULL ;

        /*
         * Creating pipes to get stdout and stderr.
         * The non blocking I/O flag is set on the reading side.
         */
        if ( pipe(outpfd) == -1 ) {
                log(LOG_ERR,"pipe(): %s\n",sys_errlist[errno]) ;
                clientlog(sock,"pipe(): %s\n",sys_errlist[errno]) ;
                return SYERR ;
        }
        if ( fcntl(outpfd[0],F_SETFL,O_NDELAY) == -1 ) {
                log(LOG_ERR,"fcntl(): %s\n",sys_errlist[errno]) ;
                clientlog(sock,"fcntl(): %s\n",sys_errlist[errno]) ;
                return SYERR ;
        }

        if ( pipe(errpfd) == -1 ) {
                log(LOG_ERR,"pipe(): %s\n",sys_errlist[errno]) ;
                clientlog(sock,"pipe(): %s\n",sys_errlist[errno]) ;
                return SYERR ;
        }
        if ( fcntl(errpfd[0],F_SETFL,O_NDELAY) == -1 ) {
                log(LOG_ERR,"fcntl(): %s\n",sys_errlist[errno]) ;
                clientlog(sock,"fcntl(): %s\n",sys_errlist[errno]) ;
                return SYERR ;
        }

	/*
	 * Creating pipe to get log information.
	 * The non blocking I/O flag is set on the reading side.
	 */
	if ( pipe(logpfd) == -1 ) {
		log(LOG_ERR,"pipe(): %s\n",sys_errlist[errno]) ; 
		clientlog(sock,"pipe(): %s\n",sys_errlist[errno]) ; 
		return SYERR ;
	}
	if ( fcntl(logpfd[0],F_SETFL,O_NDELAY) == -1 ) {
		log(LOG_ERR,"fcntl(): %s\n",sys_errlist[errno]) ; 
		clientlog(sock,"fcntl(): %s\n",sys_errlist[errno]) ; 
		return SYERR ;
	}

	/*
	 * Installing interrupt handler to catch 
	 * SIGCLD or SIGCHLD signal. 
	 */
	isback= 0 ;
#if defined(CRAY) || defined(sgi) || defined(hpux)
	if ( signal(SIGCLD,(void (*)())actionSIGCLD) == SIG_ERR ) {
#endif	/* CRAY || sgi || hpux */
#if defined(sun) || defined(ultrix) || defined(_AIX) || ( defined(__osf__) && defined(__alpha) ) || defined(linux)
	if ( signal(SIGCHLD,(void (*)())actionSIGCLD) == SIG_ERR ) {
#endif	/* sun || ultrix || _AIX */
		log(LOG_ERR,"signal(SIGCLD,actionSIGCLD): %s\n",sys_errlist[errno]) ; 
		clientlog(sock,"signal(SIGCLD,actionSIGCLD): %s\n",sys_errlist[errno]) ; 
		return SYERR ; 
	}
		
	/*
	 * File MSGLOG should be created by root before setuid()
	 */
	if ( stat(MSGLOG,&errstat) < 0 && errno == ENOENT ) {
		st= open(MSGLOG,O_CREAT|O_WRONLY,0666);
		fchmod(st,0666) ;
		close(st) ;
	}
      	/*
       	 * Setting Group ID
         */
      	if ( setgid(gid) == -1 ) {
               log(LOG_ERR,"setgid(%d): %s\n",gid,sys_errlist[errno]) ;
               exit(SYERR) ;
      	}

      	/*
       	 * Setting User ID
       	 */
      	if ( setuid(uid) == -1 ) {
               log(LOG_ERR,"setuid(%d): %s\n",uid,sys_errlist[errno]);
               exit(SYERR) ;
       	}

	/*
	 * Forking a process to run the request.
	 */
	switch(fork()) {
		case -1:
		  {     int save_errno = errno;
			log(LOG_ERR,"fork(): %s\n",sys_errlist[save_errno]) ; 
			clientlog(sock,"fork(): %s\n",sys_errlist[save_errno]) ; 
			(void) time (&cl);
        		strcpy(clas,ctime(&cl) );
        		clas[strlen(clas) -1 ]='\0';
			printerr("%s [%d]: fork() failed: %s\n",clas,getpid(),sys_errlist[save_errno] ) ;
			return SYERR ;
		  }
		case 0:
			/*
			 * Closing all files but the pipes which 
			 * are remapped on file descriptors 1, 2 and 3.
			 */
#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined(linux)
			for(i= getdtablesize()-1; i >=0; --i)
#else
			for(i=0;i<_NFILE;i++) 
#endif
                                if (   i != outpfd[1]
                                    && i != errpfd[1]
                                    && i != logpfd[1] )
                                        (void) close(i) ;



                        if ( dup2(outpfd[1],1) == -1 ) {
                                log(LOG_ERR,"dup2(): %s\n",sys_errlist[errno]) ;

                                exit(SYERR) ;
                        }
                        if ( dup2(errpfd[1],2) == -1 ) {
                                log(LOG_ERR,"dup2(): %s\n",sys_errlist[errno]) ;

                                exit(SYERR) ;
                        }
			/* 
			 * Logs should be sent to stream # 3 
			 */
                        if ( dup2(logpfd[1],3) == -1 ) {
                                log(LOG_ERR,"dup2(): %s\n",sys_errlist[errno]) ;

                                exit(SYERR) ;
                        }

			(void) initlog("rtcopyd", loglevel, (logf ?userlogfile:logfile) ) ;
			/*
	 		 * Setting Account ID 
			 * Only on CRAY when daemon started
			 * with inetd.
	 		 */
#if defined(CRAY) 
			if ( ! standalone ) {
				if ( (userdb= getudbuid(uid)) == UDB_NULL ) {
					log(LOG_ERR,"getudbuid(%d): error %d\n",uid,udb_errno) ;
					exit(SYERR) ; 
				}
				if ( ( cp= acid2nam(userdb->ue_acids[0])) == NULL ) {
					log(LOG_ERR,"acid2nam(%d): error\n",userdb->ue_acids[0]); 
					exit(SYERR) ; 
				}
				(void) strncpy(acctnam,cp,3) ; 
				(void) strcpy(acctnam+3,"$") ;
				if ( ( cp= gid2nam(gid)) == NULL ) {
					log(LOG_ERR,"gid2nam(%d): error\n",gid) ; 
					exit(SYERR) ; 
				}
				(void) strcat(acctnam,cp) ; 
				if ( ( acid= nam2acid(acctnam)) == -1 ) {
					log(LOG_ERR,"nam2acid(%s): error\n",acctnam) ; 
					exit(SYERR) ;
				}	
				if ( acctid(0,acid) == -1 ) {
					log(LOG_ERR,"acctid(0,%d): %s\n",acid,sys_errlist[errno]);
					exit(SYERR) ; 
				}
			}
#endif	/* CRAY */

			/*
			 * Executing the rtcopy script.
			 * We should never returned from execve().
			 */
			execve(command,argv,envp) ;
			log(LOG_ERR,"execve(%s): %s\n",command,sys_errlist[errno]) ; 
			exit(SYERR) ;
			/*NOTREACHED*/
		default:
			/*
			 * Calling process waiting for the child process to return.
			 * Answering in the same time to the tpread() and tpwrite() ping.
			 */
			for(;;) {
				struct timeval    out ;
				fd_set rfds,wfds,efds ;	/* Set of file descriptors	*/
				int            nfound ; /* Nb of ready descriptors	*/

				FD_ZERO(&rfds) ; 
				FD_ZERO(&wfds) ; 
				FD_ZERO(&efds) ; 
				FD_SET(logpfd[0],&rfds) ; 
				FD_SET(outpfd[0],&rfds) ;
                                FD_SET(errpfd[0],&rfds) ;
				FD_SET(sock,&rfds) ; 
				out.tv_sec= 10 ; 
				out.tv_usec= 0 ; 

				/*
				 * Waiting for either,
				 * - a PING request from the client,
				 * - data on pipe outpfd to send to the client,
				 * - data on pipe errpfd to be filtered and sent to client
				 * - data on pipe logpfd to log,
				 * - or an interrupt.
				 */
				nfound=select(FD_SETSIZE,&rfds,&wfds,&efds,&out) ;

				if ( nfound == -1 && errno != EINTR ) {
					log(LOG_ERR,"select(): %s\n",sys_errlist[errno]) ;
					clientlog(sock,"select(): %s\n",sys_errlist[errno]) ;
					killjob(jid, SYERR) ; 
				}

				/*
				 * child process has finished.
				 */
				if ( isback ) {
					log(LOG_DEBUG,"command %s: output pipe is %d, error pipe is %d\n",command,outpfd[0],errpfd[0]);
					getclientpipe(sock,outpfd[0],logtoerr) ;
					/* Always log the error output to the error 
					 * log file 
					 */
					getclientpipe(sock,errpfd[0],1) ;
					getlogpipe(sock,logpfd[0]) ;
					if ( signalled ) 
						clientlog(sock,"request killed by signal %d\n",signalled) ; 
					if ( stopped ) 
						clientlog(sock,"request stopped by signal %d\n",stopped) ; 
					return rc ; 
				}

				/*
				 * Data on pipes.
				 */
				if ( FD_ISSET(outpfd[0],&rfds) ) {
					getclientpipe(sock,outpfd[0],logtoerr) ; 
					continue ;
				}
				if ( FD_ISSET(errpfd[0],&rfds) ) {
                                        getclientpipe(sock,errpfd[0],1) ;
                                        continue ;
                                }
				if ( FD_ISSET(logpfd[0],&rfds) ) {
					getlogpipe(sock,logpfd[0]) ; 
					continue ;
				}

				/*
				 * Data on the socket.
				 */
				if ( FD_ISSET(sock,&rfds) ) {
					switch( rcvmsg(sock) ) {
                                            case SEBADVERSION:
                                                log(LOG_ERR,"Attempt to connect with bad magic from another site\n");
                                                killjob(jid, SYERR) ;
					    case -1:
						killjob(jid, SYERR) ; 
					    case RQST_ABORT:
						(void) time (&cl);
        					strcpy(clas,ctime(&cl) );
        					clas[strlen(clas) -1 ]='\0';
						printerr("%s [%d]: request aborted by user\n",clas,getpid()) ;
						(void) sendackn(sock,RQST_ABORT) ;
						killjob(jid, USERR) ; 
						break ; 
					    case RQST_PING:
						if ( sendackn(sock,RQST_PING) == -1 ) 
							killjob(jid, SYERR) ; 
						break ;
					    default: 
						serrno= SEINTERNAL ;
						log(LOG_ERR,"%s\n",sstrerror(serrno)) ;
						clientlog(sock,"%s\n",sstrerror(serrno)) ;
						killjob(jid, SYERR) ; 
					}			
					continue ;
				}	

			}
	}
	/* NOTREACHED */
}

/*
 * Answering client.
 */
static void answerreq(sock,rcode) 
	int  sock ; 
	int rcode ; 
{
	char * ptr ; 
	ptr= buffer ;

#if defined(ACCTON)
        /* Accounting is keeping track of any
         * response to clients in any case,
         * except requests for info
         */

        log(LOG_DEBUG,"rtcpacct(RTCPCMDC,%d,%d,%d,%d,%c, , , 0,0,%d,%s\n",uid,gid,jid,stagerid,charcom,rcode,clienthost) ;
        rtcpacct(RTCPCMDC,uid,gid,jid,stagerid,charcom,"","",0,0,rcode, clienthost,"") ;
#endif /* ACCTON */

	marshall_LONG(ptr,(bet ? RTCOPY_MAGIC: RTCOPY_MAGIC_OLD) ) ; 
	marshall_LONG(ptr,GIVE_RESU) ;
	marshall_LONG(ptr,LONGSIZE) ; 
	marshall_LONG(ptr,rcode) ; 
	switch( netwrite(sock,buffer,4*LONGSIZE) ) {
		case -1:
			log(LOG_ERR,"netwrite(): %s\n",sys_errlist[errno]) ;
			return ;
		case  0:
			serrno= SECONNDROP ;
			log(LOG_ERR,"netwrite(): %s\n",sstrerror(serrno)) ;
			return ;
	}
        switch ( rcode ) {
                case 0:  	
		case LIMBYSZ:
			log(LOG_INFO,"command successful\n") ;
                        break ;
		case ETMUSR:
			log(LOG_INFO,"command sent back: too many tape users\n");
			break ;
		case RSLCT:
			log(LOG_INFO,"command sent back: reselect ordered\n");
			break ;
                case TPE_LSZ:
                case BLKSKPD:
                case MNYPARY:
                        log(LOG_INFO,"partially successful with code %d\n",rcode);
                        break ;
                default:
                        log(LOG_INFO,"command failed\n");
			break ;
        }
}

/*
 * Process a tpread() or a tpwrite() request.
 * Correct User, Group and Job identifiers are set.
 */
static void dortcopy(sock,clienthost,command) 
	int          sock ; 
	char * clienthost ;
	char *    command ;
{
	char   * ptr ;		/* Pointer on buffer				*/
	char  *name  ;		/* Client login name				*/ 
	char to[15]  ; 		/* Who will client be mapped to	?		*/
	int authorized;		/* Authorization boolean			*/
	int compar   ;
	FILE *   fs  ;		/* stream for configuration file		*/
	char buf[MAXHOSTNAMELEN] ; /* Buffer to contain host names		*/

#if defined(CRAY) || defined(sgi) || defined(_AIX) || defined(hpux) || ( defined(__osf__) && defined(__alpha) )
	mode_t  mask ; 		/* File Creation Mode Mas	*/
#endif 	/* CRAY || sgi || _AIX || hpux || alpha-osf */
#if defined(sun) || defined(ultrix) || defined(apollo) || defined(linux)
	int     mask ; 		/* File Creation Mode Mask	*/
#endif	/* sun || ultrix || apollo */
#if defined(CRAY) 
	struct udb   * userdb ; /* Pointer to udb data structure*/
#endif	/* CRAY */
	struct passwd *client ;	/* Pointer to password data structure */
	char    * request   ;	/* Request name		*/
	char logmsg[BUFSIZ] ;	/* To build log message	*/
	char     * logptr   ; 	/* Pointer to args' to build log messae	*/
	int    	 i, count   ;
	struct stat statbuf ;
	extern int get_user() ;

	ptr= buffer ;
	unmarshall_STRING(ptr,name) ; 
	unmarshall_WORD(ptr, uid) ;	
	unmarshall_WORD(ptr, gid) ;	
	if ( bet ) 
		unmarshall_WORD(ptr, rfiokey) ;
	unmarshall_WORD(ptr, mask);	


		/* The user is out of site */
	if (isoutofsite) {
		int rcd;

		rcd=get_user(clienthost,name,uid,gid,to,&new_uid,&new_gid);
		if ( abs(rcd) == 1 || rcd==-ENOENT ) {
			log(LOG_ERR,"No mapping for user %s (%d,%d) from %s: attempt rejected\n",name,uid,gid,clienthost);
			clientlog(sock,"You are not an authorized external user\n");
			answerreq(sock,SYERR) ;
			return ;
		}
		log(LOG_INFO,"Mapping %s (%d,%d) from %s to %s (%d,%d)\n",name,uid,gid,clienthost,to,new_uid, new_gid);
		old_uid = uid ;
		old_gid = gid ;
		uid = new_uid ;
		gid = new_gid ;
		name=to;
	}
	/*
	 * Setting Job ID.
	 * Only when daemon started by INETD.
	 */
	if ( ! standalone ) {
#if defined(CRAY) 
		if ( (jid= setjob(uid,0)) == -1 ) {
			log(LOG_ERR,"setjob(%d,0): %s\n",uid,sys_errlist[errno]) ; 
			clientlog(sock,"setjob(%d,0): %s\n",uid,sys_errlist[errno]) ; 
			answerreq(sock,SYERR) ; 
			return ;
		}
#else
#if  ( defined(__osf__) && defined(__alpha) )
                jid = getpid() ;
#else
#if defined(linux)
		jid = setsid();
#else
#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || (defined(_AIX) && defined(_IBMESA))
		jid= getpid();
		if ( setpgrp(jid,jid) == -1 ) {
#endif	/* sun || ultrix */
#if defined(sgi) || (defined(_AIX) && defined(_IBMR2)) || defined(hpux) || defined(SOLARIS)
#if HPUX10
		if ( (jid= setpgrp3()) == -1 ) {
#else
		if ( (jid= setpgrp()) == -1 ) {
#endif
#endif /* sgi || _AIX || hpux  */
			log(LOG_ERR,"setpgrp(): %s\n",sys_errlist[errno]) ; 
			clientlog(sock,"setpgrp(): %s\n",sys_errlist[errno]) ; 
			answerreq(sock,SYERR) ; 
			return ; 
		}
#endif /* linux */
#endif /* alpha-osf */
#endif	/* CRAY */
	}
        else {
                jid = setsid() ;
                log(LOG_DEBUG,"job ID set to %d\n",jid);
        }

	/*
	 * Log information.
	 * WARNING !!! We are not using unmarshall_STRING !!!
	 */
	if ( (request= strrchr(command,'/')) == NULL )
		request= command ; 
	else
		request ++ ;
	log(LOG_INFO,"%s request by %s (%d,%d) from %s\n",
	request,name,uid,gid,clienthost) ; 

#if defined(ACCTON)
        if ( strstr(command,"cptpdsk") != NULL )
                charcom='r' ;
        else if ( strstr(command,"cpdsktp") != NULL )
                charcom='w' ;
        else if ( strstr(command,"dumptape") != NULL )
                charcom='d' ;
        else
                charcom='u' ;

	log(LOG_DEBUG,"rtcpacct(RTCPCMDR,%d,%d,%d, , , , , 0,0,0,%s\n",uid,gid,jid,clienthost ) ;
        rtcpacct(RTCPCMDR,uid,gid,jid,0,charcom,"","",0,0,0, clienthost,"") ;
#endif

	  /*
	   * Checking login name and uid compatibility.
	   */
	if ( uid < 100 ) {
	  	log(LOG_ERR,"attempt by user %s (%d,%d) from %s rejected\n",
			name,uid,gid,clienthost) ; 
		clientlog(sock,"request from uid smaller than 100 are rejected\n") ; 
		answerreq(sock,SYERR) ;
		return ;
	}
		
          /*
           * Checking permission for the caller to use rtcopyd daemon
           */
                authorized=0;
                /*
                 * request is local, probably for tests
                 */
                if ( islocal ) {
                        log (LOG_INFO, "Local access for %s (%d,%d)\n",name,uid,gid);
                        authorized=1;
                }
                else {

                    if (  ( fs = fopen(AUTH_HOSTS, "r") ) == NULL ) {
                        log(LOG_ERR,"File %s does not exist. Any host is accepted\n",AUTH_HOSTS);
                        authorized=1;
                    }
                    else {
                        while( fscanf(fs, "%s%*[^\n]\n", buf) != EOF ) {
                                if (buf[0] != '#'){
					if ( !strcmp(buf,"any")) {
						authorized=1;
						log(LOG_INFO,"File %s is authorizing any host\n",AUTH_HOSTS);
						break ;
					}
                                        compar = strcmp(buf, clienthost );
                                        if (  compar ==0 ) {
                                                authorized=1;
						break ;
					}
					strcat (buf,".") ;
					strcat (buf, DOMAINNAME) ;
					compar = strcmp(buf, clienthost );
					if (  compar ==0 ) {
						authorized=1;
						break ;
					}
                                }
                        }
                        fclose(fs);
                    }
		}

        if (!authorized) {
                log(LOG_ERR,"attempt by %s to use rtcopyd from unauthorized host %s\n", name,clienthost);
                clientlog(sock,"request is unauthorized from %s.Sorry.\n",clienthost );
                answerreq(sock,SYERR) ;
                return ;
        }
        else 
                log(LOG_DEBUG,"request is authorized from %s\n",clienthost );

	if ( ( client= getpwuid(uid)) == NULL ) {
	  	log(LOG_ERR,"attempt by user %s (%d,%d) from %s rejected\n",
			name,uid,gid,clienthost) ; 
		clientlog(sock,"your uid is not defined on this server\n") ; 
		answerreq(sock,SYERR) ;
		return ;
	}
	if ( strcmp(client->pw_name,name) ) {
	  	log(LOG_ERR,"attempt by user %s (%d,%d) from %s rejected\n",
			name,uid,gid,clienthost) ; 
		clientlog(sock,"your uid does not match your login name\n") ;
		answerreq(sock,SYERR) ;
		return ;
	}
	/*
	 * Checking gid compatibility.
	 * A user can belong to several groups.
	 */
#if defined(CRAY)
	if ( (userdb= getudbuid(uid)) == UDB_NULL ) {
		log(LOG_ERR,"getudbuid(%d): error %d\n",uid,udb_errno) ;
		clientlog(sock,"getudbuid(%d): error %d\n",uid,udb_errno) ;
		answerreq(sock,SYERR) ;
		return ;
	}
	for(i= 0; i < MAXVIDS && userdb->ue_gids[i] != -1; i++) { 
		if ( userdb->ue_gids[i] == gid ) 
			break ;
	}
	if ( i == MAXVIDS || userdb->ue_gids[i] != gid ) {
	  	log(LOG_ERR,"attempt by user %s (%d,%d) from %s rejected\n",
			name,uid,gid,clienthost) ; 
		clientlog(sock,"your gid does not match your uid\n") ;
		answerreq(sock,SYERR) ;
		return ;
	}
#else
	if ( client->pw_gid != gid ) {
		struct group *gr ;
		char **cp ; 

		setgrent();
		while(gr= getgrent()) {
			if ( client->pw_gid == gr->gr_gid ) 
				continue ;
			for(cp= gr->gr_mem; cp && *cp; cp++)
				if ( ! strcmp(*cp,name) )
					break ; 
			if ( cp && *cp && !strcmp(*cp,name) ) 
				break ; 
		}
		endgrent();
		if ( (cp == NULL || *cp == NULL || strcmp(*cp,name)) &&
		    chk_newacct(client,gid) < 0 ) {
			log(LOG_ERR,"attempt by user %s (%d,%d) from %s rejected\n",
				name,uid,gid,clienthost) ; 
			clientlog(sock,"your gid does not match your uid\n") ;
			answerreq(sock,SYERR) ;
			return ;
		}
	}
#endif	/* CRAY */


        if ( !strcmp(request,"tpdump") )
                (void) strcpy(logmsg,"dumptape");
        else if ( !strcmp(request,"cptpdsk") )
                (void) strcpy(logmsg,"tpread");
        else if  ( !strcmp(request,"cpdsktp") )
                (void) strcpy(logmsg,"tpwrite");
        else {
                log(LOG_ERR,"Error: request %s unknown !\n",request);
                return  ;
        }

	logptr= ptr ;
	unmarshall_LONG(logptr,count) ;

	for(i= 0 ; i< count; i ++) {
		(void) strcat(logmsg," ") ; 

		if ((int) strlen(logmsg) > MAXLINELEN-128 ) { 
			log(LOG_INFO,"%s%s\n",logmsg, (logptr[0]=='\0' ? "":"\\") ) ;
			logmsg[0]='\0' ;
		}
		/*
		 * 36 is 33 ( for the time stamp in log & job id ) + 3 ( possible suffixes '\' )
		 */

                if ((int) strlen(logptr)+ (int) strlen(logmsg)+ 36  < MAXLINELEN ) {
                                (void) strcat(logmsg,logptr) ;
                                logptr+= strlen(logptr) + 1 ;
                }
                else {
                                int curlen ;
                                curlen=strlen(logmsg)+1;
                                (void) strncat(logmsg,logptr,MAXLINELEN-curlen);
                                log(LOG_INFO,"%s%s\n",logmsg,(logptr[0]=='\0' ? "":"\\") );
                                logmsg[0]='\0' ;
                                logptr+= MAXLINELEN-curlen ;
				i-- ;
                }
	}
	if ( logmsg[0] != '\0' )
			log(LOG_INFO,"%s\n",logmsg) ; 
	

	/* 
	 * Check and create if necessary the 
  	 * rtcopy directory before 
	 */
        if ( stat(workdir,&statbuf) < 0  ) {
                /*
                 * Then Create the directory
                 */
                 if ( errno == ENOENT ) {
			int omask ;
			omask=umask(0) ;
                        i=mkdir(workdir,S_IRUSR|S_IWUSR|S_IXUSR|S_IRGRP|S_IWGRP|S_IXGRP|S_IROTH|S_IWOTH|S_IXOTH ) ;
                        if ( i < 0 )
                                log(LOG_ERR,"Cannot create directory %s\n",workdir);
                        if ( i == 0 )
                                log(LOG_ERR,"Created directory %s\n",workdir);
			umask(omask); 
                 }
        }
        else if ( !S_ISDIR(statbuf.st_mode) ) {
                log(LOG_ERR,"%s should be a directory !\n",workdir);
        }

	/*
	 * Going to the rtcopy directory.
	 */
	if ( chdir(workdir) == -1 ) {	
		log(LOG_ERR,"chdir(%s): %s\n",workdir,sys_errlist[errno]) ; 
		clientlog(sock,"chdir(%s): %s\n",workdir,sys_errlist[errno]) ; 
		answerreq(sock,SYERR) ; 
		return ;
	}

	/*
	 * Setting File Creation Mode Mask.
	 */
	(void) umask(mask) ;

	/*
	 * Executing the request.
	 * Sending back the return code to the client.
	 */
	answerreq(sock, execreq(sock,command,&ptr,clienthost) ) ;  
}

/*
 * Return an answer to client who performed a 
 * RQST_INFO request.
 */
static void sendinfo(sock,ok,queue,numb) 
	int  sock ; 
	int    ok ; 
	int queue ;
	int  numb ;
{
	char info[7*LONGSIZE] ; 
	char            * ptr ; 

	ptr= info ; 
	marshall_LONG(ptr,(bet ? RTCOPY_MAGIC: RTCOPY_MAGIC_OLD) ) ; 
	marshall_LONG(ptr,GIVE_INFO) ; 
	marshall_LONG(ptr,3*LONGSIZE) ; 
	marshall_LONG(ptr,ok) ; 
	marshall_LONG(ptr,queue) ; 
	marshall_LONG(ptr,numb);
	switch( netwrite(sock,info,6*LONGSIZE) ) {
		case -1:
			log(LOG_ERR,"netwrite(): %s\n",sys_errlist[errno]) ;
			return  ;
		case  0:
			serrno= SECONNDROP ;
			log(LOG_ERR,"netwrite(): %s\n",sstrerror(serrno)) ;
			return ;
	}
	return ; 
}

/*
 * Process a RQST_INFO request.
 * Check client authorization,
 * Check if the no more tape flag is on,
 * Check the queue status.
 */
static void getinfo(sock,clienthost)
	int 	     sock ; 
	char * clienthost ;
{
	char   * ptr ;		/* Pointer on buffer				*/
	char  * name ;		/* Client login name				*/ 
	char to[15]  ; 		/* To map client possibly 			*/
	char * devgp ;		/* Device group					*/
	int    queue ;		/* Queue length of the system			*/
	char 	    call[256] ; /* To get the queue length of the tape server	*/
	struct stat   statbuf ; /* To perform a stat() call			*/
	int authorized=0      ;
        int compar   	      ; 	
	char clas[26] 	      ;
        FILE *   fs           ; /* stream for configuration file                */
	FILE *fspopen 	      ; /* file stream for popen() call			*/
        char buf[MAXHOSTNAMELEN] ; /* Buffer to contain host names              */
	time_t cl	      ; /* To read time					*/
	int	          num ;	/* Number of tape cartriges                     */
	int 		    n ;	/* Number of bytes returned by command call 	*/
	char               *p ;
	char nmtperdev[64] ;
	char devtype[10] ;
	int itry;
#if defined(CRAY) 
	struct udb   * userdb ; /* Pointer to udb data structure		*/
	int		    i ; /* Loop Counter					*/
#endif	/* CRAY */
#ifdef SOLARIS
	struct sigaction sa;
	sigset_t sa_mask;
#endif
#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined(_AIX)
        struct sigvec   sv;
#endif /* sun || ultrix || _AIX */
	struct passwd *client ;	/* Pointer to password data structure		*/
	extern char * getconfent() ;
	extern int 	get_user() ;

	ptr= buffer ;
	unmarshall_STRING(ptr,name) ; 
	unmarshall_WORD(ptr, uid) ;	
	unmarshall_WORD(ptr, gid) ;	
	unmarshall_STRING(ptr,devgp) ; 

	strcpy(devtype,devgp) ;
	(void) time (&cl);
        strcpy(clas,ctime(&cl) );
        clas[strlen(clas) -1 ]='\0';
                /* The user is out of site */

        if (isoutofsite) {
                int rcd;
		char username[MAXHOSTNAMELEN];
		strcpy(username,name) ;

                rcd=get_user(clienthost,username,uid,gid,to,&new_uid,&new_gid);
                if ( abs(rcd) == 1 || rcd==-ENOENT ) {
                        log(LOG_INFO,"No mapping for %s (%d,%d) from %s: attempt rejected\n",username,uid,gid,clienthost);
			sendinfo(sock,NOTAUTH,0,0) ;
                        return ;
                }
                old_uid = uid ;
                old_gid = gid ;
                uid = new_uid ;
                gid = new_gid ;
		name=to;
        }


	/*
	 * Is the user authorized on that system ?
	 * Checking logname, uid and then gid.
	 */
	if ( uid < 100 ) {
	  	log(LOG_INFO,"info request by unauthorized user %s (%d,%d) from %s\n",name,uid,gid,clienthost) ; 
		sendinfo(sock,PERMDENIED,0,0) ;
		return ; 
	}
	if ( (client=getpwuid(uid))==NULL ) {
	  	log(LOG_INFO,"info request by unauthorized user %s (%d,%d) from %s\n",name,uid,gid,clienthost) ; 
		sendinfo(sock,UNKNOWNUID,0,0) ;
		return ; 
	}
	if ( strcmp(client->pw_name,name) ) {
	  	log(LOG_INFO,"info request by unauthorized user %s (%d,%d) from %s\n",name,uid,gid,clienthost) ; 
		sendinfo(sock,UIDMISMATCH,0,0) ;
		return ;
	}
#if defined(CRAY)
	if ( (userdb= getudbuid(uid)) == UDB_NULL ) {
		log(LOG_ERR,"info request aborted because of error in getudbuid(%d): %d\n",uid,udb_errno) ;
		sendinfo(sock,SYERROR,0,0) ;
		return ;
	}
	for(i= 0; i < MAXVIDS && userdb->ue_gids[i] != -1; i++) { 
		if ( userdb->ue_gids[i] == gid ) 
			break ;
	}
	if ( i == MAXVIDS || userdb->ue_gids[i] != gid ) {
	  	log(LOG_INFO,"info request by unauthorized user %s (%d,%d) from %s\n",name,uid,gid,clienthost) ; 
		sendinfo(sock,UNKNOWNGID,0,0) ;
		return ;
	}
#else
	if ( client->pw_gid != gid ) {
		struct group *gr ;
		char **cp ; 

		setgrent();
		while(gr= getgrent()) {
			if ( client->pw_gid == gr->gr_gid ) 
				continue ;
			for(cp= gr->gr_mem; cp && *cp; cp++)
				if ( ! strcmp(*cp,name) )
					break ; 
			if ( cp && *cp && !strcmp(*cp,name) ) 
				break ; 
		}
		endgrent();
		if ( (cp == NULL || *cp == NULL || strcmp(*cp,name)) &&
		    chk_newacct(client,gid) < 0  ) {
			log(LOG_INFO,"info request by unauthorized user %s (%d,%d) from %s\n",name,uid,gid,clienthost) ; 
			sendinfo(sock,UNKNOWNGID,0,0) ;
			return ;
		}
	}
#endif	/* CRAY */

	/*
 	 * Last authorization test: check if host is authorized
	 */
                authorized=0;
		if ( islocal ) {
                        log (LOG_INFO, "Local access for %s (%d,%d)\n",name,uid,gid);
                        authorized=1;
                }
		else {

                     if (  ( fs = fopen(AUTH_HOSTS, "r") ) == NULL ) {
                        log(LOG_ERR,"File %s does not exist. Any host is accepted\n",AUTH_HOSTS);
                        authorized=1;
                     }
                     else {
                        while( fscanf(fs, "%s%*[^\n]\n", buf) != EOF ) {
                                if( strncmp(buf, "#", 1) ){
                                        if ( !strcmp(buf,"any")) {
                                                authorized=1;
                                                log(LOG_INFO,"File %s is authorizing any host\n",AUTH_HOSTS);
						break ;
					}
                                        compar = strcmp(buf, clienthost );
                                        if (  compar ==0 ) {
                                                authorized=1;
						break ;
                                        }
					strcat (buf,".") ;
					strcat (buf, DOMAINNAME) ;
					compar = strcmp(buf, clienthost );
					if (  compar ==0 ) {
						authorized=1;
						break ;
					}
                                }
                        }
                        fclose(fs);
                     }
		}

	if (!authorized) {
		 log(LOG_INFO,"info request by user %s (%d,%d) from unauthorized host %s\n", name, uid, gid,clienthost) ;
		 sendinfo(sock,HOSTNOTAUTH,0,0) ;
		 return;
	}

	/*
	 * Logging message for authorized user.
	 */
	log(LOG_DEBUG,"info request by user %s (%d,%d) from %s\n",name,uid,gid,clienthost) ; 

	/*
  	 * If tape software unavailable , send fixed info status.
	 */
        if ( (p=strtok(getconfent ("TPSERV","INFO", 0)," \t"))!= NULL && !strcmp(p,"NO") ) {
                sendinfo(sock,AVAILABLE,-1,1) ;
                return ;
        }

	/*
	 * Checking if operators still accept 
	 * requests.
	 */
	if ( stat(NOMORETAPES,&statbuf) == 0 ) {
		log(LOG_INFO," tape service momentarily interrupted.\n");
		sendinfo(sock,NOTAVAIL,0,0) ;
		return ; 
	}
	sprintf(nmtperdev,"%s-%s",NOMORETAPES,( strcmp(devtype,"CT1") ? devtype : "CART" ));
	if ( stat(nmtperdev,&statbuf) == 0 ) {
		log(LOG_INFO," tape service momentarily interrupted for %s.\n",(strcmp(devtype,"CT1") ? devtype : "CART" ));
		sendinfo(sock,NOTAVAIL,0,0) ;
		return ;
	}

	/*
	 * Getting queues
	 */
#ifdef SOLARIS
                memset(&sa,'\0',sizeof(sa));
                sigemptyset(&sa_mask);
                sigaddset(&sa_mask,SIGCHLD);
                sa.sa_mask = sa_mask;
                sa.sa_handler = SIG_DFL;
                sigaction(SIGCHLD,&sa,NULL);
#endif

#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined(_AIX)
#if (defined(sun) && !defined(SOLARIS))
                sv.sv_mask = sigmask(SIGCHLD)|sigmask(SIGALRM);
#else
                sv.sv_mask = sigmask(SIGCHLD);
#endif
                sv.sv_handler = SIG_DFL;
                sigvec(SIGCHLD, &sv, (struct sigvec *)0);
#endif /* sun || ultrix || _AIX */
#if defined(sgi) || defined (hpux)
		signal(SIGCLD, SIG_DFL) ;
#endif /* sgi || hpux */

#if defined(CRAY)
	(void) sprintf(call,
"/etc/tpgstat|grep %s|cut -c19-|awk '{if(NR==1)if($2==0)print \"NO\";else { q=$3-$2;num=$2} }/\\*/{q++}END{print q\" \"num}'",
	( strcmp(devgp,"CT1")) ? devgp : "CART" ) ;  
#else
	(void) sprintf(call,
"%s/tprstat|grep %s|cut -c16-|awk '{if(NR==1)if($2==0)print \"NO\";else {q=$3-$2+$4;num=$2} }END{print q\" \"num}'",
	BIN,
	( strcmp(devgp,"CT1")) ? devgp : "CART" ) ;  
#endif	/* CRAY */
	itry=0;
tryagain:
	fspopen = popen(call,"r");
	if (fspopen == NULL) {
		log(LOG_ERR,"info request: error in popen(): %d\n",errno) ;
		sendinfo(sock,SYERROR,0,0) ;
		return ;
	}
	if ( (n=fread (call,1,10,fspopen)) >0 ) {
		pclose(fspopen) ;
		call[n]='\0' ;
		if ( ! strncmp(call,"NO",2) ) {
			log(LOG_INFO," tape service momentarily interrupted.\n");
			sendinfo(sock,ALLDOWN,0,0) ;
		}
		else if ( strcspn(call," \n") == 0 ){
			if (!itry && (!strcmp(devgp,"CT1") || 
				   !strcmp(devgp,"CART"))) {
#if defined(CRAY)
			  (void) sprintf(call,
"/etc/tpgstat|grep CT2|cut -c19-|awk '{if(NR==1)if($2==0)print \"NO\";else { q=$3-$2;num=$2} }/\\*/{q++}END{print q\" \"num}'");
#else
			  (void) sprintf(call,
"%s/tprstat|grep CT2 |cut -c16-|awk '{if(NR==1)if($2==0)print \"NO\";else {q=$3-$2+$4;num=$2} }END{print q\" \"num}'",
					 BIN);
#endif	/* CRAY */
			  itry++;
			  goto tryagain;
			}
                        log(LOG_INFO," The service for %s does not exist.\n",( strcmp(devgp,"CT1") ? devgp : "CART" ));
                        sendinfo(sock,ALLDOWN,0,0) ;
                }
		else if ( sscanf(call,"%d %d",&queue,&num) ) {
			sendinfo(sock,AVAILABLE,queue,num) ;
		}
		else {
			log(LOG_INFO,"Server was unable to compute or to send us its status.\n");
			sendinfo(sock,SYERROR,0,0) ;
		}
	}
	else {
		log(LOG_INFO,"Command tprstat did not return info\n");
		sendinfo(sock,SYERROR,0,0) ;
	}
}
 
/*
 * One occurence of this function is created for 
 * each client connecting the server.
 */
static void doit(sock,from)
	int                  sock ;	/* Connected socket		*/
	struct sockaddr_in  *from ;     /* Client socket address	*/
{
	struct hostent 	     * hp ; 	/* Client host structure	*/
	char 		*client   ;	/* Client host name		*/
	char localhost[MAXHOSTNAMELEN];

	/*
	 * Getting client host name.
	 */
	hp= gethostbyaddr((char *)(&from->sin_addr),sizeof(struct in_addr),from->sin_family) ;
	if ( hp == NULL ) 
		client= inet_ntoa(from->sin_addr) ; 
	else
		client= hp->h_name ;
	strcpy(clienthost,client)  ;

         /*
          * Getting hostname.
          */
         if (gethostname(localhost,MAXHOSTNAMELEN))   {
                        log(LOG_ERR,"gethostname(): %s\n",sys_errlist[errno]);
                        return ;
         }

        if (    !strcmp(clienthost, localhost)  ||
                ( !strncmp(clienthost,localhost,strlen(localhost)) &&
                  clienthost[strlen(localhost)]=='.' ) ) {
                islocal = 1 ;
        }

	/*
	 * Is this host out of site ?
	 */
	isoutofsite= isremote(from->sin_addr,clienthost);
	
	/*
	 * Reading, and processing the request.
	 */
	switch( rcvmsg(sock) ) {
		case -1:
			break ; 
		case SEBADVERSION:
                	log(LOG_ERR,"Attempt to connect with bad magic from another site (%s)\n",clienthost);
			break ;
		case RQST_TPDK:
			if ( sendackn(sock,RQST_TPDK) == -1 ) 
				break ;  
			dortcopy(sock,clienthost,cptpdsk) ;
			break ; 
		case RQST_DKTP:
			if ( sendackn(sock,RQST_DKTP) == -1 ) 
				break ;  
			dortcopy(sock,clienthost,cpdsktp) ;
			break ; 
		case RQST_INFO:
			getinfo(sock,clienthost) ; 
			break ; 
		case RQST_DPTP:
                        if ( sendackn(sock,RQST_DPTP) == -1 )
                                break ;
                        dortcopy(sock,clienthost, tpdump) ;
                        break ;
		default:
			log(LOG_ERR,"unknown request type\n") ; 
	}
	(void) shutdown(sock,2) ; 
}

#if defined(sun) || defined(SOLARIS) || defined(ultrix) || defined(_AIX) || defined(hpux)
/*
 * Used only on standalone mode,
 * to avoid the creation of zombies.
 */
#ifndef WTERMSIG
#define WTERMSIG(x)     (((union wait *)&(x))->w_termsig)
#endif 
#ifndef WSTOPSIG
#define WSTOPSIG(x)     (((union wait *)&(x))->w_stopsig)
#endif
static void reaper(sig)
int sig;
{
#if !defined(_AIX) && !defined(hpux) && !defined(SOLARIS)
	union wait      status;
#else
      	int             status ;
#endif

	int             pid;

	for (;;) {
		pid = wait3(&status, WNOHANG, (struct rusage *)0);
		if (pid <=0)   
	 		break;
		log(LOG_DEBUG," %d reaped\n", pid);
		if (WIFSIGNALED(status))  
			log(LOG_ERR, "%d signaled by signal %d\n",pid, WTERMSIG(status));
		if (WIFSTOPPED(status))   
			log(LOG_ERR, "%d stopped by signal %d\n",pid, WSTOPSIG(status));
	}
}
#endif /* sun || ultrix || _AIX */

/*
 * Body of the Remote Tape Copy Daemon.
 */
main (argc,argv)
	int     argc;
	char    **argv;
{
	register int        option ;		/* To parse options	*/
	extern   int        opterr ; 		/* required by getopt(3)*/
	extern   int  	    optind ;	        /* required by getopt(3)*/
	extern   char     * optarg ;            /* required by getopt(3)*/
	int 	rcode ;
        char     clas[26] ; /* clock value in ascii format */
        time_t cl         ;


	/*
	 * 	Getting options.
	 */
	logf=0 ;
	while ((option = getopt(argc,argv,"sdlp:f:")) != EOF)        {
		switch (option) {
			case 'd': debug++;
				loglevel= LOG_DEBUG ; 
				break;
			case 's': standalone++;
				break;
			case 'l':
				logging++;
				break;
			case 'p':
				port=atoi(optarg);
				break;
			case 'f':
				strcpy(userlogfile,optarg);
				logf ++ ;
				break ;
				
		}
	}
	/*
	 * The Daemon is running in Stand Alone.
	 */
	if (standalone) {
		struct sockaddr_in 		sin ;	/* Internet address	*/
		int			       sock ;	/* Socket 		*/
		struct servent          	*sp ;	/* Server Entity	*/
		char      localhost[MAXHOSTNAMELEN] ;   /* Local host name      */
#ifdef SOLARIS
		struct sigaction sa;
		sigset_t sa_mask;
#endif
#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined( _AIX) || defined (hpux)
		struct sigvec   sv;		/* For interrupt handler	*/
		struct sigvec   ovec;		/* For interrupt handler	*/
#endif	/* sun || ultrix || _AIX*/

		/*
		 * Disassociate controlling terminal
		 * if not in debug mode.
 		 */
		if (!debug) {
			int i ; 

#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix)
			for (i = getdtablesize()-1; i>0 ; --i)  
				(void) close(i);
			(void) open("/dev/null", O_RDONLY);
			(void) dup2(0,1);
			(void) dup2(0,2);
			i = open("/dev/tty", O_RDWR);
			if (i>0) {
				(void) ioctl(i, TIOCNOTTY, 0);
				(void) close(i);
			}
#else 	/* CRAY || sgi || _AIX || hpux || SOLARIS */
			switch(fork()) {
				case -1:
					perror("Initial fork()") ; 	
					exit(1);
				case  0:
#if HPUX10
					(void) setpgrp3();
#else
					(void) setpgrp();
#endif
#ifndef linux
					for (i=0;i< _NFILE;i++) 
#else
					for (i = getdtablesize()-1; i>0 ; --i)  
#endif
						(void) close(i) ;
					break ; 
				default:
					exit(0) ;
			}
#endif /* sun || ultrix */
		}

		/*
		 * Starting LOG
		 */
		if ( logf && !strcmp(userlogfile,"stderr") )
			userlogfile[0]='\0' ;
		(void) initlog("rtcopyd", loglevel, (logf ?userlogfile:logfile) ) ;
			

		log(LOG_INFO,"remote tape copy daemon starting ...\n") ; 

		/*
		 * Setting interrupt handlers.
		 * To avoid zombie creations.
		 */
#ifdef SOLARIS
		memset(&sa,'\0',sizeof(sa));
		sigemptyset(&sa_mask);
		sigaddset(&sa_mask,SIGCHLD);
		sigaddset(&sa_mask,SIGHUP);
		sigaddset(&sa_mask,SIGALRM);
		sa.sa_mask = sa_mask;
		sa.sa_handler = (void (*)(int))reaper;
		sigaction(SIGCHLD,&sa,NULL);
#endif
#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined(_AIX) || defined(hpux) 
		sv.sv_mask = sigmask(SIGCHLD)|sigmask(SIGHUP)|sigmask(SIGALRM);
		sv.sv_handler = reaper;
#if !defined(hpux)
		(void) sigvec(SIGCHLD, &sv, (struct sigvec *)0);
#else
		(void) sigvector(SIGCHLD, &sv, (struct sigvec *)&ovec);
#endif
#endif
#if defined(CRAY) || defined(hpux)
		if ( signal(SIGCLD,SIG_IGN) == SIG_ERR ) {
			log(LOG_ERR,"signal(SIGCLD,SIG_IGN): %s\n",sys_errlist[errno]); 
			exit(1) ; 
		}
#endif	

/* Disabling SIGPIPE signal
 */
#if defined(CRAY)
                sigignore(SIGPIPE);
#endif
#if defined(apollo) || defined (hpux) ||  defined (sgi) || ( defined (ultrix) && defined(mips) )
                (void) signal(SIGPIPE, SIG_IGN);
#endif
#if defined(_AIX) || defined(sun)
		(void)signal(SIGPIPE,(void (*)())SIGPIPE_hand);
#endif /* _AIX || sun */

		/*
		 * Getting hostname.
		 */
		if (gethostname(localhost,sizeof(localhost)))   {
			log(LOG_ERR,"gethostname(): %s\n",sys_errlist[errno]);
			exit(1);
		}

		/*
		 * Creating socket.
		 */
		if ((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0)  {
			log(LOG_ERR,"socket(): %s\n",sys_errlist[errno]);
			exit(1);
		}
		rcode = 1 ;
		if (setsockopt(sock, SOL_SOCKET, SO_KEEPALIVE,(char *)&rcode, sizeof (int) ) == -1) 
			log(LOG_ERR,"setsockopt(SO_KEEPALIVE) failed");
		
		/*
		 * Finding port number.
		 */
		if (!port) {
			sp = getservbyname("rtcopy", "tcp");
			if (sp == NULL) {
				serrno = SENOSSERV;
				log(LOG_ERR,"getservbyname(): %s\n",sstrerror(serrno)) ;
				exit(1);
			}
			sin.sin_port = sp->s_port;
		}
		else    {
			sin.sin_port = htons((u_short)port);
		}

		/*
		 * Binding socket.
		 */
		sin.sin_addr.s_addr = htonl(INADDR_ANY);
		sin.sin_family = AF_INET;
		if (bind(sock, (struct sockaddr *)&sin, sizeof(sin)) < 0) {
			log(LOG_ERR, "bind(): %s\n",sys_errlist[errno]);
			exit(1);
		}

		/*
		 * Listening on socket.
		 */
		if ( listen(sock, 5) == -1 ) {
			log(LOG_ERR, "listen(): %s\n",sys_errlist[errno]);
			exit(1);
		}

		for (;;) {
			int 		    nsock ;
			struct sockaddr_in   from ; 
			int fromlen= sizeof(from) ;

			/*
			 * Accepting request.
			 */
			nsock = accept(sock, (struct sockaddr *)&from, &fromlen);
			if (nsock < 0) {
				if (errno != EINTR) {
					log(LOG_ERR,"accept(): %s\n",sys_errlist[errno]);
					exit(1);
				}
				continue;
			}

			/*
			 * Checking network
			 */
			if ( setnetio(nsock) == -1 ) {
				(void) close(nsock) ; 
				log(LOG_ERR,"error in setnetio()\n") ; 
				continue ;
			}

			if (getpeername(nsock,(struct sockaddr *)&from, &fromlen)<0) {
				log(LOG_ERR, "getpeername: %s\n",sys_errlist[errno]);
				(void) close(nsock) ; 
				continue ; 
			}

			switch (fork()) { 
				case -1:
				  {     int save_errno = errno;
					log(LOG_ERR,"fork(): %s \n",sys_errlist[save_errno]);
					(void) time (&cl);
        				strcpy(clas,ctime(&cl) );
        				clas[strlen(clas) -1 ]='\0';
					printerr("%s [%d]: fork() failed: %s\n",clas,getpid(),sys_errlist[save_errno] ) ;
					(void) close(nsock);
					exit(1);
				  }
				case 0:           
					(void) close(sock);
					doit(nsock, &from);
					exit(0) ;
					break;
				default:
					(void) close(nsock) ; 
			}
		}
	}

	/*
	 * The Daemon is started by INETD.
	 */
	else {      
		struct sockaddr_in   from ; 
		int fromlen= sizeof(from) ;

#if defined(_AIX) || defined(sun)
		(void)signal(SIGPIPE,(void (*)())SIGPIPE_hand);
#endif
		/* 
		 * Initializing log file.
		 */
		(void) initlog("rtcopyd", loglevel, logfile ) ;

		/*
		 * Checking network
		 */
		if ( setnetio(0) == -1 ) {
			log(LOG_ERR,"error in setnetio()\n") ; 
			exit(0) ;
		}

		if (getpeername(0,(struct sockaddr *)&from, &fromlen)<0) {
			log(LOG_ERR, "getpeername: %s\n",sys_errlist[errno]);
			exit(1);
		}
		/*
		 * SETTING KEEPALIVE
 		 */
#if defined(_AIX) || defined(sun)
		if (setsockopt(0, SOL_SOCKET, SO_KEEPALIVE,(char *)&rcode, sizeof (int) ) == -1) 
			log(LOG_ERR,"setsockopt(SO_KEEPALIVE) failed");
 
#endif /* _AIX || sun */
#if defined(_AIX) && defined(_IBMESA)
		if ( setluid (0) == -1 ) {
			log(LOG_ERR, "setluid: %s\n",sys_errlist[errno]);
			exit(1);
		}
#endif
		doit(0, &from);
		exit(0) ;
	}

}

/*
 * Filter to select between messages coming from client pipe
 */
filter(res)
char *res;
{
	time_t cl;
	char clas[26];
	char *p, *q;
	static char savebuf[1024];
	static int saveflag = 0;

        (void) time(&cl);
        strcpy(clas, ctime(&cl));
	clas[ strlen(clas) -1 ]='\0';

	p = res;
	if (saveflag) {
		q = strchr(res, '\n');
		if (! q) {	/* line is still incomplete */
			(void) strcat(savebuf, p);
			return;
		}
		*q = '\0';
		(void) strcat(savebuf, p);
		if (CPtest(savebuf))
			printerr("%s [%d]: %s\n", clas, getpid(), savebuf);
		saveflag = 0;
		*q = '\n';
		p = q + 1;
	}
	while (q = strchr(p, '\n')) {
		*q = '\0';
		if (CPtest(p))
			printerr("%s [%d]: %s\n", clas, getpid(), p);
		*q = '\n';
		p = q + 1;
	}
	if (strlen(p)) {	/* save incomplete line */
		strcpy(savebuf, p);
		saveflag = 1;
	}
}

/*
 * Returns 1 if message is an error
 */
int CPtest(s)
char *s;
{
 return  ( (strncmp(s," CP",3) && strcmp(s,"")) || (s[9]=='!') ? 1:0 );
}

  /*
   * Opening file to preserve carbon copy of messages sent to user
   */
#if !defined(IRIX5)
static void printerr(va_alist)
va_dcl
#else
static void printerr( char * format , ...)
#endif /* IRIX5 */
{
 va_list args;
#if !defined(IRIX5)
 char *format;
#endif /* IRIX5 */
 FILE *msglog;

 if ( (msglog=fopen(MSGLOG,"a") ) == NULL )
             log(LOG_ERR,"Warning :Unable to open file %s\n",MSGLOG);
 else {

#if !defined(IRIX5)
        va_start(args);
        format = va_arg(args,char*);
#else
        va_start(args, format) ;
#endif /* IRIX5 */
        vfprintf(msglog,format,args);
        va_end(args);
        fclose(msglog);
 }
}

