/*
 * @(#)rtcopy.h	2.21 11/03/99 CERN CN-SW/DC   Antoine Trannoy 
 */

/*
 * Copyright (C) 1990-1994 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef __RTCOPY_H__
#define __RTCOPY_H__

/* Maximum file size (tape and disk) */
#define MAXFILESZ 2147483647

typedef struct {
  unsigned long from_host;
  unsigned long to_tape;
  unsigned long from_tape;
  unsigned long to_host;
} COMPRESSION_STATS;


/*
 * Key number for communication with rtcopy daemon
 */
#define RTCOPY_MAGIC_OLD	0x0666	
#define RTCOPY_MAGIC		0x0667	
#define RFIO2TPREAD_MAGIC 0X0110
#define MAXLINELEN 1024  /* The length the logged command line cannot exceed */

/*
 * Possible requests, and acknowledgment to rtcopy daemon.
 */
#define RQST_TPDK	0x1001
#define ACKN_TPDK	0x2001

#define RQST_DKTP	0x1002
#define ACKN_DKTP	0x2002

#define RQST_PING	0x1003
#define ACKN_PING	0x2003

#define RQST_INFO	0x1004
#define GIVE_INFO	0x2004

#define GIVE_RESU	0x1005

#define GIVE_OUTP	0x1006

#define RQST_ABORT	0x1007
#define ACKN_ABORT	0x2007
#define SYCONFLIM	20000 /* Buffer length limit */

#define RQST_DPTP       0x1008
#define ACKN_DPTP       0x2008


/*
 * Different possible answers 
 * to RQST_INFO.
 */
#define	IMPOSSIBLE		-3
#define CONNECTING		-2
#define SENDING 		-1	
#define SYERROR			 1
#define NOTAUTH			 2
#define ALLDOWN			 3
#define NOTAVAIL		 4
#define AVAILABLE		 5
#define	PERMDENIED		 6
#define	UNKNOWNUID		 7
#define UNKNOWNGID		 8
#define	UIDMISMATCH		 9
#define HOSTNOTAUTH		 10
#define HOSTMAINT		 11
#define MUTEINFO		 12
#define HOSTNOTSUIT		 13

/*
 * Constants needed on the client side.
 */
#define RTCOPY_RETRY_INTERVAL	 300
#define RTCOPY_RETRY_COUNT	   1
#define PING_TIMEOUT		  60
#define RTCOPY_TIMEOUT		3600

/*
 * Error responsability
 */
#define USERR	1	/* User 			*/
#define SYERR   2       /* System                       */
#define UNERR   3       /* Undefined                    */
#define SEERR   4       /* Internal                     */

/*
 *  Error responsability when -E option is invoked
 */
#define ETMUSR  205     /* too many tape users */
#define RSLCT	222	/* Reselect requested  */
#define BLKSKPD 193	/* A skip occured  and request was sucessful */
#define TPE_LSZ 194	/* A skip occured and data sent is limited by -s */
#define MNYPARY	195	/* Request failed though  skip was attempted */
/* 
 * Retry codes ( numbers appearing in shift.conf )
 */
#define SYRETRY 5       /* Error that requires retry    */
#define SYRETRYD 6      /* Error requiring demount + retry */
#define SYRETRYMORE 7   /* Error requiring a lot of retries */
#define SYRETRYUSERR 51 /* Error as for SYRETRY but exit code USERR */
#define SYRETRYPARITY 52 /* Error of parity, exit code MNYPARY */

/*
 * Flags for recovery on error
 */
#define NEXTREC -10
#define SKIP_ON_ERR 1
#define SET_EFLAG 2	/* Indicates wether -E was specified in tpio.c*/
#define MAXNBSKIPS 10

#define LIMBYSZ 197 	/* Status when limited by -s option value */

#include "rtcopyerr.h"
#endif
