/*
 * Copyright (C) 1995-1996 by CERN/CN/PDP/CS
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)dumptape.c	1.7 05/06/98 CERN CN-PDP/CS, E. Saclier d'Arquian, F. Hassine";
#endif /* not lint */

/* 
 * dumptape.c             SHIFT remote tape dump client command.
 */

#include <stdio.h>
#include <malloc.h>
#if ! defined(apollo) 
#include <unistd.h>
#endif 	/* ! apollo */
#include "rtcopy.h"

#include <sys/types.h>
#include <sys/time.h>
#include <sys/param.h>

#if defined(apollo)
#include <strings.h>
#else
#include <string.h>
#endif	/* apollo */

#include <pwd.h>
#if defined(_AIX) && defined(_IBMR2)
#include <sys/select.h>
#endif /* _AIX */
#if defined(SOLARIS)
#include <sys/filio.h>
#endif

/*
 * Process handling.
 */
#include <signal.h>		/* Signal handling	*/

#if defined(apollo)
#define SIG_ERR (void(*)())-1
#endif  /* apollo */

/*
 * Networking.
 */
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <marshall.h>

/*
 * TRACE specification
 */
#include <trace.h>

extern int (*recvfunc)() ;
extern int (*sendfunc)() ;
extern int setnetio() ;
#define netread         (*recvfunc)
#define netwrite        (*sendfunc)
#define MAXFILENAMSIZE 1024

/*
 * Error and message handling
 */
#include <errno.h>
#include <log.h>

#ifndef linux
extern char *sys_errlist[] ;
#endif /* linux */
extern int errno ;

/*
 * Variable errfault is used to known
 * in the main() function who is responsible
 * for the error. It can take the following
 * values: USERR, SYERR, UNERR, SEERR.
 */
extern int errfault ;

/*
 * Buffer used to build, send and receive
 * the messages.
 */
extern char *getbuffer() ;

/*
 * For option info
 */
extern int alg_info ; 		/* variable used only by tpread.c but needs to be */
		   	  	/* declared since tpclient.c has it as an extern */
extern int istpselect ;
extern int isout ; 		/* Is request for an out of site server ? */
extern int nfile ;         	/* Number of disk files */

extern int ABORT ;
extern void actionSIGINT() ;	/* SIGINT interrupt  handler */
extern int rcvmsg() ;		/* Receive message in buffer. return -1 if 
				   error, RQST ot ACKN otherwise */
extern int ping() ; 		/* Sending a PING. If error close socket */
extern void sendabort() ; 	/* Sending abort request to the server */
extern int sendreq() ;		/* Sending request */

char * command ; 		/* Name of the command */

/*
 * Finding out the type of device needed if specified. 
 */
int getdevtyp(argc,argv,device,host)
	int    	 argc ;
	char  ** argv ; 
	char * device ;
	char *   host ; 
{
	extern char   * optarg ; 	
	extern int      optind ; 
	int 		     c ;
	char filename[MAXFILENAMSIZE] ;
	char 	       fopt[5] ;
	char   tms_device[10] ; /* device selected by tms */
	int		    i ; 
        char            *uvid = NULL ;
        char            *cp   ;
        char        buff[100] ;
#if defined (TMS)
        char          req[80] ; /* Request command      */
        int            reqlen ; /* Request length       */
        char        info[132] ; /* Info buffer          */
        int           infolen ; /* Info length          */
        extern int   sysreq() ; /* External declaration */
        extern char *  getconfent() ;
	char 	      *server ;
        char 	     *ptr[10] ;
        int 	n ,rcode ,ok=0;
        int 	 RETRY, SLEEP ;
#endif

	/*
	 * Initialization
	 */
	optind= 1 ; 
	*device = '\0' ;
	*host= '\0' ; 
	*fopt= '\0' ;
	*tms_device = '\0' ;

	/*
	 * Parsing options to eventually 
	 * get device type needed.
	 */
	while((c= getopt(argc,argv,"B:b:C:d:E:F:g:IN:S:V:x")) != EOF) {
		switch(c) {
                        case 'S':
                                (void) strcpy(host,optarg) ;
                                break ;
		        case 'V':
                                uvid = (char *) malloc(strlen(optarg)+1
) ;
                                (void) strcpy(uvid,optarg) ;
				break ;
                        case 'g':
                                (void) strcpy(device,optarg) ;
                                break ;
			case 'x':
				(void) initlog(command,LOG_DEBUG,"") ;
				break ;
			case 'I':
				alg_info++ ;
				break ;
			case 'C':
				if ( strcmp (optarg,"ebcdic") && strcmp(optarg,"ascii") ) {
					log(LOG_INFO,"C option must be ebcdic or ascii\n") ;
					exit (USERR);
				}
				break ;
			case 'E':
			case 'F':
			case 'B':
			case 'N':
			case 'b':
			case 'd':
				break ;
			default:
				log(LOG_ERR,"! '%c' is not a valid option\n",c) ; 
				errfault= USERR ;
				return -1 ; 
		}
	}

	if (argc - optind > 0) {
		log(LOG_ERR,"Command line error.\n");
		errfault= USERR ;
		return -1 ;
	}

        /*
         * vid has to be specified.
         */
        if ( uvid == NULL && !alg_info ) {
                log(LOG_ERR,"! vid must be specified\n") ;
                errfault= USERR ;
                return -1 ;
        }


#if defined(TMS)
      
	if (!isout && !alg_info ) {
                /*
                 * If TMS is installed, the device
                 * type of the tape is retrieved.
                 */

                strcpy(buff,uvid) ;

                for (cp = strtok(buff,":"),i=0 ; cp!= NULL ; i++ ,cp=strtok(NULL,":")) {
                        ptr[i] = (char *)malloc(20) ;
                        strcpy(ptr[i], cp);
                }
                for (n=0;n<i;n++) {
                        (void) sprintf(req,"QVOL %s (GENERIC SHIFT MESSAGE",ptr[n]) ;
                        reqlen= strlen(req) ;
                        infolen= 132 ;
                        ok = 0 ;
                        while (!ok) {
                           infolen= 132 ;
                           rcode = sysreq("TMS",req,&reqlen,info,&infolen) ;
                           switch ( rcode ) {
                                case 0 :
                                        cp= strchr(info+25,' ') ;
                                        if ( cp != NULL ) {
                                                * cp = '\0' ;
                                                (void) strcpy(tms_device,info+25) ;
                                        }
                                        ok ++ ;
                                        break ;
                                case 8 :
                                        log(LOG_ERR,"! volume ID %s has wrong syntax\n",ptr[n]) ;
                                        errfault= USERR ;
                                        return -1 ;
                                        break ;
                                case 100 :
                                        log(LOG_ERR,"! volume ID %s does not exist\n",ptr[n]) ;
                                        errfault= USERR ;
                                        return -1 ;
                                        break ;
                                case 312 :
                                        log(LOG_ERR,"! volume ID %s is unavailable\n",ptr[n]);
                                        errfault= USERR ;
                                        return -1 ;
                                        break ;
                                case 313 :
                                        log(LOG_ERR,"! tms: Unknown generic system SHIFT\n") ;
                                        errfault= USERR ;
                                        return -1 ;
                                        break ;
                                case 314 :
                                        log(LOG_ERR,"! tms: Unknown system\n");
                                        errfault= USERR ;
                                        return -1 ;
                                        break ;
                                case 315 :
                                        log(LOG_ERR,"! Volume %s unmountable\n",ptr[n]) ;
                                        errfault= USERR ;
                                        return -1 ;
                                        break ;
                                default :
                                        if (rcode <0) {
						sperror("TMS NOT RESPONDING");
						rcode = -rcode ;
					}
					if ( (int)strlen(info) >0 ) fprintf(stderr,"%s\n", info) ;
					
                                        log(LOG_ERR,"will retry in a while...\n");
                                        RETRY= ( (cp = getconfent("RTCOPY","RETRY",0)) ==NULL ) ? 0 : atoi(cp) ;
                                        SLEEP= ( (cp = getconfent("RTCOPY","SLEEP",0)) ==NULL ) ? 0 : atoi(cp) ;
                                        if ( RETRY == 0 || SLEEP == 0 ) {
                                                RETRY= 0 ;
                                                SLEEP= 0 ;
                                        }
                                        sleep(SLEEP) ;
                                        break ;
                        } /* switch */
                 } /* while */
           } /* for */
        } /* !isout && !alg_info */

#endif  /* TMS  */

	/*
	 * Freeing buffers
	 */
	if (uvid != NULL ) (void) free(uvid) ;

	if ( *device == '\0' || *tms_device != '\0') {
		if ( *device == '\0' && *tms_device == '\0') {
			/*
		 	 * The device type is still unknown.
			 * By default it is set to CART.
			 */
			(void) strcpy(device,"CART") ;			
		}
		else {
			if ( *device == '\0' && *tms_device != '\0') 
				(void) strcpy(device,tms_device);
	     		else if ( tms_device != '\0' ) {
				if ( !strcmp(tms_device,"CT1") ) {
					(void) strcpy(tms_device,"CART");
				}
				if ( !strcmp(device,"CT1") ) {
					(void) strcpy(device,"CART");
				}
				if ( strcmp(tms_device,device) ) {
					log(LOG_ERR,"! Confusion: %s (user) <--> %s (tms data)\n",device,tms_device);
					errfault= USERR ;
                       			return -1 ;
                		}
	     		}
		}
    	}
	return 0 ; 
}

/*
 * Select a server.
 * Depending on the type of device requested,
 * and the queue of the different servers.
 *
 * Connection with the different tape servers are asynchronous
 * except when running on apollo where I did not manage to make it work.
 */
extern int selectserver() ;

/*
 * dumptape()
 */
main(argc,argv)
	int     argc ; 
	char ** argv ; 
{
	char * getconfent() ;	/* External declaration	*/
	char 	   host[64] ;	/* Tape server hostname	*/
	int	       sock ; 	/* Socket Identifier	*/
	int	    	  i ; 	/* Loop index		*/
	char 	      * ptr ; 	/* Char pointer		*/
	int 	      RETRY ; 	/* Number of possible retries	*/
	int 	      SLEEP ; 	/* Interval between two retries	*/
	char buf[MAXFILENAMSIZE] ;
	int rfiosock ;		
	int checked ;		/* Do we expect more key checks ? 	  */
	u_short key_p ;		/* To get key number 			  */
	static char *argv1[64]; /* Store filenames after link were solved */

	INIT_TRACE("RFIO_TRACE");
	/*
	 * Stripping the command name from its full path name.
	 */
	if ( (command= strrchr(argv[0],'/')) == NULL ) 
		command= argv[0] ;
	else 
		command ++ ; 
	
	log(LOG_DEBUG,"command is %s\n", command);

	/*
	 * Starting LOG on stderr.
	 */
	(void) initlog(command,LOG_INFO,"") ;

restart:

	/*
	 * Selecting tape server.
	 */
	RETRY= ( (ptr= getconfent("RTCOPY","RETRY",0)) == NULL ) ? 0 : atoi(ptr) ;
	SLEEP= ( (ptr= getconfent("RTCOPY","SLEEP",0)) == NULL ) ? 0 : atoi(ptr) ;
	if ( RETRY == 0 || SLEEP == 0 ) {
		RETRY= 0 ; 
		SLEEP= 0 ; 
	}
	for(i= 0; i<= RETRY; i ++) {
		if ( i ) {
			log(LOG_INFO,"retry selection in a little while...\n") ; 
			sleep(SLEEP) ; 
		}
                if ( selectserver(argc,argv,host) == -1 ) {
                        if ( errfault || i == RETRY ) {
                                log(LOG_INFO,"command failed\n\n") ;
                                exit(errfault? errfault:SYERR) ;
                        }
                }
                else
                        break ;
        }
	

        /*
         * Only info has been requested
         */
        if (alg_info)
                exit(0);

	/*
	 * Setting SIGINTR interrupt handler.
	 * To catch ^C.
	 */
	if ( signal(SIGINT,( void (*) ()) actionSIGINT) == SIG_ERR ) {
		log(LOG_ERR,"! signal(SIGINT,actionINT): %s\n",sys_errlist[errno]) ; 
		log(LOG_INFO,"command failed\n\n") ; 
		exit(SYERR) ;
	}

	/*
	 * Connecting tape server.
	 */
	if ( (sock= connectserver(host)) == -1 ) {
		log(LOG_INFO,"command failed\n\n") ; 
		exit(errfault) ; 
	}

	/*
	 * Sending request.
	 */
	if ( sendreq(sock,argc,argv,&key_p ,&rfiosock) == -1 ) {
		log(LOG_INFO,"command failed\n\n") ; 
		exit(errfault) ; 
	}
	checked = 0 ;

	/*
	 * Waiting for answer.
	 */
	for(;;) {
		fd_set  rfds,wfds,efds ;	/* Set of file descriptor    */
		int 		 rcode ;	/* Used for return code	     */
		struct timeval     out ; 	/* To set time out in select */

		FD_ZERO(&rfds) ; 
		FD_ZERO(&wfds) ; 
		FD_ZERO(&efds) ; 
		FD_SET(sock,&rfds) ; 
                if ( isout && !checked )
                        FD_SET ( rfiosock, &rfds) ;

		out.tv_sec= RTCOPY_TIMEOUT ;
		out.tv_usec= 0 ; 
		/*
		 * Did a SIGINT occured ?
		 */
		if ( ABORT ) {
			sendabort(sock) ; 
			log(LOG_INFO,"command failed\n\n") ; 
			exit(USERR) ;
		}
		/*
		 * Waiting for an event.
		 */
		rcode= select(FD_SETSIZE,&rfds,&wfds,&efds,(struct timeval *)&out) ; 
		if ( rcode == -1 ) {
			if ( errno != EINTR) {
				log(LOG_ERR,"! select(): %s\n",sys_errlist[errno]) ; 
				log(LOG_INFO,"command failed\n\n") ; 
				(void) close(sock) ; 
				exit(SYERR) ;
			}
			else if ( ABORT ) {
				sendabort(sock) ; 
				log(LOG_INFO,"command failed\n\n") ; 
				exit(USERR) ;
			}
		}

		/*
		 * if there is no answer yet, a PING
		 * is sent to check the connection.
		 */
		if ( rcode == 0  &&  ping(sock) == -1 ) {
			log(LOG_INFO,"command failed\n\n") ; 
			exit(errfault) ;
		}
		
		/*
		 * Receiving answer.
		 */
		if ( FD_ISSET(sock,&rfds) ) {
		    switch(rcode= rcvmsg(sock)) {
			case -1:
				log(LOG_INFO,"Command failed\n\n") ; 
				log(LOG_DEBUG,"rcode = -1") ;
				exit(errfault) ;
			case ACKN_PING:
				break ; 
			case GIVE_OUTP:	
				/*
				 * WARNING !!!
				 * Valid  only on ASCII machine
				 * buffer is NOT UNMARSHALLed as it should be.
				 */
				(void) fprintf(stderr,"%s",getbuffer()) ;
				break ;
			case GIVE_RESU:
				ptr= getbuffer() ;
				unmarshall_LONG(ptr,rcode) ; 
				if (rcode == ETMUSR || rcode == RSLCT ) {
					(void) close(sock) ;
					log(LOG_INFO,"Re-selecting another tape server\n");
					sleep(SLEEP) ;
					goto restart;
				}
				log(LOG_INFO,"command %s\n\n",(rcode) ? "failed" : "successful") ; 
				exit(rcode) ; 
			default:
				log(LOG_ERR,"! internal error\n") ; 
				log(LOG_INFO,"command failed\n\n") ; 
				exit(SEERR) ; 
		    }
		}
	}
}
