/*
 * Copyright (C) 1990-1999 by CERN/IT/PDP/IP
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)dktotpF.c	2.43 11/10/99  F. Hassine";
#endif /* not lint */

/* dktotpF.c             SHIFT transferring data from remote disk to local tape in fixed format. */

#include <stdio.h>
#include <fcntl.h>
#include <malloc.h>
#include <sys/errno.h>

#if defined(apollo)
#include <strings.h>
#else
#include <string.h>
#endif	/* apollo */
#include <sys/types.h>
#include <signal.h>
#include <sys/stat.h>
#include "rtcopy.h"

extern char * getifnam() ;
extern void rtyexit() ;
extern char * getconfent() ;
extern int sonyraw ; /* If this flag is raised, choose sony_read,sony_write ...*/

extern int errno ;
extern int serrno ;
extern int rfio_errno ;
#ifndef linux
extern char *sys_errlist[];
#endif /* linux */

#define RFIO_KERNEL 1
#include "rfio.h"

/*
 * Static definitions
 */
static struct stat statbuf ;
static int dskon = 0 ;
int tpon = 0 ;
static int dskfd ;
static int tpfd ;
static int rc ;
static char func[16] ;
char tpdevtyp[9] = "";        /* Device type          */

/*
 * Stager control code
 */
#define LIMBYSZ 197

#ifndef min
#define min(a,b)      (((a)<(b)) ? (a):(b))
#endif

#define	PAGE	4096
#define DEFNBPAGES 256     /* 1 MB */
/*
 * Handler for signal SIGPIPE
 */
void hand() { 	(void) fprintf(stderr, RT136, "CPDSKTP") ; 
		fflush(stderr);
	      	if ( getconfent("RTCOPYD","NETRETRY",0) != NULL && 
		     (rc = stat(NOMORETAPES, &statbuf)) < 0) {
				rtcplogit(func,"SIGPIPE hand(): retry required");
				if (dskon) { 
					close(dskfd) ;
					rtcplogit(func,"socket closed");
				}
				if (tpon) tcloserr(tpfd);
				exit(SYRETRY) ;
		}
		else {
				rtcplogit(func,"SIGPIPE hand(): retry not required %s", 
					(rc < 0 ? "":"file nomoretapes exists") );
				if (dskon) close(dskfd) ;
				if (tpon) tcloserr(tpfd);
				exit(SYERR) ;
		}
}

/*
 * Transfer program
 */
main(argc,argv)
	int     argc ; 
	char ** argv ;
{
	/*
	 * To parse options.
	 */
	extern char   * optarg ; 
	extern int      optind ;
	extern long   strtol() ;
	extern char * getenv() ;
	char 	          * cp ;
	int 		     c ; 	

	time_t stime ; 	/* Start time for data fransfer */
	time_t etime ;  /* Ending time for data fransfer */
	/*
	 *  To log
	 */ 
	char 	     ptr[10] ;		/* Message to log	     	*/
	char 	       *ifce ;		/* ptr to interface name	*/


	/*
	 * To store options.
	 */
	int         a2ebc = 0 ;
	int	blksiz= 32760 ;		/* Block size		*/
	int	 blockflg = 0 ;		/* Variable to fixed		*/
	int	     lrecl= 0 ;		/* Record length	*/
	int 	    nread= -1 ;		/* Max nb of records	*/
	int         free = -1 ;         /* Nb of bytes still available  */
	int        maxsiz= -1 ;         /* Max nb of Megabytes  */
	int     undersctl = 0 ; 	/* data under limit control ? */
	int         nrecs = 0 ; 	/* records counted */
	char    rtyreason[24] ;
	char 	vmstr[256]    ;
	int 	underNctl = 0 ;
	int 	      nbpages ; 
	static char tpden[8] = "" ;    /* Tape density         */
#if defined(linux)
	float 	compress ;
	COMPRESSION_STATS compstats ;
#endif


	/*
	 * Buffer
	 */
	char 	    * buffer ;		/* Pointer to buffer	*/
	int 	      buflen ; 		/* Buffer length	*/
	int 	      bufp=0 ;          /* Buffer pointer	*/
	int 	   bufendp=0 ;          /* Buffer end pointer	*/
	char * convbuf = NULL ;		/* Buffer to convert variable to fixed */
	int	 eof_reached ;
	int           nbread ;		/* Nb read per transfer	*/
	char 	       rh[1] ;
	char 	   * protptr ;   	/* To handle protocol   */

	/*
	 * Files 
	 */
	char	   * dskfil ;		/* Disk file name	*/
	char 	   *  tpfil ;		/* Tape file name	*/

	/*
	 * Counters
	 */
	int	    irec= 0 ; 		/* Index of the current record		*/
	int	      n2= 0 ;		/* Number of bytes in conversion buffer */
	int	 nbtrunc= 0 ;		/* Number of truncated records		*/
	int	   total= 0 ; 		/* Total number of bytes transferred	*/

        /*
         * For storing the uid & gid & key of an external user
         */
        char    *special_uid = NULL;
        char    *special_gid = NULL;
        char    *special_key = NULL;
	char 	*reqhost     = NULL;
	

	(void)signal(SIGPIPE,(void (*)())hand);
	strcpy(func, argv[0]);
	vmstr[0] = '\0' ;
	rh[0]='\0' ;

	/* 
	 * Input parameter analysis
	 */
	(void) fprintf(stderr, RT209, "CPDSKTP", 'F') ; 
	while( (c= getopt(argc,argv, "C:xb:t:L:N:X:s:d:T:")) != EOF ) {
		switch(c) {
			case 'b':
				blksiz= (int) strtol(optarg,&cp,10) ;
				if ( *cp != '\0' ) {
					(void) fprintf(stderr, RT129, "CPDSKTP") ;
					exit(USERR) ;
				}
				(void) fprintf(stderr, RT204, "CPDSKTP", blksiz) ;
				break ; 
			case 'x': 
				break;
			case 'X':
				strcpy(vmstr,optarg) ;
				break;
			case 't':
				tpfil= optarg ;
				break ; 
			case 'L':
				lrecl= (int) strtol(optarg,&cp,10) ;
				if ( *cp != '\0' ) {
					(void) fprintf(stderr, RT135, "CPDSKTP") ;
					exit(USERR) ;
				}
				(void) fprintf(stderr, RT210, "CPDSKTP", lrecl) ; 
				break ; 
			case 'd':
				strcpy(tpden,optarg) ;
				break;
			case 'N':
				nread= (int) strtol(optarg,&cp,10) ;
				if ( *cp != '\0' ) {
					(void) fprintf(stderr, RT133, "CPDSKTP") ;
					exit(USERR) ;
				}
				if ( nread > 0 ) {
					(void) fprintf(stderr, RT207, "CPDSKTP", nread) ;
					underNctl ++ ;
				}
				break ; 
                        case 's':
                                maxsiz= (int) strtol(optarg, &cp,10) ;
                                if ( *cp != '\0' ) {
                                        (void) fprintf(stderr, RT132, "CPDSKTP") ;
                                        exit(USERR) ;
                                }
                                if (maxsiz > 0)
                                        (void) fprintf(stderr, RT208, "CPDSKTP", maxsiz) ;
				undersctl ++ ;
                                if ( maxsiz >= 2048 ) {
                                        (void) fprintf(stderr, RT220, "CPTPDSK") ;
                                        free = MAXFILESZ ;
                                }
                                else
                                        free = maxsiz*1024*1024 ;

                                break ;

                        case 'C':
				cp = strtok (optarg,",") ;
				while (cp) {
					if ( !strcmp (cp,"ebcdic") ) {
						a2ebc ++ ;
#if defined(TRACE1)
						fprintf(stderr," ebcdic conversion requested \n");
#endif  /* TRACE1 */
						(void) fprintf(stderr, RT213, "CPDSKTP") ;
					} else if ( !strcmp (cp,"block") )
						blockflg ++ ;
					if (cp = strtok (NULL,",")) *(cp-1) = ',' ;
				}
                                break ;
		        case 'T':
			        strcpy(tpdevtyp,optarg);
				break;
			case '?':
				(void) fprintf(stderr, RT102, "CPDSKTP"); 
				exit(USERR) ;
		}
	}

	setdevtype(tpdevtyp,tpden);
	
	/*
	 * Buffer allocation.
	 */
	if ( lrecl == 0 ) {
		(void) fprintf(stderr, RT139, "CPDSKTP") ; 
		exit(USERR) ;
	}
	if ( (cp=getconfent("RTCOPYBUFFER","NBPAGES",0)) != NULL && atoi(cp) > 0 ) {
		nbpages=atoi(cp) ; 
	}
	else
		nbpages=DEFNBPAGES ;

#if defined(SONYRAW)
	if ( !strcmp(tpden,"RAW") || !strcmp(tpden,"raw") ) {
		sonyraw++ ;
	}
#endif /* SONYRAW */

#if defined(TRACE1)
       	fprintf(stderr," Buffer will allocate %d pages\n",nbpages) ;
#endif  /* TRACE1 */

	nbread= (nbpages*PAGE) / blksiz ;
	if ( nbread == 0 ) nbread= 1;	/* specified blksiz > NBPAGES */
#ifdef SUNOS_411
	if ( blksiz % 2 ) nbread= 1 ;
#else
#ifdef CRAY
	if ( blksiz % 8 ) nbread= 1 ;
#endif
#endif
	buflen= ((nbread*blksiz+PAGE-1)/PAGE)*PAGE ;
	nbread= nbread * (blksiz/lrecl) ;
 	if ( buflen <= 0 ) {
		(void) fprintf(stderr, RT148, "CPDSKTP",buflen) ;
		exit (USERR) ;
	}
	if ( ( buffer= ( char *) malloc((unsigned) buflen)) == NULL ) {
#if defined(TRACE1)
        	fprintf(stderr," malloc(%d) failed : %s\n",buflen,sys_errlist[errno]);
#endif  /* TRACE1 */
		(void) fprintf(stderr, RT105, "CPDSKTP", sys_errlist[errno]) ;
		exit(RSLCT) ;
	}	
	if ( ( convbuf= ( char *) malloc((unsigned) blksiz)) == NULL ) {
#if defined(TRACE1)
        	fprintf(stderr," malloc(%d) failed : %s\n",blksiz,sys_errlist[errno]);
#endif  /* TRACE1 */
		(void) fprintf(stderr, RT105, "CPDSKTP", sys_errlist[errno]) ;
		exit(RSLCT) ;
	}	

	/*
	 * Opening tape file as output.
	 * Setting it for tape I/O list.
	 */
	tpfd= topen(tpfil,O_RDWR) ;
	tpon ++ ;
	/*
	 * Getting info from the daemon
         */
        special_uid=getenv("ORI_UID");
        special_gid=getenv("ORI_GID");
        special_key=getenv("KEY");
	reqhost=getenv("REQHOST");

	/* 
	 * Reading one after the other all
	 * the disk files in order to read
	 * them.
	 */
	(void) time (&stime) ;
	for(;optind<argc;optind++) {
	  int v;
		/*
		 * Opening the current disk file.
		 */

	  /* Activate new transfer mode */
	  v = RFIO_STREAM;
	  rfiosetopt(RFIO_READOPT,&v,4); 
	  (void) fprintf(stderr," CPDSKTP - TRYING NEW RFIO V3 PROTOCOL\n") ;
	  

		dskfil= argv[optind] ;
		eof_reached = 0;
		rfio_errno = 0 ;
		if ( special_uid != NULL && special_gid != NULL && special_key !=NULL && reqhost!=NULL ) {
                        dskfd = rfio_open_ext(dskfil,O_RDONLY, 0666 ,
					(uid_t)atol(special_uid),
                                        (gid_t)atol(special_gid),
                                         atoi(special_key),
					 reqhost,
					 vmstr ) ;
		}
                else if ( strlen(vmstr) != 0 )
                        dskfd = rfio_open_ext(dskfil,O_RDONLY, 0666 , 0  , 0 , 0 , rh , vmstr ) ;
			
		else
                        dskfd = rfio_open(dskfil,O_RDONLY) ;

		if ( dskfd == -1 ) {
			rtcplogit(argv[0], "rfio_open() : errno = %d, serrno = %d, rfio_errno = %d", errno, serrno, rfio_errno ) ;
			(void) fprintf(stderr, RT110, "CPDSKTP", rfio_serror()) ;
			(void) tcloserr(tpfd) ; 
			switch (rfio_errno) {
			 	case ENOENT:
				case EACCES:
				case EISDIR:
				case EPERM :
					exit(USERR) ;
					break ;
				default:
					if ( errno == EBADF && rfio_errno == 0 && serrno == 0 ) {
						strcpy(rtyreason,"TRANSFRTY");
						rtyexit(rtyreason,UNERR) ;
					}
					else {
						exit(UNERR) ;
					}
			}
		}

	  if ((rfioreadopt(RFIO_READOPT) & RFIO_READBUF) == RFIO_READBUF) 
	    (void) fprintf(stderr," CPDSKTP - SERVER DOESN'T HAVE RFIO V3 PROTOCOL\n") ;


		dskon ++ ;

		/*
	 	 * writing interface name
	 	 */
		if ( (ifce=getifnam(dskfd))==NULL ) {
			strcpy(ptr,"unknown");
		}
		else 
			strcpy(ptr,ifce) ;

		if ( (protptr=getconfent("READAHEAD",ptr,1)) != NULL &&
			strstr(protptr,"YES") != NULL ) {
			rfilefdt[dskfd]->ahead=1 ;
		}

		/*
		 * Loop of reading and writing
		 */
		for(;;) {
			int     i ; 
			int    n1 ;
			int  ngot ;
			int nwant ;
			int nbyte ;

			/*
			 * Reading data from disk
			 */
			nwant= ( nread != -1 && nread < nbread ) ? nread : nbread ;
			if ( undersctl )
				if ( free >= 0 ) {
					nwant= min( (free+bufendp)/lrecl , nwant ) ;
					if ( nwant == bufendp/lrecl )
						nwant++ ;
					nrecs += nwant ;
				}
				else {
					if ( bufendp ) {
					  if ( a2ebc ) asc2ebc(&buffer[bufp],bufendp-bufp);
#if defined(TRACE1)
                          	          fprintf(stderr,"3 - twrite() : writing %d bytes \n",bufendp-bufp) ;
#endif /* TRACE1 */
					  (void) twrite(tpfd,&buffer[bufp],bufendp-bufp) ;
					}
					if ( n2 ) {
						if ( a2ebc ) asc2ebc(convbuf,n2) ;
						(void) twrite(tpfd,convbuf,n2) ;
					}
					tclose(tpfd) ;
					(void)time(&etime) ;
					rfio_close(dskfd) ;
					(void) printf("%d:%d:%s\n",irec,total,ptr) ;
					(void) fprintf(stderr, RT206, "CPDSKTP");
					(void) fprintf(stderr, RT212, "CPDSKTP");
					(void) fprintf(stderr, RT201, "CPDSKTP", total) ;
					(void) fprintf(stderr, RT202, "CPDSKTP", irec) ; 
					if ( nbtrunc )
						(void) fprintf(stderr, RT222, "CPDSKTP", nbtrunc) ; 
					total/=1024 ;
					if ( etime - stime > 0 ) 
						(void) fprintf(stderr, RT221,"CPDSKTP",total,ptr,total/(etime-stime));
					rtcplogit(argv[0],"Exiting with code %d",LIMBYSZ);
					exit(LIMBYSZ) ;
				}

			rfio_errno = 0 ;
			nbyte = 0;
			if ( nwant*lrecl != bufendp && (nbyte= rfio_read(dskfd,&buffer[bufendp],nwant*lrecl-bufendp)) == -1 ) { 
				rtcplogit(argv[0],"rfio_read() failed: errno = %d, serrno = %d, rfio_errno = %d", errno, serrno, rfio_errno ) ;
				(void) fprintf(stderr, RT112, "CPDSKTP", rfio_serror()) ;
				(void) tcloserr(tpfd) ; 
				rfio_close(dskfd) ;
				exit(SYERR) ;
			}
			if ( nbyte != nwant*lrecl-bufendp ) eof_reached = 1 ;
			total+= nbyte ; 
			free -= nbyte  ;
			if ( nwant*lrecl == bufendp ) nbyte = bufendp-bufp;

			/*
			 * Writing data to tape.
			 */
		    if ( ! blockflg ) {
			for(i= 0; i<(nbyte/blksiz); i ++) {
				if ( a2ebc ) asc2ebc(&buffer[bufp+i*blksiz],blksiz);
#if defined(TRACE1)		
				fprintf(stderr," 1 - twrite() : writing %d bytes \n",blksiz) ;
#endif /* TRACE1 */
				(void) twrite(tpfd,&buffer[bufp+i*blksiz],blksiz) ;	
			}

			/*
			 * Writing last block if only partial.
			 */
			if ( (nbyte/blksiz)*blksiz != nbyte ) {
				if ( eof_reached || (undersctl && free < lrecl) ) {
					/*
					 * Avoid intermediate short blocks if concatenating 
					 * diskfiles.
					 */
					bufp += i*blksiz;
					bufendp += nbyte;
#if defined(TRACE1)
					fprintf(stderr,"2 - partial block kept in buffer: bufp=%d, bufendp=%d (eof=%d, free=%d)\n",bufp,bufendp,eof_reached,free);
#endif /* TRACE1 */
				} else {
					/*
					 * That we arrived here normally means that
					 * the user has specified a blksiz which is
					 * not a multiple of lrecl.
					 */
	                                if ( a2ebc ) 
        	                                asc2ebc(&buffer[bufp+i*blksiz],nbyte+bufendp-(bufp+i*blksiz));
                	                (void) twrite(tpfd,&buffer[bufp+i*blksiz],nbyte+bufendp-(bufp+i*blksiz)) ;
#if defined(TRACE1)                     
                        	        fprintf(stderr,"2 - twrite() : writing %d bytes \n",nbyte+bufendp-(bufp+i*blksiz)) ;
#endif /* TRACE1 */
					bufp=0;
					bufendp=0;
				}
			} else {
				bufp=0;
				bufendp=0;
			}
			ngot= nbyte / lrecl ;
			if ( (bufendp/lrecl)*lrecl != bufendp ) ngot++;  /* Take into account
									  * partial record */
		    } else {
			ngot= 0 ;
			if ( nbyte )
				while ( n1= var2fix (buffer, convbuf, nbyte, blksiz, lrecl, &nbtrunc) ) {
					if ( n1 == blksiz ) {
						if ( a2ebc ) asc2ebc(convbuf,blksiz);
						(void) twrite(tpfd,convbuf,blksiz) ;
						n2= 0 ;
					} else
						n2= n1 ;
					ngot ++ ;
					if ( nread != -1 && ngot == nread ) break ;
				}
		    }

			irec += ngot ;
			if ( nread != -1 ) {
				nread -= ngot ;
				if ( nread == 0 ) {
					if ( n2 ) {
						if ( a2ebc ) asc2ebc(convbuf,n2) ;
						(void) twrite(tpfd,convbuf,n2) ;
					}
					(void) rfio_close(dskfd) ;
					(void) tclose(tpfd) ;
					(void)time(&etime) ;
					(void) printf("%d:%d:%s\n",nread,total,ptr) ; 
					(void) fprintf(stderr, RT206, "CPDSKTP") ;
					(void) fprintf(stderr, RT201, "CPDSKTP", total) ; 
					(void) fprintf(stderr, RT202, "CPDSKTP", irec) ; 
					if ( nbtrunc )
						(void) fprintf(stderr, RT222, "CPDSKTP", nbtrunc) ; 
					total/=1024 ;
					if ( etime-stime > 0 ) 
						(void) fprintf(stderr, RT221, "CPDSKTP",total,ptr,total/(etime-stime));
					if ( underNctl ) {
                        			(void) fprintf(stderr, RT212, "CPDSKTP");
                        			fflush (stderr) ;
                        			exit (LIMBYSZ) ;
                			}
					break ;
				}
			}	
			if ( eof_reached ) {	
				/*
				 * End of file was reached.
				 */
				(void) rfio_close(dskfd) ;
				break ; 
			}
		} /* for (;;) */
	}
	/*
	 * End of transfer.
	 */
	if ( total ) {
		if ( bufendp ) {
			if ( a2ebc ) asc2ebc(&buffer[bufp],bufendp-bufp);
#if defined(TRACE1)
                	fprintf(stderr,"3 - twrite() : writing %d bytes \n",bufendp-bufp) ;
#endif /* TRACE1 */
			(void) twrite(tpfd,&buffer[bufp],bufendp-bufp) ;
		}
		if ( n2 ) {
			if ( a2ebc ) asc2ebc(convbuf,n2) ;
			(void) twrite(tpfd,convbuf,n2) ;
		}
	
		time(&etime) ;
		(void) printf("%d:%d:%s\n",nread,total,ptr) ; 
		(void) fprintf(stderr, RT206, "CPDSKTP") ;
		(void) fprintf(stderr, RT201, "CPDSKTP", total) ; 
		(void) fprintf(stderr, RT202, "CPDSKTP", irec) ; 
		if ( nbtrunc )
			(void) fprintf(stderr, RT222, "CPDSKTP", nbtrunc) ; 
		total/=1024 ;
		if ( etime-stime > 0 ) 
			(void) fprintf(stderr, RT221,"CPDSKTP",total,ptr,total/(etime-stime));
		(void) tclose(tpfd) ; 
		if ( nread == 0 && underNctl ) {
			(void) fprintf(stderr, RT212, "CPDSKTP");
			fflush (stderr) ;
			exit (LIMBYSZ) ;
		}
		else
			exit(0) ;
	}
	else	{
		/*
		 * No data has been written to tape.
		 * A tape file should not be empty. 
		 */ 
		(void) fprintf(stderr, RT121, "CPDSKTP") ; 
		(void) tclose(tpfd) ; 
		exit(USERR) ; 
	}
}

/* var2fix - search for new line, remove it and padd to lrecl
	for each input block, the routine should be called until it returns 0
	the output record should be written when return code == blksiz or at EOF
	return	 0	nothing left in input buffer
		>0	nb of bytes in output buffer
 */
var2fix(ibuf, obuf, len, blksiz, lrecl, nbtrunc)
char *ibuf;
char *obuf;
int len;
int blksiz;
int lrecl;
int *nbtrunc;
{
	static int nl_at_endbuf = 0;
	static char *ip = NULL;
	int n;
	int nl;
	static char *op = NULL;
	static char *orp;	/* ptr to beginning of output record */
	static int ovfl = 0;
	char *p;

	if (nl_at_endbuf) {
		nl_at_endbuf = 0;
		return (0);
	}
	if (! ip)
		ip = ibuf;
	if (! op) {
		op = obuf;
		orp = obuf;
	}
scanblk:
	nl = 0;
	for (p = ip; p < ibuf + len; p++)
		if (*p == '\n') {
			nl = 1;
			break;
	}
	if (ovfl) {
		if (nl) {	/* tail part of a truncated record */
			ovfl = 0;
			(*nbtrunc)++;
		}
		ip = p;
		if (ip >= ibuf + len) {
			ip = ibuf;
			if (! nl)
				return (0);
			else
				nl_at_endbuf = 1;
		} else ip++;		/* skip newline */
		goto scanblk;
	}
	n = p - ip;
	if (op - orp + n > lrecl) {
		n = lrecl - (op - orp);
		ovfl = 1;		/* record longer than lrecl */
		nl = 0;
	}
	memcpy (op, ip, n);
	ip += n;
	op += n;
	if (ip >= ibuf + len) {		/* input buffer exhausted */
		ip = ibuf;
		if (! nl)
			return (0);
		else
			nl_at_endbuf = 1;
	} else ip++;			/* skip newline */
	n = lrecl - (op - orp);
	if (n > 0)
		memset (op, ' ', n);	/* pad to lrecl with blanks */
	op += n;
	orp += lrecl;
	n = orp - obuf;
	if (n >= blksiz) {		/* output buffer full */
		op = obuf;
		orp = obuf;
	}
	return (n);
}
