/*
 * Copyright (C) 1990-1997 by CERN CN-PDP/SC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)connect.c	3.15 06/18/99 CN-PDP/SC Frederic Hemmer";
#endif /* not lint */

/* connect.c    Remote File I/O - connect to remote server              */

#define RFIO_KERNEL     1       /* system part of Remote File I/O       */

#if defined(_WIN32)
#include "log.h"             /* system logger                        */
#else
#include <syslog.h>             /* system logger                        */
#endif
#include "rfio.h"               /* remote file I/O definitions          */

extern char     *getenv();      /* get environmental variable value     */

#if defined(_WIN32)
__declspec(thread)
#endif
static char     last_host[256]; /* to hold last connect host name       */

int     rfio_connect(node,remote)       /* Connect <node>'s rfio server */
char    *node;                  /* remote host to connect               */
int     *remote  ;              /* connected host is remote or not      */
{
	register int    s;      /* socket descriptor                    */
	struct servent  *sp;    /* service entry pointer                */
	struct hostent  *hp;    /* host entry pointer                   */
	struct sockaddr_in sin; /* socket address (internet) struct     */
	char    *host;          /* host name chararcter string          */
	char    *p, *cp;        /* character string pointers            */
	register int    retrycnt; /* number of NOMORERFIO retries       */
	register int    retryint; /* interval between NOMORERFIO retries*/
	register int    crtycnt = 0; /* connect retry count             */
	register int    crtyint = 0; /* connect retry interval          */
	register int    crtyattmpt = 0; /* connect retry attempts done  */
	register int    crtycnts = 0 ;
	struct    stat statbuf ; /* NOMORERFIO stat buffer              */
	char    nomorebuf1[BUFSIZ], nomorebuf2[BUFSIZ]; /* NOMORERFIO buffers */

	INIT_TRACE("RFIO_TRACE");
/*
 * Should we use an alternate name ?
 */

/*
 * Under some circumstances (heavy load, use of inetd) the server fails
 * to accept a connection. A simple retry mechanism is therefore
 * implemented here.
 */
	if ( rfioreadopt(RFIO_NETRETRYOPT) != RFIO_NOTIME2RETRY ) {
		if ((p = getconfent("RFIO", "CONRETRY", 0)) != NULL)        {
			if ((crtycnt = atoi(p)) <= 0)     {
				crtycnt = 0;
			}
		}
		serrno = 0 ;
		if ((p = getconfent("RFIO", "CONRETRYINT", 0)) != NULL)        {
			if ((crtyint = atoi(p)) <= 0)     {
				crtyint = 0;
			}
		}
	}
	crtycnts = crtycnt ;
/*
 * When the NOMORERFIO file exists, or if NOMORERFIO.host file exists,
 * the RFIO service is suspended. By default it will retry for ever every
 * DEFRETRYINT seconds.
 */
	if ((p=getconfent("RFIO", "RETRY", 0)) == NULL) {
		retrycnt=DEFRETRYCNT;
	}
	else    {
		retrycnt=atoi(p);
	}
	if ((p=getconfent("RFIO", "RETRYINT", 0)) == NULL) {
		retryint=DEFRETRYINT;
	}
	else    {
		retryint=atoi(p);
	}

	if ( rfioreadopt(RFIO_NETOPT) != RFIO_NONET ) {
		if ((host = getconfent("NET",node,1)) == NULL)  {
			host = node;
		}
		else {
			TRACE(3,"rfio","set of hosts: %s",host);
		}
	}
	else    {
		host = node;
	}

	serrno = 0; /* reset the errno could be SEENTRYNFND */
	rfio_errno = 0;

	TRACE(1, "rfio", "rfio_connect: connecting(%s)",host);

	TRACE(2, "rfio", "rfio_connect: getservbyname(%s, %s)","rfio", "tcp");
	if ((sp = getservbyname("rfio","tcp")) == NULL) {
		TRACE(2, "rfio", "rfio_connect: rfio/tcp no such service");
		serrno = SENOSSERV;     /* No such service              */
		END_TRACE();
		return(-1);
	}

	sin.sin_family = AF_INET;
	sin.sin_port = sp->s_port;

	if ((p = getenv("RFIO_PORT")) != NULL)  {
		TRACE(2, "rfio", "rfio_connect: *** Warning: using port %s", p);
		sin.sin_port = htons(atoi(p));
	}
	cp = strtok(host," \t") ;
        if (cp == NULL ) {
               TRACE(1,"rfio","host specified incorrect");
               serrno = SENOSHOST;
               END_TRACE();
               return(-1);
        }

conretryall:
	TRACE(2, "rfio", "rfio_connect: gethostbyname(%s)", cp);
	hp = gethostbyname(cp);
	if (hp == NULL) {
		if (strchr(cp,'.') != NULL) { /* Dotted notation */
			TRACE(2, "rfio", "rfio_connect: using %s", cp);
			sin.sin_addr.s_addr = htonl(inet_addr(cp));
		}
		else    {
			TRACE(2, "rfio", "rfio_connect: %s: no such host",cp);
			serrno = SENOSHOST;     /* No such host                 */
			END_TRACE();
			return(-1);
		}
	}
	else    {
		sin.sin_addr.s_addr = ((struct in_addr *)(hp->h_addr))->s_addr;
	}

#if defined(_WIN32)
	if (strncmp (NOMORERFIO, "%SystemRoot%\\", 13) == 0 &&
	    (p = getenv ("SystemRoot")))
		sprintf (nomorebuf1, "%s%s", p, strchr (NOMORERFIO, '\\'));
#else
	strcpy(nomorebuf1, NOMORERFIO);
#endif
	sprintf(nomorebuf2, "%s.%s", nomorebuf1, cp);
retry:
	if (!stat(nomorebuf1,&statbuf)) {
		if (retrycnt-- >=0)  {
			syslog(LOG_ALERT, "rfio: connect: all RFIO service suspended (pid=%d)\n", getpid());
			sleep(retryint);
			goto retry;
		} else {
			syslog(LOG_ALERT, "rfio: connect: all RFIO service suspended (pid=%d), retries exhausted\n", getpid());
			serrno=SERTYEXHAUST;
			return(-1);
		}
	}
	if (!stat(nomorebuf2, &statbuf)) {
		if (retrycnt-- >=0)  {
			syslog(LOG_ALERT, "rfio: connect: RFIO service to <%s> suspended (pid=%d)\n", cp, getpid());
			sleep(retryint);
			goto retry;
		} else {
			syslog(LOG_ALERT, "rfio: connect: RFIO service to <%s> suspended (pid=%d), retries exhausted\n", cp, getpid());
			serrno=SERTYEXHAUST;
			return(-1);
		}
	}

conretry:
	TRACE(2, "rfio", "rfio_connect: socket(%d, %d, %d)",
				AF_INET, SOCK_STREAM, 0);
	if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0)  {
		TRACE(2, "rfio", "rfio_connect: socket(): ERROR occured (errno=%d)", errno);
		END_TRACE();
		return(-1);
	}
	TRACE(2, "rfio", "rfio_connect: connect(%d, %x, %d)", s, &sin, sizeof(struct sockaddr_in));
	if (connect(s, (struct sockaddr *)&sin, sizeof(struct sockaddr_in)) < 0)   {
		TRACE(2, "rfio", "rfio_connect: connect(): ERROR occured (errno=%d)", errno);
#if defined(_WIN32)
		if (errno == WSAECONNREFUSED) {
#else
		if (errno == ECONNREFUSED)      {
#endif
			syslog(LOG_ALERT, "rfio: connect: %d failed to connect %s", getpid(), cp);
			if (crtycnt-- > 0)       {
				if (crtyint) sleep(crtyint);
				syslog(LOG_ALERT, "rfio: connect: %d retrying to connect %s", getpid(), cp);
/*
 * connect() returns "Invalid argument when called twice,
 * so socket needs to be closed and recreated first
 */

				(void) close(s);
				crtyattmpt ++ ;
				goto conretry;
			}
			if ( ( cp = strtok(NULL," \t")) != NULL ) 	{
				crtycnt =  crtycnts ;
				syslog(LOG_ALERT, "rfio: connect: after ECONNREFUSED, changing host to %s", cp) ;
				TRACE(3,"rfio","rfio: connect: after ECONNREFUSED, changing host to %s", cp) ;
				(void) close(s);
				goto conretryall;
			}
		}
#if defined(_WIN32)
		if (errno==WSAENETUNREACH || errno==WSAETIMEDOUT) {
#else
		if (errno==EHOSTUNREACH || errno==ETIMEDOUT)	{
#endif
			if ( ( cp = strtok(NULL," \t")) != NULL ) 	{
				crtycnt =  crtycnts ;
#if defined(_WIN32)
				if (errno == WSAENETUNREACH)
#else
				if (errno == EHOSTUNREACH)
#endif
					syslog(LOG_ALERT, "rfio: connect: after EHOSTUNREACH, changing host to %s", cp) ;
				else
					syslog(LOG_ALERT, "rfio: connect: after ETIMEDOUT, changing host to %s", cp) ;
					
				(void) close(s);
				goto conretryall;
			}
				
		}
		(void) close(s);
		END_TRACE();
		return(-1);
	}
	if (crtyattmpt) {
		syslog(LOG_ALERT, "rfio: connect: %d recovered connection after %d secs with %s",getpid(), crtyattmpt*crtyint,cp) ;
	}
	*remote = isremote( sin.sin_addr, node ) ;
	strcpy(last_host,cp); /* remember to fetch back remote errs     */
	TRACE(2, "rfio", "rfio_connect: connected");
	TRACE(2, "rfio", "rfio_connect: calling setnetio(%d)", s);
	if (setnetio(s) < 0)    {
		close(s);
		END_TRACE();
		return(-1);
	}

	TRACE(1, "rfio", "rfio_connect: return socket %d", s);
	END_TRACE();
	return(s);
}

char    *rfio_lasthost() /* returns last succesfully connected host     */
{
	return(last_host);
}
