/*
 * Copyright (C) 1990-1997 by CERN/IT/PDP/IP
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)close.c	3.8 05/06/98  F. Hemmer, A. Trannoy, F. Hassine";
#endif /* not lint */

/* close.c      Remote File I/O - close a file                          */

#define RFIO_KERNEL     1 
#include "rfio.h"        

/*
 * remote file close
 */
int rfio_close(s)
     int     s;
{
  /* Remote file ? */
  if ((s >= 0) && (s < MAXRFD) && (rfilefdt[s] != NULL))
    {
      if (rfilefdt[s]->version3 == 1)
	{
	  /* New V3 stream protocol for sequential transfers */
	  return(rfio_close_v3(s));
	}
      else
	return(rfio_close_v2(s));
    }
  else
    return(rfio_close_v2(s));
}

int rfio_close_v2(s)    
int     s;
{
	char   * p  ; 
	int  status ;
	struct {
		unsigned int    rcount; /* read() count                 */
		unsigned int    wcount; /* write() count                */
		unsigned int    rbcount;/* byte(s) read                 */
		unsigned int    wbcount;/* byte(s) written              */
	} iostatbuf ;
	char  * trp ; 	/* Pointer to a temporary buffer		*/
	int temp= 0 ; 	/* A temporary buffer has been allocated	*/

	INIT_TRACE("RFIO_TRACE");
	TRACE(1, "rfio", "rfio_close(%d)", s);

	/*
	 * The file is local
	 */
	if ( s < 0 || s >= MAXRFD || rfilefdt[s] == NULL ) {
		TRACE(2, "rfio", "rfio_close: using local close(%d)",s) ; 
		status= close(s) ; 
#if defined (CLIENTLOG)
        	/* Client logging */
        	rfio_logcl(s);
#endif
		END_TRACE() ; 
		rfio_errno = 0;
		return status ;
	}
#if defined (CLIENTLOG)
	/* Client logging */
	rfio_logcl(s);
#endif
	/*
	 * Checking magic number
	 */
	if ( rfilefdt[s]->magic != RFIO_MAGIC ) {
		serrno = SEBADVERSION ;
		(void) close(s) ;
		free((char *)rfilefdt[s]);
		rfilefdt[s] = 0;
		END_TRACE();
		return(-1);
	}
	/*
	 * Sending request.
	 */
	p= rfio_buf ;
	marshall_WORD(p, RFIO_MAGIC);
	marshall_WORD(p, RQST_CLOSE);
	TRACE(2, "rfio", "rfio_close: sending %d bytes",RQSTSIZE) ;
	if (netwrite(s, rfio_buf,RQSTSIZE) != RQSTSIZE) {
		TRACE(2, "rfio", "rfio_close: write(): ERROR occured (errno=%d)", errno);
		(void) rfio_cleanup(s) ;
		END_TRACE() ;
		return -1 ;
	}
	/*
	 * Getting data from the network.
	 */
	for(;;) {
		WORD    req ; 
		LONG  rcode ;
		LONG msgsiz ;

		TRACE(2, "rfio", "rfio_close: reading %d bytes",rfilefdt[s]->_iobuf.hsize) ; 
		if (netread(s,rfio_buf,rfilefdt[s]->_iobuf.hsize) != rfilefdt[s]->_iobuf.hsize) {
			TRACE(2, "rfio", "rfio_close: read(): ERROR occured (errno=%d)", errno);
			if ( temp ) (void) free(trp) ; 
			(void)rfio_cleanup(s) ; 
			END_TRACE() ;
			return -1 ; 
		}
		p = rfio_buf ;
		unmarshall_WORD(p,req) ;
		unmarshall_LONG(p,status) ;
		unmarshall_LONG(p, rcode) ;
		unmarshall_LONG(p,msgsiz) ;
		rfio_errno = rcode ;
		switch(req) {
		   case RQST_CLOSE:
			if ( temp ) (void) free(trp) ; 
			(void) rfio_cleanup(s) ; 
			TRACE(1, "rfio", "rfio_close: return status=%d, rcode=%d",status,rcode) ;
			END_TRACE() ; 
			return status ;
		   case RQST_READAHEAD:
		   case RQST_LASTSEEK:
		   case RQST_PRESEEK:
			/* 
			 * At this point a temporary buffer may need to be created
			 * to receive data which is going to be thrown away.
			 */
			if ( temp == 0 ) {
			   if ( rfilefdt[s]->_iobuf.base==NULL || rfilefdt[s]->_iobuf.dsize<msgsiz ) {
				temp= 1 ; 
				TRACE(3,"rfio","rfio_close: allocating momentary buffer of size %d",msgsiz) ; 
				if ( (trp= ( char *) malloc(msgsiz)) == NULL ) {
					TRACE(3,"rfio","rfio_close: malloc(): ERROR occured (errno=%d)",errno) ; 
					(void) rfio_cleanup(s) ; 
					END_TRACE() ; 
					return -1 ;
				}
			   }
			   else
				trp= iodata(rfilefdt[s]) ;
			}
			if ( netread(s,trp,msgsiz) != msgsiz ) {
				TRACE(2,"rfio","rfio_close: read(): ERROR occured (errno=%d)",errno) ;
				if ( temp ) (void) free(trp) ; 
				(void) rfio_cleanup(s) ; 
				END_TRACE() ; 
				return -1 ;
			}
			break ; 
		    default:
			TRACE(1,"rfio","rfio_close(): Bad control word received\n") ; 
			rfio_errno= SEINTERNAL ;
			if ( temp ) (void) free(trp) ; 
			(void) rfio_cleanup(s) ; 
			END_TRACE() ; 
			return -1 ;
		}
	}	
}
