/*
 * Copyright (C) 1990-1998 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)tpmstat.c	1.7 05/06/98 CERN CN-SW/DC Antoine Trannoy";
#endif /* not lint */

/* tpmstat.c               Display all mount messages requests to SHIFT msgdaemon */

#include <stdio.h>
#if ! defined(apollo)
#include <unistd.h>
#endif  /* not apollo */
#include "msg.h"

#include <sys/types.h>
#include <time.h>
#include <sys/param.h>
#include <sys/stat.h>
#if defined(apollo)
#include <strings.h>
#else
#include <string.h>
#endif	/* apollo */

/*
 * Networking.
 */
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <marshall.h>

#define netread                 dorecv
#define netwrite                dosend

/*
 * Error and message handling.
 */
#include <errno.h>

#include <serrno.h>
#include <log.h>
extern int errno ;
extern int sys_nerr ;
extern void perror() ;
#if !defined(linux)
extern char *sys_errlist[] ;
#endif

static void usage(cmd)
	char * cmd ; 
{
	(void) fprintf(stderr,"usage: %s ",cmd) ; 
	(void) fprintf(stderr,"[-d]\n") ;
}

main(argc,argv) 
	int     argc ; 
	char ** argv ; 
{
	char buffer[MSGSIZ+4*LONGSIZE];	/* Buffer		*/
	char    * ptr ;			/* Pointer to the buffer*/
	int 	 sock ; 		/* Socket identifier	*/
	int 	count ;			/* Number of messages	*/
	int    hdr= 0 ;			/* Header printed ?	*/
	int	    i ; 		/* Loop index		*/
	int	    c ;			/* Option parsing	*/
	int   dflg= 0 ; 		/* Option d flag	*/
	time_t cur_time ;		/* Current time		*/
	extern time_t time() ; 		/* External declaration */
	extern char *ctime() ;		/* External declaration */

	/*
	 * Getting options
	 */
	while ( (c= getopt(argc,argv,"d")) != EOF ) {
		int errflg= 0 ; 

		switch(c) {
			case 'd':
				dflg= 1 ; 
				break ; 
			case '?':
				errflg ++ ;
				break ; 
		}
		if (errflg) {
			usage(argv[0]) ; 
			exit(1) ; 
		}
	}

	/*
	 * Connecting the msgdaemon.
	 */
	if ( ( sock= conmsgd()) == -1 ) {
		exit(1) ;
	}

	/*
	 * Building the request.
	 */
	ptr= buffer ;
	marshall_LONG(ptr,MSG_MAGIC) ;
	marshall_LONG(ptr,RQST_GETR) ;
	marshall_LONG(ptr,0) ;

	/* 
	 * Sending the request.
	 */
	switch( netwrite(sock,buffer,3*LONGSIZE) ) {
		case 0:
			serrno= SECONNDROP ;
		case -1:
			(void) close(sock) ; 
			exit(1) ; 
	}

	/* 
	 * Waiting for the answer.
	 */
	switch( rcvmsgd(sock,buffer) ) {
		case -1:
			(void) close(sock) ;
			exit(1) ; 
		case ACKN_GETR:
			break ; 
		default:
			serrno= SEINTERNAL ; 
			(void) close(sock) ; 
			exit(1) ; 
	}

	/*
	 * Getting current time
	 * Displaying it if dflg.
	 */
	(void) time(&cur_time) ; 
	if ( dflg ) 
		(void) printf("%s", ctime(&cur_time) ) ;

	/* 
	 * Receiving messages
	 */
	ptr= buffer ;
	unmarshall_LONG(ptr,count) ;
	for(i=0;i<count;i++) {
		char msg[MSGSIZ] ;	/* Message buffer	*/
		int 	   index ; 	/* Message index	*/
		time_t	    time ; 	/* Message time		*/
		int 	    size ;	/* Message size		*/
		struct tm    * t ; 	/* To format time	*/

		/*
	 	 * Receiving index, time and size.
		 */
		switch( netread(sock,buffer,LONGSIZE*3) ) {
			case 0:
				serrno= SECONNDROP ;
			case -1:
				(void) close(sock) ;
				exit(1) ; 
		}
		ptr= buffer ;
		unmarshall_LONG(ptr,index) ; 
		unmarshall_LONG(ptr,time) ;
		unmarshall_LONG(ptr,size) ; 

		/*
		 * Receiving message itself.
		 * Unmarshalling it.
		 */
		switch( netread(sock,buffer,size) ) {
			case 0:
				serrno= SECONNDROP ;
			case -1:
				(void) close(sock) ;
				exit(1) ; 
		}
		ptr= buffer ;
		unmarshall_STRING(ptr,msg) ;

		/*
		 * If tape mount message 
		 */
		if (  ! strncmp("TP020",msg,5) ) {
			char unid[7] ;
			int      jid ; 	
			char * logid ;
			char  * unit ;
			char  * ring ;
			char   * vid ;
			char   *  cp ; 
		
			/*
			 * Parsing the message.
			 */
			vid = strtok(msg+19,"(") ;	
			(void) strtok((char *)NULL,"-") ; 
			ring= strtok((char *)NULL," ") ;
			(void) strtok((char *)NULL," ") ; 
			(void) strtok((char *)NULL," ") ; 
			unit= strtok((char *)NULL,"@") ;
			(void) strtok((char *)NULL," ") ; 
			(void) strtok((char *)NULL," ") ; 
			logid= strtok((char *)NULL," ") ; 
			jid= atoi(strtok((char *)NULL,",")) ;	
			cp= strtok((char *)NULL,"(") ; 
			if ( ! strcmp(cp,"  ") ) {
				/*
				 * Job is interactif
				 */
				*unid= 'I' ;
				(void) sprintf(unid+1,"%d",jid) ; 
			}
			else	{
				/*
				 * Job is batch
				 */
				*unid= 'B' ;
				(void) strcpy(unid+1,strtok(cp,".")) ; 
			}
			
			if ( hdr++ == 0 ) {
				(void)printf ("time      jobid uniqid  logonid  unit     ring mount    ");
				(void)printf ("vid    library rack/slot\n");
			}

			t= localtime(&time) ; 
			(void) printf("%02d:%02d:%02d %6d %-7s %-8s %-8s %-3s  %-8s %-6s\n",
				t->tm_hour,t->tm_min,t->tm_sec,jid,unid,logid,unit,ring,"pending",vid) ; 
		}
	}
}
