/*
 * Copyright (C) 1990-1998 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)term.c	1.13 05/07/98 CERN CN-SW/DC Antoine Trannoy";
#endif /* not lint */

/* term.c     		Operations on terminal.		 */

#include <stdio.h>
#if defined(apollo)
#include <sys/ioctl.h>
#else /* ! apollo */
#include <unistd.h>
#if !defined(linux)
#include <sys/termio.h>
#else
#include <termio.h>
#endif
#endif /* apollo */
#include <sys/types.h>
#include <fcntl.h>


/*
 * Getting terminal window size.
 */
int termwinsiz(col,row)
	int *col ;
	int *row ;
{
	int 		term ;		/* Terminal identifier	*/	
	struct winsize 	win  ;		/* Window structure	*/

	if ( (term= open("/dev/tty",O_RDWR)) == -1 ) {
		return -1 ;
	}
	if ( ioctl(term,TIOCGWINSZ,&win) == -1 ) {
		return -1 ;
	}
/*
 * Irix 4.0.5 has a bug, returning ENODEV on the following close
 */
#if (defined(sgi) && defined(__EXTENSIONS__))
	(void) close(term);
#else
	if ( close(term) == -1 ) {
		return -1 ;
	}
#endif /* sgi && __EXTENSIONS */
	*col= win.ws_col ;
	*row= win.ws_row ;
	return 0 ;
}

/*
 * Dissassociating current process from controlling terminal
 */

int noterm()
{
	register int    i;
	register int    maxfds;

#if defined(apollo) || (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined(linux)
	maxfds=getdtablesize();
#else  /* _AIX || CRAY || hpux || sgi || SOLARIS */
	maxfds=_NFILE;
#endif /* apollo || sun || ultrix */

       for (i=0; i< maxfds; i++) (void) close(i);

#if defined(_AIX) || defined(apollo) || defined(sgi) || defined(sun) || defined(ultrix)
	(void) open("/dev/null", O_RDONLY);
	dup2(0,1);
	dup2(0,2);
	i = open("/dev/tty", O_RDWR);
	if (i>0) {
		ioctl(i, TIOCNOTTY, 0);
		(void) close(i);
	}
#endif /* _AIX || apollo || sgi || sun || ultrix */

/*
 * fork ourselves
 */
	switch(fork()) {
		case -1:
			return(-1);
		case 0 :
#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined(_IBMESA)
			(void) setpgrp(0, getpid());
#else
#if (defined(__osf__) && defined(__alpha))
			(void) setsid();
#else
#if HPUX10
			(void) setpgrp3();
#else
			(void) setpgrp();
#endif
#endif
#endif
			break ; 
		default:
			exit(0);
	}
	return(0);
}
