/*
 * Copyright (C) 1990,1991 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)rep.c	1.4 03/06/91 CERN CN-SW/DC Antoine Trannoy";
#endif /* not lint */

#include <stdio.h>
#include <serrno.h>
#include "msg.h"

main(argc,argv)
	int    argc ;
	char **argv ;
{
	int  	     index ;	/* Message index.	*/
	int 		 i ;	/* Loop index.		*/
	char reply[MSGSIZ] ;	/* Reply message.	*/

	/*
	 * Checking the number of arguments.
	 */
	if ( argc < 2 ) {
		fprintf(stderr,"command failed: not enough arguments\n") ;
		fflush(stderr) ;
		exit(1) ;
	}

	/*
	 * Getting Message index.
	 */
	if ( sscanf(argv[1],"%d",&index) != 1 ) {
		fprintf(stderr,"command failed: wrong first argument\n") ; 
		fflush(stderr) ;
		exit(1) ;
	}

	/* 
	 * Getting Reply message.
	 */
	for(i=2,*reply='\0';i<argc;i++) {
		if ( (strlen(reply)+strlen(argv[i])+2) > MSGSIZ ) {
			serrno= SEUMSG2LONG ;
			sperror("command failed") ;
			exit(1) ;
		}
		if ( i != 2 ) 
			strcat(reply," ") ;
		strcat(reply,argv[i]) ;
	}
			
	/*
	 * Sending reply.
	 */
	if ( sndrepl(index,reply) == -1 ) {
		sperror("command failed") ;
		exit(1) ;
	}
	exit(0) ;
}
