.\" @(#)oper.man	1.2		CERN-SW/DC	Antoine Trannoy		05/12/92
.\" Copyright (C) 1990,1991 by CERN/CN/SW/DC
.\" All rights reserved
.\"
.TH OPER l "05/12/92"
.SH NAME
oper \- Invokes the operator display manager
.SH SYNOPSIS
.B  /usr/local/bin/oper
.SH DESCRIPTION
.LP
The 
.B oper
command periodically executes and displays the output of a shell command.
The screen is divided in two parts; the bottom part is used to enter commands
in scroll mode while the top part displays output.
.br
By default,
.BR msgd (l) 
is executed every ten seconds.
.SH COMMANDS
.LP
.RS
.TP 1.5i
.BI ref " delay"
Changes the interval between two calls to the command to 
.I delay.
.TP
.B ex, exit
Exits the 
.B oper 
command.
.TP
.BR \+ " or "  "space bar"
Displays the next screen.
.TP
.B -
Displays the previous screen.
.RE
The other commands are divided into three categories defined by the configuration
file /etc/OPERCONFIG:

.RS
Commands to be executed at regular intervals (refresh mode) like
.BR msgd.

Commands to be executed once, without changing the periodically refreshed
command. The output is done on the last line of the screen.
.B rep
to reply to a message belongs to this category.

To execute any command not defined in the configuration file, the 
.B oper
windows are suppressed. To resume normal operation, press carriage return.
Note that commands getting full control of the screen, such as 
.B vi,
should not be called.
.RE
.SH FILE
Here is an example of a configuration file:

.RS
#
.br
# configuration file for oper display
.br
#
.br
# commands to be executed in refresh mode
.br
infd		r
.br
msgd		r
.br
ps		r
.br
qstat		r
.br
tmstat		r
.br
tpstat		r
.br
# commands to be executed once
.br
rep		1
.br
tpconfig		1
.br
notms		1
.br
tmsactive	1
.RE
.SH SEE ALSO
.BR msgd (l), 
.BR msgr (l),
.BR rep (l)
.SH AUTHOR
Antoine Trannoy, CERN-CN Division CH-1211 Geneva 23, Switzerland
(trannoy@cernvm.cern.ch)
