.\" @(#)msgdaemon.man	1.2         CERN-SW/DC      Antoine Trannoy         11/28/97
.\" Copyright (C) 1990-1997 by CERN/CN/SW/DC
.\" All rights reserved
.\"
.TH MSGDAEMON l "11/28/97"
.SH NAME
msgdaemon \- Starts message daemon
.SH SYNOPSIS
.B /usr/local/bin/msgdaemon
[
.BI -d
][
.BI \-p " port"
]
.SH DESCRIPTION
The 
.B msgdaemon
is a server which handles message exchange between users and operators within
the 
.B shift 
complex. Through the 
.BR msgr (l)
command, users send messages to the operators who are replying
with the 
.BR rep (l)
command. Each message is kept in the message daemon until an operator 
has replied to its sender, or, this last one has canceled his message.
.PP
The message daemon is reached through 
.SM TCP/IP 
at the 
.SM MSG 
port specified in the 
.B /etc/services
file.
.B msgdaemon
log files must be defined in the
.B /etc/shift.conf
file.
.br
For example:

.RS
MSG	LOGI		/usr/tmp/msgi.log       # Informative message log file
.br
MSG	LOGR		/usr/tmp/msgr.log       # Active message log file 
.RE
.SH OPTIONS
.LP
.TP
.B \-d
Uses for debugging the daemon itself.
.TP
.BI \-p " port"
Specifies a specific port number to be used. 
.SH FILES
.PD 0
.TP 
.B /etc/services
.TP
.B /etc/shift.conf
.TP
.BR /usr/tmp/msgi.log\t "informative message log file."
.TP
.BR /usr/tmp/msgr.log\t "message and reply log file."
.PD
.SH SEE ALSO
.BR msgd (l), 
.BR msgr (l), 
.BR rep (l)
.SH AUTHOR
Antoine Trannoy, CERN-CN Division CH-1211 Geneva 23, Switzerland
(trannoy@cernvm.cern.ch)
