/*
 * Copyright (C) 1990-1998 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)msgdaemon.c	1.20 05/06/98 CERN CN-SW/DC Antoine Trannoy";
#endif /* not lint */

/* msgdaemon.c       SHIFT remote message daemon                             */

#include <stdio.h>
#if defined(sun) || defined(ultrix) || defined(sgi)
#include <unistd.h>
#endif	/* sun || ultrix || sgi */
#include <fcntl.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/time.h>
#include <time.h>

#include "msg.h"

/*
 * Process handling
 */
#if !defined(sgi) 
#include <sys/wait.h>
#endif	/* ! sgi */
#include <signal.h>
#if defined(apollo)
#define SIG_ERR (void(*)())-1
#endif	/* apollo */
/*
 * Networking.
 */

#define netread		dorecv
#define netwrite	dosend

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <marshall.h>

/*
 * Error and message handling.
 */
#include <errno.h>
#include <serrno.h>
#include <syslog.h>
#include <log.h>
extern void	perror() ; 
extern int 	errno ; 
#if !defined(linux)
extern char 	*sys_errlist[] ; 
#endif

/*
 * Options' flags.
 */
static int loglevel = LOG_INFO ; 		/* Default log level	*/
static char  logfile[128] = "" ; 		/* Log file name	*/
static int  	     debug = 0 ; 		/* Debuf flag 		*/
static int 	      port = 0 ;		/* Non-standard port	*/

/*
 * Message logging files.
 */
char msgifn[100] ;
char msgrfn[100] ;
int msgifd ; 
int msgrfd ; 

/*
 * Message buffer
 */
static char buffer[BUFSIZ] ;

extern int noterm();                    /* disassociate terminal        */

/* 
 * to avoid zombie creation, SIGCHLD signals 
 * have to be caught.
 */
#if !defined(sgi) 
void actionSIGCHLD()
{
#if !defined(_AIX) && !defined(SOLARIS) && !(defined(__osf__) && defined(__alpha))
	union wait	status ;

	for(;;) {
		if ( wait3(&status,WNOHANG,(struct rusage *)0) <= 0 ) 
			break ;
	}
#else
	int	status;

        wait (&status);
        signal (SIGCHLD, (void (*)())actionSIGCHLD);
#endif	/* ! AIX && ! SOLARIS && ! alpha osf */
}
#endif	/* ! sgi */

/*
 * Receive message in buffer.
 *
 */
static int rcvmsg(sock) 
	int sock ; 
{
	int  magic ;
	int   code ;
	int   size ; 
	char * ptr ;

	/*
	 * Getting header message.
	 */
	switch( netread(sock,buffer,LONGSIZE*3) ) { 
		case -1:
			log(LOG_ERR,"netread(): %s\n",sys_errlist[errno]) ; 
			return -1 ;
		case  0:
			serrno= SECONNDROP ;
			log(LOG_ERR,"netread(): %s\n",sstrerror(serrno)) ;
			return -1 ;
	}
	
	/* 
	 * Unmarshalling.
	 */
	ptr= buffer ; 
	unmarshall_LONG(ptr,magic) ; 
	unmarshall_LONG(ptr, code) ; 
	unmarshall_LONG(ptr, size) ; 

	if ( magic != MSG_MAGIC ) { 
		serrno= SEBADVERSION ;
		log(LOG_ERR,"rcvmsg(): %s\n",sstrerror(serrno)) ;
		return -1 ; 
	}

	/*
	 * Returns, if no body, the message type.
	 */
	if ( size == 0 ) 
		return code ; 

	/* 
	 * Getting message body.
	 */
	switch( netread(sock,buffer,size) ) {
		case -1:
			log(LOG_ERR,"netread(): %s\n",sys_errlist[errno]) ; 
			return -1 ;
		case  0:
			serrno= SECONNDROP ;
			log(LOG_ERR,"netread(): %s\n",sstrerror(serrno)) ;
			return -1 ;
	}

	/*
	 * No problem,
	 * sending back message type.
	 */
	return code ; 
}

/*
 * Processing MSGI request.
 */
static void domsgi(sock,from) 
	int 			  sock ; 	/* Connected socket 		*/
	struct sockaddr_in	* from ;	/* Client socket address 	*/
{
	extern time_t		time() ;	/* Extern declaration		*/
	time_t			 clock ;	/* To store time 		*/
	char			 * ptr ;	/* Pointer to buffer 		*/
	char 		   msg[MSGSIZ] ; 	/* Message 			*/

	/*
	 * Unmarshalling.
	 */
	ptr= buffer ;
	unmarshall_STRING(ptr,msg) ; 
	
	/* 
	 * Getting time
	 */
	(void) time(&clock) ; 

	/*
	 * Logging message.
	 */
	(void) strncpy(buffer,ctime(&clock),19) ;
	(void) sprintf(buffer+19,"  Message :  %s\n",msg) ;	
	if ( (msgifd= open(msgifn,O_WRONLY|O_CREAT|O_APPEND,0666)) < 0 ) {
		log(LOG_ERR,"open(): %s\n",sys_errlist[errno]) ; 
	} 
	(void) write(msgifd,buffer,strlen(buffer)) ; 
	(void) close(msgifd);

	/*
	 * Storing Data in the DataBase
	 * Arguments are :
	 * + Time of the request.
	 * + Message of the request.
	 */
	 (void) addmsgi(clock,msg) ;

	/* 
	 * Acknowledging the request.
	 */
	ptr= buffer ; 
	marshall_LONG(ptr,MSG_MAGIC) ; 
	marshall_LONG(ptr,ACKN_MSGI) ; 
	marshall_LONG(ptr,0) ;
	switch( netwrite(sock,buffer,3*LONGSIZE) ) {
		case -1:
			log(LOG_ERR,"netwrite(): %s\n",sys_errlist[errno]) ; 
			return  ; 
		case  0:
			serrno= SECONNDROP ;
			log(LOG_ERR,"netwrite(): %s\n",sstrerror(serrno)) ;
			return  ; 
	}
	return ;
}

/*
 * Processing MSGR request.
 */
static void domsgr(sock,from)
	int 			  sock ; 	/* Connected socket 		*/
	struct sockaddr_in	* from ;	/* Client socket address 	*/
{
	int			 asock ;	/* Answering socket		*/
	int			 rport ;	/* reply port			*/
	static int  	      index= 0 ;	/* Index of the request		*/ 
	int		    identifier ;	/* For sender private use	*/
	extern time_t		time() ;	/* Extern declaration		*/
	time_t			 clock ;	/* To store time 		*/
	char			 * ptr ;	/* Pointer to buffer 		*/
	char 		   msg[MSGSIZ] ; 	/* Message 			*/

	/*
	 * Unmarshalling.
	 */
	ptr= buffer ;
	unmarshall_LONG(ptr,rport) ; 
	from->sin_port= htons(rport);
	unmarshall_LONG(ptr,identifier) ; 
	unmarshall_STRING(ptr,msg) ; 
	
	/*
	 * Incrementing the index counter.
	 */
	index ++ ;

	/* 
	 * Getting time
	 */
	(void) time(&clock) ; 

	/*
	 * Logging message.
	 */
	(void) strncpy(buffer,ctime(&clock),19) ;
	(void) sprintf(buffer+19,"  Message %4d:  %s\n",index,msg) ;	
	if ( (msgrfd= open(msgrfn,O_WRONLY|O_CREAT|O_APPEND,0666)) < 0 ) {
		log(LOG_ERR,"open(): %s\n",sys_errlist[errno]) ; 
	} 
	(void) write(msgrfd,buffer,strlen(buffer)) ; 
	(void) close(msgrfd) ;

	/*
	 * Storing data in the DataBase.
	 * Arguments are :
	 * + Index of the request.
	 * + Time of the request.
	 * + Reply address.
	 * + Message of the request.
	 */
	if ( addmsgr(index,identifier,clock,msg,from) == -1 ) 
		index= -1 ; 

	/* 
	 * Acknowledging the request
	 * on return port.
	 */
	if ( (asock= socket(AF_INET,SOCK_STREAM,0)) == -1 ) {
		log(LOG_ERR,"socket(): %s\n",sys_errlist[errno]) ; 
		(void) delmsgr(index) ; 
		return  ; 
	}
	if ( connect(asock,(struct sockaddr *)from,sizeof(struct sockaddr_in)) == -1 ) {
		log(LOG_ERR,"connect(): %s\n",sys_errlist[errno]) ; 
		(void) close(asock) ; 
		(void) delmsgr(index) ; 
		return  ; 
	}
	ptr= buffer ; 
	marshall_LONG(ptr,MSG_MAGIC) ; 
	marshall_LONG(ptr,ACKN_MSGR) ; 
	marshall_LONG(ptr, 2*LONGSIZE) ;
	marshall_LONG(ptr,identifier) ; 
	marshall_LONG(ptr, index ) ;
	switch( netwrite(asock,buffer,5*LONGSIZE) ) {
		case -1:
			log(LOG_ERR,"netwrite(): %s\n",sys_errlist[errno]) ; 
			(void) delmsgr(index) ; 
			break ; 
		case  0:
			serrno= SECONNDROP ;
			log(LOG_ERR,"netwrite(): %s\n",sstrerror(serrno)) ;
			(void) delmsgr(index) ; 
			break ; 
	}
	(void) close(asock) ; 
	return ;
}

/*
 * Processing CANCEL requests.
 * No acknowledgment are performed.
 */
static void docancel(sock,from) 
	int 			  sock ; 	/* Connected socket 		*/
	struct sockaddr_in	* from ;	/* Client socket address 	*/
{
	int			   num ; 	/* Request index to cancel	*/
	char			 * ptr ;	/* Pointer to the buffer 	*/

	/*
	 * Unmarshalling.
	 */
	ptr= buffer ;
	unmarshall_LONG(ptr,num) ; 

	/*
	 * Deleting message in the DataBase.
	 */
	if ( delmsgr(num) == -1 ) 
		log(LOG_ERR,"message number %d not found\n",num) ; 
}

/*
 * Sending acknowledgment to reply message.
 */
static void acknreply(sock,rcode)
	int 	  sock ; 	/* Connected socket 	*/
	int	 rcode ;	/* Return code		*/
{
	char     * ptr ;	/* Pointer to buffer	*/

	ptr= buffer ; 
	marshall_LONG(ptr,MSG_MAGIC) ; 
	marshall_LONG(ptr,ACKN_REPL) ; 
	marshall_LONG(ptr, LONGSIZE) ;
	marshall_LONG(ptr, rcode ) ;
	switch( netwrite(sock,buffer,4*LONGSIZE) ) {
		case -1:
			log(LOG_ERR,"netwrite(): %s\n",sys_errlist[errno]) ; 
			break ;
		case  0:
			serrno= SECONNDROP ;
			log(LOG_ERR,"netwrite(): %s\n",sstrerror(serrno)) ;
			break ; 
	}
}
	
/*
 * Processing REPLY requests.
 */
static void doreply(sock,from)
	int 			  sock ; 	/* Connected socket 		*/
	struct sockaddr_in	* from ;	/* Operator socket address 	*/
{
	int			 index ; 	/* Request index to cancel	*/
	int		    identifier ;	/* Sender private identifier	*/
	extern time_t		time() ;	/* Extern declaration		*/
	time_t			 clock ;	/* To store time 		*/
	struct sockaddr_in	  addr ;	/* Client socket address 	*/
	char 		   	 * msg ; 	/* Pointer to the message	*/
	char			 * ptr ;	/* Pointer to the buffer 	*/
	int 			 csock ;	/* Client socket identifier	*/
	int      		  size ;	/* Size of the message		*/
	int 		authorized = 0 ; 	/* boolean 			*/
	FILE *fs ;
	char buf[100] ;
	int compar ;
        struct hostent       * hp ;     /* Client host structure        */
	char *client ;			/* Host name of requestor 	*/

	/*
	 * Unmarshalling.
	 * WARNING !!! VERY DIRTY CODE !!!
	 */
	ptr= buffer ;
	unmarshall_LONG(ptr,index) ; 
	if ( (msg= ( char *) malloc(strlen(ptr)+1)) == NULL ) {
		log(LOG_ERR,"malloc(): %s\n",sys_errlist[errno]) ; 
		acknreply(sock,-SEMSGSYERR) ;
		return ; 
	}

/*
 * Checking if request comes from an authorized host
 */

        /*
         * Getting client host name.
         */
        hp= gethostbyaddr((char *)(&from->sin_addr),sizeof(struct in_addr),from->sin_family) ;
        if ( hp == NULL )
                client= inet_ntoa(from->sin_addr) ;
        else
                client= hp->h_name ;

        if (  ( fs = fopen(MSGAUTH_HOSTS, "r") ) == NULL ) {
                log(LOG_ERR,"File %s does not exist. Any host is accepted\n",MSGAUTH_HOSTS);
                authorized=1;
         }
         else {
                while( fscanf(fs, "%s%*[^\n]\n", buf) != EOF ) {
                      if( buf[0] !='#' ){
                                        compar = strcmp(buf, client );
                                        if (  compar ==0 )
                                                authorized=1;
                                        if ( !strcmp(buf,"any")) {
                                                authorized=1;
                                                log(LOG_INFO,"File %s is authorizing any host\n",MSGAUTH_HOSTS);
                                        }
                      }
                }
          	fclose(fs);
        }
	if ( !authorized ) {
		log(LOG_INFO,"host %s not authorized to reply\n",client);
		acknreply(sock,-SENOPERM) ;
		return ;
	}

	unmarshall_STRING(ptr,msg) ; 

	/*
	 * Logging reply.
	 */
	(void) time(&clock) ; 
	(void) strncpy(buffer,ctime(&clock),19) ;
	(void) sprintf(buffer+19,"  Reply   %4d:  %s\n",index,msg) ;	
	if ( (msgrfd= open(msgrfn,O_WRONLY|O_CREAT|O_APPEND,0666)) < 0 ) {
		log(LOG_ERR,"open(): %s\n",sys_errlist[errno]) ; 
	} 
	(void) write(msgrfd,buffer,strlen(buffer)) ; 
	(void) close(msgrfd) ;
	
	/*
	 * Getting message sender address and 
	 * discarding message from DataBase.
	 */
	if ( addrmsgr(index,&identifier,&addr) == -1 ) {
		acknreply(sock,-SEMSGINVRNO) ;	/* Invalid reply number	*/
		return ; 
	}

	/*
	 * Setting up interrupt handler
	 * to avoid zombie creations. 
	 */
#if defined(sgi) 
	if ( signal(SIGCLD,SIG_IGN) == SIG_ERR ) {
		perror("signal()") ;
		exit(1) ;
	}
#else
	if ( signal(SIGCHLD,(void (*)())actionSIGCHLD) == SIG_ERR ) {
		perror("signal()") ;
		exit(1) ;
	}
#endif	/* sgi 	*/

	/*
	 * Sending the reply to the client
	 * A process is spawned since it can 
	 * be long ( ie connection time out)
	 */
	switch(fork()) {
		case -1:
			log(LOG_ERR,"fork(): %s\n",sys_errlist[errno]) ; 
			acknreply(sock,-SEMSGSYERR) ;
			return ; 
		case  0:
			if (( csock= socket(AF_INET,SOCK_STREAM,0)) == -1 ) {
				log(LOG_ERR,"socket(): %s\n",sys_errlist[errno]) ;
				acknreply(sock,-SEMSGSYERR) ;
				exit(0) ; 
			}
			if ( connect(csock,(struct sockaddr *)&addr,sizeof(addr)) == -1 ){
				log(LOG_ERR,"connect(): %s\n",sys_errlist[errno]) ;
				(void) close(csock) ;
				acknreply(sock,-SEMSGU2REP) ;
				exit(0) ; 
			}
			ptr= buffer ; 
			size= 2*LONGSIZE+1+strlen(msg) ;
			marshall_LONG(ptr,MSG_MAGIC) ; 
			marshall_LONG(ptr,GIVE_REPL) ; 
			marshall_LONG(ptr, size) ;
			marshall_LONG(ptr,identifier) ;
			marshall_LONG(ptr,index) ;
			marshall_STRING(ptr,msg) ;
			switch( netwrite(csock,buffer,3*LONGSIZE+size) ) {
				case -1:
					log(LOG_ERR,"netwrite(): %s\n",sys_errlist[errno]) ; 
					(void) close(csock) ;
					acknreply(sock,-SEMSGU2REP) ;
					exit(0) ; 
				case  0:
					serrno= SECONNDROP ;
					log(LOG_ERR,"netwrite(): %s\n",sstrerror(serrno)) ;
					(void) close(csock) ;
					acknreply(sock,-SEMSGU2REP) ;
					exit(0) ; 
				default:
					(void) close(csock) ;
					acknreply(sock,0) ;
					exit(0) ;
			}
		default:
			/*
			 * going back to the main loop.
			 */
			return ; 
	}
}

/*
 * Sending to operator all the messages waiting 
 * for an answer.
 */
static void dogetr(sock,from)
	int 			  sock ; 	/* Connected socket 		*/
	struct sockaddr_in	* from ;	/* Operator socket address 	*/
{
	int			 count ;	/* Number of messages		*/
	int 			     i ;	/* Loop counter			*/
	char			 * ptr ;	/* Pointer to the buffer 	*/
	
	/*
	 * Sending first of all the number
	 * of messages which are going to be sent
	 */
	ptr= buffer ;
	count= msgrnum() ;
	marshall_LONG(ptr,MSG_MAGIC) ; 
	marshall_LONG(ptr,ACKN_GETR) ; 
	marshall_LONG(ptr, LONGSIZE) ;
	marshall_LONG(ptr,count) ;
	switch( netwrite(sock,buffer,4*LONGSIZE) ) {
		case -1:
			log(LOG_ERR,"netwrite(): %s\n",sys_errlist[errno]) ; 
			return ; 
		case  0:
			serrno= SECONNDROP ;
			log(LOG_ERR,"netwrite(): %s\n",sstrerror(serrno)) ;
			return ; 
	}
	
	/*
	 * Sending all the messages.
	 */
	setmsgrlist() ;
	for(i=0; i<count; i++) {
		int 	 index ;	/* Index of the current message	*/
		time_t 	  time ;	/* Time of the current message	*/
		char 	 * msg ; 	/* Pointer to the message	*/
	
		getmsgrent(&index,&time,&msg) ; 
		ptr= buffer ;
		marshall_LONG(ptr,index) ;
		marshall_LONG(ptr,(long)time) ;
		marshall_LONG(ptr,strlen(msg)+1) ;
		marshall_STRING(ptr,msg) ;	
		switch( netwrite(sock,buffer,3*LONGSIZE+1+strlen(msg)) ) {
			case -1:
				log(LOG_ERR,"netwrite(): %s\n",sys_errlist[errno]) ; 
				return ; 
			case  0:
				serrno= SECONNDROP ;
				log(LOG_ERR,"netwrite(): %s\n",sstrerror(serrno)) ;
				return ; 
		}
	}
}

/*
 * Sending to an operator all the 
 * informative messages pending.
 */
static void dogeti(sock,from)
	int 			  sock ; 	/* Connected socket 		*/
	struct sockaddr_in	* from ;	/* Operator socket address 	*/
{
	int			 count ;	/* Number of messages		*/
	int 			     i ;	/* Loop counter			*/
	char			 * ptr ;	/* Pointer to the buffer 	*/
	
	/*
	 * Sending first of all the number
	 * of messages which are going to be sent
	 */
	ptr= buffer ;
	count= msginum() ;
	marshall_LONG(ptr,MSG_MAGIC) ; 
	marshall_LONG(ptr,ACKN_GETI) ; 
	marshall_LONG(ptr, LONGSIZE) ;
	marshall_LONG(ptr,count) ;
	switch( netwrite(sock,buffer,4*LONGSIZE) ) {
		case -1:
			log(LOG_ERR,"netwrite(): %s\n",sys_errlist[errno]) ; 
			return ; 
		case  0:
			serrno= SECONNDROP ;
			log(LOG_ERR,"netwrite(): %s\n",sstrerror(serrno)) ;
			return ; 
	}
	
	/*
	 * Sending all the messages, and,
	 * removing them from the list.
	 */
	for(i=0; i<count; i++) {
		time_t 	     time ;	/* Time of the current message	*/
		char  msg[MSGSIZ] ; 	/* Pointer to the message	*/
	
		remmsgient(&time,msg) ; 
		ptr= buffer ;
		marshall_LONG(ptr,(long)time) ;
		marshall_LONG(ptr,strlen(msg)+1) ;
		marshall_STRING(ptr,msg) ;	
		switch( netwrite(sock,buffer,2*LONGSIZE+1+strlen(msg)) ) {
			case -1:
				log(LOG_ERR,"netwrite(): %s\n",sys_errlist[errno]) ; 
				return ; 
			case  0:
				serrno= SECONNDROP ;
				log(LOG_ERR,"netwrite(): %s\n",sstrerror(serrno)) ;
				return ; 
		}
	}
}

/*
 * Listening on dedicated socket.
 */
static int listening() 
{
	char localhost[MAXHOSTNAMELEN] ;	/* Local host name	*/
	struct servent 		  * sp ;	/* Server entity	*/ 	
	struct sockaddr_in	   sin ;	/* Internet address	*/
	int 			  sock ; 	/* socket identifier	*/

	/*
	 * Getting hostname.
	 */
	if (gethostname(localhost,sizeof(localhost)))   {
		log(LOG_ERR, "gethostname(): %s\n",sys_errlist[errno]);
		return -1 ; 
	}

	/*
	 * Creating socket.
	 */
	if ((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0)  {
		log(LOG_ERR, "socket(): %s\n",sys_errlist[errno]);
		return -1 ; 
	}
		
	/*
	 * Finding port number.
	 */
	if (!port) {
		sp = getservbyname("msg", "tcp");
		if (sp == NULL) {
			serrno = SENOSSERV;
			log(LOG_ERR,"getservbyname(msg,tcp): %s\n",sstrerror(serrno));
			return -1 ; 
		}
		sin.sin_port = sp->s_port;
	}
	else    {
		sin.sin_port = htons(port);
	}

	/*
	 * Binding socket.
	 */
	sin.sin_addr.s_addr = htonl(INADDR_ANY);
	sin.sin_family = AF_INET;
	if (bind(sock, (struct sockaddr *)&sin, sizeof(sin)) < 0) {
		log(LOG_ERR, "bind(): %s\n",sys_errlist[errno]);
		return -1 ; 
	}

	/*
	 * Listening on socket.
	 */
	listen(sock, 5);

	/*
	 * Returning socket identifier.
	 */
	return sock ; 
}

/*
 * Body of the server.
 */
main(argc,argv)
	int    argc ; 
	char **argv ;
{
	int sock ;				/* Socket identifier	*/	

	register int        option ;		/* To parse options	*/
	extern   int        opterr ; 		/* required by getopt(3)*/
	extern   int  	    optind ;	        /* required by getopt(3)*/
	extern   char     * optarg ;            /* required by getopt(3)*/
	extern char * getconfent() ;		/* external declaration	*/
	char 		   * fname ;		/* pointer to file name	*/

	/* 
	 * Getting options.
	 */
	while ((option = getopt(argc,argv,"df:p:")) != EOF)        {
		switch (option) {
			case 'd': debug++;
				loglevel= LOG_DEBUG ; 
				break;
			case 'f':
				(void) strcpy(logfile,optarg) ; 
				break;
			case 'p':
				port=atoi(optarg);
				break;
		}
	}
	 
	if ( ! debug ) {
		/*
		 * Disassociating controlling terminal.
		 */
		if (noterm() == -1)     {
			syslog(LOG_ERR,"noterm(): initial fork failed: %s\n", 
				sys_errlist[errno]);
			exit(1);
		}
	}

	/*
	 * Initializing logging files.
	 */
	(void) initlog("msgd",loglevel,logfile) ; 
	if ( (fname= getconfent("MSG","LOGR",0)) == NULL ) {
		log(LOG_ERR,"getconf(MSG,LOGR,0): returned NULL\n") ;
		exit(1) ; 
	}
	strcpy(msgrfn,fname) ;
	if ( (fname= getconfent("MSG","LOGI",0)) == NULL ) {
		log(LOG_ERR,"getconf(MSG,LOGI,0): returned NULL\n") ;
		exit(1) ; 
	}
	strcpy(msgifn,fname) ;

	/* 
	 * Binding socket and starting to listen.
	 */
	if ( (sock= listening()) == -1 ) { 
		exit(1) ; 
	}

	/*
	 * Accepting and processing request.
	 */
	for (;;) {
		int 		    nsock ;	/* Socket identifier		*/
		struct sockaddr_in   from ; 	/* Internet socket address	*/
		int fromlen= sizeof(from) ;	/* Length of socket address	*/

		/*
		 * Accepting request.
		 */
		if ((nsock=accept(sock,(struct sockaddr*)&from,&fromlen)) == -1) {
			log(LOG_ERR,"accept(): %s\n",sys_errlist[errno]) ;
			if ( errno != EINTR ) {
				exit(1) ;
			}
			else {
				continue;
			}
		}

		/*
		 * Receiving message header
		 */
		switch( rcvmsg(nsock)) {
			/*
			 * Processing the request.
			 */
			case -1: 
				break ; 
			case RQST_MSGI:
				domsgi(nsock,&from) ;
				break ;
			case RQST_MSGR:	
				domsgr(nsock,&from) ;
				break ; 
			case RQST_CANC:
				docancel(nsock,&from) ;
				break ; 
			case RQST_REPL:
				doreply(nsock,&from) ;
				break ;
			case RQST_GETR:
				dogetr(nsock,&from) ;
				break ;
			case RQST_GETI:
				dogeti(nsock,&from) ;
				break ;
		}
		/*
		 * Closing the communication.
		 */
		(void) close(nsock) ; 
	}
	/*
	 * NOTREACHED
	 */
}
