/*
 * Copyright (C) 1990-1998 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)msgd.c	1.11 05/06/98 CERN CN-SW/DC Antoine Trannoy";
#endif /* not lint */

/* msgd.c		SHIFT getting all messages pending in message daemon */

#include <stdio.h>
#if ! defined(apollo)
#include <unistd.h>
#endif 	/* not apollo */
#include "msg.h"

#include <sys/types.h>
#include <time.h>
#include <sys/param.h>
#include <sys/stat.h>
#if defined(apollo)
#include <strings.h>
#else
#include <string.h>
#endif	/* apollo */

/*
 * Networking.
 */
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <marshall.h>

#define netread                 dorecv
#define netwrite                dosend

/*
 * Error and message handling.
 */
#include <errno.h>

#include <serrno.h>
#include <log.h>
extern int errno ;
extern int sys_nerr ;
extern void perror() ;
#if !defined(linux)
extern char *sys_errlist[] ;
#endif

/*
 * Printing msgr for operator.
 */
void printmsgr(column,index,time,msg) 
	int  column ;		/* Number of columns of the screen	*/
	int   index ;		/* Index of the msg to print		*/
	time_t time ;		/* Time at which the message was issued	*/
	char  * msg ;		/* Pointer to the message itself	*/
{
	struct tm * t ;		/* To format time.			*/
	char    * ptr ;

	t= localtime(&time) ;
	fprintf(stdout," %5d",index) ;
        if ( t->tm_hour < 10 )
                fprintf(stdout,"  0%1d:",t->tm_hour) ;
        else
                fprintf(stdout,"  %2d:",t->tm_hour) ;
        if ( t->tm_min < 10 )
                fprintf(stdout,"0%1d  ",t->tm_min) ;
        else
                fprintf(stdout,"%2d  ",t->tm_min) ;
	ptr= msg ;
	for(;;) {
		int      left ;	/* Number of characters left per line	*/

		left= column - 15 ;
		if ( (int)strlen(ptr) <= left ) {
			/*
			 * End of message fits on the line.
			 */
			fprintf(stdout,"%s\n",ptr) ;
			fflush(stdout) ;
			return ;
		}
		else	{
			/*
			 * Message does not fit 
			 * on a single line.
			 */
			if ( (int)strcspn(ptr," ") > left ) {
				/*
				 * A word has to be cut.
				 */
				char c ;

				c= ptr[left] ;
				ptr[left]= '\0' ;
				fprintf(stdout,"%s\n",ptr) ;
				ptr[left]= c ;
				ptr+= left ;
			}
			else	{
				while( (int)strcspn(ptr," ") <= left ) {
					char * blk ; 	/* Pointer to first blank  */

					blk= strpbrk(ptr," ") ;
					*blk= '\0' ;
					left-= strlen(ptr) ;
					if ( left ) {
						fprintf(stdout,"%s ",ptr) ;
						left -- ;
					}
					else	{
						fprintf(stdout,"%s",ptr) ;
					}
					ptr= blk+1 ;
				}	
				fprintf(stdout,"\n") ;
			}	
		}
		/*
		 * New line, and,
		 * margin for next line.
		 */
		fprintf(stdout,"               ") ;
	}
}

/*
 * Getting all messages waiting for a reply.
 */
main()
{
	char buffer[MSGSIZ+4*LONGSIZE];	/* Buffer		*/
	int 	       col ; 		/* Number of columns	*/
	int 	       row ;		/* Number of rows 	*/
	char 	     * ptr ;		/* Pointer to the buffer*/
	int   	      sock ;		/* Socket identifier	*/
	int	     count ;		/* Number of messages	*/
	int	         i ;		/* Loop index 		*/

	/*
	 * Getting number of columns of the window.
	 */
	if ( termwinsiz(&col,&row) == -1 ) {
		perror("command failed: termwinsiz()") ;
		exit(1) ;
	}

	if ( col < 30 ) {
		fprintf(stderr,"command failed: window too small\n") ;
		fflush(stderr) ;
		exit(1) ;
	}

	/*
	 * Connecting the daemon.
	 */
	if ( (sock= conmsgd()) == -1 ) {	
		sperror("command failed") ;
		exit(1) ;
	}

	/*
	 * Building the request.
	 */
	ptr= buffer ;
	marshall_LONG(ptr,MSG_MAGIC) ; 
	marshall_LONG(ptr,RQST_GETR) ; 
	marshall_LONG(ptr,0) ; 

	/*
 	 * Sending the request.
 	 */
	switch( netwrite(sock,buffer,3*LONGSIZE) ) {
		case  0:
			serrno= SECONNDROP ;
		case -1:
			(void) close(sock) ;
			sperror("command failed") ;
			exit(1) ;
	}

	/*
	 * Waiting for the answer.
	 */
	switch( rcvmsgd(sock,buffer)) {
		case -1:
			sperror("command failed") ; 
			(void) close(sock) ; 
			exit(1) ; 
		case ACKN_GETR:
			/*
			 * What we should get. 
			 */
			break ; 
		default:	
			serrno= SEINTERNAL ;
			sperror("command failed") ; 
			(void) close(sock) ; 
			exit(1) ; 
	}

	/*
	 * Printing header.
	 */
	fprintf(stdout," Msg #   Time  System Messages\n") ;
	fprintf(stdout," =====   ====  ===============\n\n") ;

	/*
	 * Receiving pending smsgr.
	 */
	ptr= buffer ;
	unmarshall_LONG(ptr,count) ; 
	for(i=0;i<count;i++) {
		char msg[MSGSIZ] ;	/* Buffer for msgr.			*/
		int 	   index ;	/* Index of the current pending msgr	*/
		time_t	    time ;	/* Time at which it was issued		*/
		int	    size ;	/* Size of the pending msgr		*/

		/*
		 * Receiving index,time and size.
		 */
		switch( netread(sock,buffer,LONGSIZE*3) ) {
			case 0:
				serrno= SECONNDROP ;
			case -1:
				sperror("command failed") ;
				(void) close(sock) ; 
				exit(1) ;
		}
		ptr= buffer ;
		unmarshall_LONG(ptr,index) ;
		unmarshall_LONG(ptr, time) ;
		unmarshall_LONG(ptr, size) ;

		/*
		 * Receiving message itself.
		 * Unmarshalling it.
		 */
		switch( netread(sock,buffer,size) ) {
			case 0:
				serrno= SECONNDROP ;
			case -1:
				sperror("command failed") ;
				(void) close(sock) ; 
				exit(1) ;
		}
		ptr= buffer ;
		unmarshall_STRING(ptr,msg) ;

		/*
		 * Printing...
		 */
		printmsgr(col,index,time,msg) ;
	}	
	exit(0) ;
}
