/*
 * @(#)u_signed64.h	1.1 11/04/98 CERN IT-PDP/DM Olof Barring
 */
 
/* static char SccsId[] = "include/u_signed64.h, gen, 3v2   3/5/98   13:47:15   "; */
/*  The Vesta Parallel File System
 *
 *  Designed and implemented by
 *
 *  Peter F. Corbett
 *  Dror G. Feitelson
 *
 *  IBM T. J. Watson Research Center
 *  P. O. Box 218
 *  Yorktown Heights, NY 10598
 *
 *  Code written beginning
 *  July 26, 1992.
 *
 *  This file is one of the include files used by Vesta.
 *
 *  Traceability:
 *       Version   Date       Description
 *       _______   ________   _______________________________________________ 
 *         1.0     02/18/93   Initial version
 *         1.2     06/21/94   Support div2x64m, div_cl2x64m, and mod2x64m
 *                            operations
 *                            Copyright statement update
 *         1.3     07/20/94   Add support for Intel (little endian).
 *         1.4     01/31/96   Added clrbit64m(), Fisher.
 *         4.1     05/10/96   AIX 4.1 upgrade: renamed unsigned64 to u_signed64
 *                            File name was also changed.
 *         4.2     01/29/97   Added port code changes
 *         4.3     06/13/97   Added CS_DEC64_LEN definition needed by FTP
 *			      clients and server for hpss_u64conv calls.
 *         4.4     06/20/97   Added CONVERT_U64_TO_LONGLONG and converse
 *			      CONVERT_LONGLONG_TO_U64 to convert HPSS unsigned64s
 *			      to long long and back.
 *	   4.5     07/09/97   Fixed CONVERT_LONGLONG_TO_U64 macro
 *         4.6     08/01/97   Deal with LITTLEEND BYTE8INT machines (Dec Alpha)
 *			      Restructured to handle 32 Bit Machines then 64 bit
 *			      machines.
 *         4.7     11/10/97   Fix mem64m for LITTLEEND BYTE8INT machines
 *         4.8     11/25/97   Change mem64m.
 *         4.9     03/05/98   Defined mem64() for BYTE8INT BIGEND Machines
 *
 *  Notes:
 *       Licensed Materials
 *
 *       (C) Copyright International Business Machines Corp. 1994
 *       (C) Copyright Martin Marietta Energy Systems, Inc. and
 *                     Oak Ridge National Laboratory 1994
 *                     under CRADA No. Y1293-0203
 *       (C) Copyright Regents of The University of California and
 *                     Lawrence Livermore National Laboratory 1994
 *                     under CRADA No. T-253-92-C (as modified by T-325-92-C)
 *       (C) Copyright Regents of The University of California and
 *                     Los Alamos National Laboratory 1994
 *                     under CRADA No. LA93C10085
 *       (C) Copyright Sandia Corporation and Sandia National Laboratories 1994
 *                     under CRADA No. SC93/01198
 *
 *       All rights reserved.
 *
 *       This file is IBM Confidential.
 *    
 */

/*
 * Vesta_arith64.h
 * ***************
 */

#ifndef _VESTA_ARITH64_H
#define	_VESTA_ARITH64_H

#include "hpss_types.h"

#define CS_DEC64_LEN 20		/* String length to print 2^64 as an integer */

#if !defined(BYTE8INT)

/*
 * Macros for 64 bit arithmetic.
 * These macros are required for computations on offsets and ids.
 */

/* 
 * This first group are just macros, and do not expand to function calls. 
 */

/* 
 * Comparisons. 
 */
#define gt64m(a1,a2) ( ( (a1).high > (a2).high) || ( ( (a1).high == (a2).high) && ( (a1).low > (a2).low) ) )
#define ge64m(a1,a2) ( !( ( (a1).high < (a2).high) || ( ( (a1).high == (a2).high) && ( (a1).low < (a2).low) ) ) )
#define eq64m(a1,a2) ( ( (a1).high == (a2).high) && ( (a1).low == (a2).low) )
#define neq64m(a1,a2) ( !( ( (a1).high == (a2).high) && ( (a1).low == (a2).low) ) )
#define le64m(a1,a2) ( !( ( (a1).high > (a2).high) || ( ( (a1).high == (a2).high) && ( (a1).low > (a2).low) ) ) )
#define lt64m(a1,a2) ( ( (a1).high < (a2).high) || ( ( (a1).high == (a2).high) && ( (a1).low < (a2).low) ) )
#define eqz64m(a)    ( ( (a).high == 0) && ( (a).low == 0) )
#define neqz64m(a)   ( ( (a).high != 0) || ( (a).low != 0) )

/* 
 * Add a2 to a1 destroying old a1. 
 */
#define inc64m(a1,a2) ( ( ( (~( (a1).low | (a2).low) ) < ( (a1).low & (a2).low) ) ? \
                          ( (a1).high += ( (a2).high + 1) ) : ( (a1).high += (a2).high) ), \
                        (a1).low += (a2).low, \
			(a1) )

/* 
 * Subtract a2 from a1 destroying old a1. 
 */
#define dec64m(a1,a2) ( ( ( (a2).low > (a1).low ) ? \
                          ( (a1).high -= ( (a2).high + 1) ) : ( (a1).high -= (a2).high) ), \
			(a1).low -= (a2).low, \
                        (a1) )

/* 
 * These are casting macros.  The cast64_2m takes a unsigned32 
 * source b and casts it into an already allocated u_signed64 
 * destination a. 
 */
#define cast32m(a)      ( (a).low)
#define cast64_2m(a,b) ( (a).h = 0, (a).l=(b) )

#define low32m(a)       ( (a).low)
#define high32m(a)      ( (a).high)
#define bld64m(a,b)     (bld64( (a),(b) ) )

/* 
 * or bit position b in unsigned 64 bit integer a 
 */
#define orbit64m(a,b)   (or64m( (a), shr64m( bld64m( 0x80000000, 0 ),(b) ) ) )

/* 
 * clear bit position b in unsigned 64 bit integer a 
 */

#define clrbit64m(a,b)  (and64m( (a), not64m(shr64m( bld64m(0x80000000,0),(b) ) ) ) )

/* 
 * and bit position b in unsiqned 64 bit integer a 
 */
#define andbit64m(a,b)  (and64m( (a), shr64m( bld64m( 0x80000000, 0 ),(b) ) ) )

/* 
 * return 1 if bit position b is set in unsigned integer a 
 */
#define chkbit64m(a,b)  (!eqz64m( andbit64m( (a), (b) ) ) )

/* 
 * Add, and subtract macros that take three arguments.  The macros 
 * are equivalent to a = b op c.  The arguments of these macros 
 * should not be nested invocations of mul64m, div64m, or div_cl64m, 
 * as this would cause multiple calls to the corresponding functions. 
 */

#define add64_3m(a,b,c)	( (a)=(b),inc64m( (a),(c) ) )
#define sub64_3m(a,b,c)	( (a)=(b),dec64m( (a),(c) ) )

/* 
 * Shift a, destroying old a. 
 */

#define shr64_ipm(a,s)	( ( ( (s) >= 64 ) ? \
                            ( (a).low = 0, (a).high = 0 ) : \
                            ( ( (s) >= 32 ) ? \
                              ( (a).low = (a).high >> ( (s)-32), (a).high = 0 ) : \
			      ( (a).low = ( (a).low >> (s) ) | ( (a).high << (32-(s) ) ), (a).high = (a).high >> (s) ) \
                            ) \
                          ), (a) \
                        )

#define shl64_ipm(a,s)	( ( ( (s) >= 64) ? \
                            ( (a).high = 0, (a).low = 0) : \
                            ( ( (s) >= 32) ? \
                              ( (a).high = (a).low << ( (s)-32), (a).low = 0) : \
			      ( (a).high = ( (a).high << (s) ) | ( (a).low >> (32-(s) ) ), (a).low = (a).low << (s) ) \
                            ) \
                          ), (a) \
                        )

/* 
 * Shift macros that take three arguments.  The macros are equivalent
 * to a = b op c.  The arguments of these macros should not be nested
 * invocations of mul64m, div64m, or div_cl64m, as this would cause 
 * multiple calls to the corresponding functions. 
 */

#define shr64_3m(a,b,s) ( (a)=(b),shr64_ipm( (a),(s) ) )
#define shl64_3m(a,b,s) ( (a)=(b),shl64_ipm( (a),(s) ) )

/* 
 * These macros are substituted for by 64 bit integer functions, or
 * simply by arithmetic expressions in a 64 bit machine. 
 */

#define cast64m(a)       (cast64( (a) ) )

#define mem64m(a)	 (mem64( (unsigned char *)(a) ) )

#define add64m(a1,a2)    (add64( (a1),(a2) ) )
#define sub64m(a1,a2)    (sub64( (a1),(a2) ) )
#define mul64m(a1,a2)    (mul64( (a1),(a2) ) )
#define div64m(a1,a2)    (div64( (a1),(a2) ) )
#define div2x64m(a1,a2)    (div2x64( (a1),(a2) ) )
#define div_cl64m(a1,a2) (div_cl64( (a1),(a2) ) )
#define div_cl2x64m(a1,a2) (div_cl2x64( (a1),(a2) ) )
#define mod64m(a1,a2)    (mod64( (a1),(a2) ) )
#define mod2x64m(a1,a2)    (mod2x64( (a1),(a2) ) )
#define shr64m(a1,a2)    (shr64( (a1),(a2) ) )
#define shl64m(a1,a2)    (shl64( (a1),(a2) ) )
#define and64m(a1,a2)    (and64( (a1),(a2) ) )
#define or64m(a1,a2)     (or64( (a1),(a2) ) )
#define not64m(a)        (not64( (a) ) )

/* 
 * These 3 argument macros are fast if using 32 bit arithmetic.
 * They are of the form a = b op c.  They should not be nested.
 * i.e. any macro that resolves to a function call should not be
 * used as an argument to one of these macros. 
 */
#define mul64_3m(a,b,c) ( ( ( (b).high == 0) && ( ( (b).low * (c) ) / (c) == (b).low) ) ? \
                          ( (a).high = 0, (a).low = (b).low * (c), (a) ) : \
                          ( (a) = mul64m ( (b), (c) ) ) \
                        )

#define div64_3m(a,b,c) ( ( (b).high == 0 ) ? \
                          ( (a).high = 0, (a).low = (b).low / (c), (a) ) : \
                          ( (a) = div64m ( (b), (c) ) ) \
                        )

#define div2x64_3m(a,b,c) ( ( ( (b).high == 0 ) && ( (c).high == 0 ) ) ? \
                            ( (a).high = 0, (a).low = (b).low / (c).low, (a) ) : \
                            ( (a) = div2x64m ( (b), (c) ) ) \
                          )

#define mod64_3m(a,b,c) ( ( (b).high == 0 ) ? \
                          ( (a).high = 0, (a).low = (b).low % (c), (a) ) : \
                          ( (a) = mod64m ( (b), (c) ) ) \
                        )

#define mod2x64_3m(a,b,c) ( ( ( (b).high == 0 ) && ( (c).high == 0 ) ) ? \
                            ( (a).high = 0, (a).low = (b).low % (c).low, (a) ) : \
                            ( (a) = mod2x64m ( (b), (c) ) ) \
                          )

#define div_cl64_3m(a,b,c) ( ( (b).high == 0 ) ? \
                             ( (a).high = 0, (  ( (b).low % (c) == 0 ) ? \
                                             ( (a).low = (b).low / (c) ) : \
                                             ( (a).low = ( (b).low / (c) ) + 1) \
                                          ), (a) ) : \
                             ( (a) = div_cl64 ( (b), (c) ) ) \
                           )

#define div_cl2x64_3m(a,b,c) ( ( ( (b).high == 0 ) && ( (c).high == 0 ) ) ? \
                               ( (a).high = 0, (  ( (b).low % (c).low == 0 ) ? \
                                               ( (a).low = (b).low / (c).low ) : \
                                               ( (a).low = ( (b).low / (c).low) + 1) \
                                            ), (a) ) : \
                               ( (a) = div_cl2x64 ( (b), (c) ) ) \
                             )

/*
 * Function prototypes for 64 bit arithmetic.
 */

u_signed64	cast64( unsigned32 n );
u_signed64	bld64( unsigned32 high,unsigned32 low );
u_signed64	mem64(unsigned char *mem);
int		gt64(  u_signed64 a1, u_signed64 a2 );
int		ge64(  u_signed64 a1, u_signed64 a2 );
int		eq64(  u_signed64 a1, u_signed64 a2 );
int 		neq64( u_signed64 a1, u_signed64 a2 );
int		le64(  u_signed64 a1, u_signed64 a2 );
int 		lt64(  u_signed64 a1, u_signed64 a2 );
u_signed64	add64( u_signed64 a1, u_signed64 a2 );
u_signed64	sub64( u_signed64 a1, u_signed64 a2 );
u_signed64	mul64( u_signed64 m1, unsigned32 m2 );
u_signed64	div64( u_signed64 n,  unsigned32 d  );
u_signed64	div2x64( u_signed64 n, u_signed64 d );
u_signed64	div_cl64( u_signed64 n, unsigned32 d );
u_signed64	div_cl2x64( u_signed64 n, u_signed64 d );
u_signed64	mod64( u_signed64 n,  unsigned32 d  );
u_signed64	mod2x64( u_signed64 n,  u_signed64 d  );
u_signed64	shr64( u_signed64 n,  unsigned32 s  );
u_signed64	shl64( u_signed64 n,  unsigned32 s  );
u_signed64	and64( u_signed64 a1, u_signed64 a2 );
u_signed64	or64(  u_signed64 a1, u_signed64 a2 );
u_signed64	not64( u_signed64 a );

#else	/* BYTE8INT */

#if !defined(unicos) && !defined(__ALPHA__)
typedef unsigned	u_signed64;
#endif /* unicos && __ALPHA__ */

/*
 * Macros for 64 bit arithmetic.
 * These macros are required for computations on offsets and ids.
 */

/* 
 * This first group are just macros, and do not expand to function calls. 
 */

/* 
 * Comparisons. 
 */
#define gt64m(a1,a2) ( (a1) > (a2) )
#define ge64m(a1,a2) ( (a1) >= (a2) )
#define eq64m(a1,a2) ( (a1) == (a2) )
#define neq64m(a1,a2) ( (a1) != (a2) )
#define le64m(a1,a2) ( (a1) <= (a2) )
#define lt64m(a1,a2) ( (a1) < (a2) )
#define eqz64m(a)    ( (a) == 0)
#define neqz64m(a)   ( (a) != 0)

/* 
 * Add a2 to a1 destroying old a1. 
 */
#define inc64m(a1,a2) ( (a1) += (a2) )

/* 
 * Subtract a2 from a1 destroying old a1. 
 */
#define dec64m(a1,a2) ( (a1) -= (a2) )

#define cast32m(a)   ( (a) & 0xFFFFFFFF)
#define low32m(a)    ( (a) & 0xFFFFFFFF)
#define high32m(a)   ( (a) >> 32)
#define bld64m(a,b)  (bld64( (a),(b) ) )

/* 
 * or bit position b in unsigned 64 bit integer a 
 */
#define orbit64m(a,b)   (or64m( (a), shr64m( bld64m( 0x80000000, 0 ),(b) ) ) )

/* 
 * clear bit position b in unsigned 64 bit integer a 
 */

#define clrbit64m(a,b)  (and64m( (a), not64m(shr64m( bld64m(0x80000000,0),(b) ) ) ) )

/* 
 * and bit position b in unsiqned 64 bit integer a 
 */
#define andbit64m(a,b)  (and64m( (a), shr64m( bld64m( 0x80000000, 0 ),(b) ) ) )

/* 
 * return 1 if bit position b is set in unsigned integer a 
 */
#define chkbit64m(a,b)  (!eqz64m( andbit64m( (a), (b) ) ) )

#define mem64m(a)	 (mem64( (unsigned char *)(a) ) )

/* 
 * Add, and subtract macros that take three arguments.  The macros
 * are equivalent to a = b op c.  The arguments of these macros 
 * should not be nested invocations of mul64m, div64m, or div_cl64m, 
 * as this would cause multiple calls to the corresponding
 * functions. 
 */

#define add64_3m(a,b,c)	( (a)=(b)+(c) )
#define sub64_3m(a,b,c)	( (a)=(b)-(c) )

/* 
 * Shift a, destroying old a. 
 */

#define shr64_ipm(a,s)	( (a) >>= (s) )

#define shl64_ipm(a,s)	( (a) <<= (s) )

/* 
 * Shift macros that take three arguments.  The macros are equivalent
 * to a = b op c.  The arguments of these macros should not be nested
 * invocations of mul64m, div64m, or div_cl64m, as this would cause
 * multiple calls to the corresponding functions. 
 */

#define shr64_3m(a,b,s) ( (a)=(b) >> (c) )
#define shl64_3m(a,b,s) ( (a)=(b) << (c) )

/* 
 * These macros are substituted for by 64 bit integer functions, or
 * simply by arithmetic expressions in a 64 bit machine. 
 */

#define cast64m(a)       (cast64( (a) ) )
#define add64m(a1,a2)    (add64( (a1),(a2) ) )
#define sub64m(a1,a2)    (sub64( (a1),(a2) ) )
#define mul64m(a1,a2)    (mul64( (a1),(a2) ) )
#define div64m(a1,a2)    (div64( (a1),(a2) ) )
#define div2x64m(a1,a2)    (div2x64( (a1),(a2) ) )
#define div_cl64m(a1,a2) (div_cl64( (a1),(a2) ) )
#define div_cl2x64m(a1,a2) (div_cl2x64( (a1),(a2) ) )
#define mod64m(a1,a2)    (mod64( (a1),(a2) ) )
#define mod2x64m(a1,a2)    (mod2x64( (a1),(a2) ) )
#define shr64m(a1,a2)    (shr64( (a1),(a2) ) )
#define shl64m(a1,a2)    (shl64( (a1),(a2) ) )
#define and64m(a1,a2)    (and64( (a1),(a2) ) )
#define or64m(a1,a2)     (or64( (a1),(a2) ) )
#define not64m(a)        (not64( (a) ) )

/* 
 * These 3 argument macros are fast if using 32 bit arithmetic.
 * They are of the form a = b op c.  They should not be nested.
 * i.e. any macro that resolves to a function call should not be
 * used as an argument to one of these macros. 
 */
#define mul64_3m(a,b,c) ( (a) = (b) * (c) )

#define div64_3m(a,b,c) ( (a) = (b) / (c) )

#define mod64_3m(a,b,c) ( (a) = (b) % (c) )

#define div_cl64_3m(a,b,c) ( (a) = div_cl64( (b),(c) ) )

/*
 * Function prototypes for 64 bit arithmetic.
 */

u_signed64	cast64( unsigned32 n );
u_signed64	bld64( unsigned32 high,unsigned32 low );
u_signed64  mem64( unsigned char * a1 );
int	gt64(  u_signed64 a1, u_signed64 a2 );
int	ge64(  u_signed64 a1, u_signed64 a2 );
int	eq64(  u_signed64 a1, u_signed64 a2 );
int 	neq64( u_signed64 a1, u_signed64 a2 );
int	le64(  u_signed64 a1, u_signed64 a2 );
int 	lt64(  u_signed64 a1, u_signed64 a2 );
u_signed64  add64( u_signed64 a1, u_signed64 a2 );
u_signed64  sub64( u_signed64 a1, u_signed64 a2 );
u_signed64  mul64( u_signed64 m1, unsigned32 m2 );
u_signed64  div64( u_signed64 n,  unsigned32 d  );
u_signed64  div2x64( u_signed64 n,  u_signed64 d  );
u_signed64  div_cl64( u_signed64 n, unsigned32 d );
u_signed64  div_cl2x64( u_signed64 n, u_signed64 d );
u_signed64  mod64( u_signed64 n,  unsigned32 d  );
u_signed64  mod2x64( u_signed64 n,  u_signed64 d  );
u_signed64  shr64( u_signed64 n,  unsigned32 s  );
u_signed64  shl64( u_signed64 n,  unsigned32 s  );
u_signed64  and64( u_signed64 a1, u_signed64 a2 );
u_signed64  or64(  u_signed64 a1, u_signed64 a2 );
u_signed64  not64( u_signed64 a );

#endif	/* BYTE8INT */

/*
 *  Miscellaneous Conversions; e.g., u_signed64 ==> long long
 */
#define CONVERT_U64_TO_LONGLONG(U64, LL)   ( (LL) = high32m(U64), \
					    (LL) = (LL) << 32, \
					    (LL) = (LL) | low32m(U64) )
#define CONVERT_LONGLONG_TO_U64(LL, U64)   ( (U64)=bld64m( ( (LL)>>32) & 0xFFFFFFFF,\
					    (LL) & 0xFFFFFFFF) )

#endif	/*  _VESTA_ARITH64_H */
