/*
 * @(#)mvr_register.h	1.1 11/04/98 CERN IT-PDP/DM Olof Barring
 */
 
/* static char SccsId[] = "@(#)mvr_register.h	4.1   5/16/96   21:10:16   "; */
/*===========================================================================
 *
 * Include Name:	mvr_register.h
 * 
 * Description:
 *	This file contains macros and prototypes to be used in the
 *	handling of RegisterBitmap and SelectionFlags values.
 *
 * Traceability:
 *	Version		Author		Date		Description
 *	-------		------		----		-----------
 *	0.1		KWE		08/2/93		Initial version
 *      1.2             tyler           05/03/94        Changed #if !defined
 *                                                      for dependency tool
 *         1.x     07/05/94   Copyright Update
 *
 *  Notes:
 *       Licensed Materials
 *
 *       (C) Copyright International Business Machines Corp. 1994
 *       (C) Copyright Martin Marietta Energy Systems, Inc. and
 *                     Oak Ridge National Laboratory 1994
 *                     under CRADA No. Y1293-0203
 *       (C) Copyright Regents of The University of California and
 *                     Lawrence Livermore National Laboratory 1994
 *                     under CRADA No. T-253-92-C (as modified by T-325-92-C)
 *       (C) Copyright Regents of The University of California and
 *                     Los Alamos National Laboratory 1994
 *                     under CRADA No. LA93C10085
 *       (C) Copyright Sandia Corporation and Sandia National Laboratories 1994
 *                     under CRADA No. SC93/01198
 * 
 *       All rights reserved.
 * 
 *	None.
 *
 *--------------------------------------------------------------------------*/

#ifndef mvr_register_h
#define mvr_register_h

#include "u_signed64.h"

/*
 *  Macro to return TRUE if Value is set in Flags, and
 *  FALSE otherwise.
 */

#define RegisterValueSet(Flag,Value) \
		neqz64m(and64m((Flag),(Value)))

/*
 *  Macro to return TRUE if any other flag outside those
 *  specified in Value is set in Flags, and FALSE otherwise.
 */

#define OtherRegisterValueSet(Flag,Value) \
		neqz64m(and64m((Flag),not64m((Value))))

/*
 *  Function prototypes.
 */

u_signed64
AddRegisterValues(
u_signed64 InitialValue,
...);

u_signed64
RemoveRegisterValues(
u_signed64 InitialValue,
...);

u_signed64
AddAllRegisterValues(
long		LastPosition);

#endif		/* mvr_register_h */
