/*
 * Copyright (C) 1990,1991 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)msg.c	1.1 02/19/93 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

#include <errno.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/fcntl.h>
#include <msg.h>
#include "fhs.h"
opnmsgr(orpn)
char *orpn;
{
	char func[16];
	int orfd;

	strcpy (func, "opnmsgr");
	/* make operator reply pipe */
	strcpy (orpn, tempnam(NULL, "fhs"));
	if (mknod (orpn, 0010700, 0) < 0) {
		fhslogit (func, FHS01, orpn, "mknod", errno);
		exit (23);
	}
	if ((orfd = open (orpn, O_RDONLY | O_NDELAY)) < 0) {
		fhslogit (func, FHS01, orpn, "open", errno);
		exit (23);
	}
	return (orfd);
}

sndmsgr(p, orpn, myindex)
char *p;
char *orpn;
int myindex;
{
	char *buf;
	int c;
	int fd;
	char func[16];
	struct msghdr hdr;
	char *malloc();

	strcpy (func, "sndmsgr");
	/* send message to message daemon */
	if ((fd = open (MSG_PIPE, O_WRONLY | O_NDELAY)) < 0) {
		fhslogit (func, FHS01, MSG_PIPE, "open", errno);
		return (-1);
	}
	hdr.func = MSG_SEND_REP;
	strcpy (hdr.reply_pipe_name, orpn);
	hdr.msg_size = strlen (p);
	hdr.user_data = myindex;
	while ((buf = malloc (hdr.msg_size+sizeof(struct msghdr))) == NULL)
		sleep(1);
	COPYB (buf, &hdr, sizeof(struct msghdr));
	COPYB (buf+sizeof(struct msghdr), p, hdr.msg_size);
	if ((c = write (fd, buf, hdr.msg_size+sizeof(struct msghdr))) < 0)
		fhslogit (func, FHS01, MSG_PIPE, "write", errno);
	close (fd);
	free (buf);
	return (c);
}

rcvmsgr(orfd, type, myindex, msg_number, buf, buflen)
int orfd;
int *type;
int *myindex;
int *msg_number;
char *buf;
int buflen;
{
	int c;
	char func[16];
	struct msghdr hdr;

	strcpy (func, "rcvmsgr");
	/* receive reply from message daemon */
	if ((c = read (orfd, &hdr, sizeof(struct msghdr))) < 0) {
		fhslogit (func, FHS01, MSG_PIPE, "read", errno);
		return (-1);
	}
	if (c == 0) return (0);
	if (hdr.status > 0) return (-1);
	switch (hdr.func) {
	case MSG_SEND_REP:	/* msgid returned */
		*type = 0x2001;
		break;
	case MSG_RPLY:		/* oper replied */
		*type = 0x1007;
		if (hdr.msg_size) {
			if ((c = read (orfd, buf, hdr.msg_size)) < 0) {
				fhslogit (func, FHS01, MSG_PIPE, "read", errno);
				return (-1);
			}
		} else *buf = '\0';
	default:
		*type = 0;
	}
	*myindex = hdr.user_data;
	*msg_number = hdr.msg_number;
	return (hdr.msg_size);
}

canmsgr(msg_number, orpn)
int msg_number;
char *orpn;
{
	int c;
	int fd;
	char func[16];
	struct msghdr hdr;

	strcpy (func, "canmsgr");
	/* cancel an operator message */
	if ((fd = open (MSG_PIPE, O_WRONLY | O_NDELAY)) < 0) {
		fhslogit (func, FHS01, MSG_PIPE, "open", errno);
		return (-1);
	}
	hdr.func = MSG_CNCL;
	hdr.msg_number = msg_number;
	strcpy (hdr.reply_pipe_name, orpn);
	hdr.msg_size = 0;
	if ((c = write (fd, (char *) &hdr, sizeof(struct msghdr))) < 0)
		fhslogit (func, FHS01, MSG_PIPE, "write", errno);
	close (fd);
	return (c);
}
