/*
 * Copyright (C) 1992 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)fhstat.c	1.1 02/19/93 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

/*	fhstat - request list of current FHS requests from fhsdaemon */

#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <time.h>
#include "fhs.h"

main(argc, argv)
int	argc;
char	**argv;
{
	int c, n, nreq;
	char *ctime();
	time_t current_time;
	int dflg = 0;
	int errflg = 0;
	struct fhdmreq_sv *fmrs, *p;
	static char fhsmtyp[8][3]= {"  ", "MV", "  ", "DM", "DM", "DM", "DM", "CM"};
	int hdrprinted = 0;
	struct stat st;
	struct tm *tm;
	int trfd;

	while ((c = getopt (argc, argv, "d")) != EOF) {
		switch (c) {
		case 'd':
			dflg = 1;
			break;
		case '?':
			errflg++;
			break;
		}
	}
	if (errflg) {
		usage (argv[0]);
		exit(1);
	}
	time (&current_time);		/* Get current time */
	if (dflg) 
		printf ("%s", ctime (&current_time));
	trfd = open (REQFILE, O_RDONLY);
	fstat (trfd, &st);
	if (st.st_size == 0) {
		close (trfd);
		return;
	}
	fmrs = (struct fhdmreq_sv *) calloc (1, st.st_size);
	nreq = st.st_size / sizeof(struct fhdmreq_sv);
	read (trfd, fmrs, st.st_size);
	close (trfd);
	for (n = 0, p = fmrs; n < nreq; n++, p++) {
		tm = localtime (&p->at_time);
		if (hdrprinted++ == 0) {
			printf ("at_time   jobid  unit      type  vid     ");
			printf ("rtype  rc  reason  reqid\n");
		}
		printf ("%02d:%02d:%02d  %5d  %-8s   %s   %-6s   %c    %2x   %5d  %5d\n",
			tm->tm_hour, tm->tm_min, tm->tm_sec, p->jid, p->dvn,
			fhsmtyp[p->type], p->vid,
			p->rtype ? p->rtype : ' ', p->status, p->reason, p->reqid);
	}
}

usage(cmd)
char *cmd;
{
	fprintf (stderr, "usage: %s ", cmd);
	fprintf (stderr, "[-d]\n");
}
