/*
 * Copyright (C) 1992 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)fhsexit.c	1.2 05/04/93 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

/*      fhsexit - tpdaemon user exit interfacing to Foreign Host Server */
#include <errno.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include TAPEINC
#include "fhs.h"
static struct fhdreq qreq;
fhsexit(rqp, type)
struct vsn_req *rqp;
int type;
{
	int c, n;
	struct fhdmreq *fmrp;
	struct fhdqreq *fqrp;
	char func[16];
	int getfhsdreply();
	char *p, *q;
	struct passwd *pwd;
	char repbuf[1];
	struct fhdreq req;
	struct stat st;

	if (stat (NOFHSD, &st) == 0) return (0);        /* does not want to call FHS */
	strcpy (func, "fhsexit");
	signal (FHSRESPSIG, getfhsdreply);

	/* build request block */

	memset ((char *)&req, 0, sizeof(struct fhdrqhdr) + sizeof(struct fhdmreq));
	req.rh.size = sizeof(struct fhdrqhdr) + sizeof(struct fhdmreq);
	req.rh.code = FHSMOUNT;
	fmrp = (struct fhdmreq *) req.data;
	fmrp->jid = rqp->jid;
	fmrp->pid = getpid();
	fmrp->type = type;
	if (rqp->nqsid[0] != '\0') {
		q = fmrp->uniqueid;
		*q = 'B';
		for (p = rqp->nqsid; *p != '.'; p++)
			*++q = *p;
	} else
		sprintf (fmrp->uniqueid, "I%d", rqp->jid);
	pwd = getpwuid (rqp->uid);
	strcpy (fmrp->logonid, pwd->pw_name);
	strcpy (fmrp->path, rqp->path);
	strcpy (fmrp->dvn, rqp->dvn);
	strcpy (fmrp->vid, rqp->vid[0]);

	/* build query block */

	memset ((char *)&qreq, 0, sizeof(struct fhdrqhdr) + sizeof(struct fhdqreq));
	qreq.rh.size = sizeof(struct fhdrqhdr) + sizeof(struct fhdqreq);
	qreq.rh.code = FHSQUERY;
	fqrp = (struct fhdqreq *) qreq.data;
	fqrp->jid = fmrp->jid;
	strcpy (fqrp->dvn, fmrp->dvn);
	strcpy (fqrp->vid, fmrp->vid);

	/* send request to FHS daemon */

	while (1) {
		c = send2fhsd (&req, repbuf, &n);
		if (c == 0) break;	/* request sent successfully */
		sleep (FHDNRSRI);
	}
	return (0);
}

getfhsdreply()
{
	int c, n;
	struct fhdqrep fhdqrep;
#ifndef cray
	extern int fhs_mount_failed;
#endif
	char func[16];

	strcpy (func, "getfhsdreply");

	/* get reply from FHS daemon */

	while (1) {
		c = send2fhsd (&qreq, &fhdqrep, &n);
		if (c == 0) break;	/* request sent successfully */
		sleep (FHDNRSRI);
	}
#ifndef cray
	fhs_mount_failed = 1;
#endif
	if (fhdqrep.status)
		fumsg (func, FHS08, fhdqrep.rtype, fhdqrep.status, fhdqrep.reason,
			fhdqrep.reqid);
	return (0);
}

fumsg(func, msg, p1, p2, p3, p4, p5)
char *func;
char *msg;
{
#if cray
/*	send user messages to stderr if called from a command module (tpmnt, rls)
	or to tape.msg if called from a tpdaemon overlay.			*/
	extern char msgfn[];
	if (msgfn[0] == '\0')
		errmsg (func, 0, msg, p1, p2, p3, p4, p5);
	else
		usrmsg (func, msg, p1, p2, p3, p4, p5);
#else
	extern char repbuf[];
	sprintf (repbuf, msg, p1, p2, p3, p4, p5);
#endif
}
