/*
 * Copyright (C) 1992-1997 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)fhsdaemon.c	1.16 02/02/97 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

#include <errno.h>
#include <stdio.h>
#include <pwd.h>
#include <sys/types.h>
#include <fcntl.h>
#include <netdb.h>
#include <netinet/in.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/socket.h>
#if _AIX
#include <sys/un.h>
#endif
#if _AIX && _IBMR2
#include <sys/select.h>
#endif
#if _AIX
#include <sys/wait.h>
#endif
#include "fhs.h"
#define NOPMSG 32
#define netread s_recv
#define netwrite s_send
extern int sys_nerr;
extern char *sys_errlist[];
int daem_reqid = 0;
struct fhdmreq_sv *fmre;	/* end of savearea for FHS requests */
struct fhdmreq_sv *fmrs;	/* start of savearea for FHS requests */
char func[16];
int nreq;
int omsgcnt = 0;
int omsgids[NOPMSG];
#if cray
char orpn[MAXPATH];
#else
int orport;
#endif
int orfd;
fd_set readfd, readmask;
struct fhdrep rep;
int reqbufsz;
int rqfd;
#if defined(_AIX) && defined(_IBMR2)
struct sigaction sa;
#endif
time_t time();

main()
{
	int c, l;
	struct fhdreq fhdreq;
	struct fhdmreq_sv *p;
	int fhs_s;
	int highest_socket_n;
	int lowest_socket_n;
	int maxfds;
	struct stat st;
	struct timeval timeval;
	char *tempnam();
	time_t lasttime, tm;
	int trfd;
#if _AIX
	struct sockaddr_un sun, fromunix;
	int fromlen = sizeof(fromunix);
	int s;
	void wait4child();
#endif

	maxfds = _NFILE;
	highest_socket_n = -1;
	lowest_socket_n = maxfds;
#ifndef TEST
	/* Background */
	if ((c = fork()) < 0) {
		fprintf (stderr, "fhsdaemon: cannot fork\n");
		exit (1);
	} else
		if (c > 0) exit (0);
#if HPUX10
	setpgrp3():
#else
	setpgrp();
#endif
	for (c = 0; c < maxfds; c++)
		close (c);
#endif
#if defined(_AIX) && defined(_IBMESA)
	signal (SIGCHLD, wait4child);
#else
#if defined(_AIX) && defined(_IBMR2)
        sa.sa_handler = wait4child;
        sa.sa_flags = SA_RESTART;
        sigaction (SIGCHLD, &sa, NULL);
#endif
#endif
	strcpy (func, "fhsdaemon");

	lasttime = time(0);
	timeval.tv_sec = FHCHECKI;
	timeval.tv_usec = 0;
	FD_ZERO (&readmask);
	FD_ZERO (&readfd);
	signal (SIGPIPE,SIG_IGN);

	/* Open command pipe */
	unlink (REQPIPE);
#if _AIX
	if ((s = socket (AF_UNIX, SOCK_STREAM, 0)) < 0) {
		fhslogit (func, FHS01, REQPIPE, "socket", errno);
		exit (47);
	}
	sun.sun_family = AF_UNIX;
	strcpy (sun.sun_path, REQPIPE);
	if (bind (s, &sun, sizeof(struct sockaddr_un)) < 0) {
		fhslogit (func, FHS01, REQPIPE, "bind", errno);
		exit (47);
	}
	listen (s, 5);
	FD_SET (s, &readmask);
#else
	if (mknod (REQPIPE, 0010700, 0) < 0) {
		fhslogit (func, FHS01, REQPIPE, "mknod", errno);
		exit (47);
	}
	if ((rqfd = open (REQPIPE, O_RDONLY | O_NDELAY)) < 0) {
		fhslogit (func, FHS01, REQPIPE, "open", errno);
		exit (47);
	}
	FD_SET (rqfd, &readmask);
#endif

	/* open operator reply pipe */
#if cray
	orfd = opnmsgr (orpn);
#else
	orport = 0;
	orfd = opnmsgr (&orport);
#endif
	FD_SET (orfd, &readmask);

	/* Scan file containing pending FHS requests */
	trfd = open (REQFILE, O_RDWR | O_CREAT, 0664);
	fstat (trfd, &st);
	if (st.st_size == 0) {
		reqbufsz = BUFSIZ;
		fmrs = (struct fhdmreq_sv *) calloc (1, reqbufsz);
		fmre = fmrs + (reqbufsz/sizeof(struct fhdmreq_sv));
		nreq = 0;
		close (trfd);
	} else {
		reqbufsz = (st.st_size + BUFSIZ -1) / BUFSIZ * BUFSIZ;
		fmrs = (struct fhdmreq_sv *) calloc (1, reqbufsz);
		fmre = fmrs + (reqbufsz/sizeof(struct fhdmreq_sv));
		nreq = st.st_size / sizeof(struct fhdmreq_sv);
		read (trfd, (char *) fmrs, st.st_size);
		close (trfd);

	/* Send FHS DEMOUNT for all FHS requests successfully transmitted */
	/* to VM/FHS before the shutdown/crash but still in the FHS daemon table */
		for (p = fmrs; p < fmre; ) {
			if (p->jid == 0) break;
			if (p->type == FHMOUNTV) {	/* mount request */
				p->daem_reqid = ++daem_reqid;
				p->socket = -1;	/* socket not open */
				if (mnt2dmnt (p) <= 0) p++;
			} else {
				if (p->sndrcv == 2 && p->status == 0 && p->rtype == 'F') {
					delreq (p);
					continue;
				} else {
					p->daem_reqid = ++daem_reqid;
					p->at_time = time(0);
					p->blocked_req = 0;
					p->sndrcv = 0;
					p->socket = 0;
					p->reqid = 0;
					p->reason = 0;
					p->status = 0;
					p->rtype = '\0';
					savereqs ();
					p++;
				}
			}
		}
	}

	while (1) {
#if _AIX
		if (FD_ISSET (s, &readfd)) {
			rqfd = accept (s, &fromunix, &fromlen);
#else
		if (FD_ISSET (rqfd, &readfd)) {
#endif
			l = READ (rqfd, (char *) &fhdreq, sizeof(struct fhdrqhdr));
			if (l == sizeof(struct fhdrqhdr)) {
#if _AIX
				sprintf (fhdreq.rh.rpn, "%d", rqfd);
#endif
				l = fhdreq.rh.size - sizeof(struct fhdrqhdr);
				READ (rqfd, (char *) &fhdreq.data[0], l);
				switch (fhdreq.rh.code) {
				case FHSMOUNT:
					c = procmountreq (&fhdreq);
					break;
				case FHSQUERY:
					c = procqueryreq (&fhdreq);
					break;
				default:
					fhslogit (func, FHS06, fhdreq.rh.code);
					rep.rh.rc = EFHSSYS;
					rep.rh.size = sizeof(struct fhdrphdr);
					sendrep (fhdreq.rh.rpn, &rep);
				}
			} else if (l != 0)
				fhslogit (func, FHS07, l);
			FD_CLR (rqfd, &readfd);
		}
		if (FD_ISSET (orfd, &readfd)) {
			checkorep();	/* check for pending ops replies */
			FD_CLR (orfd, &readfd);
		}
		for (fhs_s = lowest_socket_n; fhs_s <= highest_socket_n; fhs_s++)
			if (FD_ISSET (fhs_s, &readfd)) {
				c = getfhsresponse (fhs_s);
				FD_CLR (fhs_s, &readfd);
			}
		if (((tm = time (0)) - lasttime) >= FHCLNREQI) {
			if (nreq) clean4jobdied();  /* look for jobs that died */
			lasttime = tm;
		}
		tm = time(0);
		for (p = fmrs; p < fmre; p++) {
			if (p->jid == 0) break;
			if (p->sndrcv == 0 && p->blocking_req == 0 && p->at_time <= tm) {
				c = sendfhsmount (p);
				if (c > 0 && c < lowest_socket_n)
					lowest_socket_n = c;
				if (c > highest_socket_n) highest_socket_n = c;
			}
		}
		memcpy (&readfd, &readmask, sizeof(readmask));
		if (select (maxfds, &readfd, (fd_set *)0, (fd_set *)0, &timeval) < 0) {
			FD_ZERO (&readfd);
		}
	}
}

procmountreq(reqp)
struct fhdreq *reqp;
{
	int c;
	int inuse;
	struct fhdmreq_sv *p, *p2, *newreq();
	struct fhdmreq *p1;

	c = 0;
	p1 = (struct fhdmreq *) reqp->data;
	switch (p1->type) {
	case FHMOUNTV:
		p = newreq ();
		memcpy ((char *)p, (char *) p1, sizeof(struct fhdmreq));
		for (p2 = fmrs; p2 < p; p2++) {
			if (strcmp (p2->dvn, p1->dvn) == 0) break;
		}
		p->daem_reqid = ++daem_reqid;
		p->at_time = time(0);
		if (p2 != p) {	/* pending request on same unit */
			p->blocking_req = p2->daem_reqid;
			p2->blocked_req = p->daem_reqid;
		}
		sortreq (p);
		break;
	case FHDMOUNTV:
		for (p = fmrs; p < fmre; ) {
			if (p->jid == 0) break;
			if (p->type == FHMOUNTV &&
			    strcmp (p->dvn, p1->dvn) == 0 &&
			    strcmp (p->vid, p1->vid) == 0) {
				if (mnt2dmnt (p) <= 0) p++;
			} else p++;
		}
		break;
	case FHDMOUNTD:
		for (p = fmrs; p < fmre; ) {
			if (p->jid == 0) break;
			if (p->type == FHMOUNTV &&
			    p->jid == p1->jid &&
			    strcmp (p->uniqueid, p1->uniqueid) == 0 &&
			    strcmp (p->logonid, p1->logonid) == 0 &&
			    strcmp (p->dvn, p1->dvn) == 0) {
				if (mnt2dmnt (p) <= 0) p++;
				break;
			} else p++;
		}
		break;
	case FHDMOUNTP:
		for (p = fmrs; p < fmre; ) {
			if (p->jid == 0) break;
			if (p->type == FHMOUNTV &&
			    p->jid == p1->jid &&
			    strcmp (p->uniqueid, p1->uniqueid) == 0 &&
			    strcmp (p->logonid, p1->logonid) == 0 &&
			    strcmp (p->path, p1->path) == 0) {
				if (mnt2dmnt (p) <= 0) p++;
			} else p++;
		}
		break;
	case FHDMOUNTA:
		for (p = fmrs; p < fmre; ) {
			if (p->jid == 0) break;
			if (p->type == FHMOUNTV &&
			    p->jid == p1->jid &&
			    strcmp (p->uniqueid, p1->uniqueid) == 0 &&
			    strcmp (p->logonid, p1->logonid) == 0) {
				if (mnt2dmnt (p) <= 0) p++;
			} else p++;
		}
		break;
	case FHFRCDMNT:
		inuse = 0;
		for (p = fmrs; p < fmre; ) {
			if (p->jid == 0) break;
			if (strcmp (p->dvn, p1->dvn) == 0) {
				inuse = 1;
				break;
			} else p++;
		}
		if (inuse == 0) {	/* unit not currently in use */
			p = newreq ();
			memcpy ((char *)p, (char *) p1, sizeof(struct fhdmreq));
			p->type = FHDMOUNTV;
			p->at_time = time(0);
			sortreq (p);
		}
		break;
	default:
		fhslogit (func, FHS06, p1->type);
		c = EFHSSYS;
	}
	rep.rh.rc = c;
	rep.rh.size = sizeof(struct fhdrphdr);
	c = sendrep (reqp->rh.rpn, &rep);	/* send confirmation to tpdaemon */
	return (c);
}

mnt2dmnt(p)
struct fhdmreq_sv *p;
{
	if (p->sndrcv == 0 ||	/* mount request not sent yet */
	   (p->sndrcv == 2 && p->status != 0)) { /* mount received bad rc */
		delreq (p);
		return (-1);
	} else {
		if (p->rtype == 'I') {	/* intermediate response received */
			p->type = FHMNTCAN;
			p->canreqid = p->reqid;
			if (p->socket >= 0) {
				close (p->socket);	/* final resp will never come */
				FD_CLR (p->socket, &readmask);
			}
		} else {		/* final response received */
			p->type = FHDMOUNTV;
		}
		p->at_time = time(0);
		p->sndrcv = 0;
		p->socket = 0;
		p->reqid = 0;
		p->reason = 0;
		p->status = 0;
		p->rtype = '\0';
		return (sortreq (p));
	}
}

procqueryreq(reqp)
struct fhdreq *reqp;
{
	int c;
	struct fhdmreq_sv *p;
	struct fhdqreq *p1;
	struct fhdqrep *p2;

	p1 = (struct fhdqreq *) reqp->data;
	for (p = fmrs; p < fmre; p++) {
		if (p->jid == 0) break;
		if (p->jid == p1->jid &&
		    p->type == FHMOUNTV &&
		    strcmp (p->dvn, p1->dvn) == 0 &&
		    strcmp (p->vid, p1->vid) == 0) break;
	}
	rep.rh.rc = 0;
	rep.rh.size = sizeof(struct fhdrphdr) + sizeof(struct fhdqrep);
	p2 = (struct fhdqrep *) rep.data;
	if (p < fmre && p->jid) {
		p2->reqid = p->reqid;
		p2->reason = p->reason;
		p2->status = p->status;
		p2->rtype = p->rtype;
		if (p->at_time == FHNEVER) delreq (p);
	} else {	/* request does not exist */
		p2->reqid = 0;
		p2->reason = 0;
		p2->status = 0;
		p2->rtype = 'N';
	}
	c = sendrep (reqp->rh.rpn, &rep);	/* send information to tpdaemon */
	return (c);
}

sendfhsmount(reqp)
struct fhdmreq_sv *reqp;
{
	int c, n;
	struct fhscqreq fhscqreq;
	struct fhsmdreq fhsmdreq;
	char obuf[128];
	struct passwd *pw;
	struct stat st;

	if (stat (NOFHS, &st) == 0) { /* FHS not working for a long period of time */
		reqp->at_time = time(0) + FHSNWRKRI;
		sortreq (reqp);
		return (0);
	}
	pw = getpwuid (geteuid());
	if (reqp->type != FHMNTCAN) {
		memset ((char *)&fhsmdreq, ' ', sizeof(fhsmdreq));
		fhsmdreq.magic = FHMAGIC;
		memcpy (fhsmdreq.euser, pw->pw_name, strlen(pw->pw_name));
		memcpy (fhsmdreq.type, reqp->type == FHMOUNTV ? "MV" : "DM", 2);
		memcpy (fhsmdreq.tpdev, reqp->dvn + 4, strlen(reqp->dvn + 4));
		memcpy (fhsmdreq.vid, reqp->vid, strlen(reqp->vid));
		fhsmdreq.respflg = 'Y';
		fhslogit (func, FHS02, fhsmdreq.type, fhsmdreq.tpdev);
		c = send2fhs (&fhsmdreq, 95);
	} else {	/* cancel mount request */
		memset ((char *)&fhscqreq, ' ', sizeof(fhscqreq));
		fhscqreq.magic = FHMAGIC;
		memcpy (fhscqreq.euser, pw->pw_name, strlen(pw->pw_name));
		memcpy (fhscqreq.type, "CM", 2);
		fhscqreq.reqid = reqp->canreqid;
		fhslogit (func, FHS03, fhscqreq.type, fhscqreq.reqid);
		c = send2fhs (&fhscqreq, 24);
	}
	if (c >= 0) {	/* TCP/IP is running fine */
		reqp->sndrcv = 1;
		reqp->socket = c;
		savereqs ();
		FD_SET (c, &readmask);
		for (n = 1; omsgcnt && n < 3; n++)	/* cancel pending oper msgs */
			if (omsgids[n] > 0) omsgdel (n);
	} else {
		n = -c;
		if (n == ECONNREFUSED) {
			omsgr (FHS09, 1);
		} else {
			sprintf (obuf, "%s: %s", FHS10, sys_errlist[n]);
			omsgr (obuf, 2);
		}
		reqp->at_time = time(0) + FHVMNRSRI;
		sortreq (reqp);
	}
	return (c);
}

send2fhs(reqp, reql)
char *reqp;
int reql;
{
	int fhs_s;
	char fhshost[64];
	char *getconfent();
	struct hostent *hp;
	char *p;
	struct sockaddr_in sin; /* internet socket */
	struct servent *sp;


	if ((sp = getservbyname (FHS, "tcp")) == NULL) {
		fhslogit (func, FHS05, -1002);
		exit (1);
	}
	if ((p = getconfent("FHS", "HOST",0)) == NULL)
		strcpy (fhshost, FHSHOST);
	else
		strcpy (fhshost, p);
	if ((hp = gethostbyname (fhshost)) == NULL) {
		fhslogit (func, FHS05, -1001);
		exit (1);
	}
	sin.sin_family = AF_INET;
	sin.sin_port = sp->s_port;
	sin.sin_addr.s_addr = ((struct in_addr *)(hp->h_addr))->s_addr;

	if ((fhs_s = socket (AF_INET, SOCK_STREAM, 0)) < 0) {
		fhslogit (func, FHS01, "fhs", "socket", errno);
		return (-errno);
	}
	if (connect (fhs_s, &sin, sizeof(struct sockaddr_in)) < 0) {
		fhslogit (func, FHS01, "fhs", "connect", errno);
		(void) close (fhs_s);
		return (-errno);
	}
	if (netwrite (fhs_s, reqp, reql) < 0) {
		fhslogit (func, FHS01, "fhs", "send", errno);
		(void) close (fhs_s);
		return (-errno);
	}
	return (fhs_s);
}

getfhsresponse(fhs_s)
int fhs_s;
{
	struct fhsrep fhsrep;
	struct fhsrphdr fhsrphdr;
	struct fhdmreq_sv *p;
	pid_t pid;

	for (p = fmrs; p < fmre; p++) {
		if (p->jid == 0) break;
		if (p->sndrcv > 0 && p->socket == fhs_s) break;
	}
	if (netread (fhs_s, (char *) &fhsrphdr, 12) < 0) {	/* get header */
		fhslogit (func, FHS01, "fhs", "recv", errno);
		(void) close (fhs_s);
		FD_CLR (fhs_s, &readmask);
		if (p >= fmre || p->jid == 0) return (0);	/* req. doesn't exist anymore */
		p->at_time = time (0) + FHCOMERRI;
		p->sndrcv = 0;
		p->socket = 0;
		sortreq (p);
		return (0);
	}
	if (fhsrphdr.type[0] == 'M' || fhsrphdr.type[0] == 'D') {
		if (netread (fhs_s, (char *) &fhsrep, 75) < 0) {
			fhslogit (func, FHS01, "fhs", "recv", errno);
			(void) close (fhs_s);
			FD_CLR (fhs_s, &readmask);
			if (p >= fmre || p->jid == 0) return (0);	/* req. doesn't exist anymore */
			p->at_time = time (0) + FHCOMERRI;
			p->sndrcv = 0;
			p->socket = 0;
			sortreq (p);
			return (0);
		}
		fhsrep.srccat[0] = '\0';
		fhslogit (func, FHS04, fhsrphdr.type, fhsrep.tpdev, fhsrphdr.rtype,
			fhsrphdr.status, fhsrphdr.reason, fhsrphdr.reqid);
	} else {
		fhslogit (func, FHS04, fhsrphdr.type, "            ", fhsrphdr.rtype,
			fhsrphdr.status, fhsrphdr.reason, fhsrphdr.reqid);
	}
	if (fhsrphdr.rtype == 'F' || fhsrphdr.status != 0) {
		close (fhs_s);
		FD_CLR (fhs_s, &readmask);
	}
	if (p->jid == 0) return (0);	/* request does not exit anymore */
	p->sndrcv = 2;
	p->reqid = fhsrphdr.reqid;
	p->reason = fhsrphdr.reason;
	p->status = fhsrphdr.status;
	p->rtype = fhsrphdr.rtype;
	if (fhsrphdr.reason != 3940)	/* RM Master available */
		if (omsgids[0] > 0) omsgdel (0);
	if (fhsrphdr.rtype == 'I') {	/* intermediate response */
		switch (fhsrphdr.status) {
		case 0:		/* request has been accepted */
			savereqs ();
			return (0);
		default:
			p->at_time = FHNEVER;
			break;
		}
	} else {		/* final response */
		switch (fhsrphdr.status) {
		case 0:		/* request completed ok */
			if (p->type == FHMOUNTV) {
				p->socket = 0;
				savereqs ();
			} else
				delreq (p);
			return (0);
		case 2:		/* RM master unavailable */
			p->at_time = time(0) + RMSNWRKRI;
			break;
		case 4:		/* request completed with minor error */
			if (p->type == FHMOUNTV) {
				p->socket = 0;
				p->status = 0;
				savereqs ();
			} else
				delreq (p);
			return (0);
		case 8:		/* request didn't complete successfully */
			checkreason (fhsrphdr.reason, p);
			break;
		case 0x11:	/* client not authorized */
		case 0x12:	/* syntax error */
		case 0x13:	/* device address unknown */
		case 0x14:	/* device assign problem */
		case 0x15:	/* internal error */
		case 0x16:	/* request not found */
		case 0x17:	/* device attach problem */
		case 0x18:	/* device open failure */
		case 0x19:	/* getting PGID failed */
			p->at_time = FHNEVER;
			break;
		case 0x20:	/* request will not be processed */
			checkreason (fhsrphdr.reason, p);
			break;
		case 0x21:	/* device close failure */
		case 0x22:	/* internal error */
			p->at_time = FHNEVER;
			break;
		case 0x23:	/* already attached */
			p->at_time = time(0) + FHUNTBSYRI;
			break;
		default:
			p->at_time = FHNEVER;
			break;
		}
	}
	p->sndrcv = 0;
	p->socket = 0;
	if (p->at_time == FHNEVER) {
		if (p->type == FHMOUNTV) {
			pid = p->pid;
			sortreq (p);
			fhslogit (func, FHS11, pid);
			kill (pid, FHSRESPSIG);		/* signal tpdaemon ovl */
		} else {
			delreq (p);
		}
	} else
		sortreq (p);
	return (0);
}

checkreason(reason, freqp)
int reason;
struct fhdmreq_sv *freqp;
{
	time_t tm;

	tm = time (0);
	switch (reason) {
	case 24:	/* Master not accepting requests */
		freqp->at_time = tm + RMSNWRKRI;
		break;
	case 36:	/* request not found for discard */
		freqp->type = FHDMOUNTV;
		freqp->at_time = tm;
		break;
	case 76:	/* RBTSERVR could not start request */
		freqp->at_time = tm + RMSNWRKRI;
		break;
	case 3128:	/* device cannot be opened */
	case 3140:	/* device not available */
		configdown (freqp->dvn);
		freqp->at_time = FHNEVER;
		break;
	case 3320:	/* hardware failure */
		freqp->at_time = tm + FHUNTBSYRI;
		break;
	case 3336:	/* volume in use */
		freqp->at_time = tm + FHVOLBSYRI;
		break;
	case 3372:	/* demount already pending */
		freqp->at_time = tm + FHUNTBSYRI;
		break;
	case 3500:	/* Library Attachment check */
		omsgr (FHS20, 3);
		freqp->at_time = tm + RMSNWRKRI;
		break;
	case 3504:	/* Library Manager offline */
		omsgr (FHS21, 4);
		freqp->at_time = tm + RMSNWRKRI;
		break;
	case 3692:	/* unload failure */
		freqp->at_time = tm + FHUNTBSYRI;
		break;
	case 3932:	/* communications error */
		freqp->at_time = tm + FHCOMERRI;
		break;
	case 3940:	/* RM Master unavailable */
		omsgr (FHS14, 0);
		freqp->at_time = tm + RMSNWRKRI;
		break;
	case 3941:	/* Check-back call failed */
		freqp->at_time = tm + FHCOMERRI;
		break;
	default:
		freqp->at_time = FHNEVER;
	}
}

configdown(unit)
char *unit;
{
	char obuf[128];
	int pid;

	sprintf (obuf, FHS15, unit);
	omsgr (obuf, -1);
	pid = fork ();
	if (pid < 0) {
		fhslogit (func, FHS01, "", "fork", errno);
		return (-1);
	} else if (pid == 0) {
		execlp (TPCONFIG, "tpconfig", unit, "down", 0);
		fhslogit (func, FHS01, "tpconfig", "execlp", errno);
		exit (errno);
	}
}

savereqs()
{
	int c, n;
	int trfd;

	if ((trfd = open (REQFILE, O_WRONLY)) < 0) {
		fhslogit (func, FHS01, REQFILE, "open", errno);
		return (-1);
	}
	n = nreq * sizeof(struct fhdmreq_sv);
	if (nreq != 0) {
		if ((c = write (trfd, fmrs, n)) != n) {
			fhslogit (func, FHS01, REQFILE, "write", errno);
			close (trfd);
			return (-1);
		}
	}
#if cray
	trunc (trfd);
#else
	ftruncate (trfd, n);
#endif
	close (trfd);
	return (0);
}

struct fhdmreq_sv *
newreq()
{
	struct fhdmreq_sv *p;

	nreq++;
	if (nreq > reqbufsz/sizeof(struct fhdmreq_sv)) {
		fmrs = (struct fhdmreq_sv *) realloc (fmrs, reqbufsz+BUFSIZ);
		memset ((char *)fmrs+reqbufsz, 0, BUFSIZ);
		reqbufsz += BUFSIZ;
		fmre = fmrs + (reqbufsz/sizeof(struct fhdmreq_sv));
	}
	for (p = fmrs; p->jid != 0; p++) ;
	return (p);
}

delreq(freqp)
struct fhdmreq_sv *freqp;
{
	int n;
	struct fhdmreq_sv *p;
	char *p1, *p2;

	if (freqp->blocked_req) {
		for (p = fmrs; p < fmre; p++) {
			if (p->jid == 0) break;
			if (p->daem_reqid == freqp->blocked_req) {
				p->blocking_req = 0;
				break;
			}
		}
	}
	if (freqp->blocking_req) {
		for (p = fmrs; p < fmre; p++) {
			if (p->jid == 0) break;
			if (p->daem_reqid == freqp->blocking_req) {
				p->blocked_req = 0;
				break;
			}
		}
	}
	nreq--;
	p2 = (char *)fmrs + (nreq * sizeof(struct fhdmreq_sv));
	if ((char *)freqp != p2) {	/* not last request in the list */
		p1 = (char *)freqp + sizeof(struct fhdmreq_sv);
		n = p2 + sizeof(struct fhdmreq_sv) - p1;
		memcpy ((char *)freqp, p1, n);
	}
	memset (p2, 0, sizeof(struct fhdmreq_sv));
	savereqs ();
}

sortreq(freqp)
struct fhdmreq_sv *freqp;
{
	struct fhdmreq_sv fhdmreq_t;
	int n;
	struct fhdmreq_sv *p;
	int pos;

	for (p = fmrs; p < fmre; p++) {
		if (p->jid == 0) break;
		if (p->at_time > freqp->at_time) break;
	}
	if (p == fmre || p == (freqp + 1)) {
		savereqs ();
		return (0);	/* request already at right place */
	}
	memcpy (&fhdmreq_t, freqp, sizeof(struct fhdmreq_sv));
	if (p > freqp) {
		p--;
		n = (char *) p - (char *) freqp;
		memcpy (freqp, freqp + 1, n);
		pos = 1;		/* request moved towards end of buffer */
	} else {
		n = (char *) freqp - (char *) p;
		memmove (p + 1, p, n);
		pos = -1;		/* request moved towards beg of buffer */
	}
	memcpy (p, &fhdmreq_t, sizeof(struct fhdmreq_sv));
	savereqs ();
	return (pos);
}

clean4jobdied()
{
	int i, j, n;
	int *jids;
	struct fhdmreq_sv *p;

	j = 0;
	jids = (int *) calloc (nreq + 1, sizeof(int));
	for (p = fmrs; p < fmre; p++) {
		if (p->jid == 0) break;
		for (i = 0; i < j; i++)
			if (p->jid == *(jids + i)) break;
		if (i == j) *(jids + j++) = p->jid;
	}

	n = checkjobdied (jids);

	for (p = fmrs; p < fmre; ) {
		if (p->jid == 0) break;
		for (j = 0; j < n; j++) {
			if (*(jids + j) == p->jid) break;
		}
		if (j != n) {	/* job has died */
			fhslogit (func, FHS12, p->jid);
			if (p->type == FHMOUNTV) {	/* mount request */
				if (mnt2dmnt (p) <= 0) p++;
			} else {
				if (p->sndrcv == 2 && p->status == 0 && p->rtype == 'F') {
					delreq (p);
					continue;
				} else
					p++;
			}
		} else
			p++;
	}
	free (jids);
}

omsgr(p, index)
char *p;
int index;
{
	int c;
	int myindex;

	if (index < 0) {
		for (myindex = 5; myindex < NOPMSG; myindex++)
			if (omsgids[myindex] == 0) break;
		if (myindex == NOPMSG) {
			fhslogit (func, FHS16);
			return (-1);
		}
	} else {
		if (omsgids[index]) return (0);	/* don't repeat message */
		myindex = index;
	}
	fhslogit (func, "%s", p);
#if cray
	c = sndmsgr (p, orpn, myindex);
#else
	c = sndmsgr (p, orport, myindex);
#endif
	if (c < 0) return (-1);
	omsgcnt++;
	omsgids[myindex] = -1;
	return (0);
}

checkorep()
{
	char rep[80];
	int c, i;
	int msg_number;
	int myindex;
	int reply_type;

	c = rcvmsgr (orfd, &reply_type, &myindex, &msg_number, rep, sizeof(rep));
	if (c < 0) return (-1);
	switch (reply_type) {
	case 0x2001:	/* msgid returned */
		omsgids[myindex] = msg_number;
		break;
	case 0x1007:	/* oper replied */
		for (i = 0; i < NOPMSG; i++) {
			if (omsgids[i] == msg_number) break;
		}
		if (i == NOPMSG) return (0);
		if (c == 0) rep[0] = '\0';
		fhslogit (func, FHS13, rep);
		omsgcnt--;
		omsgids[i] = 0;
	}
	return (0);
}

omsgdel(msgindx)
int msgindx;
{
	int c;

#if cray
	c = canmsgr (omsgids[msgindx], orpn);
#else
	c = canmsgr (omsgids[msgindx], orport);
#endif
	if (c < 0) return (-1);
	omsgcnt--;
	omsgids[msgindx] = 0;
	return (0);
}

#if defined(_AIX)
void wait4child()
{
	int status;

#if defined(_IBMR2)
	while (waitpid (-1, &status, WNOHANG) > 0) continue;
#else
	wait (&status);
	signal (SIGCHLD, wait4child);
#endif
}
#endif
