/*
 * Copyright (C) 1992-1996 by CERN/CN/SW/CU
 * All rights reserved
 */

/*
 * @(#)fhs.h	1.4 11/05/96 CERN CN-SW/CU   Jean-Philippe Baud
 */

		/* FHS constants and macros */

#ifdef MAXPATH
#undef MAXPATH
#endif
#define MAXPATH  80		/* maximum path length */
#define FHMAGIC    0x06081301
#define FHS	   "fhs"	/* service name in /etc/services */
#define FHSRESPSIG 53		/* signal sent to fhsexit when bad reply avail. */
#define FHPRTBUFSZ 512
#define FHREPBUFSZ 25           /* must be >= sizeof(fhdqrep) */
#define FHREQBUFSZ 148          /* must be >= (max(sizeof(fhdmreq), sizeof(fhdqreq)) */
#define	FHCHECKI   10		/* max interval to check for work to be done */
#define	FHCLNREQI  180		/* retry interval to check for jobs that have died */
#define	FHCOMERRI  5		/* retry interval if communication error */
#define	FHDNRSRI   10		/* retry interval if daemon not responding */
#define	FHNEVER    950000000	/* retry sometime in year 2000, i.e. never */
#define FHSNWRKRI  600		/* retry interval if FHS not working */
#define FHUNTBSYRI 60 		/* retry interval if unit busy */
#define FHVMNRSRI  60           /* retry interval if VM not responding */
#define FHVOLBSYRI 300		/* retry interval if volume busy */
#define RMSNWRKRI  60		/* retry interval if RM Master not working */

#define READ(x,y,z) read(x,y,z)
#define WRITE(x,y,z) write(x,y,z)

		/* FHS daemon commands */

#define FHSMOUNT    0
#define FHSQUERY    1

		/* FHS MOUNT/DEMOUNT request types */


#define	FHMOUNTV    1		/* mount volume */
#define	FHDMOUNTV   3		/* demount specific volume */
#define	FHDMOUNTD   4		/* demount specific device */
#define	FHDMOUNTP   5		/* demount for a specific path */
#define	FHDMOUNTA   6		/* demount for a specific jid */
#define	FHMNTCAN    7		/* mount cancel */
#define	FHFRCDMNT   8		/* force demount on specific device */

		/* FHS daemon return codes */

#define	EVMNRSP    83
#define EFHSSYS    98

		/* FHS messages */

#define FHS00	"FHS00 - FHS daemon not available"
#define FHS01	"FHS01 - %s : %s error : %d"
#define FHS02	"FHS02 - %.2s %.12s"
#define FHS03	"FHS03 - %.2s %d"
#define FHS04	"FHS04 - %.2s %.12s rtype %c rc %x rsn %d reqid %d"
#define FHS05   "FHS05 - Fatal configuration error %d"
#define FHS06   "FHS06 - Illegal function %d"
#define	FHS07   "FHS07 - Error reading request header, read = %d"
#define FHS08	"FHS08 - FHS returns fatal error: rtype %c rc %x rsn %d reqid %d"
#define	FHS09	"FHS09 - FHS not active"
#define	FHS10	"FHS10 - FHS not responding"
#define	FHS11	"FHS11 - sending signal to pid %d"
#define	FHS12	"FHS12 - cleaning up: job %d has died"
#define	FHS13	"FHS13 - ops replied: %s"
#define	FHS14	"FHS14 - RM Master unavailable"
#define	FHS15	"FHS15 - unit %s not available"
#define	FHS16	"FHS16 - no free slot in msg queue"
#define FHS17   "FHS17 - nofhs"
#define FHS18   "FHS18 - fhsactive"
#define	FHS19	"FHS19 - cannot get memory"
#define	FHS20	"FHS20 - Library Attachment check"
#define	FHS21	"FHS21 - Library Manager offline"

		/* FHS daemon internal structures */

struct fhdmreq_sv {	/* fhs mount/demount request saved onto disk */
	int	jid;
	int	pid;
	int	type;
	char	uniqueid[9];
	char	logonid[9];
	char	path[MAXPATH];
	char	dvn[9];
	char	vid[7];
	int	canreqid;

	int	daem_reqid;
	time_t	at_time;
	int	blocked_req;
	int	blocking_req;
	int	sndrcv;		/* 0 = not sent, 1 = sent, 2 = reply received */
	int	socket;

	int	reqid;
	int	reason;
	int	status;
	char	rtype;
};

		/* FHS daemon request structures */

struct fhdrqhdr {	/* fhs request header */
	int	size;
	int	code;
	char	rpn[MAXPATH];
};
struct fhdmreq {	/* fhs mount/demount request */
	int	jid;
	int	pid;
	int	type;
	char	uniqueid[9];
	char	logonid[9];
	char	path[MAXPATH];
	char	dvn[9];
	char	vid[7];
};
struct fhdqreq {	/* fhs query request */
	int	jid;
	char	dvn[9];
	char	vid[7];
};
struct fhdreq {		/* fhsdaemon request */
	struct fhdrqhdr rh;
	char	data[FHREQBUFSZ];
};

		/* FHS daemon reply structures */

struct fhdrphdr {	/* fhs reply header */
	int	size;
	int	rc;
};
struct fhdqrep {	/* fhs query reply */
	int	reqid;
	int	reason;
	int	status;
	char	rtype;
};
struct fhdrep {		/* fhs daemon reply */
	struct fhdrphdr rh;
	char	data[FHREPBUFSZ];
};

		/* FHS request structures */

struct fhsmdreq {	/* fhs mount/demount request */
	uint	magic:32;
	char	euser[14];
	char	type[2];
	char	tpdev[4];
	char	vid[6];
	char	respflg;
	char	srccat[32];
	char	targcat[32];
};
struct fhscqreq {	/* fhs cancel/query request */
	uint	magic:32;
	char	euser[14];
	char	type[2];
	uint	reqid:32;
};

		/* FHS response structures */

struct fhsrphdr {	/* fhs reply header */
	uint	reqid:32;
	uint	reason:32;
	uint	status:8;
	char	rtype;
	char	type[2];
};
struct fhsrep {		/* MOUNT/DEMOUNT response data */
	char	tpdev[4];
	char	vid[6];
	char	respflg;
	char	srccat[32];
	char	targcat[32];
};
