/*
 * Copyright (C) 1990-1997 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)report.c	1.10 04/29/97 CERN CN-SW/DC Les Robertson";
#endif /* not lint */

#include <stdio.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/param.h>

#define boolean char
#define TRUE 1
#define FALSE 0

#define oops(msg) {perror(msg); exit(-1);}

#ifdef cray
#include <sys/types.h>
#include <sys/jtab.h>
#include <sys/machd.h>

#define	RUSAGE_SELF	0
#define	RUSAGE_CHILDREN	-1

struct	rusage {
	struct timeval ru_utime;	/* user time used */
	struct timeval ru_stime;	/* system time used */
};

/* 	Cray has not implemented getrusage. This routine converts
	the j_tab data for the calling process and stores it
	in a (dummy) rusage structure.							*/
		
void getrusage(parm, cputime)
	int parm;
	struct rusage *cputime;
{
	struct jtab usage;
	int hz = HZ/1000000; /* ticks per microsecond */
	int usecs;

	if( parm != RUSAGE_SELF ) oops("cray_getrusage");

	if( getjtab(&usage) < 0 ) oops("cray_jtab");

	usecs = usage.j_ucputime / hz; /* be careful - the granularity of Cray ticks is
					  so small that it is easy to lose significant digits */ 
        (*cputime).ru_utime.tv_sec = usecs / 1000000;
	(*cputime).ru_utime.tv_usec = usecs - ((*cputime).ru_utime.tv_sec * 1000000);

	usecs = usage.j_scputime / hz;
        (*cputime).ru_stime.tv_sec = usecs / 1000000;
	(*cputime).ru_stime.tv_usec = usecs - ((*cputime).ru_stime.tv_sec * 1000000);

}
#endif /* cray */

#if (defined(sgi) && !defined(__EXTENSIONS__)) || (defined(hpux) && !defined(HPUX1010)) || (defined(SOLARIS) && !defined(SOLARIS25))
#include <sys/types.h>
#include <sys/times.h>

#if SOLARIS
#define	RUSAGE_SELF	0
struct	rusage {
	struct timeval ru_utime;	/* user time used */
	struct timeval ru_stime;	/* system time used */
};
#endif

/* 	Silicon Graphics has not implemented getrusage. This routines
	converts the "times" data for the calling process and stores it
	in an rusage structure.							*/
		
void getrusage(parm, cputime)
	int parm;
	struct rusage *cputime;
{
	struct tms usage;

	if( parm != RUSAGE_SELF ) oops("sg_getrusage");

	if( times(&usage) < 0 ) oops("sg_times");

        (*cputime).ru_utime.tv_sec = usage.tms_utime / HZ;
	(*cputime).ru_utime.tv_usec = ( usage.tms_utime - ((*cputime).ru_utime.tv_sec * HZ) ) * (1000000 / HZ);

        (*cputime).ru_stime.tv_sec = usage.tms_stime / HZ;
	(*cputime).ru_stime.tv_usec = ( usage.tms_stime - ((*cputime).ru_stime.tv_sec * HZ) ) * (1000000 / HZ);

}

#endif /* sgi */
	


#define HISTRATES 10
#define LINES_PER_PAGE 10
#define NUM_REPS 10

struct timeval start[NUM_REPS];
struct rusage startusage[NUM_REPS];

boolean started = FALSE; 
struct  timeval init_time;
boolean saved_Pflag, saved_Xflag;
int     saved_argc;
char    **saved_argv;
#ifndef MAXHOSTNAMELEN /* cater for Sun */
#define MAXHOSTNAMELEN 31
#endif /* MAXHOSTNAMELEN */
char hostname[MAXHOSTNAMELEN+1];

int byte_count[NUM_REPS], histptr, hdrct = LINES_PER_PAGE;
float oldrates[NUM_REPS][HISTRATES];

void report_start(rep_text, Pflag, Xflag, argc, argv)
char     *rep_text;
boolean  Pflag, Xflag;
int      argc;
char     *argv[];

/*	Initialises report, and prints a message useful if logging to a file, 
	or checking timing with a stopwatch. 

	rep_text is copied to the initialisation message.

	Pflag, Xflag define the types of report required. If TRUE, these
	indicate line output and X-window respectively.

	argc, argv are passed to provide the program call name and in case
	they contain any X parameters						*/

{
	/* read time */
	gettimeofday(&init_time,0);

	/* read hostname */
	gethostname(hostname, sizeof(hostname));

	if(Pflag) printf("%s starting on %s (%s ) - %s", argv[0], hostname, rep_text, ctime((time_t *) &init_time.tv_sec));

	/* save parameters */
	saved_Pflag = Pflag;
	saved_Xflag = Xflag;
	saved_argc = argc;
	saved_argv = argv;

	started = TRUE;
}


void report_stop()

/*	Prints termination message.						*/

{
	struct timeval stop;
	int mins, secs;

	if (! started) oops("report_start never called!");

	/* read time */
	gettimeofday(&stop,0);
	mins = ( (stop.tv_sec - init_time.tv_sec) / 60 );
	secs = stop.tv_sec - init_time.tv_sec - (60 * mins);

	if(saved_Pflag) printf("%s stopping on %s after %d minutes %d seconds - %s", 
		    saved_argv[0], hostname,  mins, secs, ctime((time_t *) &stop.tv_sec));
}


void report(index, run_type, bytes)
int index;
char *run_type;
int bytes;

/*	Reports transfer rate and cpu utilisation. 

	index is an index into the array of reports being accumulated.

	run_type is simply copied to the output line.

	"bytes" gives the number of bytes transferred since
	the previous call. If it is zero, counters for the [index] report
	are (re-)initialised. 							*/

{
	struct timeval stop;
	struct rusage stopusage;
	float elapsed, cpuproc, cpusys, cputot;
	float rate, avrate, sampKB, totMB, secperMB, cpupct ;
	int work, scratch;

	/* read time and cpu usage */
	gettimeofday(&stop,0);
	getrusage(RUSAGE_SELF, &stopusage);

	if ( bytes == 0 ) /* first call */ {
	  if ( ! started ) gethostname(hostname, sizeof(hostname));
	  gettimeofday(&start[index],0);
	  getrusage(RUSAGE_SELF, &startusage[index]);
	  byte_count[index] = 0;
	  for ( work = 0 ; work < HISTRATES; ) { oldrates[index][work++] = 0.; }
	  histptr = 0;
	  return;
	}

	/* maintain total bytes transferred */
	byte_count[index] = byte_count[index]+bytes;

	/* compute data rate in KB/s for this sample */
	elapsed = ( (float)( ( (stop.tv_sec - start[index].tv_sec) * 1000000 ) + (stop.tv_usec - start[index].tv_usec) ) )/1000000.;
	rate = ( (float)bytes/1000. )/ elapsed;

	/* compute average data rate of recent samples */
	for ( work = 0, avrate = rate, scratch = 0; work < HISTRATES; work++ ) {
	  if( oldrates[index][work] != 0 ) { avrate = avrate + oldrates[index][work]; scratch++; }
	}
	avrate = avrate/(scratch + 1);
	if (histptr == HISTRATES) histptr = 0;
	oldrates[index][histptr++] = rate;
 
	/* compute cpu consumption in seconds for this sample */
	cpuproc = (float)( ( (stopusage.ru_utime.tv_sec - startusage[index].ru_utime.tv_sec) * 1000000 )
                    + (stopusage.ru_utime.tv_usec - startusage[index].ru_utime.tv_usec) ) / 1000000.;
	cpusys = (float)( ( (stopusage.ru_stime.tv_sec - startusage[index].ru_stime.tv_sec) * 1000000 )
                    + (stopusage.ru_stime.tv_usec - startusage[index].ru_stime.tv_usec) ) / 1000000.;
	cputot = cpuproc + cpusys;

	sampKB = ((float)bytes)/1000.;
	totMB  = ((float)byte_count[index])/1000000.;
	secperMB = cputot/(((float)bytes)/1000000.);
	cpupct = (cputot/elapsed)*100.;

	/* produce report(s) */	

	if ( saved_Xflag ) {
#ifdef reportX
	  reportX( hostname, sampKB, totMB, rate, avrate,
	    cputot, cpuproc, cpusys, secperMB, cpupct, saved_argc, saved_argv);
#else
	  oops("X reporting not available");
#endif /* reportX */
	}
	
	if ( saved_Pflag ) {
	  if( hdrct++ == LINES_PER_PAGE ) {
	    fprintf(stdout,
	    " # description      host       sample_KB  total_MB sample_KB/s   avge_KB/s   cpu_sec  user_sec   sys_sec    sec/MB cpu_pct\n");
	    hdrct = 1;
	  }
	  fprintf(stdout,
	    "%2d %-17s%-10s%10.3f%10.3f%12.3f%12.3f%10.3f%10.3f%10.3f%10.3f%8.0f\n",
	    index, run_type, hostname, sampKB, totMB, rate, avrate,
	    cputot, cpuproc, cpusys, secperMB, cpupct);
	  fflush(stdout);
	}

	/* reset resource counters */
	gettimeofday(&start[index],0);
	getrusage(RUSAGE_SELF, &startusage[index]);
}
