/*
 * Copyright (C) 1990-1993 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)diskperf.b.c	1.6 11/18/93 CERN CN-SW/DC lmr";
#endif /* not lint */

/*

	This version uses the Unix block I/O interface

								*/

#include <sys/types.h>
#include <stdio.h>
#if defined(apollo)
#include <strings.h>
#else
#include <string.h>
#endif  /* apollo */
#include <sys/file.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#ifdef apollo
#include <apollo/base.h>
#include <apollo/ios.h>
#endif /* apollo */

#include <rfio.h>

#define boolean char
#define TRUE 1
#define FALSE 0

#define oops(msg) {perror(msg); exit(-1);}
#define REC_LEN 200000

extern void report(), report_start(), report_stop();

/* parameters are described in the "usage" message in the body of the program	*/


void main(argc, argv)
int argc; char *argv[];
{
	struct sockaddr_in saddr;
	struct hostent *hp;
	int    wdf, rdf;
	int    s, bytes, i, j, ch;
	int    sfd, bytes_read;
	char   *record_buffer,record[REC_LEN];

	char   reptext[256], *path_name, *hostname, **Xargv, *role;
	boolean diskman = FALSE, server = FALSE, netman = FALSE, Debug = FALSE;
	int    argptr, portnum, rec_len, file_size, cycles;
	int    Xargc, Xflag = 0, Pflag = 0;

	/* check argument count */
	if(argc < 9) {
	  fprintf(stderr, "Parameters of %s are as follows:\n", argv[0]);
	  fprintf(stderr, "file_name	name of file to be read or written\n");
	  fprintf(stderr, "role_flag	indicates role of this process:\n");
	  fprintf(stderr, "			d - read/write disk, server mode\n");
	  fprintf(stderr, "			D - standalone mode\n");
	  fprintf(stderr, "			n - network client(only role is source and sink\n");
	  fprintf(stderr, "			      of data for the server process)\n");
	  fprintf(stderr, "host_name	TCP host name to be used for the connection\n");
	  fprintf(stderr, "port_number	TCP port number to be used\n");
	  fprintf(stderr, "record_length	Size in bytes of data records (max REC_LEN)\n");
	  fprintf(stderr, "megabytes	Total data to be written and re-read in MBytes\n");
	  fprintf(stderr, "cycles		Number of write/read cycles to perform\n");
	  fprintf(stderr, "report_type	Report type required:\n");
	  fprintf(stderr, "			l - line output to stdout\n");
	  fprintf(stderr, "			d - line output to stdout, plus debug data\n");
	  fprintf(stderr, "			X - X display\n");
	  fprintf(stderr, "			b - line output and X\n");
	  fprintf(stderr, "Xt parameters	If report uses X then any Xt parameters\n");
	  fprintf(stderr, "		may be added for XtInitialise\n");
	  exit(-1);
	}

	/* extract parameters */
	argptr = 1;

	/* get path name for disk file */
	path_name = argv[argptr++];

	/* extract role flag */
	strncat(reptext, " role=", 255 - strlen(reptext));
	strncat(reptext, argv[argptr], 255 - strlen(reptext));
	switch (argv[argptr++][0]) {
	  case 'd': diskman = TRUE; server = TRUE; role = "disk"; break;
	  case 'D': diskman = TRUE; role = "disk and network"; break;
	  case 'n': netman = TRUE; break;
	  default:  oops("Invalid role specified");
	}

	/* extract the hostname and port number of the server */
	hostname = argv[argptr++];
	portnum = atoi(argv[argptr++]);

	/* get the record length */
	strncat(reptext, " reclen=", 255 - strlen(reptext));
	strncat(reptext, argv[argptr], 255 - strlen(reptext));
	if ( (rec_len = atoi(argv[argptr++]) ) > REC_LEN ) {
	  fprintf(stderr, " record length exceeds maximum (%d bytes)\n",REC_LEN);
	  exit(-1);
	}

	/* get file size */
	file_size = atoi(argv[argptr++]) * 1000000;

	/* and number of cycles to perform */
	cycles = atoi(argv[argptr++]);

	/* Check report type required */
	switch ( argv[argptr++][0] ) {
	  case 'l': Pflag = 1; Xflag = 0; break;
	  case 'd': Pflag = 1; Xflag = 0; Debug = TRUE; break;
	  case 'X': Pflag = 0; Xflag = 1; break; 
	  case 'b': Pflag = 1; Xflag = 1; break;
	  default:  oops("Invalid report type specified");
	}


	/* remove the parameters from the argument list, leaving 
	   any X parameters in place  */
	Xargv = argv+argptr-1; /* remove standard parameters */
	Xargv[0] = argv[0];
	Xargc = argc - argptr + 1;


	/* initialise the record buffer */
	record_buffer = &record[0];
	ch = 0;
	for(i = 0 ; i < rec_len ; i++ ) {
	  record[i] = ch++;
	  if ( ch > 255 ) ch = 0;
	}

	if (server | netman) {
	  /* build the network address if necessary */
	  memset( &saddr, 0, sizeof(saddr) );
	  saddr.sin_family = AF_INET;
	  hp = gethostbyname(hostname);
	  if (hp == NULL) oops("no such host");
	  memcpy( &saddr.sin_addr, hp->h_addr, hp->h_length );
	  saddr.sin_port = htons(portnum);

	  /* create the socket */
	  s = socket( AF_INET, SOCK_STREAM, 0 );
	  if (s == -1) oops("socket");

	}
	
	if (netman) {

          /******** processing for role as network source/sink *******/

	  /* make the connection */
	  i = 10;
	  while (connect(s, (struct sockaddr *)&saddr, sizeof(saddr)) != 0) {
	   sleep(10);
	   if (i-- < 0) oops("connect");
	  }

          for (cycles; cycles > 0; cycles--) {	/* main loop */

	    /* write data to the socket */
	    for(i = 0; i < file_size;) {
	      if ( (bytes = (file_size - i)) > rec_len ) bytes = rec_len;
	      if(Debug) printf("writing to socket %d bytes\n", bytes);
	      if( write(s, record_buffer, bytes) != bytes ) oops("write");
	      i = i + bytes;
	    }

	    /* read data from the socket */
	    for(i = 0; i < file_size;) {
	      if ( (bytes = (file_size - i)) > rec_len ) bytes = rec_len;
	      if(Debug) printf("reading from socket %d bytes\n", bytes);
	      if( (bytes_read = read(s, record_buffer, bytes)) <= 0 ) oops("read");
	      if(Debug) printf("  actually read %d bytes\n", bytes_read);
	      i = i + bytes_read;
	    }
	    
	  }

	} /* end of netman */

	else if (diskman) {

	  /********* processing for role as disk reader/writer and reporter ********/

	  if (server) { /* if this is not a stand-alone diskman */
	    if(Debug) printf("waiting for client to open socket\n");
	    /* bind the address and wait for the client */
	    if (bind(s, (struct sockaddr *)&saddr, sizeof(saddr)) != 0) oops("bind");
	    if (listen(s,1) != 0) oops("listen");
	    sfd = accept(s, NULL, NULL);
	    if (sfd == -1) oops("accept");
	  }

	  /* initialise reporter */
	  report_start(reptext, Pflag, Xflag, Xargc, Xargv); 

	  for (cycles; cycles > 0; cycles--) {	/* main loop */

	    /* initialise timers - open/close+write */
	    report(1, "open/write/close", 0); 

	    /* open the disk file for writing */
	    if(Debug) printf("opening disk for write\n");
	    if ( (wdf = rfio_open(path_name, O_WRONLY|O_CREAT|O_TRUNC, 0644)) < 0 ) oops("Output disk file open");

	    /* initialise timers - write only */
	    report(2, "write", 0); 

	    /* write the file */
	    for(i = 0; i < file_size;) {

	      if ( (bytes = (file_size - i)) > rec_len ) bytes = rec_len;

	      if (server) { /* read data from the socket */
		for(j = 0; j < bytes;) {
	          if(Debug) printf("reading from socket %d bytes\n", bytes - j);
	          if( (bytes_read = read(sfd, record_buffer, bytes - j)) <= 0 ) oops("socket read");
	          if(Debug) printf("  actually read %d bytes\n", bytes_read);
		  j = j + bytes_read;
		}
	      }

	      /* write data to the disk */
	      if(Debug) printf("writing to disk %d bytes\n", bytes);
	      if ( rfio_write(wdf, record_buffer, bytes) != bytes ) oops("disk write");
	      i = i + bytes;
	    }

	    /* issue timing report (write only) and close file */
	    report(2, "write", i); 
	    if(Debug) printf("closing disk after write\n");
	    rfio_close(wdf);

	    /* issue timing report (open/close+write) */
	    report(1, "open+write+close", i); 

	    /* initialise timers - open/close+read */
	    report(3, "open+read+close", 0); 

	    /* open the disk file for reading */
	    if(Debug) printf("opening disk for read\n");
	    if ( (rdf = rfio_open(path_name, O_RDONLY)) < 0 ) oops("Input disk file open");

	    /* initialise timers - read only */
	    report(4, "read", 0); 

	    /* read the file */
	    for(i = 0; i < file_size;) {

	      /* read data from the disk */
	      if ( (bytes = (file_size - i)) > rec_len ) bytes = rec_len;
	      if(Debug) printf("reading from disk %d bytes\n", bytes);
	      if ( rfio_read(rdf, record_buffer, bytes) != bytes ) oops("disk read");

	      if (server) { /* write data to the socket */
	        if(Debug) printf("writing to socket %d bytes\n", bytes);
	        if( write(sfd, record_buffer, bytes) != bytes ) oops("socket write");
	      }

	      i = i + bytes;

	    }
                                                               
	    /* issue timing report and close file */
	    report(4, "read", i); 
	    if(Debug) printf("closing disk after read\n");
	    rfio_close(rdf);

	    /* issue timing report (open/close+read) */
	    report(3, "open+read+close", i); 
	    
	  }

	  report_stop(); 
	  if(Debug) printf("diskman finished\n");
	} /* end of diskman */

	else oops("unknown role");
	exit(0);
}
