#!/bin/ksh
#
#		Copyright (C) 1996-1997 by CERN/CN/PDP/DM
#		All rights reserved
#
#	@(#)tpcpout.ksh	1.6 04/14/99 CERN CN-PDP/DM Christian Boissat
#
#
# Temporary version of stagewrt, to have it operate with
# the copytape facility
#
# Dependencies:
#	${STAGEWRT}
#
STAGEWRT=/usr/local/bin/stagewrt
TPCPD=/usr/spool/copytape/tpcopy	# Directory for on-going requests
TPCPF=tpcopy_				# Associated filenames
PATH=${PATH}:/usr/ucb			# Path extended (for Solaris)
#
#	Kill the named process
killproc() {
#
#		Retrieve child process identifier
	line="`ps -fu ${user} | grep -v grep | grep \"$$.*${STAGEWRT}\"`"
	test -n "${line}" && kill -INT `echo ${line} | cut -d' ' -f2`
}
trap 'killproc; rm -f ${tpfile} ${tpfile}[-+]*; exit 1' 2 15	# Interrupted command
#
#	Local variables
user=`whoami`
files=""
vid=""
#
#	Find parent process
ppid=`ps -fp $$ | grep -v PPID | cut -c1-40 | awk '{print $3}'`
tpfile=${TPCPD}/${TPCPF}${ppid}
#
#	Save arguments list
args="$*"
#
#	Scan arguments list
set -- `getopt b:C:d:E:F:f:Gg:h:I:KL:l:N:op:q:S:s:TU:u:V:v:X:z $*`
if [ $? -eq 0 ]; then
	while [ $# -gt 1 ]
	do
		case $1 in
		-G|-K|-o|-T|-z)
			;;
		-V)
#
#				Volume identifier specified ?
			shift
			vid=$1
			;;
		--)
#
#				File names specified ?
			shift
			files="$*"
			break
			;;
		*)
			shift
		esac
		shift
	done
fi
#
#	File creation mask
umask 0
#
#	Update control files
if [ -d ${TPCPD} -a -n "${files}" -a -n "${vid}" ]; then
#
#		Remove full pathnames for volumes already staged
	if [ -s ${tpfile} ]; then
		echo ${files} | tr ' ' '\012' > ${tpfile}+
		fgrep -v -f ${tpfile}+ ${tpfile} > ${tpfile}++
		mv -f ${tpfile}++ ${tpfile}
	fi
fi
#
#	Execute stage command in background
jobs > /dev/null 2>&1
${STAGEWRT} ${args} &
#
#	Wait for end of command
wait %1
stagerc=$?
#
#	Remove temporary stuff
test -s ${tpfile} || rm -f ${tpfile} ${tpfile}+ ${tpfile}++
#
#	Exit
exit ${stagerc}
#EOF
