/*
 * Copyright (C) 1995-1998 by CERN/CN/PDP/DS
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)tpcopy.c	1.18 05/05/98 CERN IT-PDP/DM Jean-Philippe Baud";
#endif /* not lint */

#include <errno.h>
#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include <malloc.h>
#include <netinet/in.h>
#include <signal.h>
#include <sys/time.h>
#if _AIX && _IBMR2
#include <sys/select.h>
#endif
#include <string.h>
#include <sys/wait.h>
#if defined(ultrix) || (defined(sun) && !defined(SOLARIS))
#include <sys/resource.h>
#endif
#include "copytape.h"
#include "marshall.h"
#undef  unmarshall_STRING
#define unmarshall_STRING(ptr,str)  { str = ptr ; INC_PTR(ptr,strlen(str)+1) ; }
extern	int	optind;
extern	char	*optarg;
#if !defined(linux)
extern char *sys_errlist[];
#endif
int blindmode;
char func[16];
gid_t gid;
struct cptp_parm gparm;
int inpflg;
struct cptp_parm *iparm;
int keepid;	/* keep vid/fseq from input tape in fid of output tape */
#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined(vms)
int mask;
#else
mode_t mask;
#endif
int maxfds;
int mergemode;
int nb_inp_tp;
int nb_out_tp;
struct cptp_parm *oparm;
int outflg;
int ovl_status;
int pid;
int reqid;
int rpfd;
#if (defined(_AIX) && defined(_IBMR2)) || defined(SOLARIS) || defined(IRIX5) || (defined(__osf__) && defined(__alpha)) || defined(linux)
struct sigaction sa;
#endif
char savebuf[256];
int saveflag;
int splitmode;
char stage_host[MAXHOSTNAMELEN];
char stage_pool[MAXPOOLNAMELEN];
uid_t uid;
int vidmap;
main(argc, argv)
int argc;
char **argv;
{
	int c, i;
	int clientpid;
	char *name;
	int nargs;
	char *rbp;
	char *req_data;
	int reqlen;
	void tpcopykilled();
	char *user;
	void wait4child();

	strcpy (func, "tpcopy");

#if defined(ultrix) || (defined(sun) && !defined(SOLARIS)) || (defined(__osf__) && defined(__alpha)) || defined(linux)
	maxfds = getdtablesize();
#else
	maxfds = _NFILE;
#endif
#if defined(ultrix) || (defined(sun) && !defined(SOLARIS)) || (defined(_AIX) && defined(_IBMESA))
	signal (SIGCHLD, wait4child);
#else
#if (defined(sgi) && !defined(IRIX5)) || defined(hpux)
	signal (SIGCLD, wait4child);
#else
#if (defined(_AIX) && defined(_IBMR2)) || defined(SOLARIS) || defined(IRIX5) || (defined(__osf__) && defined(__alpha)) || defined(linux)
	sa.sa_handler = wait4child;
	sa.sa_flags = SA_RESTART;
	sigaction (SIGCHLD, &sa, NULL);
#endif
#endif
#endif
	reqid = atoi (argv[1]);
	rpfd = atoi (argv[2]);
	reqlen = atoi (argv[3]);
	req_data = (char *) malloc (reqlen);
	read (0, req_data, reqlen);
	close (0);

	signal (SIGINT, tpcopykilled);

	rbp = req_data;
	unmarshall_STRING (rbp, user);	/* login name */
	unmarshall_STRING (rbp, name);
	unmarshall_WORD (rbp, uid);
	unmarshall_WORD (rbp, gid);
	unmarshall_WORD (rbp, mask);
	unmarshall_WORD (rbp, clientpid);
	unmarshall_WORD (rbp, nargs);
	argv = (char **) malloc ((nargs + 1) * sizeof(char *));
	for (i = 0; i < nargs; i++)
		unmarshall_STRING (rbp, argv[i]);
	argv[nargs] = NULL;
	chkopt (nargs, argv, &gparm);
	procinpdir (rbp, req_data + reqlen);
	c = docopy();
	exit (c);
}

bld_out_fseq(coparm)
struct cptp_parm *coparm;
{
	int local_alloc = 0;
	int n;

	if (coparm->fseq == NULL) {
		coparm->fseq = (char *) malloc (MAXFSEQ);
		local_alloc = 1;
		strcpy (coparm->fseq, "1");
		coparm->given_nbtpf = 1;
	}
	if (*coparm->fseq == 'n') {
		if (strlen (coparm->fseq) == 1) {
			if (coparm->actual_nbtpf == 1) return (0);
			coparm->fseq = (char *) malloc (MAXFSEQ);
			sprintf (coparm->fseq, "n%d", coparm->actual_nbtpf);
		} else if (coparm->given_nbtpf != coparm->actual_nbtpf) {
			sendrep (rpfd, MSG_ERR, CTP21);
			return (USERR);
		}
	} else if (coparm->given_nbtpf == 1) {
		if (coparm->actual_nbtpf == 1) return (0);
		n = atoi (coparm->fseq);
		if (!local_alloc)
			coparm->fseq = (char *) malloc (MAXFSEQ);
		sprintf (coparm->fseq, "%d-%d", n, n + coparm->actual_nbtpf - 1);
	} else if (coparm->given_nbtpf != coparm->actual_nbtpf) {
		sendrep (rpfd, MSG_ERR, CTP21);
		return (USERR);
	}
	return (0);
}
		
bld_xec_stgcmd(out, ctp, coparmp)
int out;
struct cptp_parm *ctp;
struct cptp_parm **coparmp;
{
	char arg_blksize[7];
	char arg_lrecl[7], arg_nread[6], arg_retentd[5];
	char buf[512];
	int cmdargc;
	char **cmdargv;
	char cmdname[12];
	int errflg = 0;
	int i, l;
	char **inpaths;
	char logbuf[PRTBUFSZ];
	int n;
	char *p;
	int pfd[2];
	char progfullpath[MAXPATH];
	fd_set readfd, readmask;
	struct timeval timeval;

	/* build the command */

	cmdargc = 0;
	cmdargv = (char **) malloc ((ctp->actual_nbtpf + 44) * sizeof(char *));
	strcpy (cmdname, out ? "tpcpout.ksh" : "tpcpin.ksh");
	cmdargv[cmdargc++] = cmdname;
	if (! out || vidmap)
		cmdargv[cmdargc++] = "-z";

	if (! out) {
		/* Deferred allocation always set for copytape (stagein only) */
		cmdargv[cmdargc++] = "-A";
		cmdargv[cmdargc++] = "deferred";
	}

	if (ctp->blksize) {
		cmdargv[cmdargc++] = "-b";
		sprintf (arg_blksize, "%d", ctp->blksize);
		cmdargv[cmdargc++] = arg_blksize;
	}
        if (ctp->charconv) {
		cmdargv[cmdargc++] = "-C";
		cmdargv[cmdargc++] = "ebcdic";
	}
#ifndef TMS
	if (ctp->den[0]) {
		cmdargv[cmdargc++] = "-d";
		cmdargv[cmdargc++] = ctp->den;
	}
#endif
	if (ctp->E_Tflags & SKIPBAD) {
		cmdargv[cmdargc++] = "-E";
		cmdargv[cmdargc++] = "skip";
	}
	if (ctp->E_Tflags & KEEPFILE) {
		cmdargv[cmdargc++] = "-E";
		cmdargv[cmdargc++] = "keep";
	}
	if (ctp->E_Tflags & IGNOREEOI) {
		cmdargv[cmdargc++] = "-E";
		cmdargv[cmdargc++] = "ignoreeoi";
	}
	if (ctp->recfm[0]) {
		cmdargv[cmdargc++] = "-F";
		cmdargv[cmdargc++] = ctp->recfm;
	}
	if (ctp->fid) {
		cmdargv[cmdargc++] = "-f";
		cmdargv[cmdargc++] = ctp->fid;
	}
#ifndef TMS
	if (ctp->dgn[0]) {
		cmdargv[cmdargc++] = "-g";
		cmdargv[cmdargc++] = ctp->dgn;
	}
#endif
	if (stage_host[0]) {
		cmdargv[cmdargc++] = "-h";
		cmdargv[cmdargc++] = stage_host;
	}
	if (ctp->lrecl) {
		cmdargv[cmdargc++] = "-L";
		sprintf (arg_lrecl, "%d", ctp->lrecl);
		cmdargv[cmdargc++] = arg_lrecl;
	}
	if (ctp->lbl[0]) {
#ifdef TMS
		if (strcmp (ctp->lbl, "blp") == 0) {
#endif
			cmdargv[cmdargc++] = "-l";
			cmdargv[cmdargc++] = ctp->lbl;
#ifdef TMS
		}
#endif
	}
	if (ctp->nread) {
		cmdargv[cmdargc++] = "-N";
		sprintf (arg_nread, "%d", ctp->nread);
		cmdargv[cmdargc++] = arg_nread;
	}
	if (stage_pool[0] && !out) {
		cmdargv[cmdargc++] = "-p";
		cmdargv[cmdargc++] = stage_pool;
	}
	if (ctp->fseq) {
		cmdargv[cmdargc++] = "-q";
		cmdargv[cmdargc++] = ctp->fseq;
	}
	if (ctp->tapesrvr[0]) {
		cmdargv[cmdargc++] = "-S";
		cmdargv[cmdargc++] = ctp->tapesrvr;
	}
	if (ctp->size) {
		cmdargv[cmdargc++] = "-s";
		cmdargv[cmdargc++] = ctp->size;
	}
	if (ctp->E_Tflags & NOTRLCHK)
		cmdargv[cmdargc++] = "-T";
	if (ctp->retentd) {
		cmdargv[cmdargc++] = "-t";
		sprintf (arg_retentd, "%d", ctp->retentd);
		cmdargv[cmdargc++] = arg_retentd;
	}
	if (ctp->vid[0]) {
		cmdargv[cmdargc++] = "-V";
		cmdargv[cmdargc++] = ctp->vid;
	}
#ifndef TMS
	if (ctp->vsn[0]) {
		cmdargv[cmdargc++] = "-v";
		cmdargv[cmdargc++] = ctp->vsn;
	}
#endif
	if (out) {
		inpaths = &cmdargv[cmdargc];
		cmdargv[cmdargc++] = strtok (ctp->path, " ");
		while (p = strtok (NULL, " "))
			cmdargv[cmdargc++] = p;
	}
	cmdargv[cmdargc] = NULL;

	sendrep (rpfd, MSG_ERR, "\n");
	strcpy (logbuf, cmdargv[0]);
	for (i = 1; i < cmdargc; i++) {
		strcat (logbuf, " ");
		n = strlen (cmdargv[i]);
		p = cmdargv[i];
		if ((int) (strlen (logbuf) + n) > (PRTBUFSZ - 33)) {
			strcat (logbuf, "\\");
			sendrep (rpfd, MSG_ERR, "%s\n", logbuf);
			strcpy (logbuf, "+ ");
			while (n > (PRTBUFSZ - 35)) {
				strncat (logbuf, p, PRTBUFSZ - 35);
				strcat (logbuf, "\\");
				sendrep (rpfd, MSG_ERR, "%s\n", logbuf);
				strcpy (logbuf, "+ ");
				n -= PRTBUFSZ - 35;
				p += PRTBUFSZ - 35;
			}
		}
		strcat (logbuf, p);
	}
	sendrep (rpfd, MSG_ERR, "%s\n", logbuf);

	/* creating pipe to get stderr from cptp[in|out].ksh (stagein/stagewrt) */

	if (pipe (pfd) < 0) {
		sendrep (rpfd, MSG_ERR, CTP08, "", "pipe", sys_errlist[errno]);
		return (SYERR);
	}
	if (fcntl (pfd[0], F_SETFL, O_NDELAY) < 0 ) {
		sendrep (rpfd, MSG_ERR, CTP08, "", "fcntl", sys_errlist[errno]);
		return (SYERR);
	}

	/* fork and exec cptp[in|out].ksh (stagein/stagewrt) process */

	ovl_status = -1;
	pid = fork ();
	if (pid < 0) {
		sendrep (rpfd, MSG_ERR, CTP08, "", "fork", sys_errlist[errno]);
		return (SYERR);
	} else if (pid == 0) {  /* we are in the child */
		ctplogit (func, "execing %s, pid=%d\n", cmdname, getpid());
		for (i = 0; i < maxfds; i++)
			if (i != pfd[1]) close (i);
		dup2 (pfd[1], 2);
                (void) umask (mask);
                setgid (gid);
                setuid (uid);
		sprintf (progfullpath, "%s/%s", BIN, cmdname);

		execvp (progfullpath, cmdargv);
		ctplogit (func, CTP08, cmdname, "execvp", sys_errlist[errno]);
		exit (SYERR);
	}
	FD_ZERO (&readmask);
	FD_ZERO (&readfd);
	FD_SET (pfd[0], &readmask);
	while (1) {
		if (FD_ISSET (pfd[0], &readfd)) {
			while ((l = read (pfd[0], buf, sizeof(buf)-1)) > 0) {
				buf[l] = 0;
				errflg = chk_stg_output (buf, out, ctp, coparmp,
					inpaths);
			}
			FD_CLR (pfd[0], &readfd);
		}
		if (ovl_status >=0) break;
		memcpy (&readfd, &readmask, sizeof(readmask));
		timeval.tv_sec = CHECKI;	/* must set each time for linux */
		timeval.tv_usec = 0;
		if (select (maxfds, &readfd, (fd_set *)0, (fd_set *)0, &timeval) < 0) {
			FD_ZERO (&readfd);
		}
	}
	while ((l = read (pfd[0], buf, sizeof(buf)-1)) > 0) {
		buf[l] = 0;
		errflg = chk_stg_output (buf, out, ctp, coparmp, inpaths);
	}
	if (saveflag)
		if (strncmp (savebuf, "STG47", 5) == 0)
			if (! out)
				errflg = iparm2oparm (savebuf, ctp, coparmp);
			else
				errflg = oparm2mparm (savebuf, inpaths, ctp->vid);
		else
			sendrep (rpfd, STAGE_OUT, "%s\n", savebuf);
	saveflag = 0;
	close (pfd[0]);
	free (cmdargv);
	if ((ovl_status == LIMBYSZ && (ctp->size != NULL || ctp->nread)) ||
	     ovl_status == BLKSKPD || ovl_status == TPE_LSZ ||
	    (ovl_status == MNYPARI && (ctp->E_Tflags & KEEPFILE)))
		ovl_status = 0;
	return (ovl_status == 0 ? errflg : ovl_status);
}

checkfseq(fseq)
char *fseq;
{
	int n1, n2;
	int nbtpf;
	char *p, *q;

	if (*(fseq + strlen (fseq) - 1) == '-') {
		/* *(fseq + strlen (fseq) - 1) = '\0'; */
	}
	switch (*fseq) {
	case 'n':
	case 'u':
		if (strlen (fseq) == 1) {
			nbtpf = 1;
		} else {
			nbtpf = atoi (fseq + 1);
		}
		break;
	default:
		nbtpf = 0;
		n2 = 0;
		p = strtok (fseq, ",");
		while (p) {
			if (q = strchr (p, '-')) {
				*q = '\0';
				n1 = atoi (p);
				n2 = atoi (q + 1);
				*q = '-';
			} else {
				n1 = atoi (p);
				n2 = n1;
			}
			nbtpf += n2 - n1 + 1;
			if (p = strtok (NULL, ",")) *(p - 1) = ',';
		}
	}
	return (nbtpf);
}

checkovlstatus(pid, status)
int pid;
int status;
{
	ctplogit (func, "process %d exiting with status %x\n", pid, status & 0xFFFF);
	ovl_status = (status & 0xFF) ? SYERR : ((status >> 8) & 0xFF);
	pid = 0;
}

chk_stg_output(buf, out, ctp, coparmp, inpaths)
char *buf;
int out;
struct cptp_parm *ctp;
struct cptp_parm **coparmp;
char **inpaths;
{
	int errflg;
	char *p, *q;

	p = buf;
	if (saveflag) {
		q = strchr (p, '\n');
		if (! q) {	/* line is still incomplete */
			strcat (savebuf, p);
			return (0);
		}
		*q = '\0';
		strcat (savebuf, p);
		if (strncmp (savebuf, "STG47", 5) == 0) {
			if (! out)
				errflg = iparm2oparm (savebuf, ctp, coparmp);
			else
				errflg = oparm2mparm (savebuf, inpaths, ctp->vid);
			if (errflg)
				return (errflg);
		} else
			sendrep (rpfd, STAGE_OUT, "%s\n", savebuf);
		saveflag = 0;
		p = q + 1;
	}
	while (q = strchr (p, '\n')) {
		*q = '\0';
		if (strncmp (p, "STG47", 5) == 0) {
			if (! out)
				errflg = iparm2oparm (p, ctp, coparmp);
			else
				errflg = oparm2mparm (p, inpaths, ctp->vid);
			if (errflg)
				return (errflg);
		} else
			sendrep (rpfd, STAGE_OUT, "%s\n", p);
		p = q + 1;
	}
	if (strlen (p)) {	/* save incomplete line */
		strcpy (savebuf, p);
		saveflag = 1;
	}
	return (0);
}

chkopt(nargs, argv, ctp)
int nargs;
char **argv;
struct cptp_parm *ctp;
{
	int c;

	optind = 1;
	while ((c = getopt (nargs, argv, "b:C:d:E:F:f:Gg:kL:l:mN:q:S:s:Tt:V:v:")) != EOF) {
		switch (c) {
		case 'b':
			ctp->blksize = atoi (optarg);
			break;
		case 'C':	/* character conversion */
			if (strcmp (optarg, "ebcdic") == 0)
				ctp->charconv = 'e';
			break;
		case 'd':
			strcpy (ctp->den, optarg);
			break;
		case 'E':
			if (strcmp (optarg, "skip") == 0)
				ctp->E_Tflags |= SKIPBAD;
			else if (strcmp (optarg, "keep") == 0)
				ctp->E_Tflags |= KEEPFILE;
			else if (strcmp (optarg, "ignoreeoi") == 0)
				ctp->E_Tflags |= IGNOREEOI;
			break;
		case 'F':
			strcpy (ctp->recfm, optarg);
			break;
		case 'f':
			ctp->fflag = 1;
			ctp->fid = (char *) malloc (strlen (optarg) + 1);
			strcpy (ctp->fid, optarg);
			break;
		case 'G':
			break;
		case 'g':
			strcpy (ctp->dgn, optarg);
			break;
		case 'k':
			keepid++;
			break;
		case 'L':
			ctp->lrecl = atoi (optarg);
			break;
		case 'l':
			strcpy (ctp->lbl, optarg);
			break;
		case 'm':
			vidmap++;
			break;
		case 'N':
			ctp->nread = atoi (optarg);
			break;
		case 'q':
			ctp->given_nbtpf = checkfseq (optarg);
			ctp->fseq = (char *) malloc (strlen (optarg) + 1);
			strcpy (ctp->fseq, optarg);
			break;
		case 'S':
			strcpy (ctp->tapesrvr, optarg);
			break;
		case 's':
			ctp->size = (char *) malloc (strlen (optarg) + 1);
			strcpy (ctp->size, optarg);
			break;
		case 'T':
			ctp->E_Tflags |= NOTRLCHK;
			break;
		case 't':
			ctp->retentd = atoi (optarg);
			break;
		case 'V':
			strcpy (ctp->vid, optarg);
			break;
		case 'v':
			strcpy (ctp->vsn, optarg);
			break;
		}
	}
}

dir2argv(inpdir, argvp)
char *inpdir;
char ***argvp;
{
	char **argv;
	int c;
	int nargs;
	char *p;
	int parm;

	nargs = 1;
	p = inpdir;
	parm = 0;
	while (c = *p++) {
		if (c == ' ' || c == '\t') {
			parm = 0;
		} else if (!parm) {
				parm++;
				nargs++;
		}
	}
	argv = (char **) malloc ((nargs + 1) * sizeof(char *));
	argv[0] = "copytape";
	nargs = 1;
	p = inpdir;
	parm = 0;
	while (c = *p++) {
		if (c == ' ' || c == '\t') {
			if (parm) {
				parm = 0;
				*(p - 1) = '\0';
			}
		} else if (!parm) {
			parm++;
			argv[nargs++] = p - 1;
		}
	}
	argv[nargs] = NULL;
	*argvp = argv;
	return (nargs);
}

docopy()
{
	int c, i;
	struct cptp_parm *ciparm;
	struct cptp_parm *coparm;
	char *getconfent();
	char *p;

	if (p = getconfent ("CPTAPE", "STAGEHOST", 0))
		strcpy (stage_host, p);
	if (p = getconfent ("CPTAPE", "STAGEPOOL", 0))
		strcpy (stage_pool, p);

	if (mergemode || splitmode) {
		coparm = oparm;
		for (i = 0, ciparm = iparm; i < nb_inp_tp; i++, ciparm++) {
			if (c = bld_xec_stgcmd (0, ciparm, &coparm))
				return (c);
		}
		for (i = 0, coparm = oparm; i < nb_out_tp; i++, coparm++) {
			if (c = bld_out_fseq (coparm))
				return (c);
			if (c = bld_xec_stgcmd (1, coparm, NULL))
				return (c);
			if (! coparm->fflag && coparm->fid)
				free (coparm->fid);
			free (coparm->path);
		}
	} else {
		ciparm = iparm;
		coparm = oparm;
		for (i = 0; i < nb_out_tp; i++, ciparm++, coparm++) {
			if (c = bld_xec_stgcmd (0, ciparm, &coparm))
				return (c);
			if (c = bld_out_fseq (coparm))
				return (c);
			if (c = bld_xec_stgcmd (1, coparm, NULL))
				return (c);
			if (! coparm->fflag && coparm->fid)
				free (coparm->fid);
			free (coparm->path);
		}
	}
	return (0);
}

get_nb_in_out_tp()
{
	char *q;

	q = strtok (NULL, " \t");
	nb_inp_tp = atoi (q);
	q = strtok (NULL, " \t");
	nb_out_tp = atoi (q);
}

iparm2oparm(buf, ciparm, coparmp)
char *buf;
struct cptp_parm *ciparm;
struct cptp_parm **coparmp;
{
	char **argv;
	int blksize;
	int c;
	char *dp;
	int errflg = 0;
	char fid[18];
	char fseq[MAXFSEQ];
	int lrecl;
	int nargs;
	char path[MAXPATH];

	nargs = dir2argv (buf + 8, &argv);
	optind = 1;
	while ((c = getopt (nargs, argv, "b:F:f:L:P:q:")) != EOF) {
		switch (c) {
		case 'b':
			blksize = strtol (optarg, &dp, 10);
			if (*dp != '\0' || blksize == 0) {
				sendrep (rpfd, MSG_ERR, CTP20, optarg, "-b");
				errflg++;
			} else if ((*coparmp)->blksize == 0)
				(*coparmp)->blksize = blksize;
			break;
		case 'F':
			if (strcmp (optarg, "F") && strcmp (optarg, "FB") &&
			    strcmp (optarg, "FBS") && strcmp (optarg, "FS") &&
			    strcmp (optarg, "U")) {
				sendrep (rpfd, MSG_ERR, CTP20, optarg, "-F");
				errflg++;
			} else if ((*coparmp)->recfm[0] == '\0')
				strcpy ((*coparmp)->recfm, optarg);
			break;
		case 'f':
			if ((int) strlen (optarg) > 17) {
				sendrep (rpfd, MSG_ERR, CTP20, optarg, "-f");
				errflg++;
			} else
				strcpy (fid, optarg);
			break;
		case 'L':
			lrecl = strtol (optarg, &dp, 10);
			if (*dp != '\0' || (lrecl == 0 && strcmp ((*coparmp)->recfm, "U"))) {
				sendrep (rpfd, MSG_ERR, CTP20, optarg, "-L");
				errflg++;
			} else if ((*coparmp)->lrecl == 0)
				(*coparmp)->lrecl = lrecl;
			break;
		case 'P':
			if ((int) strlen (optarg) > MAXPATH) {
				sendrep (rpfd, MSG_ERR, CTP20, optarg, "-P");
				errflg++;
			} else
				strcpy (path, optarg);
			break;
		case 'q':
			if ((int) strlen (optarg) > MAXFSEQ) {
				sendrep (rpfd, MSG_ERR, CTP20, optarg, "-q");
				errflg++;
			} else
				strcpy (fseq, optarg);
			break;
		default:
			errflg++;
		}
	}
	free (argv);
	if (errflg)
		return (SYERR);
	if (strcmp ((*coparmp)->lbl, "nl") &&	/* output tape is labelled */
	    ! (*coparmp)->fflag) {		/* output fid not given */
		if ((*coparmp)->fid == NULL) {
			if (splitmode && (*coparmp)->given_nbtpf <= 1)
				(*coparmp)->fidsize = 18;
			else
				(*coparmp)->fidsize = 1024;
			(*coparmp)->fid = (char *) malloc ((*coparmp)->fidsize );
			if (keepid || strcmp (ciparm->lbl, "nl") == 0)
				sprintf ((*coparmp)->fid,
					"T%s.FSEQ%s", ciparm->vid, fseq);
			else
				strcpy ((*coparmp)->fid, fid);
		} else {
			if ((int) strlen ((*coparmp)->fid) + 17 + 2 >
			    (*coparmp)->fidsize) {
				(*coparmp)->fidsize += 1024;
				(*coparmp)->fid = (char *) realloc ((*coparmp)->fid,
				    (*coparmp)->fidsize);
			}
			if (keepid || strcmp (ciparm->lbl, "nl") == 0)
				sprintf ((*coparmp)->fid+strlen((*coparmp)->fid),
					":T%s.FSEQ%s", ciparm->vid, fseq);
			else
				sprintf ((*coparmp)->fid+strlen((*coparmp)->fid),
					":%s", fid);
		}
	}
	(*coparmp)->actual_nbtpf++;
	if ((*coparmp)->path == NULL) {
		if (splitmode && (*coparmp)->given_nbtpf <= 1)
			(*coparmp)->pathsize = MAXPATH;
		else
			(*coparmp)->pathsize = 4096;
		(*coparmp)->path = (char *) malloc ((*coparmp)->pathsize);
		strcpy ((*coparmp)->path, path);
	} else {
		if ((int) strlen ((*coparmp)->path) + (int) strlen (path) + 2 >
		    (*coparmp)->pathsize) {
			(*coparmp)->pathsize += 4096;
			(*coparmp)->path = (char *) realloc ((*coparmp)->path,
			    (*coparmp)->pathsize);
		}
		strcat ((*coparmp)->path, " ");
		strcat ((*coparmp)->path, path);
	}

	if (splitmode && (*coparmp)->actual_nbtpf >= (*coparmp)->given_nbtpf &&
	    *coparmp < (oparm + nb_out_tp - 1))
		(*coparmp)++;
	return (0);
}

oparm2mparm(buf, inpaths, tovid)
char *buf;
char **inpaths;
char *tovid;
{
	char **argv;
	int c;
	char *curvid;
	char *dp;
	int errflg = 0;
	int fseq;
	int nargs;
	char *nextvid;
	char *p;
	char path[16];
	static int path_index = 0;
	static int Qfirst = 0;
	static int Qlast;
	char *q;

	nargs = dir2argv (buf + 8, &argv);
	optind = 1;
	while ((c = getopt (nargs, argv, "b:F:f:L:P:q:")) != EOF) {
		switch (c) {
		case 'b':
		case 'F':
		case 'f':
		case 'L':
			break;
		case 'P':
			if ((p = strrchr (optarg, '/')) == NULL ||
			    (q = strchr (p + 1, '.')) == NULL ||
			    q - p > 7) {
				sendrep (rpfd, MSG_ERR, CTP20, optarg, "-P");
				errflg++;
			} else {
				*q = '\0';
				curvid = p + 1;
			}
			break;
		case 'q':
                        fseq = strtol (optarg, &dp, 10);
                        if (*dp != '\0' || fseq == 0) {
                                sendrep (rpfd, MSG_ERR, CTP20, optarg, "-q");
                                errflg++;
                        }
			break;
		default:
			errflg++;
		}
	}
	free (argv);
	if (errflg)
		return (SYERR);
	if (p = inpaths[++path_index]) {
		p = strrchr (p, '/') + 1;
		strcpy (path, p);
		q = strchr (path, '.');
		*q = '\0';
		nextvid = path;
	} else {
		nextvid = NULL;
		path_index = 0;
	}
	if (Qfirst == 0)
		Qfirst = fseq;
	Qlast = fseq;
	if (! nextvid || strcmp (curvid, nextvid)) {
		updvidmap (curvid, tovid, Qfirst, Qlast);
		Qfirst = 0;
	}
	return (0);
}

procinpdir(inpdir, reqend)
char *inpdir;
char *reqend;
{
	char **argv_d;
	char *buf;
	struct cptp_parm *cptpp;
	char *dp;
	struct cptp_parm giparm;
	struct cptp_parm goparm;
	int n;
	int nargs;
	char *p;
	char *rbp;

	/* store the directives in an array */

	rbp = inpdir;
	while (rbp < reqend) {
		unmarshall_STRING (rbp, buf);
		p = buf + strspn (buf, " \t");
		if (*p != '-') {
			p = strtok (p, " \t");
			UPPER (p);
			if (strcmp (p, "BLIND") == 0) {
				(void) get_nb_in_out_tp();
				blindmode = 1;
			} else if (strcmp (p, "MERGE") == 0) {
				(void) get_nb_in_out_tp();
				mergemode = 1;
			} else if (strcmp (p, "SPLIT") == 0) {
				(void) get_nb_in_out_tp();
				splitmode = 1;
			} else if (strcmp (p, "INPUT") == 0) {
				inpflg = 1;
				outflg = 0;
				if ((blindmode + mergemode + splitmode) == 0)
					nb_inp_tp = 1;
				memcpy (&giparm, &gparm, sizeof(struct cptp_parm));
				iparm = (struct cptp_parm *)
				    calloc (nb_inp_tp, sizeof(struct cptp_parm));
				cptpp = iparm;
			} else if (strcmp (p, "OUTPUT") == 0) {
				inpflg = 0;
				outflg = 1;
				if ((blindmode + mergemode + splitmode) == 0)
					nb_out_tp = 1;
				memcpy (&goparm, &gparm, sizeof(struct cptp_parm));
				oparm = (struct cptp_parm *)
				    calloc (nb_out_tp, sizeof(struct cptp_parm));
				cptpp = oparm;
			} else {
				n = strtol (p, &dp, 10);
				if (inpflg)
					memcpy (cptpp, &giparm, sizeof(struct cptp_parm));
				else
					memcpy (cptpp, &goparm, sizeof(struct cptp_parm));
				p += strlen (p) + 1;
				nargs = dir2argv (p, &argv_d);
				chkopt (nargs, argv_d, cptpp);
				free (argv_d);
				if (*cptpp->vid == '\0') strcpy (cptpp->vid, cptpp->vsn);
				cptpp++;
			}
		} else {
			nargs = dir2argv (p, &argv_d);
			if (!inpflg && !outflg) {	/* common options */
				chkopt (nargs, argv_d, &gparm);
			} else if (inpflg) {	/* common input options */
				chkopt (nargs, argv_d, &giparm);
			} else {		/* common output options */
				chkopt (nargs, argv_d, &goparm);
			}
			free (argv_d);
		}
	}
}


void tpcopykilled()
{
	int c;

	if (pid) {
		ctplogit (func, "killing process %d\n", pid);
		c = kill (pid, SIGINT);
	}
	exit (REQKILD);
}

updvidmap(vid, tovid, Qfirst, Qlast)
char *vid;
char *tovid;
int Qfirst;
int Qlast;
{
#if TMS
	char tmsreq[80];

	sprintf (tmsreq, "VIDMAP %s ADD TOVID %s START %d END %d",
		vid, tovid, Qfirst, Qlast);
	sendrep (rpfd, UPD_VIDMAP, "%s\n", tmsreq);
#endif
	return (0);
}

#if defined(ultrix) || (defined(sun) && !defined(SOLARIS))
void wait4child()
{
	int pid;
	union wait status;

	while ((pid = wait3 (&status, WNOHANG, (struct rusage *) 0)) > 0)
		checkovlstatus (pid, status.w_status);
}
#else
void wait4child()
{
	int pid;
	int status;

#if defined(_IBMR2) || defined(SOLARIS) || defined(IRIX5) || (defined(__osf__) && defined(__alpha)) || defined(linux)
	while ((pid = waitpid (-1, &status, WNOHANG)) > 0)
		checkovlstatus (pid, status);
#else
	pid = wait (&status);
	checkovlstatus (pid, status);
#if _IBMESA
	signal (SIGCHLD, wait4child);
#else
	signal (SIGCLD, wait4child);
#endif
#endif
}
#endif
