/*
 * Copyright (C) 1995-1998 by CERN/CN/PDP/DS
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)send2ctpd.c	1.10 05/05/98 CERN CN-PDP/DS Jean-Philippe Baud";
#endif /* not lint */

#include <errno.h>
#include <stdio.h>
#include <sys/types.h>
#if defined(_WIN32)
#include <winsock2.h>
#else
#include <netdb.h>
#include <netinet/in.h>
#include <sys/socket.h>
#endif
#include "copytape.h"
#include "marshall.h"
#include "net.h"
#include "rfio.h"
#include "serrno.h"
#if !defined(linux)
extern char *sys_errlist[];
#endif
extern int vidmap_rc;

send2ctpd(reqp, reql, want_reply)
char *reqp;
int reql;
int want_reply;
{
	int c;
	char ctphost[64];
	char *getconfent();
	char *getenv();
	struct hostent *hp;
	int magic;
	int n;
	char *p;
	char prtbuf[PRTBUFSZ];
	int rep_type;
	char repbuf[REPBUFSZ];
	struct sockaddr_in sin; /* internet socket */
	struct servent *sp;
	int stg_s;

	if ((sp = getservbyname ("copytape", "tcp")) == NULL) {
		fprintf (stderr, CTP24, "copytape", "not defined in /etc/services");
		return (CONFERR);
	}
	if ((p = getenv ("CPTAPE_HOST")) == NULL &&
	    (p = getconfent ("CPTAPE", "HOST", 0)) == NULL) {
		fprintf (stderr, CTP25);
		return (CONFERR);
	}
	strcpy (ctphost, p);
	if ((hp = gethostbyname (ctphost)) == NULL) {
		fprintf (stderr, CTP24, "Host unknown:", ctphost);
		return (CONFERR);
	}
	sin.sin_family = AF_INET;
	sin.sin_port = sp->s_port;
	sin.sin_addr.s_addr = ((struct in_addr *)(hp->h_addr))->s_addr;

	if ((stg_s = socket (AF_INET, SOCK_STREAM, 0)) < 0) {
#if defined(_WIN32)
		fprintf (stderr, CTP30, "socket", WSAGetLastError());
#else
		fprintf (stderr, CTP08, "", "socket", sys_errlist[errno]);
#endif
		return (SYERR);
	}

	c = RFIO_NONET;
	rfiosetopt (RFIO_NETOPT, &c, 4);

	if (connect (stg_s, (struct sockaddr *) &sin, sizeof(sin)) < 0) {
#if defined(_WIN32)
		if (WSAGetLastError() == WSAECONNREFUSED) {
#else
		if (errno == ECONNREFUSED) {
#endif
			fprintf (stderr, CTP00, ctphost);
			(void) netclose (stg_s);
			return (ESTNACT);
		} else {
#if defined(_WIN32)
			fprintf (stderr, CTP30, "connect", WSAGetLastError());
#else
			fprintf (stderr, CTP08, "", "connect", sys_errlist[errno]);
#endif
			(void) netclose (stg_s);
			return (SYERR);
		}
	}
	if ((n = netwrite (stg_s, reqp, reql)) <= 0) {
		if (n == 0)
			fprintf (stderr, CTP08, "", "send", sys_serrlist[SERRNO]);
		else
#if defined(_WIN32)
			fprintf (stderr, CTP30, "send", WSAGetLastError());
#else
			fprintf (stderr, CTP08, "", "send", sys_errlist[errno]);
#endif
		(void) netclose (stg_s);
		return (SYERR);
	}
	if (! want_reply) {
		(void) netclose (stg_s);
		return (0);
	}

	while (1) {
		if ((n = netread (stg_s, repbuf, 3 * LONGSIZE)) <= 0) {
			if (n == 0)
				fprintf (stderr, CTP08, "", "recv", sys_serrlist[SERRNO]);
			else
#if defined(_WIN32)
				fprintf (stderr, CTP30, "recv", WSAGetLastError());
#else
				fprintf (stderr, CTP08, "", "recv", sys_errlist[errno]);
#endif
			(void) netclose (stg_s);
			return (SYERR);
		}
		p = repbuf;
		unmarshall_LONG (p, magic) ;
		unmarshall_LONG (p, rep_type) ;
		unmarshall_LONG (p, c) ;
		if (rep_type == COPYTAPERC) {
			(void) netclose (stg_s);
			break;
		}
		if ((n = netread (stg_s, repbuf, c)) <= 0) {
			if (n == 0)
				fprintf (stderr, CTP08, "", "recv", sys_serrlist[SERRNO]);
			else
#if defined(_WIN32)
				fprintf (stderr, CTP30, "recv", WSAGetLastError());
#else
				fprintf (stderr, CTP08, "", "recv", sys_errlist[errno]);
#endif
			(void) netclose (stg_s);
			c = SYERR;
			break;
		}
		p = repbuf;
		unmarshall_STRING (p, prtbuf);
		if (rep_type == UPD_VIDMAP) {
			if (updvidmap (prtbuf))
				vidmap_rc++;
		} else if (rep_type == MSG_OUT)
			printf ("%s", prtbuf);
		else
			fprintf (stderr, "%s", prtbuf);
	}
	return (c);
}

updvidmap(tmsreq)
char *tmsreq;
{
#if TMS
	int c;
	int repsize;
	int reqlen;
	char tmrepbuf[132];

	fprintf (stderr, "%s", tmsreq);
	reqlen = strlen (tmsreq) - 1;
	*(tmsreq+reqlen)= '\0';
	while (1) {
		repsize = sizeof(tmrepbuf);
		c = sysreq ("TMS", tmsreq, &reqlen, tmrepbuf, &repsize);
		switch (c) {
		case 0:
			break;
		case 8:
		case 12:
		case 100:
		case 312:
		case 315:
		case 2551:
		case 2552:
		case 2555:
		case 2556:
			fprintf (stderr, "%s\n", tmrepbuf);
			c = USERR;
			break;
		default:
			sleep (60);
			continue;
		}
		break;
	}
	fprintf (stderr, "\n");
	return (c);
#else
	return (0);
#endif
}
