.\" @(#)copytape.man	1.17 09/14/97 CERN CN-PDP/DH Jean-Philippe Baud
.\" Copyright (C) 1995-1997 by CERN/CN/PDP/DS
.\" All rights reserved
.\"
.TH COPYTAPE l "09/14/97"
.SH NAME
copytape \- copy files or partial files from one or more input tapes to one or more output tapes
.SH SYNOPSIS
.B copytape 
[
.BI -b " max_block_size"
] [
.BI -C " charconv"
] [
.BI -d " density"
] [ 
.BI -E " error_action"
] [
.BI -F " record_format" 
] [
.BI -f " file_id"
] [
.BI -G 
] [ 
.BI -g " device_group_name"
] [
.BI -k
] [
.BI -L " record_length"
] [ 
.BI -l " label_type"
] [
.BI -m
] [
.BI -N " nread"
] [
.BI -q " file_sequence_number"
] [
.BI -S " tape_server"
] [
.BI -s " size"
] [
.BI -T
] [
.BI -t " retention_period_in_days"
] [
.I input_tape_vids output_tape_vids
] 
.LP
.B copytape 
.BI -Q
.SH DESCRIPTION
This command copy physical tapes using a disk pool as intermediate buffer
to avoid keeping fast devices for a long time if the other device is slow.
.LP
The
.B copytape
program checks the tape parameters and sends a request to
.B ctpdaemon
which checks the rest of the parameters, generates and executes a list of
.BR stagein / stagewrt
commands.
On all client hosts and on the ctpdaemon host there should be an entry for
.B copytape
in
.B /etc/services
like:
.RS
.HP
copytape	5009/tcp			# SHIFT copytape
.RE
.LP
On all client hosts there should be an entry in
.B /etc/shift.conf
giving the ctpdaemon hostname.
For example:
.RS
.HP
CPTAPE	HOST	sp024
.RE
The ctpdaemon hostname may also be specified thru the environment variable
CPTAPE_HOST.
.LP
If TMS is used, there should also be an entry in
.B /etc/services
like:
.RS
.HP
sysreq		4001/tcp			# SYSREQ/TCP
.RE
.LP
The server where the daemon runs should have entries in
.B /etc/shift.conf
giving the number of requests that can be executed simultaneously,
the stager hostname and the poolname.
For example:
.RS
.HP
CPTAPE	RUN_LIMIT	2
.HP
CPTAPE	STAGEHOST	sp024
.HP
CPTAPE	STAGEPOOL	copytape
.RE

If a file
.B nomorecptp
exists in the operator directory, new copytape commands will be rejected by
the daemon and will wait on the client side.
.LP
.I input_tape_vids
and
.I output_tape_vids
may be a single vid, a list or a range of vids.
If the vids are not specified on the command line or if the command is
too complex, for example if the file position on input and output tapes
are different, the parameters may be read from a directive file.
.LP
The directive file has the following format:
.br
	mode m n (BLIND, MERGE or SPLIT followed by number of input/output tapes)
.br
	global options in Unix style
.br
	INPUT
.br
	global input options
.br
	one numbered line per input tape
.br
	OUTPUT
.br
	global output options
.br
	one numbered line per output tape
.br
Comment lines should start with an asterisk.
The mode may be BLIND (copy of n volumes onto the same number of volumes),
MERGE to merge several volumes onto one volume, SPLIT to split one volume
onto several tapes.
If the line specifying the mode is missing, copy of a single volume to another
is assumed.
.SH OPTIONS
.TP
.BI \-b " blocksize"
Specifies the maximum block size.
If not given and the input tape is labelled, the block size is taken from the
header label when the field is not zero; otherwise:
for all drive types except Redwoods the default is 32760 if
.I lrecl
is not specified,
.I lrecl
otherwise. On Redwoods, the default is 262144 if
.I lrecl
is not specified or the largest multiple of
.I lrecl
below 262144.
.TP
.BI \-C " charconv"
The data is converted from this character set on input and converted to this
character set on output.
.I charconv
may be
.B ascii
(no conversion is done) or
.BR ebcdic .
.TP
.BI \-d " density"
.B 1600
or
.B 6250
for round (IBM 3420) tapes,
.B 38000
for standard IBM 3480 cartridges,
.B 38KC
for 3480 cartridges with compaction (IDRC),
.B 38KD
for double density IBM 3490 cartridges,
.B 38KDC
for 3490 cartridges with compaction (IDRC),
.BR 8200 ,
.B 8500
or
.B 8500C
for Exabytes,
.B DDS
or
.B DDSC
for DAT cartridges,
.BR 2G ,
.BR 6G ,
.BR 10G ,
.BR 10GC ,
.BR 20G ,
.BR 20GC ,
.B 35G
or
.B 35GC
for DLT cartridges,
.B 10G
or
.B 10GC
for IBM 3590 cartridges,
.BR 10G ,
.BR 10GC ,
.BR 25G ,
.BR 25GC ,
.B 50G
or
.B 50GC
for Redwood cartridges.
.TP
.BI \-E " error_action"
Specifies the action to be taken in case of tape read error. This action may be:
.RS
.TP
.B skip
unreadable blocks are skipped. For each, an error message indicates the error
type and the block number.
A maximum of 10 blocks may be skipped.
.TP
.B keep
the file up to the block where the error occurred is copied.
.TP
.B halt
the file is not copied and the command is terminated (this is the default).
.TP
.B ignoreeoi
Do not take two consecutive tapemarks as End Of Information.
.RE
.TP
.BI \-F " recfm"
Specifies the record format of the data on the tape. It may be one of the 
following:
.BR U ,
.B F
or
.BR FB .
For labelled tapes, the format is taken from the HDR2 label; for unlabelled
tapes, the default format is
.BR U .
.TP
.BI \-f " fid"
Specifies the fileid in HDR1. If more than 17 characters long,
only the last 17 are taken. It is then converted to upper case.
For input tapes,
.I fid
is checked against the fid in HDR1.
For output tapes,
if the -f parameter is absent, fid is copied from input tape or if unlabelled,
fid is built from vid and file sequence number of the input file
in the following format:
.br
	Tvid.FSEQn
.br
In the case of multiple files, a series of file identifiers may be given,
separated by ":"s. These apply to the tape files in the specified order.
If there are more files than identifiers, the last one will be used for all
remaining files. Thus,
a single file identifier may be given which applies to all files on the tape.
.TP
.B \-G
Specifies that the tape copy operations should be issued on the tape server by
the 'group user'. A 'group user' may be defined for each group in 
.B /etc/shift.conf.
.br
For example: 
.br
	GRPUSER ws	opalprod
.br
This option is only valid on the command line.
.TP 
.BI \-g " dgn"
Requests a device from an installation defined set of "device groups".
It must match the device group specified in TMS (if installed).
If this parameter is missing, the value is taken from TMS or
defaults to CART.
.TP
.BI \-k
fid on output tape is built from vid and file sequence number of the input
file in the following format:
.br
	Tvid.FSEQn
.br
.TP
.BI \-L " lrecl"
Specifies the logical record length for fixed length record format files.
.TP
.BI \-l " lab_type"
Specifies the type of label which should be checked or generated. The following
label types are supported:
.br
.B al\ \ \ 
.SM ANSI 
label
.br
.B blp\ \ 
bypass label processing (input only)
.br
.B nl\ \ \ 
no label
.br
.B sl\ \ \ 
standard 
.SM IBM
label
.LP
It must match the label type specified in TMS (if installed).
If this parameter is missing, the value is taken from TMS or
defaults to
.BR sl .
.TP
.B \-m
Generate and issue TMS VIDMAP requests to store in the TMS database the
mapping between the input volume and the output volume, i.e.
the start and end file numbers on the output tape of each input tape.
Any subsequent stagein request for the input volume will be automatically
translated to use the new volume and any write request for the original
volume will be rejected.
.TP
.BI \-N " nread"
If specified, only 
.I nread 
records will be copied.
.TP
.B \-P
This flag is set by the panel interface to indicate that TMS checking has
already been done.
.TP
.B \-Q
Displays the list of queued and running requests.
.TP
.BI \-q " fseq"
Specifies the file sequence number(s) of the tape file(s) to be copied or
created. Default is 1.
For output tapes, it is enough to specify the file sequence number of the
first file to be written.
Multiple files may be specified using the following syntax:
.RS 
.TP 1.5i 
.I f1\-f2 
Files 
.I f1
to 
.I f2 
inclusive.
.TP
.I f1\- 
Files 
.I f1
to the last file on the tape (not supported yet).
.TP
.I f1\-f2,\|f4,\|f6- 
A series of non\-consecutive ranges of files (input only).
.TP
.B n 
Append files to the tape (output only).
.TP
.B u
Position the tape by fid (input only).
.RE
.TP
.BI \-S " server"
Specifies that the tape copy operation has to be issued on the tape server 
.IR server. 
.TP
.BI \-s " size"
If specified, only 
.I size 
Mbytes will be copied.
In the case of multiple files, a series of size values may be given,
separated by ":"s. These apply to the tape files in the specified order.
If there are more files than size values, the last one will be used for all
remaining files. Thus,
a single size value may be given which applies to all files on the tape.
.TP
.BI \-T
Does not check trailer labels.
.TP
.BI \-t " days"
Retention period on tape in days. A file may be overwritten only if it is
expired.
Default is 0, which means that the file may be overwritten immediately.
.TP
.BI \-V " vid"
Specifies the tape 
.I vid
if different from the 
.I vsn
(option not valid on global directives).
.TP
.BI \-v " vsn"
Specifies the volume serial number of the tape.
When \-v and \-V are both used,
.I vsn
must be matched by a
.I vid
(option not valid on global directives).
.SH FILES
.TP 1.5i
.B /etc/shift.conf
.TP
.B /usr/spool/copytape/log
.TP
.B /etc/operator/nomorecptp
.SH EXAMPLES
The following example copies 50 input 3480 cartridges to a single DLT:

.RS
.nf
.cs R 24
copytape AB1234-AB1283 DL9999
.cs R
.fi
.RE

Here is an example of directive file to copy selected files from 2 input tapes
onto a single output tape:
.bp
.RS
.nf
.cs R 24
* COPYTAPE INPUT FILE
* -------------------
MERGE 2 1
*  GLOBAL OPTIONS
      -F F
INPUT
*  GLOBAL INPUT OPTIONS
      -d 38000
*  TAPE DEPENDENT PARAMETERS
*  TAPE    VSN       VID          LABEL    FROM&TO
      1 -v CZ0134 -V CZ0134    -l al    -q 2
      2 -v CZ0135 -V CZ0135    -l sl    -q 1-3
OUTPUT
*  GLOBAL OUTPUT OPTIONS
      -d 38KDC
*  TAPE DEPENDENT PARAMETERS
*     TAPE VSN       VID          LABEL    AT EOI
      1           -V I00102    -l nl    -q n
.cs R
.fi
.RE

Here is another example of directive file to copy 80 files from 1 DLT tape
onto two Exabyte tapes (40 files each):

.RS
.nf
.cs R 24

* COPYTAPE INPUT FILE
* -------------------
SPLIT 1 2
      -F F -l nl -b 32760 -L 32760 -s 250 -E halt -C ascii
INPUT
*  GLOBAL INPUT OPTIONS
      -d 10GC
*  TAPE DEPENDENT PARAMETERS
      1 -V DLT001  -q 1-80 -v DLT001 -g DLT
OUTPUT
*  GLOBAL OUTPUT OPTIONS
      -d 8500
*  TAPE DEPENDENT PARAMETERS
      1 -V XZ0040  -q 1-40 -v XZ0040 -g 8500
      2 -V XZ0041  -q 1-40 -v XZ0041 -g 8500
.cs R
.fi
.RE

Assuming that the directive file is saved as
.IR copytape.dir ,
.B copytape
could be called in the following way:

.RS
.nf
.cs R 24
copytape < copytape.dir
.cs R
.fi
.RE
.SH RETURN CODES
\
.br
0	Ok.
.br
1	Bad parameter.
.br
2	System error.
.br
4	Configuration error.
.br
28	ENOSPC: unable to find enough disk space or tape volume overflow.
.br
190	Vidmap failure.
.br
192	Request cancelled by stageclr.
.br
193	Blocks were skipped.
.br
194	Blocks were skipped and copy limited by size.
.br
195	Copy stopped: too many tape errors, but -E keep.
.br
197	Copy limited by size.
