/*
 * Copyright (C) 1995-1998 by CERN/CN/PDP/DS
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)copytape.c	1.22 12/09/98 CERN CN-PDP/DS Jean-Philippe Baud";
#endif /* not lint */

#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <grp.h>
#include <malloc.h>
#include <pwd.h>
#include <string.h>
#if defined(_WIN32)
#include <winsock2.h>
#else
#include <netinet/in.h>
#endif
#include "marshall.h"
#define RFIO_KERNEL 1
#include "rfio.h"
#include "copytape.h"
extern	char	*getconfent();
extern	char	*optarg;
extern	int	optind;
char account[3];
char cmdbuf[256];
int Gflag;
char Gname[15];
uid_t Guid;
static gid_t gid;
struct cptp_parm gparm;
int inpflg;
int nb_inp_tp;
int nb_out_tp;
int outflg;
int panelflag;
int pid;
static struct passwd *pw;
int Qflag;
char *sbp;
char userid[4];
int vidmap_rc;

main(argc, argv)
int argc;
char **argv;
{
	int c, i;
	void cleanup();
	FILE *fopen();
	char *getacct();
#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined(vms) || defined(_WIN32)
	int mask;
#else
	mode_t  mask;
#endif
	int msglen;
	int ntries = 0;
	char *p, *q;
	char sendbuf[REQBUFSZ];
	uid_t uid;
#if defined(_WIN32)
	WSADATA wsadata;
	int WSAStartup_done = 0;
#endif

	uid = getuid();
	gid = getgid();
#if defined(_WIN32)
	if (uid < 0 || gid < 0) {
		fprintf (stderr, CTP29);
		c = USERR;
		goto prt_final_status;
	}
#endif
#ifdef TMS
	p = getacct();
	if (p == NULL) {
		fprintf (stderr, CTP14);
		c = USERR;
		goto prt_final_status;
	}
	strncpy (userid, p, 3);
	strncpy (account, p + 4, 2);
#endif
	if (c = chkopt (argc, argv, &gparm, 1, 1)) {
		usage (argv[0]);
		goto prt_final_status;
	}

	c = RFIO_NONET;
	rfiosetopt (RFIO_NETOPT, &c, 4);

	/* Build request header */

	sbp = sendbuf;
	marshall_LONG (sbp, CTPMAGIC);
	if (! Qflag) {
		marshall_LONG (sbp, TPCOPY);
	} else {
		marshall_LONG (sbp, CTPQRY);
	}
	q = sbp;	/* save pointer. The next field will be updated */
	msglen = 3 * LONGSIZE;
	marshall_LONG (sbp, msglen);

	/* Build request body */

	if ((pw = getpwuid (uid)) == NULL) {
		char uidstr[8];
		sprintf (uidstr, "%d", uid);
		fprintf (stderr, CTP23, uidstr);
		c = SYERR;
		goto prt_final_status;
	}
	marshall_STRING (sbp, pw->pw_name);     /* login name */
	if (Qflag) {
		marshall_WORD (sbp, gid);
		goto sendreq;
	}
	if (Gflag) {
		marshall_STRING (sbp, Gname);
		marshall_WORD (sbp, Guid);
	} else {
		marshall_STRING (sbp, pw->pw_name);
		marshall_WORD (sbp, uid);
	}
	marshall_WORD (sbp, gid);
	umask (mask = umask(0));
	marshall_WORD (sbp, mask);
	pid = getpid();
	marshall_WORD (sbp, pid);

	marshall_WORD (sbp, argc);
	for (i = 0; i < argc; i++)
		marshall_STRING (sbp, argv[i]);

	if (optind == argc - 2) {	/* all parameters on command line */
		/* convert to directive format */
		if (c = fmt1_to_fmt2 (argv[optind], argv[optind+1]))
			goto prt_final_status;
	} else if (optind >= argc) {
		if (isatty (0))
			fprintf (stderr, "Please enter the directives\n");
		if (c = procinpdir (stdin))
			goto prt_final_status;
	}
	if (nb_inp_tp == 0 || nb_out_tp == 0) {
		fprintf (stderr, CTP05);
		c = USERR;
		goto prt_final_status;
	}

#if ! defined(_WIN32)
	signal (SIGHUP, cleanup);
#endif
	signal (SIGINT, cleanup);
#if ! defined(_WIN32)
	signal (SIGQUIT, cleanup);
#endif
	signal (SIGTERM, cleanup);

sendreq:
	msglen = sbp - sendbuf;
	marshall_LONG (q, msglen);      /* update length field */
#if defined(_WIN32)
	if (WSAStartup (MAKEWORD (2, 0), &wsadata)) {
		fprintf (stderr, CTP28);
		c = SYERR;
		goto prt_final_status;
	}
	WSAStartup_done = 1;
#endif

		/* send request to daemon */

        while (c = send2ctpd (sendbuf, msglen, 1)) {
                if (c == 0 || c == USERR || c == LIMBYSZ || c == CLEARED ||
		    c == ENOSPC) break;
                if (c != ESTNACT && ntries++ > MAXRETRY) break;
                sleep (RETRYI);
        }

prt_final_status:
	if (! Qflag)
		if (c)
			fprintf (stderr, "\nCOPY FAILED\n");
		else if (vidmap_rc == 0)
			fprintf (stderr, "\nCOPY SUCCESSFUL\n");
		else {
			fprintf (stderr, "\nCOPY SUCCESSFUL, BUT VIDMAP FAILURE\n");
			c = VIDMAPF;
		}
#if defined(_WIN32)
	if (WSAStartup_done)
		WSACleanup();
#endif
	exit (c);
}

chkopt(nargs, argv, ctp, global, cmdline)
int nargs;
char **argv;
struct cptp_parm *ctp;
int global;
int cmdline;
{
	int c;
	int errflg = 0;
	struct group *gr;
	char *p;

	optind = 1;
	while ((c = getopt (nargs, argv, "b:C:d:E:F:f:Gg:kL:l:mN:Qq:S:s:Tt:V:v:z")) != EOF) {
		switch (c) {
		case 'd':
			if (strlen (optarg) > sizeof(ctp->den) - 1) {
				fprintf (stderr, CTP02, "-d\n");
				errflg++;
			} else
				strcpy (ctp->den, optarg);
			break;
		case 'G':
			if (! cmdline) {
				fprintf (stderr, CTP26, 'G');
				errflg++;
			}
			Gflag++;
			if ((gr = getgrgid (gid)) == NULL) {
				fprintf (stderr, CTP31, gid);
				return (SYERR);
			}
                        if ((p = getconfent ("GRPUSER", gr->gr_name, 0)) == NULL) {
                                fprintf (stderr, CTP22, gr->gr_name);
                                errflg++;
                        } else {
                                strcpy (Gname, p);
                                if ((pw = getpwnam (p)) == NULL) {
                                        fprintf (stderr, CTP23, p);
                                        errflg++;
                                } else
                                        Guid = pw->pw_uid;
                        }
			break;
		case 'g':
			if (strlen (optarg) > sizeof(ctp->dgn) - 1) {
				fprintf (stderr, CTP02, "-g\n");
				errflg++;
			} else
				strcpy (ctp->dgn, optarg);
			break;
		case 'l':
			if (strlen (optarg) > sizeof(ctp->lbl) - 1) {
				fprintf (stderr, CTP02, "-l\n");
				errflg++;
			} else
				strcpy (ctp->lbl, optarg);
			break;
		case 'P':
			panelflag++;
			break;
		case 'Q':
			if (! cmdline) {
				fprintf (stderr, CTP26, 'Q');
				errflg++;
			}
			Qflag++;
			break;
		case 'V':
			if (global) {
				fprintf (stderr, CTP10, "-V\n");
				errflg++;
			}
			if ((int) strlen (optarg) > 6) {
				fprintf (stderr, CTP02, "-V\n");
				errflg++;
			} else
				strcpy (ctp->vid, optarg);
			break;
		case 'v':
			if (global) {
				fprintf (stderr, CTP10, "-v\n");
				errflg++;
			}
			if ((int) strlen (optarg) > 6) {
				fprintf (stderr, CTP02, "-v\n");
				errflg++;
			} else
				strcpy (ctp->vsn, optarg);
			break;
		case '?':
			errflg++;
			break;
		default:
			break;
		}
	}
	return (errflg ? USERR : 0);
}

void cleanup(sig)
int sig;
{
	int c;
	int msglen;
	char *q;
	char *sbp;
	char sendbuf[64];

	signal (sig, SIG_IGN);

	sbp = sendbuf;
	marshall_LONG (sbp, CTPMAGIC);
	marshall_LONG (sbp, CTPKILL);
	q = sbp;        /* save pointer. The next field will be updated */
	msglen = 3 * LONGSIZE;
	marshall_LONG (sbp, msglen);
	marshall_STRING (sbp, pw->pw_name);     /* login name */
	marshall_WORD (sbp, gid);
	marshall_WORD (sbp, pid);
	msglen = sbp - sendbuf;
	marshall_LONG (q, msglen);      /* update length field */
	c = send2ctpd (sendbuf, msglen, 0);
#if defined(_WIN32)
	WSACleanup();
#endif
	exit (USERR);
}

count_vids_in_list(arg)
char *arg;
{
	char *dp;
	int i;
	int nbtp;
	int n1, n2;
	char *p, *p1, *q;

	nbtp = 0;
	p = arg;
	while (p) {
		if (p1 = strchr (p, ',')) *p1 = '\0';
		if (q = strchr (p, '-')) {
			*q = '\0';
			if ((int) strlen (p) > 6 || strlen (p) != strlen(q+1)){
				fprintf (stderr, CTP06);
				return (USERR);
			}
			UPPER (p);
			UPPER (q + 1);
			for (i = 0; i < 6; i++)
				if (*(p+i) != *(q+i+1)) break;
			n2 = strtol (q + i + 1, &dp, 10);
			if (*dp != '\0') {
				fprintf (stderr, CTP04);
				return (USERR);
			}
			n1 = strtol (p + i, &dp, 10);
			if (*dp != '\0') {
				fprintf (stderr, CTP04);
				return (USERR);
			}
			*q = '-';
			nbtp += n2 - n1 + 1;
		} else {
			if ((int) strlen (p) > 6) {
				fprintf (stderr, CTP06);
				return (USERR);
			}
			UPPER (p);
			nbtp++;
		}
		if (p1)
			*(p1++) = ',';
		p = p1;
	}
	if (inpflg)
		nb_inp_tp = nbtp;
	else
		nb_out_tp = nbtp;
	return (0);
}

dir2argv(inpdir, argvp)
char *inpdir;
char ***argvp;
{
	char **argv;
	int c;
	int nargs;
	char *p;
	int parm;

	nargs = 1;
	p = inpdir;
	parm = 0;
	while (c = *p++) {
		if (c == ' ' || c == '\t') {
			parm = 0;
		} else if (!parm) {
				parm++;
				nargs++;
		}
	}
	argv = (char **) malloc ((nargs + 1) * sizeof(char *));
	argv[0] = "copytape";
	nargs = 1;
	p = inpdir;
	parm = 0;
	while (c = *p++) {
		if (c == ' ' || c == '\t') {
			if (parm) {
				parm = 0;
				*(p - 1) = '\0';
			}
		} else if (!parm) {
			parm++;
			argv[nargs++] = p - 1;
		}
	}
	argv[nargs] = NULL;
	*argvp = argv;
	return (nargs);
}

fmt1_to_fmt2(vidlist1, vidlist2)
char *vidlist1;
char *vidlist2;
{
	/* convert format 1 (command line) to format 2 (input directives) */
	int errflg = 0;

	inpflg = 1;
	outflg = 0;
	if (count_vids_in_list (vidlist1))
		errflg++;
	inpflg = 0;
	outflg = 1;
	if (count_vids_in_list (vidlist2))
		errflg++;
	if (errflg)
		return (USERR);

	if (nb_inp_tp != 1 && nb_inp_tp == nb_out_tp)
		sprintf (cmdbuf, "BLIND %d %d", nb_inp_tp, nb_out_tp);
	else if (nb_inp_tp > 1 && nb_out_tp == 1)
		sprintf (cmdbuf, "MERGE %d %d", nb_inp_tp, nb_out_tp);
	else if (nb_inp_tp == 1 && nb_out_tp > 1)
		sprintf (cmdbuf, "SPLIT %d %d", nb_inp_tp, nb_out_tp);
	else if (nb_inp_tp != nb_out_tp) {
		fprintf (stderr, CTP18);
		return (USERR);
	}
	if (strlen (cmdbuf))
		marshall_STRING (sbp, cmdbuf);
	marshall_STRING (sbp, "INPUT");
	inpflg = 1;
	outflg = 0;
	if (proclist_of_vid (vidlist1))
		errflg++;
	marshall_STRING (sbp, "OUTPUT");
	inpflg = 0;
	outflg = 1;
	if (proclist_of_vid (vidlist2))
		errflg++;
	if (errflg)
		return (USERR);
	else
		return (0);
}

get_nb_in_out_tp()
{
	char *dp;
	char *q;

	if ((q = strtok (NULL, " \t")) == NULL)
		return (USERR);
	nb_inp_tp = strtol (q, &dp, 10);
	if (*dp != '\0')
		return (USERR);
	if ((q = strtok (NULL, " \t")) == NULL)
		return (USERR);
	nb_out_tp = strtol (q, &dp, 10);
	if (*dp != '\0')
		return (USERR);
	return (0);
}

procinpdir(s)
FILE *s;
{
	char **argv_d;
	int blindmode = 0;
	char buf[256];
	int c;
	struct cptp_parm cparm;
	char *dp;
	int errflg = 0;
	struct cptp_parm giparm;
	struct cptp_parm goparm;
	int mergemode = 0;
	int n;
	int nargs;
	int nbtp;
	char *p;
	int splitmode = 0;

	/* check and store the directives in an array */

	while (fgets (buf, sizeof(buf), s) != NULL) {
		if (buf[strlen (buf)-1] != '\n') {
			fprintf (stderr, CTP09);
			return (USERR);
		} else
			buf[strlen (buf)-1] = '\0';
		if ((n = strspn (buf, " \t")) == strlen (buf)) continue; /* blank line */
		p = buf + n;
		if (*p == '*') continue;	/* comment line */
		strcpy (cmdbuf, p);
		if (*p != '-') {
			p = strtok (p, " \t");
			UPPER (p);
			if (strcmp (p, "BLIND") == 0) {
				if (mergemode || splitmode || get_nb_in_out_tp()) {
					fprintf (stderr, CTP01, p);
					return (USERR);
				}
				blindmode = 1;
			} else if (strcmp (p, "MERGE") == 0) {
				if (blindmode || splitmode || get_nb_in_out_tp()) {
					fprintf (stderr, CTP01, p);
					return (USERR);
				}
				mergemode = 1;
			} else if (strcmp (p, "SPLIT") == 0) {
				if (blindmode || mergemode || get_nb_in_out_tp()) {
					fprintf (stderr, CTP01, p);
					return (USERR);
				}
				splitmode = 1;
			} else if (strcmp (p, "INPUT") == 0) {
				inpflg = 1;
				outflg = 0;
				if ((blindmode + mergemode + splitmode) == 0)
					nb_inp_tp = 1;
				nbtp = 0;
				memcpy (&giparm, &gparm, sizeof(struct cptp_parm));
			} else if (strcmp (p, "OUTPUT") == 0) {
				inpflg = 0;
				outflg = 1;
				if ((blindmode + mergemode + splitmode) == 0)
					nb_out_tp = 1;
				nbtp = 0;
				memcpy (&goparm, &gparm, sizeof(struct cptp_parm));
			} else {
				n = strtol (p, &dp, 10);
				if (*dp != '\0') {
					fprintf (stderr, CTP01, p);
					return (USERR);
				}
				if (inpflg) {
					if (n != nbtp + 1) {
						fprintf (stderr, CTP03);
						return (USERR);
					}
					nbtp++;
				} else if (outflg) {
					if (n != nbtp + 1) {
						fprintf (stderr, CTP03);
						return (USERR);
					}
					nbtp++;
				} else {
					fprintf (stderr, CTP01, p);
					return (USERR);
				}
				if (inpflg)
					memcpy (&cparm, &giparm, sizeof(struct cptp_parm));
				else
					memcpy (&cparm, &goparm, sizeof(struct cptp_parm));
				p += strlen (p) + 1;
				nargs = dir2argv (p, &argv_d);
				if ((c = chkopt (nargs, argv_d, &cparm, 0, 0)) == SYERR)
					return (SYERR);
				else if (c)
					errflg++;
				free (argv_d);
				if (*cparm.vid == '\0') strcpy (cparm.vid, cparm.vsn);
				if (proctape (&cparm, cparm.vid, cparm.vsn))
					errflg++;
			}
		} else {
			nargs = dir2argv (p, &argv_d);
			if (!inpflg && !outflg) {	/* common options */
				if ((c = chkopt (nargs, argv_d, &gparm, 1, 0)) == SYERR)
					return (SYERR);
				else if (c)
					errflg++;
			} else if (inpflg) {	/* common input options */
				if ((c = chkopt (nargs, argv_d, &giparm, 1, 0)) == SYERR)
					return (SYERR);
				else if (c)
					errflg++;
			} else {		/* common output options */
				if ((c = chkopt (nargs, argv_d, &goparm, 1, 0)) == SYERR)
					return (SYERR);
				else if (c)
					errflg++;
			}
			free (argv_d);
		}
		marshall_STRING (sbp, cmdbuf);
	}
	if (errflg)
		return (USERR);
	else
		return (0);
}

proclist_of_vid(arg)
char *arg;
{
	char *dp;
	int errflg = 0;
	int i, j;
	int n1, n2;
	int nbtp;
	char *p, *p1, *q;
	char vid[7];

	nbtp = 0;
	p = arg;
	while (p) {
		if (p1 = strchr (p, ',')) *p1 = '\0';
		if (q = strchr (p, '-')) {
			*q = '\0';
			for (i = 0; i < 6; i++)
				if (*(p+i) != *(q+i+1)) break;
			n2 = strtol (q + i + 1, &dp, 10);
			n1 = strtol (p + i, &dp, 10);
			for (j = n1; j <= n2; j++) {
				sprintf (vid, "%.*s%0*d", i, p, strlen(p) - i, j);
				sprintf (cmdbuf, " %d -V %s", ++nbtp, vid);
				if (proctape (&gparm, vid, ""))
					errflg++;
				marshall_STRING (sbp, cmdbuf);
			}
			*q = '-';
		} else {
			sprintf (cmdbuf, " %d -V %s", ++nbtp, p);
			if (proctape (&gparm, p, ""))
				errflg++;
			marshall_STRING (sbp, cmdbuf);
		}
		if (p1)
			*(p1++) = ',';
		p = p1;
	}
	return (errflg);
}

proctape(ctp, vid, vsn)
struct cptp_parm *ctp;
char *vid;
char *vsn;
{
	if (! panelflag) {
#if TMS
	/* check tape parms against TMS if installed */
		return (tmscheck (vid, vsn, ctp->dgn, ctp->den, ctp->lbl));
#else
		if (*vsn == '\0')
			sprintf (cmdbuf+strlen(cmdbuf), " -v %s", vid);
		if (*(ctp->dgn) == '\0')
			sprintf (cmdbuf+strlen(cmdbuf), " -g %s", DEFDGN);
		if (*(ctp->lbl) == '\0')
			sprintf (cmdbuf+strlen(cmdbuf), " -l %s", "sl");
#endif
	}
	return (0);
}

#if TMS
tmscheck(vid, vsn, dgn, den, lbl)
char *vid;
char *vsn;
char *dgn;
char *den;
char *lbl;
{
	int c, j;
	int errflg = 0;
	char *p;
	int repsize;
	int reqlen;
	char tmrepbuf[132];
	static char tmsden[6] = "     ";
	static char tmsdgn[7] = "      ";
	static char tmslbl[3] = "  ";
	char tmsreq[80];
	static char tmsvsn[7] = "      ";

	if (inpflg)
		sprintf (tmsreq, "VIDMAP %s QUERY (GENERIC SHIFT MESSAGE", vid);
	else
		sprintf (tmsreq, "QVOL %s WRITE %s %s (GENERIC SHIFT MESSAGE",
			vid, userid, account);
	reqlen = strlen (tmsreq);
	while (1) {
		repsize = sizeof(tmrepbuf);
		c = sysreq ("TMS", tmsreq, &reqlen, tmrepbuf, &repsize);
		switch (c) {
		case 0:
			break;
		case 8:
		case 100:
		case 312:
		case 315:
			fprintf (stderr, "%s\n", tmrepbuf);
			errflg++;
			break;
		case 12:
			fprintf (stderr, CTP19, vid);
			errflg++;
			break;
		default:
			sleep (60);
			continue;
		}
		break;
	}
	if (errflg) return (USERR);
	strncpy (tmsvsn, tmrepbuf, 6);
	for  (j = 0; tmsvsn[j]; j++)
		if (tmsvsn[j] == ' ') break;
	tmsvsn[j] = '\0';
	if (*vsn) {
		if (strcmp (vsn, tmsvsn)) {
			fprintf (stderr, CTP11, vid, vsn, tmsvsn);
			errflg++;
		}
	} else {
		sprintf (cmdbuf+strlen(cmdbuf), " -v %s", tmsvsn);
	}

	strncpy (tmsdgn, tmrepbuf+ 25, 6);
	for  (j = 0; tmsdgn[j]; j++)
		if (tmsdgn[j] == ' ') break;
	tmsdgn[j] = '\0';
	if (strcmp (tmsdgn, "CT1") == 0) strcpy (tmsdgn, "CART");
	if (*dgn) {
		if (strcmp (dgn, tmsdgn) != 0) {
			fprintf (stderr, CTP11, vid, dgn, tmsdgn);
			errflg++;
		}
	} else {
		sprintf (cmdbuf+strlen(cmdbuf), " -g %s", tmsdgn);
	}

	p = tmrepbuf + 32;
	while (*p == ' ') p++;
	j = tmrepbuf + 40 - p;
	strncpy (tmsden, p, j);
	tmsden[j] = '\0';
	if (*den) {
		if (strcmp (den, tmsden) != 0) {
			fprintf (stderr, CTP11, vid, den, tmsden);
			errflg++;
		}
	} else {
		sprintf (cmdbuf+strlen(cmdbuf), " -d %s", tmsden);
	}

	tmslbl[0] = tmrepbuf[74] - 'A' + 'a';
	tmslbl[1] = tmrepbuf[75] - 'A' + 'a';
	if (*lbl) {
		if (strcmp (lbl, "blp") && strcmp (lbl, tmslbl)) {
			fprintf (stderr, CTP11, vid, lbl, tmslbl);
			errflg++;
		}
	} else {
		sprintf (cmdbuf+strlen(cmdbuf), " -l %s", tmslbl);
	}
	return (errflg);
}
#endif

usage(cmd)
char *cmd;
{
	fprintf (stderr, "usage: %s ", cmd);
	fprintf (stderr, "%s%s%s%s%s",
	  "[-b max_block_size] [-C charconv] [-d density] [-E error_action]\n",
	  "\t[-F record_format] [-f file_id] [-G] [-g device_group_name] [-k]\n",
	  "\t[-L record_length] [-l label_type] [-N nread] [-m] [-q file_sequence_number]\n",
	  "\t[-S tape_server] [-s size] [-T] [-t retention_period]\n",
	  "\tinput_visual_identifier(s) output-visual_identifier(s)\n");
	fprintf (stderr, "   or: %s -Q", cmd);
}
