/*
 * Copyright (C) 1993 by CERN CN-SW/DC
 * All rights reserved
 */

%{
#ifndef lint
static char sccsid[] = "@(#)user.yacc	1.1 02/09/94 	CERN CN-SW/DC Felix Hassine";
#endif /* not lint */

#include <stdio.h>
#include <sys/errno.h>
#include <pwd.h>
#include <log.h>
extern char     *sys_errlist[] ; 	/* System error list  */
extern int 	errno ; 		/* Current system error index */

#ifndef MAPPING_FILE
#define MAPPING_FILE "/etc/ext.users"
#endif

/* SHIFT function to read and find an entry in a mapping file */

#define MAXNAMELEN 100
#define MAXNODELEN 50
#define ANYNUMBER -100
#define ANYSTRING "--ANY--"
#define STRINGOK  "--OK--"
#define STR_REJECT "---"
static struct  line_content {
        int  uid;
        int  gid;
        char rt_name[MAXNAMELEN];
        char lc_name[MAXNAMELEN];
        char from[MAXNODELEN];
} line[2] ;
static int found;
static char *infile= MAPPING_FILE;

%}

%union {
        char *string;
        int  yyint;
}


%token <yyint> INTEGER 
%token <string> ID 
%token STAR DOT NEWLINE DELIM COMMENT

%type <string> node username lc_username
%type <yyint> uid gid

%start lines

%%
lines	:	COMMENT | lines line
	;

line    :       NEWLINE 
		| COMMENT
		| node DELIM username DELIM uid DELIM gid DELIM lc_username delimn
		{ 
			/*
			 * Is this entry correct ?
			 */
			if (! compare_lines()) {
#ifdef DEBUG
				display_line(&line[1]);
#endif
				found=1;
				return 0;
			}
		}
	;

delimn 	:  	/* empty */ 
		| delimn DELIM 
	;

node 	: ID	{ strcpy(line[1].from,$1); }
	| STAR ID   { 	if (strstr(line[0].from,$2) != NULL ) 
					strcpy(line[1].from,STRINGOK);
			else
					strcpy(line[1].from,STR_REJECT);
		    }
	| STAR		{ strcpy(line[1].from,ANYSTRING); }
	| error		{ fprintf(stderr, "Mapping file error: node uncorrect \n");
			  strcpy(line[1].from,STR_REJECT); }
	;


username:	ID { strcpy(line[1].rt_name,$1);}
		| STAR { strcpy(line[1].rt_name,ANYSTRING); }
		| error { fprintf(stderr,"Mapping file error: username uncorrect\n"); }
	 	;

uid	 :	INTEGER {  line[1].uid=$1; }
		| STAR { line[1].uid= ANYNUMBER; }
		| error { fprintf(stderr,"Mapping file error: uid uncorrect\n"); }
	 	;

gid 	 :	INTEGER { line[1].gid=$1;}
		| STAR { line[1].gid= ANYNUMBER;}
		| error { fprintf(stderr,"Mapping file error: gid uncorrect\n"); }
	 	;

lc_username:    ID { strcpy(line[1].lc_name,$1);}
                | STAR { strcpy(line[1].lc_name,ANYSTRING); }
                | error { fprintf(stderr,"Mapping file error: username uncorrect\n"); }
                ;


%%

#include "lex.yy.c"

static void display_line(line)
struct line_content *line;
{
	printf("Displaying line content:\n");
	printf("Node:\t%20s\n",line->from);
	printf("User:\t%20s\n",line->rt_name);
	printf("Uid: \t%20d\n",line->uid);
	printf("Gid: \t%20d\n",line->gid);
	printf("Mapped to : \t%20s\n",line->lc_name);
}

/*
 * Return 0 if line 1 matches line 0
 * -1 otherwise
 */
int compare_lines()
{
 if ( (!strcmp(line[1].rt_name,ANYSTRING) ||
       !strcmp(line[1].rt_name,STRINGOK)  ||
       !strcmp(line[0].rt_name,line[1].rt_name) ) &&

      (!strcmp(line[1].from,ANYSTRING)		|| 
       !strcmp(line[1].from,STRINGOK)  		||
       !strcmp(line[0].from,line[1].from)  ) 	&&

	(line[1].uid== ANYNUMBER	||
	 line[1].uid==line[0].uid)		&&

	(line[1].gid== ANYNUMBER ||
         line[1].gid==line[0].gid)   )
	return(0);
else
	return(-1);
} 

/*
 * function finds the corresponding entry in the
 * mapping table; 
 * returns 0 if entry was found
 *	   1 on error (errno is set)
 *         -1 if entry was not found
 */
int get_user(from_node,from_user,from_uid,from_gid,to_user,to_uid,to_gid)
char *from_node;
char *from_user;
int from_uid;
int from_gid;
char *to_user;
int *to_uid ;
int *to_gid ;
{
	struct passwd *pw ;
	if  ( (yyin=fopen(infile,"r"))==NULL ) {
		fprintf(stderr,"Could not open file %s\n",infile);
		return -ENOENT ;
	}
	
        strcpy(line[0].rt_name,from_user);
        strcpy(line[0].from,from_node);
        line[0].uid=from_uid;
        line[0].gid=from_gid;

	yyparse();
	if (found) {
#ifdef DEBUG
		printf("Matching entry was found\n");
#endif
		strcpy(to_user,line[1].lc_name);
		if ( (pw = getpwnam(to_user))==NULL) {
			log(LOG_ERR,"getpwnam(): %s\n",sys_errlist[errno]);
			return 1 ;
		}
		else {
                       	*to_uid = pw->pw_uid;
                       	*to_gid = pw->pw_gid;
		}
		return 0 ;
	}
	else
		return -1 ;
}

