# @(#)user.lex	1.1 02/09/94 CERN SW/DC Felix Hassine
#
# Copyright (C) 1993 by CERN CN-SW/DC
# All rights reserved
#
# Lexical analyser for the mapping file
#

name		[A-Za-z][0-9A-Za-z_\-]*
id 		(\.)?({name}\.)*{name}
number		[0-9]+
delim		[ \t]+
comment		#.*$
nl		\n|\r
star		\*
dot		\.

%%

{comment}|^[ ]*$	{ return COMMENT ; }
{dot} 		{ return DOT ; }
{number}	{ sscanf(yytext,"%d",&yylval.yyint);
		  return(INTEGER); }

{id}		{ yylval.string=(char *)yytext;
		  return ID;
		}
{star} 		{ return STAR ;}
{nl}		{ return NEWLINE ; }
{delim}		{ return DELIM ; }

%%

